"use strict";module.exports=Reader;var BufferReader,util=require("./util/minimal"),LongBits=util.LongBits,utf8=util.utf8;function indexOutOfRange(t,i){return RangeError("index out of range: "+t.pos+" + "+(i||1)+" > "+t.len)}function Reader(t){this.buf=t,this.pos=0,this.len=t.length}var create_array="undefined"!=typeof Uint8Array?function(t){if(t instanceof Uint8Array||Array.isArray(t))return new Reader(t);throw Error("illegal buffer")}:function(t){if(Array.isArray(t))return new Reader(t);throw Error("illegal buffer")},create=function(){return util.Buffer?function(t){return(Reader.create=function(t){return util.Buffer.isBuffer(t)?new BufferReader(t):create_array(t)})(t)}:create_array};function readLongVarint(){var t=new LongBits(0,0),i=0;if(this.len-this.pos>4){for(;i<4;++i)if(t.lo=(t.lo|(127&this.buf[this.pos])<<7*i)>>>0,this.buf[this.pos++]<128)return t;if(t.lo=(t.lo|(127&this.buf[this.pos])<<28)>>>0,t.hi=(t.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return t;i=0}else{for(;i<3;++i){if(this.pos>=this.len)throw indexOutOfRange(this);if(t.lo=(t.lo|(127&this.buf[this.pos])<<7*i)>>>0,this.buf[this.pos++]<128)return t}return t.lo=(t.lo|(127&this.buf[this.pos++])<<7*i)>>>0,t}if(this.len-this.pos>4){for(;i<5;++i)if(t.hi=(t.hi|(127&this.buf[this.pos])<<7*i+3)>>>0,this.buf[this.pos++]<128)return t}else for(;i<5;++i){if(this.pos>=this.len)throw indexOutOfRange(this);if(t.hi=(t.hi|(127&this.buf[this.pos])<<7*i+3)>>>0,this.buf[this.pos++]<128)return t}throw Error("invalid varint encoding")}function readFixed32_end(t,i){return(t[i-4]|t[i-3]<<8|t[i-2]<<16|t[i-1]<<24)>>>0}function readFixed64(){if(this.pos+8>this.len)throw indexOutOfRange(this,8);return new LongBits(readFixed32_end(this.buf,this.pos+=4),readFixed32_end(this.buf,this.pos+=4))}Reader.create=create(),Reader.prototype._slice=util.Array.prototype.subarray||util.Array.prototype.slice,Reader.prototype.uint32=function(){var t=0xffffffff;return function(){if(t=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128||(t=(t|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)||(t=(t|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)||(t=(t|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)||(t=(t|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128))return t;if((this.pos+=5)>this.len)throw this.pos=this.len,indexOutOfRange(this,10);return t}}(),Reader.prototype.int32=function(){return 0|this.uint32()},Reader.prototype.sint32=function(){var t=this.uint32();return t>>>1^-(1&t)|0},Reader.prototype.bool=function(){return 0!==this.uint32()},Reader.prototype.fixed32=function(){if(this.pos+4>this.len)throw indexOutOfRange(this,4);return readFixed32_end(this.buf,this.pos+=4)},Reader.prototype.sfixed32=function(){if(this.pos+4>this.len)throw indexOutOfRange(this,4);return 0|readFixed32_end(this.buf,this.pos+=4)},Reader.prototype.float=function(){if(this.pos+4>this.len)throw indexOutOfRange(this,4);var t=util.float.readFloatLE(this.buf,this.pos);return this.pos+=4,t},Reader.prototype.double=function(){if(this.pos+8>this.len)throw indexOutOfRange(this,4);var t=util.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,t},Reader.prototype.bytes=function(){var t=this.uint32(),i=this.pos,e=this.pos+t;if(e>this.len)throw indexOutOfRange(this,t);if(this.pos+=t,Array.isArray(this.buf))return this.buf.slice(i,e);if(i===e){var r=util.Buffer;return r?r.alloc(0):new this.buf.constructor(0)}return this._slice.call(this.buf,i,e)},Reader.prototype.string=function(){var t=this.bytes();return utf8.read(t,0,t.length)},Reader.prototype.skip=function(t){if("number"==typeof t){if(this.pos+t>this.len)throw indexOutOfRange(this,t);this.pos+=t}else do if(this.pos>=this.len)throw indexOutOfRange(this);while(128&this.buf[this.pos++]);return this},Reader.prototype.skipType=function(t){switch(t){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;4!=(t=7&this.uint32());)this.skipType(t);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+t+" at offset "+this.pos)}return this},Reader._configure=function(t){BufferReader=t,Reader.create=create(),BufferReader._configure();var i=util.Long?"toLong":"toNumber";util.merge(Reader.prototype,{int64:function(){return readLongVarint.call(this)[i](!1)},uint64:function(){return readLongVarint.call(this)[i](!0)},sint64:function(){return readLongVarint.call(this).zzDecode()[i](!1)},fixed64:function(){return readFixed64.call(this)[i](!0)},sfixed64:function(){return readFixed64.call(this)[i](!1)}})};