/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth.win;

import c.a.a.a.d.H;
import c.a.a.a.d.O;
import c.a.a.a.d.ad;
import c.a.a.b.e;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.win.CurrentWindowsCredentials;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

public class WindowsNegotiateScheme
extends AuthSchemeBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String scheme;
    private final String servicePrincipalName;
    private O.a clientCred;
    private O.b sspiContext;
    private boolean continueNeeded;
    private String challenge;

    public WindowsNegotiateScheme(String string, String string2) {
        this.scheme = string == null ? "Negotiate" : string;
        this.challenge = null;
        this.continueNeeded = true;
        this.servicePrincipalName = string2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WindowsNegotiateScheme using " + this.scheme);
        }
    }

    public void dispose() {
        int n2;
        if (this.clientCred != null && !this.clientCred.x() && 0 != (n2 = H.j.a(this.clientCred))) {
            throw new ad(n2);
        }
        if (this.sspiContext != null && !this.sspiContext.x() && 0 != (n2 = H.j.a(this.sspiContext))) {
            throw new ad(n2);
        }
        this.continueNeeded = true;
        this.clientCred = null;
        this.sspiContext = null;
    }

    public void finalize() {
        this.dispose();
        super.finalize();
    }

    @Override
    public String getSchemeName() {
        return this.scheme;
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n2, int n3) {
        this.challenge = charArrayBuffer.substringTrimmed(n2, n3);
        if (this.challenge.isEmpty() && this.clientCred != null) {
            this.dispose();
            if (this.continueNeeded) {
                throw new RuntimeException("Unexpected token");
            }
        }
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) {
        String string;
        Object object;
        if (this.clientCred == null) {
            if (!(credentials instanceof CurrentWindowsCredentials)) {
                throw new InvalidCredentialsException("Credentials cannot be used for " + this.getSchemeName() + " authentication: " + credentials.getClass().getName());
            }
            try {
                object = CurrentWindowsCredentials.getCurrentUsername();
                O.j j2 = new O.j();
                this.clientCred = new O.a();
                int n2 = H.j.a((String)object, this.scheme, 2, null, null, null, null, this.clientCred, j2);
                if (0 != n2) {
                    throw new ad(n2);
                }
                String string2 = this.getServicePrincipalName(httpContext);
                string = this.getToken(null, null, string2);
            }
            catch (RuntimeException runtimeException) {
                this.failAuthCleanup();
                if (runtimeException instanceof ad) {
                    throw new AuthenticationException("Authentication Failed", runtimeException);
                }
                throw runtimeException;
            }
        }
        if (this.challenge == null || this.challenge.isEmpty()) {
            this.failAuthCleanup();
            throw new AuthenticationException("Authentication Failed");
        }
        try {
            object = Base64.decodeBase64(this.challenge);
            O.g g2 = new O.g(2, (byte[])object);
            String string3 = this.getServicePrincipalName(httpContext);
            string = this.getToken(this.sspiContext, g2, string3);
        }
        catch (RuntimeException runtimeException) {
            this.failAuthCleanup();
            if (runtimeException instanceof ad) {
                throw new AuthenticationException("Authentication Failed", runtimeException);
            }
            throw runtimeException;
        }
        object = new CharArrayBuffer(this.scheme.length() + 30);
        if (this.isProxy()) {
            ((CharArrayBuffer)object).append("Proxy-Authorization");
        } else {
            ((CharArrayBuffer)object).append("Authorization");
        }
        ((CharArrayBuffer)object).append(": ");
        ((CharArrayBuffer)object).append(this.scheme);
        ((CharArrayBuffer)object).append(" ");
        ((CharArrayBuffer)object).append(string);
        return new BufferedHeader((CharArrayBuffer)object);
    }

    private void failAuthCleanup() {
        this.dispose();
        this.continueNeeded = false;
    }

    private String getServicePrincipalName(HttpContext httpContext) {
        RouteInfo routeInfo;
        HttpClientContext httpClientContext;
        HttpHost httpHost;
        String string = this.servicePrincipalName != null ? this.servicePrincipalName : ((httpHost = (httpClientContext = HttpClientContext.adapt(httpContext)).getTargetHost()) != null ? "HTTP/" + httpHost.getHostName() : ((routeInfo = httpClientContext.getHttpRoute()) != null ? "HTTP/" + routeInfo.getTargetHost().getHostName() : null));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using SPN: " + string);
        }
        return string;
    }

    String getToken(O.b b2, O.g g2, String string) {
        e e2 = new e();
        O.g g3 = new O.g(2, 12288);
        this.sspiContext = new O.b();
        int n2 = H.j.a(this.clientCred, b2, string, 3, 0, 16, g2, 0, this.sspiContext, g3, e2, null);
        switch (n2) {
            case 590610: {
                this.continueNeeded = true;
                break;
            }
            case 0: {
                this.dispose();
                this.continueNeeded = false;
                break;
            }
            default: {
                this.dispose();
                throw new ad(n2);
            }
        }
        return Base64.encodeBase64String(g3.x());
    }

    @Override
    public boolean isComplete() {
        return !this.continueNeeded;
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) {
        return this.authenticate(credentials, httpRequest, null);
    }
}

