/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.cache.AsynchronousValidator;
import org.apache.http.impl.client.cache.CachingExec;

public class AsynchronousValidationRequest
implements Runnable {
    private final AsynchronousValidator parent;
    private final CachingExec cachingExec;
    private final HttpRoute route;
    private final HttpRequestWrapper request;
    private final HttpClientContext context;
    private final HttpExecutionAware execAware;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    private final int consecutiveFailedAttempts;
    private final Log log = LogFactory.getLog(this.getClass());

    AsynchronousValidationRequest(AsynchronousValidator asynchronousValidator, CachingExec cachingExec, HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware, HttpCacheEntry httpCacheEntry, String string, int n2) {
        this.parent = asynchronousValidator;
        this.cachingExec = cachingExec;
        this.route = httpRoute;
        this.request = httpRequestWrapper;
        this.context = httpClientContext;
        this.execAware = httpExecutionAware;
        this.cacheEntry = httpCacheEntry;
        this.identifier = string;
        this.consecutiveFailedAttempts = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.revalidateCacheEntry()) {
                this.parent.jobSuccessful(this.identifier);
            } else {
                this.parent.jobFailed(this.identifier);
            }
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean revalidateCacheEntry() {
        boolean bl;
        CloseableHttpResponse closeableHttpResponse = this.cachingExec.revalidateCacheEntry(this.route, this.request, this.context, this.execAware, this.cacheEntry);
        try {
            int n2 = closeableHttpResponse.getStatusLine().getStatusCode();
            bl = this.isNotServerError(n2) && this.isNotStale(closeableHttpResponse);
        }
        catch (Throwable throwable) {
            try {
                closeableHttpResponse.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.log.debug("Asynchronous revalidation failed due to I/O error", iOException);
                return false;
            }
            catch (HttpException httpException) {
                this.log.error("HTTP protocol exception during asynchronous revalidation", httpException);
                return false;
            }
            catch (RuntimeException runtimeException) {
                this.log.error("RuntimeException thrown during asynchronous revalidation: " + runtimeException);
                return false;
            }
        }
        closeableHttpResponse.close();
        return bl;
    }

    private boolean isNotServerError(int n2) {
        return n2 < 500;
    }

    private boolean isNotStale(HttpResponse httpResponse) {
        Header[] headerArray = httpResponse.getHeaders("Warning");
        if (headerArray != null) {
            for (Header header : headerArray) {
                String string = header.getValue();
                if (!string.startsWith("110") && !string.startsWith("111")) continue;
                return false;
            }
        }
        return true;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getConsecutiveFailedAttempts() {
        return this.consecutiveFailedAttempts;
    }
}

