/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.cache.AsynchronousValidationRequest;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.SchedulingStrategy;
import org.apache.http.util.Args;

public class ExponentialBackOffSchedulingStrategy
implements SchedulingStrategy {
    public static final long DEFAULT_BACK_OFF_RATE = 10L;
    public static final long DEFAULT_INITIAL_EXPIRY_IN_MILLIS = TimeUnit.SECONDS.toMillis(6L);
    public static final long DEFAULT_MAX_EXPIRY_IN_MILLIS = TimeUnit.SECONDS.toMillis(86400L);
    private final long backOffRate;
    private final long initialExpiryInMillis;
    private final long maxExpiryInMillis;
    private final ScheduledExecutorService executor;

    public ExponentialBackOffSchedulingStrategy(CacheConfig cacheConfig) {
        this(cacheConfig, 10L, DEFAULT_INITIAL_EXPIRY_IN_MILLIS, DEFAULT_MAX_EXPIRY_IN_MILLIS);
    }

    public ExponentialBackOffSchedulingStrategy(CacheConfig cacheConfig, long l2, long l3, long l4) {
        this(ExponentialBackOffSchedulingStrategy.createThreadPoolFromCacheConfig(cacheConfig), l2, l3, l4);
    }

    private static ScheduledThreadPoolExecutor createThreadPoolFromCacheConfig(CacheConfig cacheConfig) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(cacheConfig.getAsynchronousWorkersMax());
        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return scheduledThreadPoolExecutor;
    }

    ExponentialBackOffSchedulingStrategy(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4) {
        this.executor = Args.notNull(scheduledExecutorService, "Executor");
        this.backOffRate = Args.notNegative(l2, "BackOffRate");
        this.initialExpiryInMillis = Args.notNegative(l3, "InitialExpiryInMillis");
        this.maxExpiryInMillis = Args.notNegative(l4, "MaxExpiryInMillis");
    }

    @Override
    public void schedule(AsynchronousValidationRequest asynchronousValidationRequest) {
        Args.notNull(asynchronousValidationRequest, "RevalidationRequest");
        int n2 = asynchronousValidationRequest.getConsecutiveFailedAttempts();
        long l2 = this.calculateDelayInMillis(n2);
        this.executor.schedule(asynchronousValidationRequest, l2, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    public long getBackOffRate() {
        return this.backOffRate;
    }

    public long getInitialExpiryInMillis() {
        return this.initialExpiryInMillis;
    }

    public long getMaxExpiryInMillis() {
        return this.maxExpiryInMillis;
    }

    protected long calculateDelayInMillis(int n2) {
        if (n2 > 0) {
            long l2 = (long)((double)this.initialExpiryInMillis * Math.pow(this.backOffRate, n2 - 1));
            return Math.min(l2, this.maxExpiryInMillis);
        }
        return 0L;
    }

    protected static <T> T checkNotNull(String string, T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        return t2;
    }

    protected static long checkNotNegative(String string, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " may not be negative");
        }
        return l2;
    }
}

