/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.impl.conn.Wire;

class LoggingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Wire wire;

    public LoggingOutputStream(OutputStream outputStream, Wire wire) {
        this.out = outputStream;
        this.wire = wire;
    }

    @Override
    public void write(int n2) {
        try {
            this.wire.output(n2);
        }
        catch (IOException iOException) {
            this.wire.output("[write] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray) {
        try {
            this.wire.output(byArray);
            this.out.write(byArray);
        }
        catch (IOException iOException) {
            this.wire.output("[write] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        try {
            this.wire.output(byArray, n2, n3);
            this.out.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            this.wire.output("[write] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.wire.output("[flush] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            this.wire.output("[close] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }
}

