/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Date;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.util.Args;

public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) {
        int n2;
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + string);
        }
        if (n2 < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + string);
        }
        setCookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)n2 * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

