/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity httpEntity) {
        try {
            EntityUtils.consume(httpEntity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity httpEntity) {
        InputStream inputStream;
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming() && (inputStream = httpEntity.getContent()) != null) {
            inputStream.close();
        }
    }

    public static void updateEntity(HttpResponse httpResponse, HttpEntity httpEntity) {
        Args.notNull(httpResponse, "Response");
        EntityUtils.consume(httpResponse.getEntity());
        httpResponse.setEntity(httpEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity httpEntity) {
        Args.notNull(httpEntity, "Entity");
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n2;
            Args.check(httpEntity.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
            int n3 = (int)httpEntity.getContentLength();
            if (n3 < 0) {
                n3 = 4096;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n3);
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayBuffer.append(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayBuffer.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getContentCharSet(HttpEntity httpEntity) {
        NameValuePair nameValuePair;
        HeaderElement[] headerElementArray;
        Args.notNull(httpEntity, "Entity");
        String string = null;
        if (httpEntity.getContentType() != null && (headerElementArray = httpEntity.getContentType().getElements()).length > 0 && (nameValuePair = headerElementArray[0].getParameterByName("charset")) != null) {
            string = nameValuePair.getValue();
        }
        return string;
    }

    public static String getContentMimeType(HttpEntity httpEntity) {
        HeaderElement[] headerElementArray;
        Args.notNull(httpEntity, "Entity");
        String string = null;
        if (httpEntity.getContentType() != null && (headerElementArray = httpEntity.getContentType().getElements()).length > 0) {
            string = headerElementArray[0].getName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpEntity httpEntity, Charset charset) {
        Args.notNull(httpEntity, "Entity");
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n2;
            Object object;
            Charset charset2;
            int n3;
            block11: {
                Args.check(httpEntity.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
                n3 = (int)httpEntity.getContentLength();
                if (n3 < 0) {
                    n3 = 4096;
                }
                charset2 = null;
                try {
                    object = ContentType.get(httpEntity);
                    if (object != null) {
                        charset2 = ((ContentType)object).getCharset();
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (charset != null) break block11;
                    throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
                }
            }
            if (charset2 == null) {
                charset2 = charset;
            }
            if (charset2 == null) {
                charset2 = HTTP.DEF_CONTENT_CHARSET;
            }
            object = new InputStreamReader(inputStream, charset2);
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(n3);
            char[] cArray = new char[1024];
            while ((n2 = ((Reader)object).read(cArray)) != -1) {
                charArrayBuffer.append(cArray, 0, n2);
            }
            String string = charArrayBuffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static String toString(HttpEntity httpEntity, String string) {
        return EntityUtils.toString(httpEntity, string != null ? Charset.forName(string) : null);
    }

    public static String toString(HttpEntity httpEntity) {
        return EntityUtils.toString(httpEntity, (Charset)null);
    }
}

