// GxtY6011.h: interface for the CGxtY601 class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GXTY6011_H__CAF8F436_A070_4DC4_8E73_1B29FCC8D04B__INCLUDED_)
#define AFX_GXTY6011_H__CAF8F436_A070_4DC4_8E73_1B29FCC8D04B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
 
#include <afxtempl.h>
#include "GxtY601Dlg.h"
#include "SerialPort.h"
#include "Config.h"

#define TIME_OUT_PROCESS			   30

#define MIN_ZIP_RATE				   10                       
#define MAX_ZIP_RATE                   50

#define MODE_IMAGE_SIZE_160X120			1 //160*120
#define MODE_IMAGE_SIZE_320X240			2 //320*240
#define MODE_IMAGE_SIZE_640X480			3 //640*480

#define MODE_SAVE_POWER					1 //ʡģʽ 
#define MODE_EXIT_SAVE_POWER			2 //˳ʡģʽ

#define	UM_PROCESS_THREAD				WM_USER+0x1000	
#define THREAD_NORMAL_EXIT				1
#define THREAD_FORCE_EXIT				2
		
#define MODE_PHOTO_INVALID				0  //Ƿֵ		
#define MODE_PHOTO_ONCE					1  //㵥ģʽ
#define MODE_PHOTO_CONTINUE				2  //ģʽ
		 
#define MODE_TRANSFER_ONCE				0
#define MODE_TRANSFER_512BYTE			1

#define BLOCK_SIZE					  512 //յ512,ͿԿʼдļ

#define CMD_INVALID						0
#define CMD_RESET						1
#define CMD_PHOTO						2
#define CMD_STOP_PHOTO					3
#define CMD_READ_LENGTH					4
#define CMD_READ_BUF_512				5
#define CMD_READ_BUF_TOTAL				6
#define CMD_ZIP_RATE					7
#define CMD_SAVE_POWER					8
#define CMD_EXIT_SAVE_POWER				9
#define CMD_MODIFY_DefBAUD			    10
#define CMD_MODIFY_BAUD				    11
#define CMD_MODIFY_IMAGE_SIZE			12
#define CMD_MOTION_SENSITIVITY          13 
#define CMD_MOTION_OPEN					14
#define CMD_MOTION_CLOSE				15

#define MODE_BAUD_CLOSEPORT     1
#define MODE_DEFBAUD_CLOSEPORT  2

#define CLOSE_MOTION                    0
#define OPEN_MOTION                     1
#define CONFIG_MOTION_SENSITIVITY       2  

#define MOTION_NONE_INCOMING             0
#define MOTION_DETECTE_INCOMING          1


extern CRITICAL_SECTION	m_csBuf;
extern CRITICAL_SECTION	m_csCmdQueue;
					
class CGxtY601 : public CObject  
{
public:
	CGxtY601Dlg* m_pDlg;

	CGxtY601(HWND hParent);
	virtual ~CGxtY601();
	
public:

	//ڴ򿪺͹ر
	BOOL OpenPort(CWnd* pPortOwner, UINT portnr, UINT baud, char parity = 'N', UINT databits = 8, UINT stopsbits = 1, DWORD dwCommEvents = EV_RXCHAR | EV_CTS, UINT nBufferSize = 512);
	void ClosePort();
	BOOL IsPortOpen();

	void Reset();

	void SetSerialNum();

	//ݷ͵ķװ
	void SendReset();
	void SendPhoto();
	void SendReadLength();
	void SendReadBuf(DWORD dwStartAddr, DWORD dwLength, UINT nInterval = 255);
	void SendStopPhoto();
	void SendSetZipRate(int nZipRate);
	void SendImageSize(int nModeImageSize);
	void SendSavePower(int nModePower);
    void SendDefBaud(UINT nDefBaud);
	void SendBaud(UINT nBaud);
	void SendMotion(UINT nSwitch);

	//
	void OnRevSerData();

	//򻺳Ӵ
	void AddSerData(BYTE *pData, WORD wLen);

	//֪ͨݵ¼
	void IndRevSerData();

	//Ϣ,Ϣпط
	void AddCmdToQueue(int nCmd);
	//ͷ
	int  QueryCmd();

	void DeleteCmd();

	void DeleteAllCmd();

	BOOL IsCmdEmpty();

	BOOL			m_bRecvFrameHead;
	
	BOOL			m_bFindFrameEnd;

	BOOL			m_bStart;
	//һζbuf
	DWORD			m_dwRead;
	//ļ
	DWORD			m_dwTotalLen;
	//Ѿдĳ
	DWORD			m_dwWriteLen;

	int				m_nTransmitMode;
	int             m_nMotionStatus;     //ƶ״̬

	BOOL			m_bWaitThisFrameEnd; //ȴ֡ʶ

	BOOL			m_bWaitLastFrame;

	//Ƿдļ,ǰմڵļbuf
	BOOL			m_bIsWritingBuf;

	CWinThread		*pProcessThread;	// pointer to thread

private:
	CSerialPort			m_SerialPort;

	
	CArray<BYTE, BYTE>	m_ArrBuf;

	

	CArray<int, int>    m_ArrCmdQueue;
	
	//֪ͨдļ

	static	UINT	RecvBufProc(LPVOID LParam);	   //̺߳
	int				StartProcessThread();
	int 			StopProcessThread();
	
	HANDLE          hEventShut;			// close thread handle
	
	BOOL			bRun;

	HWND			m_hParentWnd;

	
	BOOL			m_bFirstFrame;

	BOOL			m_bPortOpen;

};

#endif // !defined(AFX_GXTY6011_H__CAF8F436_A070_4DC4_8E73_1B29FCC8D04B__INCLUDED_)
