/**************************************************************************

This file contains T.4 decoding data

Contents are :

a) two binary trees for decoding MH fax run-length codes
b) one binary tree for decoding MR codes.
c) one lookup table of inverted characters

MH trees = one tree for white run lengths,  one tree for black run lengths.

All decodes for all trees start from the top.

For each node the first leaf is the offset from the root to the next
node if the current bit is 0,  and the second leaf is the offset to
the next node if the bit is 1.  A minus value is a terminator,  with a
run-length equal to the negation of the minus value.     

******************************************************************************/

#include "stdafx.h"
#include "TifHeader.h"
#include "huffman.h"

const int gWTree [][2] =
{
		{1, 80},          /* 0 */
		{40, 2},          /* 1 */
		{21, 3},          /* 2 */
		{4, -2},          /* 3 */
		{16, 5},          /* 4 */
		{10, 6},          /* 5 */
		{7, -256},        /* 6 */
		{9, 8},           /* 7 */
		{-1344, -1408},   /* 8 */
		{-1216, -1280},   /* 9 */
		{11, 13},         /* 10 */
		{-576, 12},       /* 11 */
		{-832, -896},     /* 12 */
		{14, 15},         /* 13 */
		{-960, -1024},    /* 14 */
		{-1088, -1152},   /* 15 */
		{-1664, 17},      /* 16 */
		{18, 19},         /* 17 */
		{-448, -512},     /* 18 */
		{20, -640},       /* 19 */
		{-704, -768},     /* 20 */
		{32, 22},         /* 21 */
		{23, 28},         /* 22 */
		{24, 26},         /* 23 */
		{-24, 25},        /* 24 */
		{-49, -50},       /* 25 */
		{27, -25},        /* 26 */
		{-51, -52},       /* 27 */
		{29, -192},       /* 28 */
		{30, 31},         /* 29 */
		{-55, -56},       /* 30 */
		{-57, -58},       /* 31 */
		{-11, 33},        /* 32 */
		{34, 36},         /* 33 */
		{-27, 35},        /* 34 */
		{-59, -60},       /* 35 */
		{37, -18},        /* 36 */
		{38, 39},         /* 37 */
		{-1472, -1536},   /* 38 */
		{-1600, -1728},   /* 39 */
		{59, 41},         /* 40 */
		{49, 42},         /* 41 */
		{43, -10},        /* 42 */
		{47, 44},         /* 43 */
		{46, 45},         /* 44 */
		{-320, -384},     /* 45 */
		{-63, 0},         /* 46 */
		{-28, 48},        /* 47 */
		{-61, -62},       /* 48 */
		{56, 50},         /* 49 */
		{53, 51},         /* 50 */
		{52, -21},        /* 51 */
		{-43, -44},       /* 52 */
		{55, 54},         /* 53 */
		{-41, -42},       /* 54 */
		{-39, -40},       /* 55 */
		{-12, 57},        /* 56 */
		{58, -26},        /* 57 */
		{-53, -54},       /* 58 */
		{70, 60},         /* 59 */
		{64, 61},         /* 60 */
		{62, -1},         /* 61 */
		{-19, 63},        /* 62 */
		{-31, -32},       /* 63 */
		{68, 65},         /* 64 */
		{67, 66},         /* 65 */
		{-37, -38},       /* 66 */
		{-35, -36},       /* 67 */
		{-20, 69},        /* 68 */
		{-33, -34},       /* 69 */
		{74, 71},         /* 70 */
		{72, -13},        /* 71 */
		{-23, 73},        /* 72 */
		{-47, -48},       /* 73 */
		{77, 75},         /* 74 */
		{76, -22},        /* 75 */
		{-45, -46},       /* 76 */
		{79, 78},         /* 77 */
		{-29, -30},       /* 78 */
		{OUREOL, BADRUN}, /* 79 */
		{86, 81},         /* 80 */
		{83, 82},         /* 81 */
		{-6, -7},         /* 82 */
		{-5, 84},         /* 83 */
		{85, -64},        /* 84 */
		{-14, -15},       /* 85 */
		{90, 87},         /* 86 */
		{88, -4},         /* 87 */
		{-9, 89},         /* 88 */
		{-16, -17},       /* 89 */
		{-3, 91},         /* 90 */
		{-128, -8}        /* 91 */
};

const int gBTree[][2] =
{
      {2, 1},           /* 0 */
      {-3, -2},         /* 1 */
      {4, 3},           /* 2 */
      {-1, -4},         /* 3 */
      {6, 5},           /* 4 */
      {-6, -5},         /* 5 */
      {9, 7},           /* 6 */
      {8, -7},          /* 7 */
      {-9, -8},         /* 8 */
      {31, 10},         /* 9 */
      {30, 11},         /* 10 */
      {12, -12},        /* 11 */
      {23, 13},         /* 12 */
      {17, 14},         /* 13 */
      {15, 0},          /* 14 */
      {-21, 16},        /* 15 */
      {-42, -43},       /* 16 */
      {21, 18},         /* 17 */
      {20, 19},         /* 18 */
      {-38, -39},       /* 19 */
      {-36, -37},       /* 20 */
      {-20, 22},        /* 21 */
      {-34, -35},       /* 22 */
      {-15, 24},        /* 23 */
      {27, 25},         /* 24 */
      {26, -19},        /* 25 */
      {-28, -29},       /* 26 */
      {29, 28},         /* 27 */
      {-26, -27},       /* 28 */
      {-128, -192},     /* 29 */
      {-10, -11},       /* 30 */
      {57, 32},         /* 31 */
      {45, 33},         /* 32 */
      {34, -14},        /* 33 */
      {41, 35},         /* 34 */
      {38, 36},         /* 35 */
      {37, -22},        /* 36 */
      {-40, -41},       /* 37 */
      {40, 39},         /* 38 */
      {-32, -33},       /* 39 */
      {-30, -31},       /* 40 */
      {-17, 42},        /* 41 */
      {44, 43},         /* 42 */
      {-62, -63},       /* 43 */
      {-48, -49},       /* 44 */
      {-13, 46},        /* 45 */
      {51, 47},         /* 46 */
      {48, -16},        /* 47 */
      {50, 49},         /* 48 */
      {-61, -256},      /* 49 */
      {-57, -58},       /* 50 */
      {55, 52},         /* 51 */
      {54, 53},         /* 52 */
      {-46, -47},       /* 53 */
      {-44, -45},       /* 54 */
      {-23, 56},        /* 55 */
      {-50, -51},       /* 56 */
      {OUREOL, 58},     /* 57 */
      {75, 59},         /* 58 */
      {67, 60},         /* 59 */
      {61, -64},        /* 60 */
      {65, 62},         /* 61 */
      {64, 63},         /* 62 */
      {-1152, -1216},   /* 63 */
      {-1024, -1088},   /* 64 */
      {-54, 66},        /* 65 */
      {-896, -960},     /* 66 */
      {72, 68},         /* 67 */
      {71, 69},         /* 68 */
      {70, -53},        /* 69 */
      {-512, -576},     /* 70 */
      {-384, -448},     /* 71 */
      {-25, 73},        /* 72 */
      {74, -320},       /* 73 */
      {-1664, -1728},   /* 74 */
      {85, 76},         /* 75 */
      {80, 77},         /* 76 */
      {78, -24},        /* 77 */
      {-60, 79},        /* 78 */
      {-1536, -1600},   /* 79 */
      {83, 81},         /* 80 */
      {82, -59},        /* 81 */
      {-1408, -1472},   /* 82 */
      {-56, 84},        /* 83 */
      {-1280, -1344},   /* 84 */
      {-18, 86},        /* 85 */
      {89, 87},         /* 86 */
      {88, -55},        /* 87 */
      {-768, -832},     /* 88 */
      {-52, 90},        /* 89 */
      {-640, -704}      /* 90 */
};

const int gTwoTree [][2] =
{
      {1, VTMODE0},        /* 0 */
      {2, 3},              /* 1 */
      {4, HORZMODE},       /* 2 */
      {VTMODE1N, VTMODE1P},/* 3 */
      {5, PASSMODE},       /* 4 */
      {6, 7},              /* 5 */
      {8, 9},              /* 6 */
      {VTMODE2N, VTMODE2P},/* 7 */
      {OUREOL, BADRUN},    /* 8 */
      {VTMODE3N, VTMODE3P} /* 9 */
};

const unsigned char gBackward[256] =
{
   0x00,0x80,0x40,0xC0,0x20,0xA0,0x60,0xE0,0x10,0x90,0x50,0xD0,0x30,0xB0,0x70,0xF0,
   0x08,0x88,0x48,0xC8,0x28,0xA8,0x68,0xE8,0x18,0x98,0x58,0xD8,0x38,0xB8,0x78,0xF8,
   0x04,0x84,0x44,0xC4,0x24,0xA4,0x64,0xE4,0x14,0x94,0x54,0xD4,0x34,0xB4,0x74,0xF4,
   0x0C,0x8C,0x4C,0xCC,0x2C,0xAC,0x6C,0xEC,0x1C,0x9C,0x5C,0xDC,0x3C,0xBC,0x7C,0xFC,
   0x02,0x82,0x42,0xC2,0x22,0xA2,0x62,0xE2,0x12,0x92,0x52,0xD2,0x32,0xB2,0x72,0xF2,
   0x0A,0x8A,0x4A,0xCA,0x2A,0xAA,0x6A,0xEA,0x1A,0x9A,0x5A,0xDA,0x3A,0xBA,0x7A,0xFA,
   0x06,0x86,0x46,0xC6,0x26,0xA6,0x66,0xE6,0x16,0x96,0x56,0xD6,0x36,0xB6,0x76,0xF6,
   0x0E,0x8E,0x4E,0xCE,0x2E,0xAE,0x6E,0xEE,0x1E,0x9E,0x5E,0xDE,0x3E,0xBE,0x7E,0xFE,
   0x01,0x81,0x41,0xC1,0x21,0xA1,0x61,0xE1,0x11,0x91,0x51,0xD1,0x31,0xB1,0x71,0xF1,
   0x09,0x89,0x49,0xC9,0x29,0xA9,0x69,0xE9,0x19,0x99,0x59,0xD9,0x39,0xB9,0x79,0xF9,
   0x05,0x85,0x45,0xC5,0x25,0xA5,0x65,0xE5,0x15,0x95,0x55,0xD5,0x35,0xB5,0x75,0xF5,
   0x0D,0x8D,0x4D,0xCD,0x2D,0xAD,0x6D,0xED,0x1D,0x9D,0x5D,0xDD,0x3D,0xBD,0x7D,0xFD,
   0x03,0x83,0x43,0xC3,0x23,0xA3,0x63,0xE3,0x13,0x93,0x53,0xD3,0x33,0xB3,0x73,0xF3,
   0x0B,0x8B,0x4B,0xCB,0x2B,0xAB,0x6B,0xEB,0x1B,0x9B,0x5B,0xDB,0x3B,0xBB,0x7B,0xFB,
   0x07,0x87,0x47,0xC7,0x27,0xA7,0x67,0xE7,0x17,0x97,0x57,0xD7,0x37,0xB7,0x77,0xF7,
   0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF,0x1F,0x9F,0x5F,0xDF,0x3F,0xBF,0x7F,0xFF
};

