# CAPSENSE™ Middleware Library 3.0

### What's Included?
Please refer to the [README.md](./README.md) and the [API Reference Guide](https://cypresssemiconductorco.github.io/capsense/capsense_api_reference_manual/html/index.html) for a complete description of the CAPSENSE™ Middleware.
The revision history of the CAPSENSE™ Middleware is also available on the [API Reference Guide Changelog](https://cypresssemiconductorco.github.io/capsense/capsense_api_reference_manual/html/index.html#section_capsense_changelog).
New important things in this release:
* Added CAPSENSE™ fifth-generation device support
* Added flash memory optimization


### Known Issues
Refer to the [API Reference Guide - Errata section](https://cypresssemiconductorco.github.io/capsense/capsense_api_reference_manual/html/index.html#section_capsense_errata) for a complete description of the known issues and possible workarounds

### Supported Software and Tools
This version of the CAPSENSE™ Middleware was validated for compatibility with the following Software and Tools:

| Software and Tools                                                                                | Version |
| :---                                                                                              | :----:  |
| ModusToolbox™ Software Environment                                                                | 2.4     |
| - ModusToolbox™ Device Configurator                                                               | 3.10    |
| - ModusToolbox™ MSC Superblock Personality for for PSoC™ 4 devices in the Device Configurator     | 1.0     |
| - ModusToolbox™ MSC Personality for PSoC™ 4 devices in Device Configurator                        | 1.1     |
| - ModusToolbox™ CSD Personality for PSoC™ 4 devices in Device Configurator                        | 1.1     |
| - ModusToolbox™ CSD Personality for PSoC™ 6 devices in Device Configurator                        | 2.0     |
| - ModusToolbox™ CAPSENSE™ Configurator / Tuner tools                                              | 4.0     |
| CAT1 Peripheral Driver Library (PDL)                                                              | 2.3.0   |
| CAT2 Peripheral Driver Library (PDL)                                                              | 1.4.0   |
| GCC Compiler                                                                                      | 9.3.1   |
| IAR Compiler                                                                                      | 8.42.1  |
| ARM Compiler 6                                                                                    | 6.13    |
| MBED OS                                                                                           | 5.15.8  |
| FreeRTOS                                                                                          | 10.4.5  |

### More information
The following resources contain more information:
* CAPSENSE™ Overview:
  * [CAPSENSE™ Middleware RELEASE.md](./RELEASE.md)
  * [CAPSENSE™ Middleware API Reference Guide](https://cypresssemiconductorco.github.io/capsense/capsense_api_reference_manual/html/index.html)
  * [ModusToolbox™ CAPSENSE™ Configurator Tool Guide](https://www.cypress.com/ModusToolboxCapSenseConfig)
  * [ModusToolbox™ CAPSENSE™ Tuner Tool Guide](https://www.cypress.com/ModusToolboxCapSenseTuner)
  * [CAPSENSE™ Design Guide](https://www.cypress.com/documentation/application-notes/an85951-psoc-4-and-psoc-6-mcu-capsense-design-guide)
  * [CSDADC Middleware API Reference Guide](https://cypresssemiconductorco.github.io/csdadc/csdadc_api_reference_manual/html/index.html)
  * [CSDIDAC Middleware API Reference Guide](https://cypresssemiconductorco.github.io/csdidac/csdidac_api_reference_manual/html/index.html)
* ModusToolbox™ Overview:
  * [ModusToolbox™ Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment)
  * [ModusToolbox™ Device Configurator Tool Guide](https://www.cypress.com/ModusToolboxDeviceConfig)
* Infineon Technologies Kits and Code Examples:
  * [CAPSENSE™ Middleware Code Example for MBED OS](https://github.com/cypresssemiconductorco/mbed-os-example-capsense)
  * [CAPSENSE™ Middleware Code Example for FreeRTOS](https://www.cypress.com/documentation/code-examples/ce218136-psoc-6-mcu-e-ink-display-capsense-rtos)
  * [CY8CKIT-145-40XX PSoC™ 4000S CAPSENSE™ Prototyping Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-145-40xx-psoc-4000s-capsense-prototyping-kit)
  * [CY8CKIT-149 PSoC™ 4100S Plus Prototyping Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-149-psoc-4100s-plus-prototyping-kit)
  * [CY8CKIT-041-40XX PSoC™ 4 S-Series Pioneer Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-041-psoc-4-s-series-pioneer-kit)
  * [CY8CKIT-041-41XX PSoC™ 4100S CAPSENSE™ Pioneer Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-041-41xx-psoc-4100s-capsense-pioneer-kit)
* General Information:
  * [AN210781 Getting Started with PSoC™ 6 MCU with Bluetooth Low Energy (BLE) Connectivity](http://www.cypress.com/an210781)
  * [PSoC™ 6 Technical Reference Manual](https://www.cypress.com/documentation/technical-reference-manuals/psoc-6-mcu-psoc-63-ble-architecture-technical-reference)
  * [PSoC™ 63 with BLE Datasheet Programmable System-on-Chip datasheet](http://www.cypress.com/ds218787)
  * [CAT1 PDL API Reference](https://cypresssemiconductorco.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/index.html)
  * [CAT2 PDL API Reference](https://cypresssemiconductorco.github.io/mtb-pdl-cat2/pdl_api_reference_manual/html/index.html)
  * [PSoC™ 4000S Family: PSoC™ 4 Architecture Technical Reference Manual (TRM)](https://www.cypress.com/documentation/technical-reference-manuals/psoc-4000s-family-psoc-4-architecture-technical-reference)
  * [PSoC™ 4100S and PSoC™ 4100S Plus: PSoC™ 4 Architecture Technical Reference Manual (TRM)](https://www.cypress.com/documentation/technical-reference-manuals/psoc-4100s-and-psoc-4100s-plus-psoc-4-architecture)
  * [Infineon Technologies GitHub](https://github.com/Infineon)
  * [Infineon Technologies](http://www.infineon.com)

---
CYPRESS™ Semiconductor Corporation, 2019-2021.