/***************************************************************************//**
* \file cyhal_triggers_psoc6_02.c
*
* \brief
* PSoC6_02 family HAL triggers header
*
********************************************************************************
* \copyright
* (c) (2016-2023), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cy_device_headers.h"
#include "cyhal_hw_types.h"

#ifdef CY_DEVICE_PSOC6A2M
#include "triggers/cyhal_triggers_psoc6_02.h"

const uint16_t cyhal_sources_per_mux[17] =
{
    87, 86, 135, 135, 223, 251, 27, 3, 127, 127, 12, 14, 1, 2, 5, 8, 8,
};

const bool cyhal_is_mux_1to1[17] =
{
    false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux0_sources[87] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux1_sources[86] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux2_sources[135] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB11_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB12_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_RX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_PDM_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux3_sources[135] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB11_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB12_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_RX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_PDM_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux4_sources[223] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB11_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB12_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_RX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_PDM_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_CSD_DSI_SAMPLE_OUT,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux5_sources[251] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB11_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB12_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_RX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_PDM_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_CSD_DSI_SAMPLE_OUT,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux6_sources[27] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux7_sources[3] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux8_sources[127] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux9_sources[127] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux10_sources[12] =
{
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux11_sources[14] =
{
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB11_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB12_TR_RX_REQ,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux12_sources[1] =
{
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux13_sources[2] =
{
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux14_sources[5] =
{
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_PDM_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux15_sources[8] =
{
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
};

const _cyhal_trigger_source_psoc6_02_t cyhal_mux16_sources[8] =
{
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
};

const _cyhal_trigger_source_psoc6_02_t* cyhal_mux_to_sources[17] =
{
    cyhal_mux0_sources,
    cyhal_mux1_sources,
    cyhal_mux2_sources,
    cyhal_mux3_sources,
    cyhal_mux4_sources,
    cyhal_mux5_sources,
    cyhal_mux6_sources,
    cyhal_mux7_sources,
    cyhal_mux8_sources,
    cyhal_mux9_sources,
    cyhal_mux10_sources,
    cyhal_mux11_sources,
    cyhal_mux12_sources,
    cyhal_mux13_sources,
    cyhal_mux14_sources,
    cyhal_mux15_sources,
    cyhal_mux16_sources,
};

const uint8_t cyhal_dest_to_mux[107] =
{
    5, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    5, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN2 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN3 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 */
    130, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 */
    8, /* CYHAL_TRIGGER_CSD_DSI_START */
    9, /* CYHAL_TRIGGER_PASS_TR_SAR_IN */
    7, /* CYHAL_TRIGGER_PERI_TR_DBG_FREEZE */
    4, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    4, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    5, /* CYHAL_TRIGGER_PROFILE_TR_START */
    5, /* CYHAL_TRIGGER_PROFILE_TR_STOP */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN0 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN2 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN3 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN4 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN5 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN6 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN7 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN8 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN9 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN10 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN11 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN12 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN13 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN0 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN1 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN3 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN4 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN5 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN6 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN7 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN8 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN9 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN10 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN11 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN12 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN13 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND0 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND1 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND2 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND3 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND4 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND5 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND6 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND7 */
};

const uint8_t cyhal_mux_dest_index[107] =
{
    0, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN3 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    8, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 */
    9, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 */
    10, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 */
    11, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 */
    12, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 */
    13, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 */
    0, /* CYHAL_TRIGGER_CSD_DSI_START */
    0, /* CYHAL_TRIGGER_PASS_TR_SAR_IN */
    0, /* CYHAL_TRIGGER_PERI_TR_DBG_FREEZE */
    0, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    1, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    2, /* CYHAL_TRIGGER_PROFILE_TR_START */
    3, /* CYHAL_TRIGGER_PROFILE_TR_STOP */
    0, /* CYHAL_TRIGGER_TCPWM0_TR_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM0_TR_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM0_TR_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM0_TR_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM0_TR_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM0_TR_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM0_TR_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM0_TR_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM0_TR_IN11 */
    12, /* CYHAL_TRIGGER_TCPWM0_TR_IN12 */
    13, /* CYHAL_TRIGGER_TCPWM0_TR_IN13 */
    0, /* CYHAL_TRIGGER_TCPWM1_TR_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM1_TR_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM1_TR_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM1_TR_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM1_TR_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM1_TR_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM1_TR_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM1_TR_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM1_TR_IN11 */
    12, /* CYHAL_TRIGGER_TCPWM1_TR_IN12 */
    13, /* CYHAL_TRIGGER_TCPWM1_TR_IN13 */
    0, /* CYHAL_TRIGGER_USB_DMA_BURSTEND0 */
    1, /* CYHAL_TRIGGER_USB_DMA_BURSTEND1 */
    2, /* CYHAL_TRIGGER_USB_DMA_BURSTEND2 */
    3, /* CYHAL_TRIGGER_USB_DMA_BURSTEND3 */
    4, /* CYHAL_TRIGGER_USB_DMA_BURSTEND4 */
    5, /* CYHAL_TRIGGER_USB_DMA_BURSTEND5 */
    6, /* CYHAL_TRIGGER_USB_DMA_BURSTEND6 */
    7, /* CYHAL_TRIGGER_USB_DMA_BURSTEND7 */
};

#endif /* CY_DEVICE_PSOC6A2M */
