/***************************************************************************//**
* \file cyhal_triggers_xmc7200.c
*
* \brief
* XMC7200 family HAL triggers header
*
********************************************************************************
* \copyright
* (c) (2016-2023), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cy_device_headers.h"
#include "cyhal_hw_types.h"

#ifdef CY_DEVICE_TVIIBH8M
#include "triggers/cyhal_triggers_xmc7200.h"

const uint16_t cyhal_sources_per_mux[27] =
{
    96, 77, 127, 7, 103, 168, 112, 69, 12, 16, 239, 178, 198, 15, 96, 22, 2, 15, 6, 96, 96, 5, 5, 20, 2, 2, 2,
};

const bool cyhal_is_mux_1to1[27] =
{
    false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux0_sources[96] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT7,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT2,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT3,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux1_sources[77] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT04,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT05,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT06,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT07,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT08,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT09,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT010,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT011,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT012,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT013,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT014,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT015,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT016,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT017,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT018,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT019,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT020,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT021,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT022,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT023,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT024,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT025,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT026,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT027,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT028,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT029,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0264,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0265,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0266,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0267,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0515,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0516,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0517,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0518,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0519,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0520,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0521,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0522,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0523,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0524,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT0,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT1,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT2,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT3,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux2_sources[127] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT030,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT031,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT032,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT033,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT034,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT035,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT036,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT037,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT038,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT039,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT040,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT041,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT042,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT043,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT044,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT045,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT046,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT047,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT048,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT049,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT050,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT051,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT052,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT053,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT054,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT055,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT056,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT057,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT058,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT059,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT060,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT061,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT062,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT063,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT064,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT065,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT066,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT067,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT068,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT069,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT070,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT071,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT072,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT073,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT074,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT075,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT076,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT077,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT078,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT079,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT080,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT081,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT082,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT083,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT28,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT29,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT30,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT31,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT32,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT33,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT34,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT35,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT36,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT37,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT38,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT39,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT40,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT41,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT42,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT43,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT44,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT45,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT46,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT47,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux3_sources[7] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux4_sources[103] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT04,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT05,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT06,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT07,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT08,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT09,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT010,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT011,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT012,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT013,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT014,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT015,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0515,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0516,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0517,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0518,
    _CYHAL_TRIGGER_SMIF0_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF0_TR_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_RX_REQ,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux5_sources[168] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT04,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT05,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT06,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT07,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT08,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT09,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT010,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT011,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT012,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT013,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT014,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT015,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT016,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT017,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT018,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT019,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT020,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT021,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT022,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT023,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT024,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT025,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT026,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT027,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT028,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT029,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT030,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT031,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT032,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT033,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT034,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT035,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT036,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT037,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT038,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT039,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT040,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT041,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT042,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT043,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT044,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT045,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT046,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT047,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT048,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT049,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT050,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT051,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT052,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT053,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT054,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT055,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT056,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT057,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT058,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT059,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT060,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT061,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT062,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT063,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT064,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT065,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT066,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT067,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT068,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT069,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT070,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT071,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT072,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT073,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT074,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT075,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT076,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT077,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT078,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT079,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT080,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT081,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT082,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT083,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0264,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0265,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0266,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0267,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0515,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0516,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0517,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0518,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0519,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0520,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0521,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0522,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0523,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0524,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ1,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ2,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ3,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ4,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO01,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO02,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO03,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO04,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO10,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO11,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO12,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO13,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO14,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ1,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ2,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ3,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ4,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO01,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO02,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO03,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO04,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO10,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO11,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO12,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO13,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO14,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT4,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT5,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT6,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT7,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT8,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT9,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT10,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT11,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux6_sources[112] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT10,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT11,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT12,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT13,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT14,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT15,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT16,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT17,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT18,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT19,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT110,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT111,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT112,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT113,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT114,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT115,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_FLEXRAY0_TR_IBF_OUT,
    _CYHAL_TRIGGER_FLEXRAY0_TR_OBF_OUT,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT28,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT29,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT30,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT31,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT32,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT33,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT34,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT35,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT36,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT37,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT38,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT39,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT40,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT41,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT42,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT43,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT44,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT45,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT46,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT47,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT2,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT3,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux7_sources[69] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0264,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0265,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0266,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0267,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0515,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0516,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0517,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0518,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0519,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0520,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0521,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0522,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0523,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0524,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT12,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT13,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT14,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux8_sources[12] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux9_sources[16] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux10_sources[239] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT32,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT33,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT34,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT35,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT36,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT37,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT38,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT39,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT40,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT41,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT42,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT43,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT44,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT45,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT46,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT47,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT48,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT49,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT50,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT51,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT52,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT53,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT54,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT55,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT56,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT57,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT58,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT59,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT60,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT61,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT62,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT63,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT64,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT65,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT66,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT67,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT68,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT69,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT70,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT71,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT72,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT73,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT74,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT75,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT76,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT77,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT78,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT79,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT80,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT81,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT82,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT83,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT84,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT85,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT86,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT87,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT88,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT89,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT90,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT91,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT92,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT93,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT94,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT95,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT96,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT97,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT98,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT99,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT100,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT101,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT102,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT103,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT104,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT105,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT106,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT107,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT108,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT109,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT110,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT111,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT112,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT113,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT114,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT115,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT116,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT117,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT118,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT119,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT120,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT121,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT122,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT123,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT124,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT125,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT126,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT127,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT128,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT129,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT130,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT131,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT132,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT133,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT134,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT135,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT136,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT137,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT138,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT139,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT140,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT141,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT142,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ1,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ2,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ3,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ4,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO01,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO02,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO03,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO04,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO10,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO11,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO12,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO13,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO14,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ1,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ2,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ3,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ4,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO01,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO02,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO03,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO04,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO10,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO11,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO12,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO13,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO14,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3,
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT2,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT3,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT0,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT1,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT2,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT3,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT4,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT5,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT6,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT7,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT8,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT9,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT10,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT11,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT12,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT13,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT14,
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT15,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux11_sources[178] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0515,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0516,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0517,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0518,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0519,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0520,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0521,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0522,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0523,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0524,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0512,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0513,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0264,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0265,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0266,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0267,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT04,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT05,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT06,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT07,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT08,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT09,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT010,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT011,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT012,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT013,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT014,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT015,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT016,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT017,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT018,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT019,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT020,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT021,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT022,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT023,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT024,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT025,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT026,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT027,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT028,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT029,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT030,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT031,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT032,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT033,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT034,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT035,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT036,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT037,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT038,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT039,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT040,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT041,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT042,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT043,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT044,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT045,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT046,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT047,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT048,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT049,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT050,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT051,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT052,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT053,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT054,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT055,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT056,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT057,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT058,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT059,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT060,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT061,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT062,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT063,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT064,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT065,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT066,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT067,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT068,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT069,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT070,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT071,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT072,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT073,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT074,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT075,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT076,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT077,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT078,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT079,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT080,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT081,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT082,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT083,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_SMIF0_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF0_TR_RX_REQ,
    _CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT,
    _CYHAL_TRIGGER_FLEXRAY0_TR_IBF_OUT,
    _CYHAL_TRIGGER_FLEXRAY0_TR_OBF_OUT,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT28,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT29,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT30,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT31,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT32,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT33,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT34,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT35,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT36,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT37,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT38,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT39,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT40,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT41,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT42,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT43,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT44,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT45,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT46,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT47,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux12_sources[198] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT31,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT32,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT33,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT34,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT35,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT36,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT37,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT38,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT39,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT40,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT41,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT42,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT43,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT44,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT45,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT46,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT47,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT48,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT49,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT50,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT51,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT52,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT53,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT54,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT55,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT56,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT57,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT58,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT59,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT60,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT61,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT62,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT63,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT64,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1512,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1513,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT10,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT11,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT12,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT13,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT14,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT15,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT16,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT17,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT18,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT19,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT110,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT111,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT112,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT113,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT114,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT115,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT116,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT117,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT118,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT119,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT120,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT121,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT122,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT123,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT124,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT125,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT126,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT127,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT128,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT129,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT130,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT131,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT132,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT133,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT134,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT135,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT136,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT137,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT138,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT139,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT140,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT141,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT142,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT143,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT144,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT145,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT146,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT147,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT148,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT149,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT150,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT151,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT152,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT153,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT154,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT155,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT156,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT157,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT158,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT159,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT160,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT161,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT162,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT163,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT164,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT165,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT166,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT167,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT168,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT169,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT170,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT171,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT172,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT173,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT174,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT175,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT176,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT177,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT178,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT179,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT180,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT181,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT182,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT183,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1262,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1263,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1264,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1265,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1266,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1267,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1512,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1513,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1514,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1515,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1516,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1517,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1518,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1519,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1520,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1521,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1522,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1523,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1524,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4,
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux13_sources[15] =
{
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO10,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ1,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO01,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO11,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ2,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO02,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO12,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ3,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO03,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO13,
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ4,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO04,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO14,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux14_sources[96] =
{
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux15_sources[22] =
{
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux16_sources[2] =
{
    _CYHAL_TRIGGER_SMIF0_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF0_TR_RX_REQ,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux17_sources[15] =
{
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO10,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ1,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO01,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO11,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ2,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO02,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO12,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ3,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO03,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO13,
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ4,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO04,
    _CYHAL_TRIGGER_CANFD1_TR_FIFO14,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux18_sources[6] =
{
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_RX_REQ,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux19_sources[96] =
{
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO0,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO1,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO2,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO3,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO4,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO5,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO6,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO7,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO8,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO9,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO10,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO11,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO12,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO13,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO14,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO15,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO16,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO17,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO18,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO19,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO20,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO21,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO22,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO23,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO24,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO25,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO26,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO27,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO28,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO29,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO30,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO31,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO32,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO33,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO34,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO35,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO36,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO37,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO38,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO39,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO40,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO41,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO42,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO43,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO44,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO45,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO46,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO47,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO48,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO49,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO50,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO51,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO52,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO53,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO54,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO55,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO56,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO57,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO58,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO59,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO60,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO61,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO62,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO63,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO64,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO65,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO66,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO67,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO68,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO69,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO70,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO71,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO72,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO73,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO74,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO75,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO76,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO77,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO78,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO79,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO80,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO81,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO82,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO83,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO84,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO85,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO86,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO87,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO88,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO89,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO90,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO91,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO92,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO93,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO94,
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO95,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux20_sources[96] =
{
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1256,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1259,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1262,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1265,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT10,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT11,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT12,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT13,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT14,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT15,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT16,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT17,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT18,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT19,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT110,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT111,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT112,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT113,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT114,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT115,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT116,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT117,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT118,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT119,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT120,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT121,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT122,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT123,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT124,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT125,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT126,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT127,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1257,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1260,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1263,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1266,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT128,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT129,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT130,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT131,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT132,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT133,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT134,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT135,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT136,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT137,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT138,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT139,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT140,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT141,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT142,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT143,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT144,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT145,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT146,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT147,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT148,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT149,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT150,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT151,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT152,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT153,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT154,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT155,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1258,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1261,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1264,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1267,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT156,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT157,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT158,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT159,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT160,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT161,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT162,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT163,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT164,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT165,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT166,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT167,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT168,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT169,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT170,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT171,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT172,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT173,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT174,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT175,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT176,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT177,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT178,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT179,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT180,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT181,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT182,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT183,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux21_sources[5] =
{
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT38,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT41,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT44,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT47,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT50,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux22_sources[5] =
{
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT32,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT35,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT38,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT41,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT44,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux23_sources[20] =
{
    _CYHAL_TRIGGER_TCPWM1_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT04,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT05,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT06,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT07,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT08,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT09,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT010,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT011,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT012,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT013,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT014,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT015,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT016,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT017,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT018,
    _CYHAL_TRIGGER_TCPWM1_TR_OUT019,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux24_sources[2] =
{
    _CYHAL_TRIGGER_FLEXRAY0_TR_IBF_OUT,
    _CYHAL_TRIGGER_FLEXRAY0_TR_OBF_OUT,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux25_sources[2] =
{
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT61,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT62,
};

const _cyhal_trigger_source_xmc7200_t cyhal_mux26_sources[2] =
{
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT63,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT64,
};

const _cyhal_trigger_source_xmc7200_t* cyhal_mux_to_sources[27] =
{
    cyhal_mux0_sources,
    cyhal_mux1_sources,
    cyhal_mux2_sources,
    cyhal_mux3_sources,
    cyhal_mux4_sources,
    cyhal_mux5_sources,
    cyhal_mux6_sources,
    cyhal_mux7_sources,
    cyhal_mux8_sources,
    cyhal_mux9_sources,
    cyhal_mux10_sources,
    cyhal_mux11_sources,
    cyhal_mux12_sources,
    cyhal_mux13_sources,
    cyhal_mux14_sources,
    cyhal_mux15_sources,
    cyhal_mux16_sources,
    cyhal_mux17_sources,
    cyhal_mux18_sources,
    cyhal_mux19_sources,
    cyhal_mux20_sources,
    cyhal_mux21_sources,
    cyhal_mux22_sources,
    cyhal_mux23_sources,
    cyhal_mux24_sources,
    cyhal_mux25_sources,
    cyhal_mux26_sources,
};

const uint8_t cyhal_dest_to_mux[543] =
{
    137, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK0 */
    137, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK1 */
    137, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK2 */
    137, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK3 */
    137, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK4 */
    136, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK0 */
    136, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK1 */
    136, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK2 */
    136, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK3 */
    136, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK4 */
    8, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN0 */
    8, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN1 */
    8, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN2 */
    8, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN3 */
    8, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN4 */
    8, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN0 */
    8, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN1 */
    8, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN2 */
    8, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN3 */
    8, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN4 */
    9, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    9, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN3 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN4 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN5 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN6 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN29 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN30 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN31 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN32 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN33 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN34 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN35 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN36 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN37 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN38 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN39 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN40 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN41 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN42 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN43 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN44 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN45 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN46 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN47 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN48 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN49 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN50 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN51 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN52 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN53 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN54 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN55 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN56 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN57 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN58 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN59 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN60 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN61 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN62 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN63 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN64 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN65 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN66 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN67 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN68 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN69 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN70 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN71 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN72 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN73 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN74 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN75 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN76 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN77 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN78 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN79 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN80 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN81 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN82 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN83 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN84 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN85 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN86 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN87 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN88 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN89 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN90 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN91 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN92 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN93 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN94 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN95 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN96 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN97 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN98 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN99 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN100 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN101 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN102 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN103 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN104 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN105 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN106 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN107 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN108 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN109 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN110 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN111 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN112 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN113 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN114 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN115 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN116 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN117 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN118 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN119 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN120 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN121 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN122 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN123 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN124 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN125 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN126 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN127 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN128 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN129 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN130 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN131 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN132 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN133 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN134 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN135 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN136 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN137 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN138 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN139 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN140 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN141 */
    129, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN142 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN29 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN30 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN31 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN32 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN33 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN34 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN35 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN36 */
    130, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN37 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN38 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN39 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN40 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN41 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN42 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN43 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN44 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN45 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN46 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN47 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN48 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN49 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN50 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN51 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN52 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN53 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN54 */
    133, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN55 */
    133, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN56 */
    133, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN57 */
    133, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN58 */
    133, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN59 */
    133, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN60 */
    139, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN61 */
    139, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN62 */
    140, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN63 */
    140, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN64 */
    141, /* CYHAL_TRIGGER_FLEXRAY0_TR_IBF_IN */
    141, /* CYHAL_TRIGGER_FLEXRAY0_TR_OBF_IN */
    8, /* CYHAL_TRIGGER_FLEXRAY0_TR_STPWT_IN */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER0 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER1 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER2 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER3 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER4 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER5 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER6 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER7 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER8 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER9 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER10 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER11 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER12 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER13 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER14 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER15 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER16 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER17 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER18 */
    138, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER19 */
    9, /* CYHAL_TRIGGER_PASS0_TR_DEBUG_FREEZE */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN0 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN1 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN2 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN3 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN4 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN5 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN6 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN7 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN8 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN9 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN10 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN11 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN12 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN13 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN14 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN15 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN16 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN17 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN18 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN19 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN20 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN21 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN22 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN23 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN24 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN25 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN26 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN27 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN28 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN29 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN30 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN31 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN32 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN33 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN34 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN35 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN36 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN37 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN38 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN39 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN40 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN41 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN42 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN43 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN44 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN45 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN46 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN47 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN48 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN49 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN50 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN51 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN52 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN53 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN54 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN55 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN56 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN57 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN58 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN59 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN60 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN61 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN62 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN63 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN64 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN65 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN66 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN67 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN68 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN69 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN70 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN71 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN72 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN73 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN74 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN75 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN76 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN77 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN78 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN79 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN80 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN81 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN82 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN83 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN84 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN85 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN86 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN87 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN88 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN89 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN90 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN91 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN92 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN93 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN94 */
    135, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN95 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN0 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN1 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN2 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN3 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN4 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN5 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN6 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN7 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN8 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN9 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN10 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN11 */
    9, /* CYHAL_TRIGGER_PERI_TR_DBG_FREEZE */
    9, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    9, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    9, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT0 */
    9, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT1 */
    9, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT2 */
    9, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_WDT */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN0 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN1 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN2 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN4 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN5 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN6 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN7 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN8 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN9 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN10 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN11 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN0 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN1 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN2 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN3 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN5 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN6 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN7 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN8 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN9 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN10 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN11 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN12 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN13 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN14 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN15 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN16 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN17 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN18 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN19 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN20 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN21 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN22 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN23 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN24 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN25 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN26 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN27 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN28 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN29 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN30 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN31 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN32 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN33 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN34 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN35 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN36 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN37 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN38 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN39 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN40 */
    9, /* CYHAL_TRIGGER_TCPWM0_TR_DEBUG_FREEZE */
    9, /* CYHAL_TRIGGER_TCPWM1_TR_DEBUG_FREEZE */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN2 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN5 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN8 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN11 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN14 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN17 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN20 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN23 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN26 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN29 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN32 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN35 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN38 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN41 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN44 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN47 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN50 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN53 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN56 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN59 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN62 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN65 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN68 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN71 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN74 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN77 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN80 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN83 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN86 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN89 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN92 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN95 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN98 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN101 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN104 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN107 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN110 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN113 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN116 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN119 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN122 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN125 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN128 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN131 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN134 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN137 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN140 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN143 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN146 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN149 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN152 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN155 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN158 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN161 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN164 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN167 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN170 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN173 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN176 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN179 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN182 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN185 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN188 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN191 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN194 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN197 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN200 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN203 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN206 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN209 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN212 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN215 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN218 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN221 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN224 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN227 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN230 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN233 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN236 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN239 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN242 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN245 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN248 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN251 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN770 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN773 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN776 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN779 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN782 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN785 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN788 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN791 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN794 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN797 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN800 */
    134, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN803 */
    10, /* CYHAL_TRIGGER_TR_GROUP9_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP9_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP9_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP9_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP9_INPUT5 */
    11, /* CYHAL_TRIGGER_TR_GROUP9_INPUT6 */
    11, /* CYHAL_TRIGGER_TR_GROUP9_INPUT7 */
    11, /* CYHAL_TRIGGER_TR_GROUP9_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP9_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP9_INPUT10 */
    12, /* CYHAL_TRIGGER_TR_GROUP9_INPUT11 */
    12, /* CYHAL_TRIGGER_TR_GROUP9_INPUT12 */
    12, /* CYHAL_TRIGGER_TR_GROUP9_INPUT13 */
    12, /* CYHAL_TRIGGER_TR_GROUP9_INPUT14 */
    12, /* CYHAL_TRIGGER_TR_GROUP9_INPUT15 */
};

const uint8_t cyhal_mux_dest_index[543] =
{
    0, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK0 */
    1, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK1 */
    2, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK2 */
    3, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK3 */
    4, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK4 */
    0, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK0 */
    1, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK1 */
    2, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK2 */
    3, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK3 */
    4, /* CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK4 */
    0, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN0 */
    1, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN1 */
    2, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN2 */
    3, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN3 */
    4, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN4 */
    5, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN0 */
    6, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN1 */
    7, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN2 */
    8, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN3 */
    9, /* CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN4 */
    2, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    3, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    12, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    13, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    14, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    15, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 */
    12, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 */
    13, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN29 */
    14, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN30 */
    15, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN31 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN32 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN33 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN34 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN35 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN36 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN37 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN38 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN39 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN40 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN41 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN42 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN43 */
    12, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN44 */
    13, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN45 */
    14, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN46 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN47 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN48 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN49 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN50 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN51 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN52 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN53 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN54 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN55 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN56 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN57 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN58 */
    12, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN59 */
    13, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN60 */
    14, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN61 */
    15, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN62 */
    16, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN63 */
    17, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN64 */
    18, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN65 */
    19, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN66 */
    20, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN67 */
    21, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN68 */
    22, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN69 */
    23, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN70 */
    24, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN71 */
    25, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN72 */
    26, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN73 */
    27, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN74 */
    28, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN75 */
    29, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN76 */
    30, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN77 */
    31, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN78 */
    32, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN79 */
    33, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN80 */
    34, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN81 */
    35, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN82 */
    36, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN83 */
    37, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN84 */
    38, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN85 */
    39, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN86 */
    40, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN87 */
    41, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN88 */
    42, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN89 */
    43, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN90 */
    44, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN91 */
    45, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN92 */
    46, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN93 */
    47, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN94 */
    48, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN95 */
    49, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN96 */
    50, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN97 */
    51, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN98 */
    52, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN99 */
    53, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN100 */
    54, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN101 */
    55, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN102 */
    56, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN103 */
    57, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN104 */
    58, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN105 */
    59, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN106 */
    60, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN107 */
    61, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN108 */
    62, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN109 */
    63, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN110 */
    64, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN111 */
    65, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN112 */
    66, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN113 */
    67, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN114 */
    68, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN115 */
    69, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN116 */
    70, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN117 */
    71, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN118 */
    72, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN119 */
    73, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN120 */
    74, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN121 */
    75, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN122 */
    76, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN123 */
    77, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN124 */
    78, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN125 */
    79, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN126 */
    80, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN127 */
    81, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN128 */
    82, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN129 */
    83, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN130 */
    84, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN131 */
    85, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN132 */
    86, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN133 */
    87, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN134 */
    88, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN135 */
    89, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN136 */
    90, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN137 */
    91, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN138 */
    92, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN139 */
    93, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN140 */
    94, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN141 */
    95, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN142 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    8, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    9, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    10, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    11, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    12, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    13, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    14, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    15, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 */
    8, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 */
    9, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 */
    10, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 */
    11, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 */
    12, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 */
    13, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN29 */
    14, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN30 */
    15, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN31 */
    16, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN32 */
    17, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN33 */
    18, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN34 */
    19, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN35 */
    20, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN36 */
    21, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN37 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN38 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN39 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN40 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN41 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN42 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN43 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN44 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN45 */
    8, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN46 */
    9, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN47 */
    10, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN48 */
    11, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN49 */
    12, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN50 */
    13, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN51 */
    14, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN52 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN53 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN54 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN55 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN56 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN57 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN58 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN59 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN60 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN61 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN62 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN63 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN64 */
    0, /* CYHAL_TRIGGER_FLEXRAY0_TR_IBF_IN */
    1, /* CYHAL_TRIGGER_FLEXRAY0_TR_OBF_IN */
    10, /* CYHAL_TRIGGER_FLEXRAY0_TR_STPWT_IN */
    0, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER0 */
    1, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER1 */
    2, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER2 */
    3, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER3 */
    4, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER4 */
    5, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER5 */
    6, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER6 */
    7, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER7 */
    8, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER8 */
    9, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER9 */
    10, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER10 */
    11, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER11 */
    12, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER12 */
    13, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER13 */
    14, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER14 */
    15, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER15 */
    16, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER16 */
    17, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER17 */
    18, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER18 */
    19, /* CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER19 */
    5, /* CYHAL_TRIGGER_PASS0_TR_DEBUG_FREEZE */
    0, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN0 */
    1, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN1 */
    2, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN2 */
    3, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN3 */
    4, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN4 */
    5, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN5 */
    6, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN6 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN7 */
    8, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN8 */
    9, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN9 */
    10, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN10 */
    11, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN11 */
    12, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN12 */
    13, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN13 */
    14, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN14 */
    15, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN15 */
    16, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN16 */
    17, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN17 */
    18, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN18 */
    19, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN19 */
    20, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN20 */
    21, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN21 */
    22, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN22 */
    23, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN23 */
    24, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN24 */
    25, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN25 */
    26, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN26 */
    27, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN27 */
    28, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN28 */
    29, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN29 */
    30, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN30 */
    31, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN31 */
    32, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN32 */
    33, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN33 */
    34, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN34 */
    35, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN35 */
    36, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN36 */
    37, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN37 */
    38, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN38 */
    39, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN39 */
    40, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN40 */
    41, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN41 */
    42, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN42 */
    43, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN43 */
    44, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN44 */
    45, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN45 */
    46, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN46 */
    47, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN47 */
    48, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN48 */
    49, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN49 */
    50, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN50 */
    51, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN51 */
    52, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN52 */
    53, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN53 */
    54, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN54 */
    55, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN55 */
    56, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN56 */
    57, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN57 */
    58, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN58 */
    59, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN59 */
    60, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN60 */
    61, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN61 */
    62, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN62 */
    63, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN63 */
    64, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN64 */
    65, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN65 */
    66, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN66 */
    67, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN67 */
    68, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN68 */
    69, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN69 */
    70, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN70 */
    71, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN71 */
    72, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN72 */
    73, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN73 */
    74, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN74 */
    75, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN75 */
    76, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN76 */
    77, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN77 */
    78, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN78 */
    79, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN79 */
    80, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN80 */
    81, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN81 */
    82, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN82 */
    83, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN83 */
    84, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN84 */
    85, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN85 */
    86, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN86 */
    87, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN87 */
    88, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN88 */
    89, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN89 */
    90, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN90 */
    91, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN91 */
    92, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN92 */
    93, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN93 */
    94, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN94 */
    95, /* CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN95 */
    0, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN0 */
    1, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN1 */
    2, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN2 */
    3, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN3 */
    4, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN4 */
    5, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN5 */
    6, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN6 */
    7, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN7 */
    8, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN8 */
    9, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN9 */
    10, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN10 */
    11, /* CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN11 */
    4, /* CYHAL_TRIGGER_PERI_TR_DBG_FREEZE */
    0, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    1, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    9, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT0 */
    8, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT1 */
    7, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT2 */
    6, /* CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_WDT */
    0, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN11 */
    0, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN11 */
    0, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN12 */
    1, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN13 */
    2, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN14 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN15 */
    4, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN16 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN17 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN18 */
    7, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN19 */
    8, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN20 */
    9, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN21 */
    10, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN22 */
    11, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN23 */
    12, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN24 */
    13, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN25 */
    14, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN26 */
    15, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN27 */
    16, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN28 */
    17, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN29 */
    18, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN30 */
    19, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN31 */
    20, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN32 */
    21, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN33 */
    22, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN34 */
    23, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN35 */
    24, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN36 */
    25, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN37 */
    26, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN38 */
    27, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN39 */
    28, /* CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN40 */
    10, /* CYHAL_TRIGGER_TCPWM0_TR_DEBUG_FREEZE */
    11, /* CYHAL_TRIGGER_TCPWM1_TR_DEBUG_FREEZE */
    4, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN2 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN8 */
    7, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN11 */
    8, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN14 */
    9, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN17 */
    10, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN20 */
    11, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN23 */
    12, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN26 */
    13, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN29 */
    14, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN32 */
    15, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN35 */
    16, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN38 */
    17, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN41 */
    18, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN44 */
    19, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN47 */
    20, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN50 */
    21, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN53 */
    22, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN56 */
    23, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN59 */
    24, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN62 */
    25, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN65 */
    26, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN68 */
    27, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN71 */
    28, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN74 */
    29, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN77 */
    30, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN80 */
    31, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN83 */
    36, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN86 */
    37, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN89 */
    38, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN92 */
    39, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN95 */
    40, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN98 */
    41, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN101 */
    42, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN104 */
    43, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN107 */
    44, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN110 */
    45, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN113 */
    46, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN116 */
    47, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN119 */
    48, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN122 */
    49, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN125 */
    50, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN128 */
    51, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN131 */
    52, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN134 */
    53, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN137 */
    54, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN140 */
    55, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN143 */
    56, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN146 */
    57, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN149 */
    58, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN152 */
    59, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN155 */
    60, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN158 */
    61, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN161 */
    62, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN164 */
    63, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN167 */
    68, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN170 */
    69, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN173 */
    70, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN176 */
    71, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN179 */
    72, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN182 */
    73, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN185 */
    74, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN188 */
    75, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN191 */
    76, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN194 */
    77, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN197 */
    78, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN200 */
    79, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN203 */
    80, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN206 */
    81, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN209 */
    82, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN212 */
    83, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN215 */
    84, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN218 */
    85, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN221 */
    86, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN224 */
    87, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN227 */
    88, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN230 */
    89, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN233 */
    90, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN236 */
    91, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN239 */
    92, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN242 */
    93, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN245 */
    94, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN248 */
    95, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN251 */
    0, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN770 */
    32, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN773 */
    64, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN776 */
    1, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN779 */
    33, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN782 */
    65, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN785 */
    2, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN788 */
    34, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN791 */
    66, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN794 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN797 */
    35, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN800 */
    67, /* CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN803 */
    0, /* CYHAL_TRIGGER_TR_GROUP9_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP9_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP9_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP9_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP9_INPUT5 */
    0, /* CYHAL_TRIGGER_TR_GROUP9_INPUT6 */
    1, /* CYHAL_TRIGGER_TR_GROUP9_INPUT7 */
    2, /* CYHAL_TRIGGER_TR_GROUP9_INPUT8 */
    3, /* CYHAL_TRIGGER_TR_GROUP9_INPUT9 */
    4, /* CYHAL_TRIGGER_TR_GROUP9_INPUT10 */
    0, /* CYHAL_TRIGGER_TR_GROUP9_INPUT11 */
    1, /* CYHAL_TRIGGER_TR_GROUP9_INPUT12 */
    2, /* CYHAL_TRIGGER_TR_GROUP9_INPUT13 */
    3, /* CYHAL_TRIGGER_TR_GROUP9_INPUT14 */
    4, /* CYHAL_TRIGGER_TR_GROUP9_INPUT15 */
};

#endif /* CY_DEVICE_TVIIBH8M */
