/***************************************************************************//**
* \file cyip_btss.h
*
* \brief
* BTSS IP definitions
*
********************************************************************************
* \copyright
* (c) (2016-2022), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYIP_BTSS_H_
#define _CYIP_BTSS_H_

#include "cyip_headers.h"

/*******************************************************************************
*                                     BTSS
*******************************************************************************/

#define BTSS_DATA_RAM_IPC_SECTION_SIZE          0x000186A0UL
#define BTSS_SECTION_SIZE                       0x01000000UL

/**
  * \brief N/A (BTSS_DATA_RAM_IPC)
  */
typedef struct {
   __IM uint32_t RESERVED[131072];
  __IOM uint32_t MXIPC_0_ACQUIRE;               /*!< 0x00080000 N/A */
  __IOM uint32_t MXIPC_0_RELEASE;               /*!< 0x00080004 N/A */
  __IOM uint32_t MXIPC_0_NOTIFY;                /*!< 0x00080008 N/A */
  __IOM uint32_t MXIPC_0_DATA0;                 /*!< 0x0008000C N/A */
  __IOM uint32_t MXIPC_0_DATA1;                 /*!< 0x00080010 N/A */
   __IM uint32_t RESERVED1[2];
   __IM uint32_t MXIPC_0_LOCK_STATUS;           /*!< 0x0008001C N/A */
  __IOM uint32_t MXIPC_1_ACQUIRE;               /*!< 0x00080020 N/A */
  __IOM uint32_t MXIPC_1_RELEASE;               /*!< 0x00080024 N/A */
  __IOM uint32_t MXIPC_1_NOTIFY;                /*!< 0x00080028 N/A */
  __IOM uint32_t MXIPC_1_DATA0;                 /*!< 0x0008002C N/A */
  __IOM uint32_t MXIPC_1_DATA1;                 /*!< 0x00080030 N/A */
   __IM uint32_t RESERVED2[2];
   __IM uint32_t MXIPC_1_LOCK_STATUS;           /*!< 0x0008003C N/A */
  __IOM uint32_t MXIPC_2_ACQUIRE;               /*!< 0x00080040 N/A */
  __IOM uint32_t MXIPC_2_RELEASE;               /*!< 0x00080044 N/A */
  __IOM uint32_t MXIPC_2_NOTIFY;                /*!< 0x00080048 N/A */
  __IOM uint32_t MXIPC_2_DATA0;                 /*!< 0x0008004C N/A */
  __IOM uint32_t MXIPC_2_DATA1;                 /*!< 0x00080050 N/A */
   __IM uint32_t RESERVED3[2];
   __IM uint32_t MXIPC_2_LOCK_STATUS;           /*!< 0x0008005C N/A */
  __IOM uint32_t MXIPC_3_ACQUIRE;               /*!< 0x00080060 N/A */
  __IOM uint32_t MXIPC_3_RELEASE;               /*!< 0x00080064 N/A */
  __IOM uint32_t MXIPC_3_NOTIFY;                /*!< 0x00080068 N/A */
  __IOM uint32_t MXIPC_3_DATA0;                 /*!< 0x0008006C N/A */
  __IOM uint32_t MXIPC_3_DATA1;                 /*!< 0x00080070 N/A */
   __IM uint32_t RESERVED4[2];
   __IM uint32_t MXIPC_3_LOCK_STATUS;           /*!< 0x0008007C N/A */
   __IM uint32_t RESERVED5[992];
  __IOM uint32_t MXIPC_INTR_0;                  /*!< 0x00081000 N/A */
  __IOM uint32_t MXIPC_INTR_0_SET;              /*!< 0x00081004 N/A */
  __IOM uint32_t MXIPC_INTR_0_MASK;             /*!< 0x00081008 N/A */
   __IM uint32_t MXIPC_INTR_0_MASKED;           /*!< 0x0008100C N/A */
   __IM uint32_t RESERVED6[4];
  __IOM uint32_t MXIPC_INTR_1;                  /*!< 0x00081020 N/A */
  __IOM uint32_t MXIPC_INTR_1_SET;              /*!< 0x00081024 N/A */
  __IOM uint32_t MXIPC_INTR_1_MASK;             /*!< 0x00081028 N/A */
   __IM uint32_t MXIPC_INTR_1_MASKED;           /*!< 0x0008102C N/A */
} BTSS_DATA_RAM_IPC_Type;                       /*!< Size = 528432 (0x81030) */

/**
  * \brief MXS40BLE52SS IP (BTSS)
  */
typedef struct {
   __IM uint32_t RESERVED[1572864];
        BTSS_DATA_RAM_IPC_Type DATA_RAM_IPC;    /*!< 0x00600000 N/A */
} BTSS_Type;                                    /*!< Size = 6391456 (0x6186A0) */


/* BTSS_DATA_RAM_IPC.MXIPC_0_ACQUIRE */
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_SUCCESS_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_ACQUIRE_MXIPC_0_ACQUIRE_SUCCESS_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_0_RELEASE */
#define BTSS_DATA_RAM_IPC_MXIPC_0_RELEASE_MXIPC_0_RELEASE_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_RELEASE_MXIPC_0_RELEASE_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_0_NOTIFY */
#define BTSS_DATA_RAM_IPC_MXIPC_0_NOTIFY_MXIPC_0_NOTIFY_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_NOTIFY_MXIPC_0_NOTIFY_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_0_DATA0 */
#define BTSS_DATA_RAM_IPC_MXIPC_0_DATA0_MXIPC_0_DATA0_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_DATA0_MXIPC_0_DATA0_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_0_DATA1 */
#define BTSS_DATA_RAM_IPC_MXIPC_0_DATA1_MXIPC_0_DATA1_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_DATA1_MXIPC_0_DATA1_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_0_LOCK_STATUS */
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_ACQUIRED_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_0_LOCK_STATUS_MXIPC_0_LOCK_STATUS_ACQUIRED_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_1_ACQUIRE */
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_SUCCESS_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_ACQUIRE_MXIPC_1_ACQUIRE_SUCCESS_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_1_RELEASE */
#define BTSS_DATA_RAM_IPC_MXIPC_1_RELEASE_MXIPC_1_RELEASE_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_RELEASE_MXIPC_1_RELEASE_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_1_NOTIFY */
#define BTSS_DATA_RAM_IPC_MXIPC_1_NOTIFY_MXIPC_1_NOTIFY_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_NOTIFY_MXIPC_1_NOTIFY_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_1_DATA0 */
#define BTSS_DATA_RAM_IPC_MXIPC_1_DATA0_MXIPC_1_DATA0_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_DATA0_MXIPC_1_DATA0_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_1_DATA1 */
#define BTSS_DATA_RAM_IPC_MXIPC_1_DATA1_MXIPC_1_DATA1_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_DATA1_MXIPC_1_DATA1_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_1_LOCK_STATUS */
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_ACQUIRED_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_1_LOCK_STATUS_MXIPC_1_LOCK_STATUS_ACQUIRED_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_2_ACQUIRE */
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_SUCCESS_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_ACQUIRE_MXIPC_2_ACQUIRE_SUCCESS_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_2_RELEASE */
#define BTSS_DATA_RAM_IPC_MXIPC_2_RELEASE_MXIPC_2_RELEASE_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_RELEASE_MXIPC_2_RELEASE_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_2_NOTIFY */
#define BTSS_DATA_RAM_IPC_MXIPC_2_NOTIFY_MXIPC_2_NOTIFY_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_NOTIFY_MXIPC_2_NOTIFY_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_2_DATA0 */
#define BTSS_DATA_RAM_IPC_MXIPC_2_DATA0_MXIPC_2_DATA0_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_DATA0_MXIPC_2_DATA0_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_2_DATA1 */
#define BTSS_DATA_RAM_IPC_MXIPC_2_DATA1_MXIPC_2_DATA1_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_DATA1_MXIPC_2_DATA1_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_2_LOCK_STATUS */
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_ACQUIRED_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_2_LOCK_STATUS_MXIPC_2_LOCK_STATUS_ACQUIRED_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_3_ACQUIRE */
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_SUCCESS_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_ACQUIRE_MXIPC_3_ACQUIRE_SUCCESS_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_3_RELEASE */
#define BTSS_DATA_RAM_IPC_MXIPC_3_RELEASE_MXIPC_3_RELEASE_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_RELEASE_MXIPC_3_RELEASE_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_3_NOTIFY */
#define BTSS_DATA_RAM_IPC_MXIPC_3_NOTIFY_MXIPC_3_NOTIFY_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_NOTIFY_MXIPC_3_NOTIFY_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_3_DATA0 */
#define BTSS_DATA_RAM_IPC_MXIPC_3_DATA0_MXIPC_3_DATA0_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_DATA0_MXIPC_3_DATA0_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_3_DATA1 */
#define BTSS_DATA_RAM_IPC_MXIPC_3_DATA1_MXIPC_3_DATA1_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_DATA1_MXIPC_3_DATA1_Msk 0xFFFFFFFFUL
/* BTSS_DATA_RAM_IPC.MXIPC_3_LOCK_STATUS */
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_P_Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_P_Msk 0x1UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_NS_Pos 1UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_NS_Msk 0x2UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_PC_Pos 4UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_PC_Msk 0xF0UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_MS_Pos 8UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_MS_Msk 0xFF00UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_ACQUIRED_Pos 31UL
#define BTSS_DATA_RAM_IPC_MXIPC_3_LOCK_STATUS_MXIPC_3_LOCK_STATUS_ACQUIRED_Msk 0x80000000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_0 */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MXIPC_INTR_0_MXIPC_INTR_0_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MXIPC_INTR_0_MXIPC_INTR_0_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MXIPC_INTR_0_MXIPC_INTR_0_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MXIPC_INTR_0_MXIPC_INTR_0_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_0_SET */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_MXIPC_INTR_0_SET_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_0_MASK */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_MXIPC_INTR_0_MASK_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_0_MASKED */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_MXIPC_INTR_0_MASKED_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_1 */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MXIPC_INTR_1_MXIPC_INTR_1_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MXIPC_INTR_1_MXIPC_INTR_1_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MXIPC_INTR_1_MXIPC_INTR_1_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MXIPC_INTR_1_MXIPC_INTR_1_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_1_SET */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_MXIPC_INTR_1_SET_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_1_MASK */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_MXIPC_INTR_1_MASK_NOTIFY_Msk 0xFFFF0000UL
/* BTSS_DATA_RAM_IPC.MXIPC_INTR_1_MASKED */
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_RELEASE________Pos 0UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_RELEASE________Msk 0xFFFFUL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_NOTIFY_Pos 16UL
#define BTSS_DATA_RAM_IPC_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_MXIPC_INTR_1_MASKED_NOTIFY_Msk 0xFFFF0000UL


#endif /* _CYIP_BTSS_H_ */


/* [] END OF FILE */
