/***************************************************************************//**
* \file cyip_mxs40adcmic.h
*
* \brief
* MXS40ADCMIC IP definitions
*
********************************************************************************
* \copyright
* (c) (2016-2022), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYIP_MXS40ADCMIC_H_
#define _CYIP_MXS40ADCMIC_H_

#include "cyip_headers.h"

/*******************************************************************************
*                                 MXS40ADCMIC
*******************************************************************************/

#define MXS40ADCMIC_SECTION_SIZE                0x00010000UL

/**
  * \brief ADC (MXS40ADCMIC)
  */
typedef struct {
  __IOM uint32_t ADCMIC_CTRL;                   /*!< 0x00000000 Control the operation of the ADCMIC block including clock
                                                                generation,clock selection and pdm data latching */
  __IOM uint32_t ADCMIC_PAD_CTRL;               /*!< 0x00000004 Control the pads in the ADCMIC block */
  __IOM uint32_t ADCMIC_FIFO_CTRL;              /*!< 0x00000008 Controls the operation of the fifo */
  __IOM uint32_t ADCMIC_LFSR_CTRL;              /*!< 0x0000000C Controls the operation of the LFSR */
   __IM uint32_t ADCMIC_TRIGGER;                /*!< 0x00000010 Register to control Trigger */
  __IOM uint32_t ADCMIC_TRIGGER_CLR;            /*!< 0x00000014 Register to clear Trigger */
  __IOM uint32_t ADCMIC_TRIGGER_SET;            /*!< 0x00000018 Register to set Trigger */
  __IOM uint32_t ADCMIC_TRIGGER_MASK;           /*!< 0x0000001C Register to mask Trigger */
  __IOM uint32_t ADCMIC_INTR;                   /*!< 0x00000020 Register to cause Interrupt */
  __IOM uint32_t ADCMIC_INTR_SET;               /*!< 0x00000024 Register to set Interrupt */
  __IOM uint32_t ADCMIC_INTR_MASK;              /*!< 0x00000028 Register to mask Interrupt */
   __IM uint32_t ADCMIC_INTR_MASKED;            /*!< 0x0000002C Register to and intr_mask Intr to crreate the interrupt */
  __IOM uint32_t ADCMIC_TRIG_INTRPT_TIMER_CTRL; /*!< 0x00000030 Controls the timer for the generation of triggers and
                                                                interrupts for dc measurement in the block */
  __IOM uint32_t ADCMIC_TP;                     /*!< 0x00000034 Data used for DFT test for setting and observing test points */
   __IM uint32_t RESERVED[2];
   __IM uint32_t ADCMIC_DATA;                   /*!< 0x00000040 N/A */
   __IM uint32_t RESERVED1[47];
  __IOM uint32_t ADC_CLK_CTRL;                  /*!< 0x00000100 Control the clocks in the ADC block */
  __IOM uint32_t ADC_GPIO_CTRL;                 /*!< 0x00000104 GPIO control for ADC */
  __IOM uint32_t ADC_PD_CTRL;                   /*!< 0x00000108 Control the  power down controls in the ADC block. */
  __IOM uint32_t ADC_BG_REF_CTRL;               /*!< 0x0000010C Control the Band Gap and Reference Voltages of the ADC */
  __IOM uint32_t ADC_CORE_CTRL;                 /*!< 0x00000110 Control the clocks in the ADC block */
  __IOM uint32_t ADC_MIC_BIAS_PGA_CTRL;         /*!< 0x00000114 Control the BIAS and PGA of ADC block */
  __IOM uint32_t ADC_SPARE;                     /*!< 0x00000118 Spare registers in the ADC block */
   __IM uint32_t RESERVED2[57];
  __IOM uint32_t AUXADC_CTRL;                   /*!< 0x00000200 Register to control AuxAdcDecim operation */
  __IOM uint32_t AUXADC_CIC_CTRL;               /*!< 0x00000204 Register to control CIC operation in AuxAdcDecim block */
  __IOM uint32_t AUXADC_OVERRIDE;               /*!< 0x00000208 Register that holds the override values for AuxAdcDecim block */
  __IOM uint32_t AUXADC_DF3_COEFF;              /*!< 0x0000020C Register that controls the RAM operation for writing DF3
                                                                Coefficients into the RAM */
  __IOM uint32_t AUXADC_BIQUAD0_COEFF_0;        /*!< 0x00000210 Register holding the coefficients for BIQUAD0 operation. */
  __IOM uint32_t AUXADC_BIQUAD0_COEFF_1;        /*!< 0x00000214 Register holding the coefficients for BIQUAD0 operation. */
  __IOM uint32_t AUXADC_BIQUAD0_COEFF_2;        /*!< 0x00000218 Register holding the coefficients for BIQUAD0 operation. */
  __IOM uint32_t AUXADC_BIQUAD1_COEFF_0;        /*!< 0x0000021C Register holding the coefficients for BIQUAD1 operation. */
  __IOM uint32_t AUXADC_BIQUAD1_COEFF_1;        /*!< 0x00000220 Register holding the coefficients for BIQUAD1 operation. */
  __IOM uint32_t AUXADC_BIQUAD1_COEFF_2;        /*!< 0x00000224 Register holding the coefficients for BIQUAD1 operation. */
  __IOM uint32_t AUXADC_BIQUAD2_COEFF_0;        /*!< 0x00000228 Register holding the coefficients for BIQUAD2 operation. */
  __IOM uint32_t AUXADC_BIQUAD2_COEFF_1;        /*!< 0x0000022C Register holding the coefficients for BIQUAD2 operation. */
  __IOM uint32_t AUXADC_BIQUAD2_COEFF_2;        /*!< 0x00000230 Register holding the coefficients for BIQUAD2 operation. */
  __IOM uint32_t AUXADC_BIQUAD3_COEFF_0;        /*!< 0x00000234 Register holding the coefficients for BIQUAD3 operation. */
  __IOM uint32_t AUXADC_BIQUAD3_COEFF_1;        /*!< 0x00000238 Register holding the coefficients for BIQUAD3 operation. */
  __IOM uint32_t AUXADC_BIQUAD3_COEFF_2;        /*!< 0x0000023C Register holding the coefficients for BIQUAD3 operation. */
  __IOM uint32_t AUXADC_BIQUAD4_COEFF_0;        /*!< 0x00000240 Register holding the coefficients for BIQUAD4 operation. */
  __IOM uint32_t AUXADC_BIQUAD4_COEFF_1;        /*!< 0x00000244 Register holding the coefficients for BIQUAD4 operation. */
  __IOM uint32_t AUXADC_BIQUAD4_COEFF_2;        /*!< 0x00000248 Register holding the coefficients for BIQUAD4 operation. */
   __IM uint32_t RESERVED3;
  __IOM uint32_t AUXADC_CIC_STATUS;             /*!< 0x00000250 Status of the CIC in AuxAdcDecim block */
   __IM uint32_t AUXADC_DF1_STATUS;             /*!< 0x00000254 Status of the DF1 FIR Filter in AuxAdcDecim block */
   __IM uint32_t AUXADC_DF2_STATUS;             /*!< 0x00000258 Status of the DF2 FIR Filter in AuxAdcDecim block */
   __IM uint32_t AUXADC_DF3_STATUS;             /*!< 0x0000025C Status of the DF3 FIR Filter in AuxAdcDecim block */
   __IM uint32_t AUXADC_BIQUAD_STATUS;          /*!< 0x00000260 Status of the BIQUAD IIR  Filter in AuxAdcDecim block */
} MXS40ADCMIC_Type;                             /*!< Size = 612 (0x264) */


/* MXS40ADCMIC.ADCMIC_CTRL */
#define MXS40ADCMIC_ADCMIC_CTRL_ADC_DIV_RATIO_Pos 0UL
#define MXS40ADCMIC_ADCMIC_CTRL_ADC_DIV_RATIO_Msk 0x1FUL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_DIV_RATIO_Pos 5UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_DIV_RATIO_Msk 0x3E0UL
#define MXS40ADCMIC_ADCMIC_CTRL_ADC_RESET_Pos   10UL
#define MXS40ADCMIC_ADCMIC_CTRL_ADC_RESET_Msk   0x400UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_LATCH_NEG_EDGE_Pos 11UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_LATCH_NEG_EDGE_Msk 0x800UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_DATA_Pos    12UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_DATA_Msk    0x1000UL
#define MXS40ADCMIC_ADCMIC_CTRL_CLK_GATE_EN_Pos 13UL
#define MXS40ADCMIC_ADCMIC_CTRL_CLK_GATE_EN_Msk 0x6000UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_LATCH_DELAY_Pos 15UL
#define MXS40ADCMIC_ADCMIC_CTRL_PDM_LATCH_DELAY_Msk 0xF8000UL
#define MXS40ADCMIC_ADCMIC_CTRL_CLKS_ACTIVE_ADC_Pos 20UL
#define MXS40ADCMIC_ADCMIC_CTRL_CLKS_ACTIVE_ADC_Msk 0x1F00000UL
#define MXS40ADCMIC_ADCMIC_CTRL_CLKS_ACTIVE_PDM_Pos 25UL
#define MXS40ADCMIC_ADCMIC_CTRL_CLKS_ACTIVE_PDM_Msk 0x1E000000UL
#define MXS40ADCMIC_ADCMIC_CTRL_ADCMIC_EN_Pos   31UL
#define MXS40ADCMIC_ADCMIC_CTRL_ADCMIC_EN_Msk   0x80000000UL
/* MXS40ADCMIC.ADCMIC_PAD_CTRL */
#define MXS40ADCMIC_ADCMIC_PAD_CTRL_CLK_PDM_OE_Pos 0UL
#define MXS40ADCMIC_ADCMIC_PAD_CTRL_CLK_PDM_OE_Msk 0x1UL
/* MXS40ADCMIC.ADCMIC_FIFO_CTRL */
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_PGMBLE_FULL_Pos 0UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_PGMBLE_FULL_Msk 0x3FUL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_PGMBLE_EMPTY_Pos 8UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_PGMBLE_EMPTY_Msk 0x3F00UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_FIFO_RESET_Pos 14UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_FIFO_RESET_Msk 0xC000UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_FIFO_STATUS_Pos 16UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_FIFO_STATUS_Msk 0xFF0000UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_FIFO_WR_BYPASS_Pos 31UL
#define MXS40ADCMIC_ADCMIC_FIFO_CTRL_FIFO_WR_BYPASS_Msk 0x80000000UL
/* MXS40ADCMIC.ADCMIC_LFSR_CTRL */
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_EN_Pos 0UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_EN_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_SET_Pos 1UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_SET_Msk 0x2UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_MODE_Pos 2UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_MODE_Msk 0xCUL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_VALID_CNTR_LIMIT_Pos 4UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_VALID_CNTR_LIMIT_Msk 0x3FF0UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_CLR_Pos 15UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_CLR_Msk 0x8000UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_TAPS_Pos 16UL
#define MXS40ADCMIC_ADCMIC_LFSR_CTRL_LFSR_TAPS_Msk 0xFFFF0000UL
/* MXS40ADCMIC.ADCMIC_TRIGGER */
#define MXS40ADCMIC_ADCMIC_TRIGGER_TR_DC_Pos    0UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_TR_DC_Msk    0x1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_TR_DATA_Pos  1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_TR_DATA_Msk  0x2UL
/* MXS40ADCMIC.ADCMIC_TRIGGER_CLR */
#define MXS40ADCMIC_ADCMIC_TRIGGER_CLR_TR_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_CLR_TR_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_CLR_TR_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_CLR_TR_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_TRIGGER_SET */
#define MXS40ADCMIC_ADCMIC_TRIGGER_SET_TR_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_SET_TR_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_SET_TR_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_SET_TR_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_TRIGGER_MASK */
#define MXS40ADCMIC_ADCMIC_TRIGGER_MASK_TR_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_MASK_TR_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_MASK_TR_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_TRIGGER_MASK_TR_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_INTR */
#define MXS40ADCMIC_ADCMIC_INTR_INTERRUPT_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_INTR_INTERRUPT_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_INTR_INTERRUPT_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_INTR_INTERRUPT_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_INTR_SET */
#define MXS40ADCMIC_ADCMIC_INTR_SET_INTERRUPT_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_INTR_SET_INTERRUPT_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_INTR_SET_INTERRUPT_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_INTR_SET_INTERRUPT_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_INTR_MASK */
#define MXS40ADCMIC_ADCMIC_INTR_MASK_INTERRUPT_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_INTR_MASK_INTERRUPT_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_INTR_MASK_INTERRUPT_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_INTR_MASK_INTERRUPT_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_INTR_MASKED */
#define MXS40ADCMIC_ADCMIC_INTR_MASKED_INTERRUPT_DC_Pos 0UL
#define MXS40ADCMIC_ADCMIC_INTR_MASKED_INTERRUPT_DC_Msk 0x1UL
#define MXS40ADCMIC_ADCMIC_INTR_MASKED_INTERRUPT_DATA_Pos 1UL
#define MXS40ADCMIC_ADCMIC_INTR_MASKED_INTERRUPT_DATA_Msk 0x2UL
/* MXS40ADCMIC.ADCMIC_TRIG_INTRPT_TIMER_CTRL */
#define MXS40ADCMIC_ADCMIC_TRIG_INTRPT_TIMER_CTRL_TIMER_LIMIT_Pos 0UL
#define MXS40ADCMIC_ADCMIC_TRIG_INTRPT_TIMER_CTRL_TIMER_LIMIT_Msk 0xFFFFUL
#define MXS40ADCMIC_ADCMIC_TRIG_INTRPT_TIMER_CTRL_TIMER_CLR_Pos 30UL
#define MXS40ADCMIC_ADCMIC_TRIG_INTRPT_TIMER_CTRL_TIMER_CLR_Msk 0x40000000UL
#define MXS40ADCMIC_ADCMIC_TRIG_INTRPT_TIMER_CTRL_TIMER_INC_Pos 31UL
#define MXS40ADCMIC_ADCMIC_TRIG_INTRPT_TIMER_CTRL_TIMER_INC_Msk 0x80000000UL
/* MXS40ADCMIC.ADCMIC_TP */
#define MXS40ADCMIC_ADCMIC_TP_TEST_POINT_SET_DATA_Pos 0UL
#define MXS40ADCMIC_ADCMIC_TP_TEST_POINT_SET_DATA_Msk 0xFFUL
#define MXS40ADCMIC_ADCMIC_TP_TEST_POINT_OBSERVE_DATA_Pos 16UL
#define MXS40ADCMIC_ADCMIC_TP_TEST_POINT_OBSERVE_DATA_Msk 0xFFFF0000UL
/* MXS40ADCMIC.ADCMIC_DATA */
#define MXS40ADCMIC_ADCMIC_DATA_FIFO_DATA_Pos   0UL
#define MXS40ADCMIC_ADCMIC_DATA_FIFO_DATA_Msk   0xFFFFFFFFUL
/* MXS40ADCMIC.ADC_CLK_CTRL */
#define MXS40ADCMIC_ADC_CLK_CTRL_ADC_SYN_CLK_PHASE_Pos 0UL
#define MXS40ADCMIC_ADC_CLK_CTRL_ADC_SYN_CLK_PHASE_Msk 0x1UL
#define MXS40ADCMIC_ADC_CLK_CTRL_ADC_CLK_GATE_EN_Pos 3UL
#define MXS40ADCMIC_ADC_CLK_CTRL_ADC_CLK_GATE_EN_Msk 0x8UL
#define MXS40ADCMIC_ADC_CLK_CTRL_ADC_DATA_OUT_Pos 4UL
#define MXS40ADCMIC_ADC_CLK_CTRL_ADC_DATA_OUT_Msk 0x30UL
/* MXS40ADCMIC.ADC_GPIO_CTRL */
#define MXS40ADCMIC_ADC_GPIO_CTRL_ADC_DCIN_MUX_Pos 0UL
#define MXS40ADCMIC_ADC_GPIO_CTRL_ADC_DCIN_MUX_Msk 0x1FUL
/* MXS40ADCMIC.ADC_PD_CTRL */
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_EN_VBAT_Pos 0UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_EN_VBAT_Msk 0x1UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_PWRUP_Pos   1UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_PWRUP_Msk   0x2UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_REF_PWRUP_Pos 2UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_REF_PWRUP_Msk 0x4UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_CORE_PWRUP_Pos 3UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_CORE_PWRUP_Msk 0x8UL
#define MXS40ADCMIC_ADC_PD_CTRL_MIC_PWRUP_Pos   4UL
#define MXS40ADCMIC_ADC_PD_CTRL_MIC_PWRUP_Msk   0x10UL
#define MXS40ADCMIC_ADC_PD_CTRL_MIC_CLAMP_EN_Pos 5UL
#define MXS40ADCMIC_ADC_PD_CTRL_MIC_CLAMP_EN_Msk 0x20UL
#define MXS40ADCMIC_ADC_PD_CTRL_MICBIAS_PWRUP_Pos 6UL
#define MXS40ADCMIC_ADC_PD_CTRL_MICBIAS_PWRUP_Msk 0x40UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_MODE_Pos    7UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_MODE_Msk    0x80UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_MIC_PDSLT_Pos 8UL
#define MXS40ADCMIC_ADC_PD_CTRL_ADC_MIC_PDSLT_Msk 0x100UL
#define MXS40ADCMIC_ADC_PD_CTRL_IDDQ_Pos        9UL
#define MXS40ADCMIC_ADC_PD_CTRL_IDDQ_Msk        0x200UL
/* MXS40ADCMIC.ADC_BG_REF_CTRL */
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_BG_PTAT_CTRL_Pos 0UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_BG_PTAT_CTRL_Msk 0x7UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_BG_CTAT_CTRL_Pos 3UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_BG_CTAT_CTRL_Msk 0x38UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_REF_CTRL_Pos 6UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_REF_CTRL_Msk 0x3C0UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_CLKDIV_Pos 10UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_CLKDIV_Msk 0xC00UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_BYPASS_Pos 12UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_BYPASS_Msk 0x1000UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_BYPASS_SEQ_Pos 13UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_BYPASS_SEQ_Msk 0x2000UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_SEQ_SLT_Pos 14UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_SCF_SEQ_SLT_Msk 0x4000UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_BIAS_CTRL_Pos 15UL
#define MXS40ADCMIC_ADC_BG_REF_CTRL_ADC_BIAS_CTRL_Msk 0x18000UL
/* MXS40ADCMIC.ADC_CORE_CTRL */
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_DITH_CTRL_Pos 0UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_DITH_CTRL_Msk 0x3UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_SHUFF_EN_Pos 2UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_SHUFF_EN_Msk 0x4UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_RESET_EN_Pos 3UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_RESET_EN_Msk 0x8UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_DCINPUT_RANGE_Pos 4UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_DCINPUT_RANGE_Msk 0x10UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_CLK_DIV2_Pos 5UL
#define MXS40ADCMIC_ADC_CORE_CTRL_ADC_CLK_DIV2_Msk 0x20UL
/* MXS40ADCMIC.ADC_MIC_BIAS_PGA_CTRL */
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_BIAS_REF_CTRL_Pos 0UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_BIAS_REF_CTRL_Msk 0x3UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_BIAS_CTRL_Pos 2UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_BIAS_CTRL_Msk 0xCUL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_REF_SLT_Pos 4UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_REF_SLT_Msk 0x10UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_CLK_CTRL_Pos 5UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_CLK_CTRL_Msk 0x60UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_BYPASS_Pos 7UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_BYPASS_Msk 0x80UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_BYPASS_SEQ_Pos 8UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_BYPASS_SEQ_Msk 0x100UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_SEQ_SLT_Pos 9UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_SCF_SEQ_SLT_Msk 0x200UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_BIAS_LZ_Pos 10UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_BIAS_LZ_Msk 0x400UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_GAIN_CTRL_Pos 11UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_GAIN_CTRL_Msk 0x1F800UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_INCM_CTRL_Pos 17UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_INCM_CTRL_Msk 0x60000UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_OUTCM_CTRL_Pos 19UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_OUTCM_CTRL_Msk 0x180000UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_CLAMPVREF_CTRL_Pos 21UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_PGA_CLAMPVREF_CTRL_Msk 0x600000UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_NEG_INPUT_SLT_Pos 23UL
#define MXS40ADCMIC_ADC_MIC_BIAS_PGA_CTRL_MIC_NEG_INPUT_SLT_Msk 0x800000UL
/* MXS40ADCMIC.ADC_SPARE */
#define MXS40ADCMIC_ADC_SPARE_ADC_SPARE_Pos     0UL
#define MXS40ADCMIC_ADC_SPARE_ADC_SPARE_Msk     0x3FFUL
/* MXS40ADCMIC.AUXADC_CTRL */
#define MXS40ADCMIC_AUXADC_CTRL_EN_Pos          0UL
#define MXS40ADCMIC_AUXADC_CTRL_EN_Msk          0x1UL
#define MXS40ADCMIC_AUXADC_CTRL_DF3_BYPASS_Pos  2UL
#define MXS40ADCMIC_AUXADC_CTRL_DF3_BYPASS_Msk  0x4UL
#define MXS40ADCMIC_AUXADC_CTRL_BIQUAD_BYPASS_Pos 3UL
#define MXS40ADCMIC_AUXADC_CTRL_BIQUAD_BYPASS_Msk 0x8UL
#define MXS40ADCMIC_AUXADC_CTRL_DFMODE_Pos      4UL
#define MXS40ADCMIC_AUXADC_CTRL_DFMODE_Msk      0x70UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR0_Pos        8UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR0_Msk        0x300UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR1_Pos        10UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR1_Msk        0xC00UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR2_Pos        12UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR2_Msk        0x3000UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR3_Pos        14UL
#define MXS40ADCMIC_AUXADC_CTRL_MPR3_Msk        0xC000UL
/* MXS40ADCMIC.AUXADC_CIC_CTRL */
#define MXS40ADCMIC_AUXADC_CIC_CTRL_CIC_GAIN_Pos 0UL
#define MXS40ADCMIC_AUXADC_CIC_CTRL_CIC_GAIN_Msk 0xFFFFUL
/* MXS40ADCMIC.AUXADC_OVERRIDE */
#define MXS40ADCMIC_AUXADC_OVERRIDE_OVERRIDE_Pos 0UL
#define MXS40ADCMIC_AUXADC_OVERRIDE_OVERRIDE_Msk 0x7FFFFFUL
/* MXS40ADCMIC.AUXADC_DF3_COEFF */
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_SEL_Pos 0UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_SEL_Msk 0x1UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_PGM_EN_Pos 1UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_PGM_EN_Msk 0x2UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_WREN_Pos 2UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_WREN_Msk 0x4UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_ADDR_Pos 4UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_ADDR_Msk 0x1F0UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_ACCESS_DONE_Pos 15UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_ACCESS_DONE_Msk 0x8000UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_DATA_Pos 16UL
#define MXS40ADCMIC_AUXADC_DF3_COEFF_DF3_COEFF_DATA_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD0_COEFF_0 */
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_0_BQ0_NUM1_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_0_BQ0_NUM1_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_0_BQ0_NUM2_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_0_BQ0_NUM2_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD0_COEFF_1 */
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_1_BQ0_NUM3_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_1_BQ0_NUM3_COEFF_Msk 0xFFFFUL
/* MXS40ADCMIC.AUXADC_BIQUAD0_COEFF_2 */
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_2_BQ0_DEN2_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_2_BQ0_DEN2_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_2_BQ0_DEN3_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD0_COEFF_2_BQ0_DEN3_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD1_COEFF_0 */
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_0_BQ1_NUM1_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_0_BQ1_NUM1_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_0_BQ1_NUM2_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_0_BQ1_NUM2_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD1_COEFF_1 */
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_1_BQ1_NUM3_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_1_BQ1_NUM3_COEFF_Msk 0xFFFFUL
/* MXS40ADCMIC.AUXADC_BIQUAD1_COEFF_2 */
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_2_BQ1_DEN2_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_2_BQ1_DEN2_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_2_BQ1_DEN3_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD1_COEFF_2_BQ1_DEN3_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD2_COEFF_0 */
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_0_BQ2_NUM1_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_0_BQ2_NUM1_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_0_BQ2_NUM2_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_0_BQ2_NUM2_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD2_COEFF_1 */
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_1_BQ2_NUM3_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_1_BQ2_NUM3_COEFF_Msk 0xFFFFUL
/* MXS40ADCMIC.AUXADC_BIQUAD2_COEFF_2 */
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_2_BQ2_DEN2_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_2_BQ2_DEN2_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_2_BQ2_DEN3_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD2_COEFF_2_BQ2_DEN3_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD3_COEFF_0 */
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_0_BQ3_NUM1_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_0_BQ3_NUM1_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_0_BQ3_NUM2_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_0_BQ3_NUM2_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD3_COEFF_1 */
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_1_BQ3_NUM3_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_1_BQ3_NUM3_COEFF_Msk 0xFFFFUL
/* MXS40ADCMIC.AUXADC_BIQUAD3_COEFF_2 */
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_2_BQ3_DEN2_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_2_BQ3_DEN2_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_2_BQ3_DEN3_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD3_COEFF_2_BQ3_DEN3_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD4_COEFF_0 */
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_0_BQ4_NUM1_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_0_BQ4_NUM1_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_0_BQ4_NUM2_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_0_BQ4_NUM2_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_BIQUAD4_COEFF_1 */
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_1_BQ4_NUM3_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_1_BQ4_NUM3_COEFF_Msk 0xFFFFUL
/* MXS40ADCMIC.AUXADC_BIQUAD4_COEFF_2 */
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_2_BQ4_DEN2_COEFF_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_2_BQ4_DEN2_COEFF_Msk 0xFFFFUL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_2_BQ4_DEN3_COEFF_Pos 16UL
#define MXS40ADCMIC_AUXADC_BIQUAD4_COEFF_2_BQ4_DEN3_COEFF_Msk 0xFFFF0000UL
/* MXS40ADCMIC.AUXADC_CIC_STATUS */
#define MXS40ADCMIC_AUXADC_CIC_STATUS_CIC_Pos   0UL
#define MXS40ADCMIC_AUXADC_CIC_STATUS_CIC_Msk   0xFFFFUL
#define MXS40ADCMIC_AUXADC_CIC_STATUS_LATCH_ON_TIMER_Pos 16UL
#define MXS40ADCMIC_AUXADC_CIC_STATUS_LATCH_ON_TIMER_Msk 0x10000UL
/* MXS40ADCMIC.AUXADC_DF1_STATUS */
#define MXS40ADCMIC_AUXADC_DF1_STATUS_DF1_Pos   0UL
#define MXS40ADCMIC_AUXADC_DF1_STATUS_DF1_Msk   0xFFFFUL
/* MXS40ADCMIC.AUXADC_DF2_STATUS */
#define MXS40ADCMIC_AUXADC_DF2_STATUS_DF2_Pos   0UL
#define MXS40ADCMIC_AUXADC_DF2_STATUS_DF2_Msk   0xFFFFUL
/* MXS40ADCMIC.AUXADC_DF3_STATUS */
#define MXS40ADCMIC_AUXADC_DF3_STATUS_DF3_Pos   0UL
#define MXS40ADCMIC_AUXADC_DF3_STATUS_DF3_Msk   0xFFFFUL
/* MXS40ADCMIC.AUXADC_BIQUAD_STATUS */
#define MXS40ADCMIC_AUXADC_BIQUAD_STATUS_BQ_Pos 0UL
#define MXS40ADCMIC_AUXADC_BIQUAD_STATUS_BQ_Msk 0xFFFFUL


#endif /* _CYIP_MXS40ADCMIC_H_ */


/* [] END OF FILE */
