# Cypress CSDIDAC Middleware Library 2.10

### What's Included?

Please refer to the [README.md](./README.md) and the [API Reference Guide](https://cypresssemiconductorco.github.io/csdidac/csdidac_api_reference_manual/html/index.html) for a complete description of the CSDIDAC Middleware.
The revision history of the CSDIDAC Middleware is also available on the [API Reference Guide Changelog](https://cypresssemiconductorco.github.io/csdidac/csdidac_api_reference_manual/html/index.html#group_csdidac_changelog).
New in this release:
* Added the support for the PSoC 4100S Plus devices


### Supported Software and Tools
This version of the CSDIDAC Middleware was validated for compatibility with the following Software and Tools:

| Software and Tools                                                      | Version |
| :---                                                                    | :----:  |
| ModusToolbox Software Environment                                       | 2.1     |
| - ModusToolbox Device Configurator                                      | 2.1     |
| - ModusToolbox CSD Personality for PSoC4 devices in Device Configurator | 1.0     |
| - ModusToolbox CSD Personality for PSoC6 devices in Device Configurator | 2.0     |
| PSoC4 Peripheral Driver Library (PDL)                                   | 1.0.0   |
| PSoC6 Peripheral Driver Library (PDL)                                   | 1.5.0   |
| GCC Compiler                                                            | 7.2.1   |
| IAR Compiler                                                            | 8.32    |
| ARM Compiler 6                                                          | 6.11    |
| MBED OS                                                                 | 5.15.1  |
| FreeRTOS                                                                | 10.0.1  |

### More information
The following resources contain more information:
* [CSDIDAC Middleware RELEASE.md](./RELEASE.md)
* [CSDIDAC Middleware API Reference Guide](https://cypresssemiconductorco.github.io/csdidac/csdidac_api_reference_manual/html/index.html)
* [ModusToolbox Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment)
* [CSDIDAC Middleware Code Example for MBED OS](https://github.com/cypresssemiconductorco/mbed-os-example-csdidac)
* [ModusToolbox Device Configurator Tool Guide](https://www.cypress.com/ModusToolboxDeviceConfig)
* [CapSense Middleware API Reference Guide](https://cypresssemiconductorco.github.io/capsense/capsense_api_reference_manual/html/index.html)
* [CSDADC Middleware API Reference Guide](https://cypresssemiconductorco.github.io/csdadc/csdadc_api_reference_manual/html/index.html)
* [PSoC 6 Technical Reference Manual](https://www.cypress.com/documentation/technical-reference-manuals/psoc-6-mcu-psoc-63-ble-architecture-technical-reference)
* [PSoC 63 with BLE Datasheet Programmable System-on-Chip datasheet](http://www.cypress.com/ds218787)
* [PSoC 4000S Family: PSoC 4 Architecture Technical Reference Manual (TRM)](https://www.cypress.com/documentation/technical-reference-manuals/psoc-4000s-family-psoc-4-architecture-technical-reference)
* [PSoC 4100S and PSoC 4100S Plus: PSoC 4 Architecture Technical Reference Manual (TRM)](https://www.cypress.com/documentation/technical-reference-manuals/psoc-4100s-and-psoc-4100s-plus-psoc-4-architecture)
* [Cypress Semiconductor](http://www.cypress.com)
  
---
© Cypress Semiconductor Corporation, 2019-2020.
