# CAPSENSE™ Middleware Library

### Overview
CAPSENSE™ is a CYPRESS™ capacitive sensing solution from Infineon. Capacitive sensing can be used in a variety of applications and products where conventional mechanical buttons can be replaced with sleek human interfaces to transform the way users interact with electronic systems. These include home appliances, automotive, IoT, and industrial applications. CAPSENSE™ supports multiple interfaces (widgets) using both Self-Capacitance (CSD) and Mutual-Capacitance (CSX) sensing methods with robust performance.

CAPSENSE™ has become a popular technology to replace conventional mechanical- and optical-based user interfaces. There are fewer parts involved, which saves cost and increases reliability with no wear-and-tear. The main advantages of CAPSENSE™ compared with other solutions are: robust performance in harsh environmental conditions and rejection of a wide range of external noise sources.

Use CAPSENSE™ for:
* Touch and gesture detection for various interfaces
* Proximity detection for innovative user experiences and low-power optimization
* Contactless liquid-level sensing in a variety of applications
* Touch-free operations in hazardous materials

### Features
* Offers best-in-class signal-to-noise ratio (SNR)
* Supports Self-Capacitance (CSD) and Mutual-Capacitance (CSX) sensing methods
* Features smart sensing algorithm auto-tuning technology for CSD sensing to avoid complex manual tuning process
* Supports various Widgets, such as Buttons, Matrix Buttons, Sliders, Touchpads, and Proximity Sensors
* Provides ultra-low power consumption and liquid-tolerant capacitive sensing technology
* Contains the integrated graphical CAPSENSE™ Tuner tool for real-time tuning, testing, and debugging
* Provides superior immunity against external noise and low-radiated emission
* Offers best-in-class liquid tolerance
* Supports one-finger and two-finger gestures

### Quick Start
The [ModusToolbox™ CAPSENSE™ Configurator Tool Guide](https://www.cypress.com/ModusToolboxCapSenseConfig) describes step-by-step instructions how to configure and launch CAPSENSE™ in [ModusToolbox™](https://www.cypress.com/products/modustoolbox-software-environment). The CAPSENSE™ Configurator Tool can be launched in ModusToolbox™ IDE from the CSD personality, as well as in stand-alone mode. Refer to [ModusToolbox™ Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment).

The quickest way to get started with CAPSENSE™ is using code examples. Infineon Technologies continuously extends their portfolio of code examples at the <a href="http:/\/www.infineon.com"><b>Infineon Technologies</b></a> and at the <a href="https:/\/github.com/Infineon"><b> Infineon Technologies GitHub</b></a>.

### More information
The following resources contain more information:
* CAPSENSE™ Overview:
  * [CAPSENSE™ Middleware RELEASE.md](./RELEASE.md)
  * [CAPSENSE™ Middleware API Reference Guide](https://cypresssemiconductorco.github.io/capsense/capsense_api_reference_manual/html/index.html)
  * [ModusToolbox™ CAPSENSE™ Configurator Tool Guide](https://www.cypress.com/ModusToolboxCapSenseConfig)
  * [ModusToolbox™ CAPSENSE™ Tuner Tool Guide](https://www.cypress.com/ModusToolboxCapSenseTuner)
  * [CAPSENSE™ Design Guide](https://www.cypress.com/documentation/application-notes/an85951-psoc-4-and-psoc-6-mcu-capsense-design-guide)
  * [CSDADC Middleware API Reference Guide](https://cypresssemiconductorco.github.io/csdadc/csdadc_api_reference_manual/html/index.html)
  * [CSDIDAC Middleware API Reference Guide](https://cypresssemiconductorco.github.io/csdidac/csdidac_api_reference_manual/html/index.html)
* ModusToolbox™ Overview:
  * [ModusToolbox™ Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment)
  * [ModusToolbox™ Device Configurator Tool Guide](https://www.cypress.com/ModusToolboxDeviceConfig)
* Infineon Technologies Kits and Code Examples:
  * [CAPSENSE™ Middleware Code Example for MBED OS](https://github.com/cypresssemiconductorco/mbed-os-example-capsense)
  * [CAPSENSE™ Middleware Code Example for FreeRTOS](https://www.cypress.com/documentation/code-examples/ce218136-psoc-6-mcu-e-ink-display-capsense-rtos)
  * [CY8CKIT-145-40XX PSoC™ 4000S CAPSENSE™ Prototyping Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-145-40xx-psoc-4000s-capsense-prototyping-kit)
  * [CY8CKIT-149 PSoC™ 4100S Plus Prototyping Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-149-psoc-4100s-plus-prototyping-kit)
  * [CY8CKIT-041-40XX PSoC™ 4 S-Series Pioneer Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-041-psoc-4-s-series-pioneer-kit)
  * [CY8CKIT-041-41XX PSoC™ 4100S CAPSENSE™ Pioneer Kit](https://www.cypress.com/documentation/development-kitsboards/cy8ckit-041-41xx-psoc-4100s-capsense-pioneer-kit)
* General Information:
  * [AN210781 Getting Started with PSoC™ 6 MCU with Bluetooth Low Energy (BLE) Connectivity](http://www.cypress.com/an210781)
  * [PSoC™ 6 Technical Reference Manual](https://www.cypress.com/documentation/technical-reference-manuals/psoc-6-mcu-psoc-63-ble-architecture-technical-reference)
  * [PSoC™ 63 with BLE Datasheet Programmable System-on-Chip datasheet](http://www.cypress.com/ds218787)
  * [CAT1 PDL API Reference](https://cypresssemiconductorco.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/index.html)
  * [CAT2 PDL API Reference](https://cypresssemiconductorco.github.io/mtb-pdl-cat2/pdl_api_reference_manual/html/index.html)
  * [PSoC™ 4000S Family: PSoC™ 4 Architecture Technical Reference Manual (TRM)](https://www.cypress.com/documentation/technical-reference-manuals/psoc-4000s-family-psoc-4-architecture-technical-reference)
  * [PSoC™ 4100S and PSoC™ 4100S Plus: PSoC™ 4 Architecture Technical Reference Manual (TRM)](https://www.cypress.com/documentation/technical-reference-manuals/psoc-4100s-and-psoc-4100s-plus-psoc-4-architecture)
  * [Infineon Technologies GitHub](https://github.com/Infineon)
  * [Infineon Technologies](http://www.infineon.com)

---
CYPRESS™ Semiconductor Corporation, 2019-2021.
