/***************************************************************************//**
* \file cyhal_triggers_psoc6_01.h
*
* \brief
* PSoC6_01 family HAL triggers header
*
********************************************************************************
* \copyright
* (c) (2016-2023), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYHAL_TRIGGERS_PSOC6_01_H_
#define _CYHAL_TRIGGERS_PSOC6_01_H_

/**
 * \addtogroup group_hal_impl_triggers_psoc6_01 PSOC6_01
 * \ingroup group_hal_impl_triggers
 * \{
 * Trigger connections for psoc6_01
 */

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/** \cond INTERNAL */
/** @brief Name of each input trigger. */
typedef enum
{
    _CYHAL_TRIGGER_CPUSS_ZERO = 0, //!< cpuss.zero
    _CYHAL_TRIGGER_AUDIOSS_TR_I2S_RX_REQ = 1, //!< audioss.tr_i2s_rx_req
    _CYHAL_TRIGGER_AUDIOSS_TR_I2S_TX_REQ = 2, //!< audioss.tr_i2s_tx_req
    _CYHAL_TRIGGER_AUDIOSS_TR_PDM_RX_REQ = 3, //!< audioss.tr_pdm_rx_req
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0 = 4, //!< cpuss.cti_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1 = 5, //!< cpuss.cti_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0 = 6, //!< cpuss.dw0_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1 = 7, //!< cpuss.dw0_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2 = 8, //!< cpuss.dw0_tr_out[2]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3 = 9, //!< cpuss.dw0_tr_out[3]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4 = 10, //!< cpuss.dw0_tr_out[4]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5 = 11, //!< cpuss.dw0_tr_out[5]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6 = 12, //!< cpuss.dw0_tr_out[6]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7 = 13, //!< cpuss.dw0_tr_out[7]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8 = 14, //!< cpuss.dw0_tr_out[8]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9 = 15, //!< cpuss.dw0_tr_out[9]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10 = 16, //!< cpuss.dw0_tr_out[10]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11 = 17, //!< cpuss.dw0_tr_out[11]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12 = 18, //!< cpuss.dw0_tr_out[12]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13 = 19, //!< cpuss.dw0_tr_out[13]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14 = 20, //!< cpuss.dw0_tr_out[14]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15 = 21, //!< cpuss.dw0_tr_out[15]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0 = 22, //!< cpuss.dw1_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1 = 23, //!< cpuss.dw1_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2 = 24, //!< cpuss.dw1_tr_out[2]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3 = 25, //!< cpuss.dw1_tr_out[3]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4 = 26, //!< cpuss.dw1_tr_out[4]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5 = 27, //!< cpuss.dw1_tr_out[5]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6 = 28, //!< cpuss.dw1_tr_out[6]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7 = 29, //!< cpuss.dw1_tr_out[7]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8 = 30, //!< cpuss.dw1_tr_out[8]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9 = 31, //!< cpuss.dw1_tr_out[9]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10 = 32, //!< cpuss.dw1_tr_out[10]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11 = 33, //!< cpuss.dw1_tr_out[11]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12 = 34, //!< cpuss.dw1_tr_out[12]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13 = 35, //!< cpuss.dw1_tr_out[13]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14 = 36, //!< cpuss.dw1_tr_out[14]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15 = 37, //!< cpuss.dw1_tr_out[15]
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0 = 38, //!< cpuss.tr_fault[0]
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1 = 39, //!< cpuss.tr_fault[1]
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT = 40, //!< csd.dsi_sense_out
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE = 41, //!< csd.tr_adc_done
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0 = 42, //!< lpcomp.dsi_comp0
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1 = 43, //!< lpcomp.dsi_comp1
    _CYHAL_TRIGGER_PASS_DSI_CTB_CMP0 = 44, //!< pass.dsi_ctb_cmp0
    _CYHAL_TRIGGER_PASS_DSI_CTB_CMP1 = 45, //!< pass.dsi_ctb_cmp1
    _CYHAL_TRIGGER_PASS_TR_CTDAC_EMPTY = 46, //!< pass.tr_ctdac_empty
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT = 47, //!< pass.tr_sar_out
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0 = 48, //!< peri.tr_io_input[0]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1 = 49, //!< peri.tr_io_input[1]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2 = 50, //!< peri.tr_io_input[2]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3 = 51, //!< peri.tr_io_input[3]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4 = 52, //!< peri.tr_io_input[4]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5 = 53, //!< peri.tr_io_input[5]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6 = 54, //!< peri.tr_io_input[6]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7 = 55, //!< peri.tr_io_input[7]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8 = 56, //!< peri.tr_io_input[8]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9 = 57, //!< peri.tr_io_input[9]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10 = 58, //!< peri.tr_io_input[10]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11 = 59, //!< peri.tr_io_input[11]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12 = 60, //!< peri.tr_io_input[12]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13 = 61, //!< peri.tr_io_input[13]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14 = 62, //!< peri.tr_io_input[14]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15 = 63, //!< peri.tr_io_input[15]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16 = 64, //!< peri.tr_io_input[16]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17 = 65, //!< peri.tr_io_input[17]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18 = 66, //!< peri.tr_io_input[18]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19 = 67, //!< peri.tr_io_input[19]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20 = 68, //!< peri.tr_io_input[20]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21 = 69, //!< peri.tr_io_input[21]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22 = 70, //!< peri.tr_io_input[22]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23 = 71, //!< peri.tr_io_input[23]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24 = 72, //!< peri.tr_io_input[24]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25 = 73, //!< peri.tr_io_input[25]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26 = 74, //!< peri.tr_io_input[26]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27 = 75, //!< peri.tr_io_input[27]
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED = 76, //!< scb[0].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED = 77, //!< scb[1].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED = 78, //!< scb[2].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED = 79, //!< scb[3].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED = 80, //!< scb[4].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED = 81, //!< scb[5].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED = 82, //!< scb[6].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED = 83, //!< scb[7].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED = 84, //!< scb[8].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ = 85, //!< scb[0].tr_rx_req
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ = 86, //!< scb[1].tr_rx_req
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ = 87, //!< scb[2].tr_rx_req
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ = 88, //!< scb[3].tr_rx_req
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ = 89, //!< scb[4].tr_rx_req
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ = 90, //!< scb[5].tr_rx_req
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ = 91, //!< scb[6].tr_rx_req
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ = 92, //!< scb[7].tr_rx_req
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ = 93, //!< scb[8].tr_rx_req
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ = 94, //!< scb[0].tr_tx_req
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ = 95, //!< scb[1].tr_tx_req
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ = 96, //!< scb[2].tr_tx_req
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ = 97, //!< scb[3].tr_tx_req
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ = 98, //!< scb[4].tr_tx_req
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ = 99, //!< scb[5].tr_tx_req
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ = 100, //!< scb[6].tr_tx_req
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ = 101, //!< scb[7].tr_tx_req
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ = 102, //!< scb[8].tr_tx_req
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ = 103, //!< smif.tr_rx_req
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ = 104, //!< smif.tr_tx_req
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0 = 105, //!< tcpwm[0].tr_compare_match[0]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1 = 106, //!< tcpwm[0].tr_compare_match[1]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2 = 107, //!< tcpwm[0].tr_compare_match[2]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3 = 108, //!< tcpwm[0].tr_compare_match[3]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4 = 109, //!< tcpwm[0].tr_compare_match[4]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5 = 110, //!< tcpwm[0].tr_compare_match[5]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6 = 111, //!< tcpwm[0].tr_compare_match[6]
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7 = 112, //!< tcpwm[0].tr_compare_match[7]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0 = 113, //!< tcpwm[1].tr_compare_match[0]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1 = 114, //!< tcpwm[1].tr_compare_match[1]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2 = 115, //!< tcpwm[1].tr_compare_match[2]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3 = 116, //!< tcpwm[1].tr_compare_match[3]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4 = 117, //!< tcpwm[1].tr_compare_match[4]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5 = 118, //!< tcpwm[1].tr_compare_match[5]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6 = 119, //!< tcpwm[1].tr_compare_match[6]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7 = 120, //!< tcpwm[1].tr_compare_match[7]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8 = 121, //!< tcpwm[1].tr_compare_match[8]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9 = 122, //!< tcpwm[1].tr_compare_match[9]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10 = 123, //!< tcpwm[1].tr_compare_match[10]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11 = 124, //!< tcpwm[1].tr_compare_match[11]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12 = 125, //!< tcpwm[1].tr_compare_match[12]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13 = 126, //!< tcpwm[1].tr_compare_match[13]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14 = 127, //!< tcpwm[1].tr_compare_match[14]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15 = 128, //!< tcpwm[1].tr_compare_match[15]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16 = 129, //!< tcpwm[1].tr_compare_match[16]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17 = 130, //!< tcpwm[1].tr_compare_match[17]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18 = 131, //!< tcpwm[1].tr_compare_match[18]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19 = 132, //!< tcpwm[1].tr_compare_match[19]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20 = 133, //!< tcpwm[1].tr_compare_match[20]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21 = 134, //!< tcpwm[1].tr_compare_match[21]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22 = 135, //!< tcpwm[1].tr_compare_match[22]
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23 = 136, //!< tcpwm[1].tr_compare_match[23]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0 = 137, //!< tcpwm[0].tr_overflow[0]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1 = 138, //!< tcpwm[0].tr_overflow[1]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2 = 139, //!< tcpwm[0].tr_overflow[2]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3 = 140, //!< tcpwm[0].tr_overflow[3]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4 = 141, //!< tcpwm[0].tr_overflow[4]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5 = 142, //!< tcpwm[0].tr_overflow[5]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6 = 143, //!< tcpwm[0].tr_overflow[6]
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7 = 144, //!< tcpwm[0].tr_overflow[7]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0 = 145, //!< tcpwm[1].tr_overflow[0]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1 = 146, //!< tcpwm[1].tr_overflow[1]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2 = 147, //!< tcpwm[1].tr_overflow[2]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3 = 148, //!< tcpwm[1].tr_overflow[3]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4 = 149, //!< tcpwm[1].tr_overflow[4]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5 = 150, //!< tcpwm[1].tr_overflow[5]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6 = 151, //!< tcpwm[1].tr_overflow[6]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7 = 152, //!< tcpwm[1].tr_overflow[7]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8 = 153, //!< tcpwm[1].tr_overflow[8]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9 = 154, //!< tcpwm[1].tr_overflow[9]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10 = 155, //!< tcpwm[1].tr_overflow[10]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11 = 156, //!< tcpwm[1].tr_overflow[11]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12 = 157, //!< tcpwm[1].tr_overflow[12]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13 = 158, //!< tcpwm[1].tr_overflow[13]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14 = 159, //!< tcpwm[1].tr_overflow[14]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15 = 160, //!< tcpwm[1].tr_overflow[15]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16 = 161, //!< tcpwm[1].tr_overflow[16]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17 = 162, //!< tcpwm[1].tr_overflow[17]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18 = 163, //!< tcpwm[1].tr_overflow[18]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19 = 164, //!< tcpwm[1].tr_overflow[19]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20 = 165, //!< tcpwm[1].tr_overflow[20]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21 = 166, //!< tcpwm[1].tr_overflow[21]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22 = 167, //!< tcpwm[1].tr_overflow[22]
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23 = 168, //!< tcpwm[1].tr_overflow[23]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0 = 169, //!< tcpwm[0].tr_underflow[0]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1 = 170, //!< tcpwm[0].tr_underflow[1]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2 = 171, //!< tcpwm[0].tr_underflow[2]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3 = 172, //!< tcpwm[0].tr_underflow[3]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4 = 173, //!< tcpwm[0].tr_underflow[4]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5 = 174, //!< tcpwm[0].tr_underflow[5]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6 = 175, //!< tcpwm[0].tr_underflow[6]
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7 = 176, //!< tcpwm[0].tr_underflow[7]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0 = 177, //!< tcpwm[1].tr_underflow[0]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1 = 178, //!< tcpwm[1].tr_underflow[1]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2 = 179, //!< tcpwm[1].tr_underflow[2]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3 = 180, //!< tcpwm[1].tr_underflow[3]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4 = 181, //!< tcpwm[1].tr_underflow[4]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5 = 182, //!< tcpwm[1].tr_underflow[5]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6 = 183, //!< tcpwm[1].tr_underflow[6]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7 = 184, //!< tcpwm[1].tr_underflow[7]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8 = 185, //!< tcpwm[1].tr_underflow[8]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9 = 186, //!< tcpwm[1].tr_underflow[9]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10 = 187, //!< tcpwm[1].tr_underflow[10]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11 = 188, //!< tcpwm[1].tr_underflow[11]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12 = 189, //!< tcpwm[1].tr_underflow[12]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13 = 190, //!< tcpwm[1].tr_underflow[13]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14 = 191, //!< tcpwm[1].tr_underflow[14]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15 = 192, //!< tcpwm[1].tr_underflow[15]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16 = 193, //!< tcpwm[1].tr_underflow[16]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17 = 194, //!< tcpwm[1].tr_underflow[17]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18 = 195, //!< tcpwm[1].tr_underflow[18]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19 = 196, //!< tcpwm[1].tr_underflow[19]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20 = 197, //!< tcpwm[1].tr_underflow[20]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21 = 198, //!< tcpwm[1].tr_underflow[21]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22 = 199, //!< tcpwm[1].tr_underflow[22]
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23 = 200, //!< tcpwm[1].tr_underflow[23]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0 = 201, //!< tr_group[10].output[0]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1 = 202, //!< tr_group[10].output[1]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2 = 203, //!< tr_group[10].output[2]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3 = 204, //!< tr_group[10].output[3]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4 = 205, //!< tr_group[10].output[4]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5 = 206, //!< tr_group[10].output[5]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6 = 207, //!< tr_group[10].output[6]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7 = 208, //!< tr_group[10].output[7]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0 = 209, //!< tr_group[11].output[0]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1 = 210, //!< tr_group[11].output[1]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2 = 211, //!< tr_group[11].output[2]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3 = 212, //!< tr_group[11].output[3]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4 = 213, //!< tr_group[11].output[4]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5 = 214, //!< tr_group[11].output[5]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6 = 215, //!< tr_group[11].output[6]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7 = 216, //!< tr_group[11].output[7]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8 = 217, //!< tr_group[11].output[8]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9 = 218, //!< tr_group[11].output[9]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10 = 219, //!< tr_group[11].output[10]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11 = 220, //!< tr_group[11].output[11]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12 = 221, //!< tr_group[11].output[12]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13 = 222, //!< tr_group[11].output[13]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14 = 223, //!< tr_group[11].output[14]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15 = 224, //!< tr_group[11].output[15]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0 = 225, //!< tr_group[12].output[0]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1 = 226, //!< tr_group[12].output[1]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2 = 227, //!< tr_group[12].output[2]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3 = 228, //!< tr_group[12].output[3]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4 = 229, //!< tr_group[12].output[4]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5 = 230, //!< tr_group[12].output[5]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6 = 231, //!< tr_group[12].output[6]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7 = 232, //!< tr_group[12].output[7]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT8 = 233, //!< tr_group[12].output[8]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT9 = 234, //!< tr_group[12].output[9]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT0 = 235, //!< tr_group[13].output[0]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT1 = 236, //!< tr_group[13].output[1]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT2 = 237, //!< tr_group[13].output[2]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT3 = 238, //!< tr_group[13].output[3]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT4 = 239, //!< tr_group[13].output[4]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT5 = 240, //!< tr_group[13].output[5]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT6 = 241, //!< tr_group[13].output[6]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT7 = 242, //!< tr_group[13].output[7]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT8 = 243, //!< tr_group[13].output[8]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT9 = 244, //!< tr_group[13].output[9]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT10 = 245, //!< tr_group[13].output[10]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT11 = 246, //!< tr_group[13].output[11]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT12 = 247, //!< tr_group[13].output[12]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT13 = 248, //!< tr_group[13].output[13]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT14 = 249, //!< tr_group[13].output[14]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT15 = 250, //!< tr_group[13].output[15]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16 = 251, //!< tr_group[13].output[16]
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17 = 252, //!< tr_group[13].output[17]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT0 = 253, //!< tr_group[14].output[0]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT1 = 254, //!< tr_group[14].output[1]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT2 = 255, //!< tr_group[14].output[2]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT3 = 256, //!< tr_group[14].output[3]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT4 = 257, //!< tr_group[14].output[4]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT5 = 258, //!< tr_group[14].output[5]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT6 = 259, //!< tr_group[14].output[6]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT7 = 260, //!< tr_group[14].output[7]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8 = 261, //!< tr_group[14].output[8]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9 = 262, //!< tr_group[14].output[9]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10 = 263, //!< tr_group[14].output[10]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11 = 264, //!< tr_group[14].output[11]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12 = 265, //!< tr_group[14].output[12]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13 = 266, //!< tr_group[14].output[13]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14 = 267, //!< tr_group[14].output[14]
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15 = 268, //!< tr_group[14].output[15]
    _CYHAL_TRIGGER_UDB_DSI_OUT_TR0 = 269, //!< udb.dsi_out_tr[0]
    _CYHAL_TRIGGER_UDB_DSI_OUT_TR1 = 270, //!< udb.dsi_out_tr[1]
    _CYHAL_TRIGGER_UDB_TR_UDB0 = 271, //!< udb.tr_udb[0]
    _CYHAL_TRIGGER_UDB_TR_UDB1 = 272, //!< udb.tr_udb[1]
    _CYHAL_TRIGGER_UDB_TR_UDB2 = 273, //!< udb.tr_udb[2]
    _CYHAL_TRIGGER_UDB_TR_UDB3 = 274, //!< udb.tr_udb[3]
    _CYHAL_TRIGGER_UDB_TR_UDB4 = 275, //!< udb.tr_udb[4]
    _CYHAL_TRIGGER_UDB_TR_UDB5 = 276, //!< udb.tr_udb[5]
    _CYHAL_TRIGGER_UDB_TR_UDB6 = 277, //!< udb.tr_udb[6]
    _CYHAL_TRIGGER_UDB_TR_UDB7 = 278, //!< udb.tr_udb[7]
    _CYHAL_TRIGGER_UDB_TR_UDB8 = 279, //!< udb.tr_udb[8]
    _CYHAL_TRIGGER_UDB_TR_UDB9 = 280, //!< udb.tr_udb[9]
    _CYHAL_TRIGGER_UDB_TR_UDB10 = 281, //!< udb.tr_udb[10]
    _CYHAL_TRIGGER_UDB_TR_UDB11 = 282, //!< udb.tr_udb[11]
    _CYHAL_TRIGGER_UDB_TR_UDB12 = 283, //!< udb.tr_udb[12]
    _CYHAL_TRIGGER_UDB_TR_UDB13 = 284, //!< udb.tr_udb[13]
    _CYHAL_TRIGGER_UDB_TR_UDB14 = 285, //!< udb.tr_udb[14]
    _CYHAL_TRIGGER_UDB_TR_UDB15 = 286, //!< udb.tr_udb[15]
    _CYHAL_TRIGGER_USB_DMA_REQ0 = 287, //!< usb.dma_req[0]
    _CYHAL_TRIGGER_USB_DMA_REQ1 = 288, //!< usb.dma_req[1]
    _CYHAL_TRIGGER_USB_DMA_REQ2 = 289, //!< usb.dma_req[2]
    _CYHAL_TRIGGER_USB_DMA_REQ3 = 290, //!< usb.dma_req[3]
    _CYHAL_TRIGGER_USB_DMA_REQ4 = 291, //!< usb.dma_req[4]
    _CYHAL_TRIGGER_USB_DMA_REQ5 = 292, //!< usb.dma_req[5]
    _CYHAL_TRIGGER_USB_DMA_REQ6 = 293, //!< usb.dma_req[6]
    _CYHAL_TRIGGER_USB_DMA_REQ7 = 294, //!< usb.dma_req[7]
} _cyhal_trigger_source_psoc6_01_t;

/** Typedef for internal device family specific trigger source to generic trigger source */
typedef _cyhal_trigger_source_psoc6_01_t cyhal_internal_source_t;

/** @brief Get a public source signal type (cyhal_trigger_source_psoc6_01_t) given an internal source signal and signal type */
#define _CYHAL_TRIGGER_CREATE_SOURCE(src, type)    ((src) << 1 | (type))
/** @brief Get an internal source signal (_cyhal_trigger_source_psoc6_01_t) given a public source signal. */
#define _CYHAL_TRIGGER_GET_SOURCE_SIGNAL(src)      ((cyhal_internal_source_t)((src) >> 1))
/** @brief Get the signal type (cyhal_signal_type_t) given a public source signal. */
#define _CYHAL_TRIGGER_GET_SOURCE_TYPE(src)        ((cyhal_signal_type_t)((src) & 1))
/** \endcond */

/** @brief Name of each input trigger. */
typedef enum
{
    CYHAL_TRIGGER_CPUSS_ZERO_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_ZERO, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.zero
    CYHAL_TRIGGER_CPUSS_ZERO_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_ZERO, CYHAL_SIGNAL_TYPE_LEVEL), //!< cpuss.zero
    CYHAL_TRIGGER_AUDIOSS_TR_I2S_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS_TR_I2S_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss.tr_i2s_rx_req
    CYHAL_TRIGGER_AUDIOSS_TR_I2S_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS_TR_I2S_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss.tr_i2s_tx_req
    CYHAL_TRIGGER_AUDIOSS_TR_PDM_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS_TR_PDM_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss.tr_pdm_rx_req
    CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.cti_tr_out[0]
    CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.cti_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[0]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[2]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[3]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[4]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[5]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[6]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[7]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[8]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[9]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[10]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[11]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[12]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[13]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[14]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[15]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[0]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[2]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[3]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[4]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[5]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[6]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[7]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[8]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[9]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[10]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[11]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[12]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[13]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[14]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[15]
    CYHAL_TRIGGER_CPUSS_TR_FAULT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_TR_FAULT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.tr_fault[0]
    CYHAL_TRIGGER_CPUSS_TR_FAULT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_TR_FAULT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.tr_fault[1]
    CYHAL_TRIGGER_CSD_DSI_SENSE_OUT_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CSD_DSI_SENSE_OUT, CYHAL_SIGNAL_TYPE_EDGE), //!< csd.dsi_sense_out
    CYHAL_TRIGGER_CSD_DSI_SENSE_OUT_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CSD_DSI_SENSE_OUT, CYHAL_SIGNAL_TYPE_LEVEL), //!< csd.dsi_sense_out
    CYHAL_TRIGGER_CSD_TR_ADC_DONE_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CSD_TR_ADC_DONE, CYHAL_SIGNAL_TYPE_EDGE), //!< csd.tr_adc_done
    CYHAL_TRIGGER_CSD_TR_ADC_DONE_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CSD_TR_ADC_DONE, CYHAL_SIGNAL_TYPE_LEVEL), //!< csd.tr_adc_done
    CYHAL_TRIGGER_LPCOMP_DSI_COMP0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_LPCOMP_DSI_COMP0, CYHAL_SIGNAL_TYPE_LEVEL), //!< lpcomp.dsi_comp0
    CYHAL_TRIGGER_LPCOMP_DSI_COMP1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_LPCOMP_DSI_COMP1, CYHAL_SIGNAL_TYPE_LEVEL), //!< lpcomp.dsi_comp1
    CYHAL_TRIGGER_PASS_DSI_CTB_CMP0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS_DSI_CTB_CMP0, CYHAL_SIGNAL_TYPE_EDGE), //!< pass.dsi_ctb_cmp0
    CYHAL_TRIGGER_PASS_DSI_CTB_CMP0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS_DSI_CTB_CMP0, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass.dsi_ctb_cmp0
    CYHAL_TRIGGER_PASS_DSI_CTB_CMP1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS_DSI_CTB_CMP1, CYHAL_SIGNAL_TYPE_EDGE), //!< pass.dsi_ctb_cmp1
    CYHAL_TRIGGER_PASS_DSI_CTB_CMP1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS_DSI_CTB_CMP1, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass.dsi_ctb_cmp1
    CYHAL_TRIGGER_PASS_TR_CTDAC_EMPTY = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS_TR_CTDAC_EMPTY, CYHAL_SIGNAL_TYPE_EDGE), //!< pass.tr_ctdac_empty
    CYHAL_TRIGGER_PASS_TR_SAR_OUT = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS_TR_SAR_OUT, CYHAL_SIGNAL_TYPE_EDGE), //!< pass.tr_sar_out
    CYHAL_TRIGGER_PERI_TR_IO_INPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[0]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[0]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[1]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[1]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[2]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[2]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[3]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[3]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[4]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[4]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[5]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[5]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[6]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[6]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[7]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[7]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[8]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[8]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[9]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[9]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[10]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[10]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[11]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[11]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[12]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[12]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[13]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[13]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[14]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[14]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[15]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[15]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT16_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT16, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[16]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT16_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT16, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[16]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT17_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT17, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[17]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT17_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT17, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[17]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT18_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT18, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[18]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT18_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT18, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[18]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT19_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT19, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[19]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT19_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT19, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[19]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT20_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT20, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[20]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT20_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT20, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[20]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT21_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT21, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[21]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT21_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT21, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[21]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT22_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT22, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[22]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT22_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT22, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[22]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT23_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT23, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[23]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT23_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT23, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[23]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT24_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT24, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[24]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT24_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT24, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[24]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT25_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT25, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[25]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT25_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT25, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[25]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT26_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT26, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[26]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT26_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT26, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[26]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT27_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT27, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[27]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT27_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT27, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[27]
    CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[0].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[1].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[2].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[3].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[4].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[5].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[6].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[7].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[8].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB0_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB0_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[0].tr_rx_req
    CYHAL_TRIGGER_SCB1_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB1_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[1].tr_rx_req
    CYHAL_TRIGGER_SCB2_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB2_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[2].tr_rx_req
    CYHAL_TRIGGER_SCB3_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB3_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[3].tr_rx_req
    CYHAL_TRIGGER_SCB4_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB4_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[4].tr_rx_req
    CYHAL_TRIGGER_SCB5_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB5_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[5].tr_rx_req
    CYHAL_TRIGGER_SCB6_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB6_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[6].tr_rx_req
    CYHAL_TRIGGER_SCB7_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB7_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[7].tr_rx_req
    CYHAL_TRIGGER_SCB8_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB8_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[8].tr_rx_req
    CYHAL_TRIGGER_SCB0_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB0_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[0].tr_tx_req
    CYHAL_TRIGGER_SCB1_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB1_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[1].tr_tx_req
    CYHAL_TRIGGER_SCB2_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB2_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[2].tr_tx_req
    CYHAL_TRIGGER_SCB3_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB3_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[3].tr_tx_req
    CYHAL_TRIGGER_SCB4_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB4_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[4].tr_tx_req
    CYHAL_TRIGGER_SCB5_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB5_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[5].tr_tx_req
    CYHAL_TRIGGER_SCB6_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB6_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[6].tr_tx_req
    CYHAL_TRIGGER_SCB7_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB7_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[7].tr_tx_req
    CYHAL_TRIGGER_SCB8_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB8_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[8].tr_tx_req
    CYHAL_TRIGGER_SMIF_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SMIF_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< smif.tr_rx_req
    CYHAL_TRIGGER_SMIF_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SMIF_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< smif.tr_tx_req
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[0]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[1]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[2]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[3]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[4]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[5]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[6]
    CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_compare_match[7]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[0]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[1]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[2]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[3]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[4]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[5]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[6]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[7]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[8]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[9]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[10]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[11]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[12]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[13]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[14]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[15]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[16]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[17]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[18]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[19]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[20]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[21]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[22]
    CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_compare_match[23]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[0]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[1]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[2]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[3]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[4]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[5]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[6]
    CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_overflow[7]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[0]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[1]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[2]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[3]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[4]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[5]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[6]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[7]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[8]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[9]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[10]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[11]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[12]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[13]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[14]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[15]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[16]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[17]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[18]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[19]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[20]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[21]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[22]
    CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_overflow[23]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[0]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[1]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[2]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[3]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[4]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[5]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[6]
    CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_underflow[7]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[0]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[1]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[2]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[3]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[4]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[5]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[6]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[7]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[8]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[9]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[10]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[11]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[12]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[13]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[14]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[15]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[16]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[17]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[18]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[19]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[20]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[21]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[22]
    CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_underflow[23]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[0]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[0]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[1]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[1]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[2]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[2]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[3]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[3]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[4]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[4]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[5]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[5]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[6]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[6]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[7]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[7]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[0]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[0]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[1]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[1]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[2]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[2]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[3]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[3]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[4]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[4]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[5]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[5]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[6]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[6]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[7]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[7]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[8]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[8]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[9]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[9]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[10]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[10]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[11]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[11]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[12]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[12]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[13]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[13]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[14]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[14]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[15]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[15]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[0]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[0]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[1]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[1]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[2]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[2]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[3]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[3]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[4]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[4]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[5]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[5]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[6]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[6]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[7]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[7]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[8]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[8]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[9]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[9]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[0]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[0]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[1]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[1]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[2]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[2]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[3]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[3]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[4]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[4]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[5]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[5]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[6]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[6]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[7]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[7]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[8]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[8]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[9]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[9]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[10]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[10]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[11]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[11]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[12]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[12]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[13]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[13]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[14]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[14]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[15]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[15]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT16_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT16, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[16]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT16_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT16, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[16]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT17_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT17, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[13].output[17]
    CYHAL_TRIGGER_TR_GROUP13_OUTPUT17_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP13_OUTPUT17, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[13].output[17]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[0]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[0]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[1]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[1]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[2]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[2]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[3]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[3]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[4]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[4]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[5]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[5]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[6]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[6]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[7]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[7]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[8]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[8]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[9]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[9]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[10]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[10]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[11]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[11]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[12]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[12]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[13]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[13]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[14]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[14]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[14].output[15]
    CYHAL_TRIGGER_TR_GROUP14_OUTPUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP14_OUTPUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[14].output[15]
    CYHAL_TRIGGER_UDB_DSI_OUT_TR0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_DSI_OUT_TR0, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.dsi_out_tr[0]
    CYHAL_TRIGGER_UDB_DSI_OUT_TR0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_DSI_OUT_TR0, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.dsi_out_tr[0]
    CYHAL_TRIGGER_UDB_DSI_OUT_TR1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_DSI_OUT_TR1, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.dsi_out_tr[1]
    CYHAL_TRIGGER_UDB_DSI_OUT_TR1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_DSI_OUT_TR1, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.dsi_out_tr[1]
    CYHAL_TRIGGER_UDB_TR_UDB0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB0, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[0]
    CYHAL_TRIGGER_UDB_TR_UDB0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB0, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[0]
    CYHAL_TRIGGER_UDB_TR_UDB1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB1, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[1]
    CYHAL_TRIGGER_UDB_TR_UDB1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB1, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[1]
    CYHAL_TRIGGER_UDB_TR_UDB2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB2, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[2]
    CYHAL_TRIGGER_UDB_TR_UDB2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB2, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[2]
    CYHAL_TRIGGER_UDB_TR_UDB3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB3, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[3]
    CYHAL_TRIGGER_UDB_TR_UDB3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB3, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[3]
    CYHAL_TRIGGER_UDB_TR_UDB4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB4, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[4]
    CYHAL_TRIGGER_UDB_TR_UDB4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB4, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[4]
    CYHAL_TRIGGER_UDB_TR_UDB5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB5, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[5]
    CYHAL_TRIGGER_UDB_TR_UDB5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB5, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[5]
    CYHAL_TRIGGER_UDB_TR_UDB6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB6, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[6]
    CYHAL_TRIGGER_UDB_TR_UDB6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB6, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[6]
    CYHAL_TRIGGER_UDB_TR_UDB7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB7, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[7]
    CYHAL_TRIGGER_UDB_TR_UDB7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB7, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[7]
    CYHAL_TRIGGER_UDB_TR_UDB8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB8, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[8]
    CYHAL_TRIGGER_UDB_TR_UDB8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB8, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[8]
    CYHAL_TRIGGER_UDB_TR_UDB9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB9, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[9]
    CYHAL_TRIGGER_UDB_TR_UDB9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB9, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[9]
    CYHAL_TRIGGER_UDB_TR_UDB10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB10, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[10]
    CYHAL_TRIGGER_UDB_TR_UDB10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB10, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[10]
    CYHAL_TRIGGER_UDB_TR_UDB11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB11, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[11]
    CYHAL_TRIGGER_UDB_TR_UDB11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB11, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[11]
    CYHAL_TRIGGER_UDB_TR_UDB12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB12, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[12]
    CYHAL_TRIGGER_UDB_TR_UDB12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB12, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[12]
    CYHAL_TRIGGER_UDB_TR_UDB13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB13, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[13]
    CYHAL_TRIGGER_UDB_TR_UDB13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB13, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[13]
    CYHAL_TRIGGER_UDB_TR_UDB14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB14, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[14]
    CYHAL_TRIGGER_UDB_TR_UDB14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB14, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[14]
    CYHAL_TRIGGER_UDB_TR_UDB15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB15, CYHAL_SIGNAL_TYPE_EDGE), //!< udb.tr_udb[15]
    CYHAL_TRIGGER_UDB_TR_UDB15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_UDB_TR_UDB15, CYHAL_SIGNAL_TYPE_LEVEL), //!< udb.tr_udb[15]
    CYHAL_TRIGGER_USB_DMA_REQ0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ0, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[0]
    CYHAL_TRIGGER_USB_DMA_REQ1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ1, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[1]
    CYHAL_TRIGGER_USB_DMA_REQ2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ2, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[2]
    CYHAL_TRIGGER_USB_DMA_REQ3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ3, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[3]
    CYHAL_TRIGGER_USB_DMA_REQ4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ4, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[4]
    CYHAL_TRIGGER_USB_DMA_REQ5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ5, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[5]
    CYHAL_TRIGGER_USB_DMA_REQ6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ6, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[6]
    CYHAL_TRIGGER_USB_DMA_REQ7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_USB_DMA_REQ7, CYHAL_SIGNAL_TYPE_EDGE), //!< usb.dma_req[7]
} cyhal_trigger_source_psoc6_01_t;

/** Typedef from device family specific trigger source to generic trigger source */
typedef cyhal_trigger_source_psoc6_01_t cyhal_source_t;

/** Deprecated defines for signals that can be either level or edge. */
#define CYHAL_TRIGGER_CPUSS_ZERO (CYHAL_TRIGGER_CPUSS_ZERO_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_CSD_DSI_SENSE_OUT (CYHAL_TRIGGER_CSD_DSI_SENSE_OUT_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_CSD_TR_ADC_DONE (CYHAL_TRIGGER_CSD_TR_ADC_DONE_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS_DSI_CTB_CMP0 (CYHAL_TRIGGER_PASS_DSI_CTB_CMP0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS_DSI_CTB_CMP1 (CYHAL_TRIGGER_PASS_DSI_CTB_CMP1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT0 (CYHAL_TRIGGER_PERI_TR_IO_INPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT1 (CYHAL_TRIGGER_PERI_TR_IO_INPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT2 (CYHAL_TRIGGER_PERI_TR_IO_INPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT3 (CYHAL_TRIGGER_PERI_TR_IO_INPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT4 (CYHAL_TRIGGER_PERI_TR_IO_INPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT5 (CYHAL_TRIGGER_PERI_TR_IO_INPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT6 (CYHAL_TRIGGER_PERI_TR_IO_INPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT7 (CYHAL_TRIGGER_PERI_TR_IO_INPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT8 (CYHAL_TRIGGER_PERI_TR_IO_INPUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT9 (CYHAL_TRIGGER_PERI_TR_IO_INPUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT10 (CYHAL_TRIGGER_PERI_TR_IO_INPUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT11 (CYHAL_TRIGGER_PERI_TR_IO_INPUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT12 (CYHAL_TRIGGER_PERI_TR_IO_INPUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT13 (CYHAL_TRIGGER_PERI_TR_IO_INPUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT14 (CYHAL_TRIGGER_PERI_TR_IO_INPUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT15 (CYHAL_TRIGGER_PERI_TR_IO_INPUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT16 (CYHAL_TRIGGER_PERI_TR_IO_INPUT16_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT17 (CYHAL_TRIGGER_PERI_TR_IO_INPUT17_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT18 (CYHAL_TRIGGER_PERI_TR_IO_INPUT18_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT19 (CYHAL_TRIGGER_PERI_TR_IO_INPUT19_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT20 (CYHAL_TRIGGER_PERI_TR_IO_INPUT20_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT21 (CYHAL_TRIGGER_PERI_TR_IO_INPUT21_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT22 (CYHAL_TRIGGER_PERI_TR_IO_INPUT22_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT23 (CYHAL_TRIGGER_PERI_TR_IO_INPUT23_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT24 (CYHAL_TRIGGER_PERI_TR_IO_INPUT24_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT25 (CYHAL_TRIGGER_PERI_TR_IO_INPUT25_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT26 (CYHAL_TRIGGER_PERI_TR_IO_INPUT26_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT27 (CYHAL_TRIGGER_PERI_TR_IO_INPUT27_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT5 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT6 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT7 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT5 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT6 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT7 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT8 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT9 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT10 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT11 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT12 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT13 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT14 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT15 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT5 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT6 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT7 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT8 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT9 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT5 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT6 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT7 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT8 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT9 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT10 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT11 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT12 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT13 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT14 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT15 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT16 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT16_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP13_OUTPUT17 (CYHAL_TRIGGER_TR_GROUP13_OUTPUT17_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT5 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT6 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT7 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT8 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT9 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT10 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT11 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT12 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT13 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT14 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP14_OUTPUT15 (CYHAL_TRIGGER_TR_GROUP14_OUTPUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_DSI_OUT_TR0 (CYHAL_TRIGGER_UDB_DSI_OUT_TR0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_DSI_OUT_TR1 (CYHAL_TRIGGER_UDB_DSI_OUT_TR1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB0 (CYHAL_TRIGGER_UDB_TR_UDB0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB1 (CYHAL_TRIGGER_UDB_TR_UDB1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB2 (CYHAL_TRIGGER_UDB_TR_UDB2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB3 (CYHAL_TRIGGER_UDB_TR_UDB3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB4 (CYHAL_TRIGGER_UDB_TR_UDB4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB5 (CYHAL_TRIGGER_UDB_TR_UDB5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB6 (CYHAL_TRIGGER_UDB_TR_UDB6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB7 (CYHAL_TRIGGER_UDB_TR_UDB7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB8 (CYHAL_TRIGGER_UDB_TR_UDB8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB9 (CYHAL_TRIGGER_UDB_TR_UDB9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB10 (CYHAL_TRIGGER_UDB_TR_UDB10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB11 (CYHAL_TRIGGER_UDB_TR_UDB11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB12 (CYHAL_TRIGGER_UDB_TR_UDB12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB13 (CYHAL_TRIGGER_UDB_TR_UDB13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB14 (CYHAL_TRIGGER_UDB_TR_UDB14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_UDB_TR_UDB15 (CYHAL_TRIGGER_UDB_TR_UDB15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.

/** @brief Name of each output trigger. */
typedef enum
{
    CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 = 0, //!< CPUSS Cross-Triggering-Interface trigger multiplexer (CTI) - cpuss.cti_tr_in[0]
    CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 = 1, //!< CPUSS Cross-Triggering-Interface trigger multiplexer (CTI) - cpuss.cti_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 = 2, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[0]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 = 3, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 = 4, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[2]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 = 5, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[3]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 = 6, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[4]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 = 7, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[5]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 = 8, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[6]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 = 9, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[7]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 = 10, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[8]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 = 11, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[9]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 = 12, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[10]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 = 13, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[11]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 = 14, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[12]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 = 15, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[13]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 = 16, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[14]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 = 17, //!< DW0 trigger multiplexer - cpuss.dw0_tr_in[15]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 = 18, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[0]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 = 19, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 = 20, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[2]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 = 21, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[3]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 = 22, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[4]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 = 23, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[5]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 = 24, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[6]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 = 25, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[7]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 = 26, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[8]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 = 27, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[9]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 = 28, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[10]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 = 29, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[11]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 = 30, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[12]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 = 31, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[13]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 = 32, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[14]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 = 33, //!< DW1 trigger multiplexer - cpuss.dw1_tr_in[15]
    CYHAL_TRIGGER_PASS_TR_SAR_IN = 34, //!< PASS trigger multiplexer - pass.tr_sar_in
    CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 = 35, //!< GPIO/HSIOM trigger multiplexer - peri.tr_io_output[0]
    CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 = 36, //!< GPIO/HSIOM trigger multiplexer - peri.tr_io_output[1]
    CYHAL_TRIGGER_PROFILE_TR_START = 37, //!< PROFILE trigger multiplexer - profile.tr_start
    CYHAL_TRIGGER_PROFILE_TR_STOP = 38, //!< PROFILE trigger multiplexer - profile.tr_stop
    CYHAL_TRIGGER_TCPWM0_TR_IN0 = 39, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[0]
    CYHAL_TRIGGER_TCPWM0_TR_IN1 = 40, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[1]
    CYHAL_TRIGGER_TCPWM0_TR_IN2 = 41, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[2]
    CYHAL_TRIGGER_TCPWM0_TR_IN3 = 42, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[3]
    CYHAL_TRIGGER_TCPWM0_TR_IN4 = 43, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[4]
    CYHAL_TRIGGER_TCPWM0_TR_IN5 = 44, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[5]
    CYHAL_TRIGGER_TCPWM0_TR_IN6 = 45, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[6]
    CYHAL_TRIGGER_TCPWM0_TR_IN7 = 46, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[7]
    CYHAL_TRIGGER_TCPWM0_TR_IN8 = 47, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[8]
    CYHAL_TRIGGER_TCPWM0_TR_IN9 = 48, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[9]
    CYHAL_TRIGGER_TCPWM0_TR_IN10 = 49, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[10]
    CYHAL_TRIGGER_TCPWM0_TR_IN11 = 50, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[11]
    CYHAL_TRIGGER_TCPWM0_TR_IN12 = 51, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[12]
    CYHAL_TRIGGER_TCPWM0_TR_IN13 = 52, //!< TCPWM0 Trigger Multiplexer - tcpwm[0].tr_in[13]
    CYHAL_TRIGGER_TCPWM1_TR_IN0 = 53, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[0]
    CYHAL_TRIGGER_TCPWM1_TR_IN1 = 54, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[1]
    CYHAL_TRIGGER_TCPWM1_TR_IN2 = 55, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[2]
    CYHAL_TRIGGER_TCPWM1_TR_IN3 = 56, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[3]
    CYHAL_TRIGGER_TCPWM1_TR_IN4 = 57, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[4]
    CYHAL_TRIGGER_TCPWM1_TR_IN5 = 58, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[5]
    CYHAL_TRIGGER_TCPWM1_TR_IN6 = 59, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[6]
    CYHAL_TRIGGER_TCPWM1_TR_IN7 = 60, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[7]
    CYHAL_TRIGGER_TCPWM1_TR_IN8 = 61, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[8]
    CYHAL_TRIGGER_TCPWM1_TR_IN9 = 62, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[9]
    CYHAL_TRIGGER_TCPWM1_TR_IN10 = 63, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[10]
    CYHAL_TRIGGER_TCPWM1_TR_IN11 = 64, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[11]
    CYHAL_TRIGGER_TCPWM1_TR_IN12 = 65, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[12]
    CYHAL_TRIGGER_TCPWM1_TR_IN13 = 66, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_in[13]
    CYHAL_TRIGGER_TR_GROUP0_INPUT1 = 67, //!< Datawire output trigger reduction mux - tr_group[0].input[1]
    CYHAL_TRIGGER_TR_GROUP0_INPUT2 = 68, //!< Datawire output trigger reduction mux - tr_group[0].input[2]
    CYHAL_TRIGGER_TR_GROUP0_INPUT3 = 69, //!< Datawire output trigger reduction mux - tr_group[0].input[3]
    CYHAL_TRIGGER_TR_GROUP0_INPUT4 = 70, //!< Datawire output trigger reduction mux - tr_group[0].input[4]
    CYHAL_TRIGGER_TR_GROUP0_INPUT5 = 71, //!< Datawire output trigger reduction mux - tr_group[0].input[5]
    CYHAL_TRIGGER_TR_GROUP0_INPUT6 = 72, //!< Datawire output trigger reduction mux - tr_group[0].input[6]
    CYHAL_TRIGGER_TR_GROUP0_INPUT7 = 73, //!< Datawire output trigger reduction mux - tr_group[0].input[7]
    CYHAL_TRIGGER_TR_GROUP0_INPUT8 = 74, //!< Datawire output trigger reduction mux - tr_group[0].input[8]
    CYHAL_TRIGGER_TR_GROUP0_INPUT9 = 75, //!< TCPWM trigger output reduction mux - tr_group[0].input[9]
    CYHAL_TRIGGER_TR_GROUP0_INPUT10 = 76, //!< TCPWM trigger output reduction mux - tr_group[0].input[10]
    CYHAL_TRIGGER_TR_GROUP0_INPUT11 = 77, //!< TCPWM trigger output reduction mux - tr_group[0].input[11]
    CYHAL_TRIGGER_TR_GROUP0_INPUT12 = 78, //!< TCPWM trigger output reduction mux - tr_group[0].input[12]
    CYHAL_TRIGGER_TR_GROUP0_INPUT13 = 79, //!< TCPWM trigger output reduction mux - tr_group[0].input[13]
    CYHAL_TRIGGER_TR_GROUP0_INPUT14 = 80, //!< TCPWM trigger output reduction mux - tr_group[0].input[14]
    CYHAL_TRIGGER_TR_GROUP0_INPUT15 = 81, //!< TCPWM trigger output reduction mux - tr_group[0].input[15]
    CYHAL_TRIGGER_TR_GROUP0_INPUT16 = 82, //!< TCPWM trigger output reduction mux - tr_group[0].input[16]
    CYHAL_TRIGGER_TR_GROUP0_INPUT17 = 83, //!< TCPWM trigger output reduction mux - tr_group[0].input[17]
    CYHAL_TRIGGER_TR_GROUP0_INPUT18 = 84, //!< TCPWM trigger output reduction mux - tr_group[0].input[18]
    CYHAL_TRIGGER_TR_GROUP0_INPUT19 = 85, //!< TCPWM trigger output reduction mux - tr_group[0].input[19]
    CYHAL_TRIGGER_TR_GROUP0_INPUT20 = 86, //!< TCPWM trigger output reduction mux - tr_group[0].input[20]
    CYHAL_TRIGGER_TR_GROUP0_INPUT21 = 87, //!< TCPWM trigger output reduction mux - tr_group[0].input[21]
    CYHAL_TRIGGER_TR_GROUP0_INPUT22 = 88, //!< TCPWM trigger output reduction mux - tr_group[0].input[22]
    CYHAL_TRIGGER_TR_GROUP0_INPUT23 = 89, //!< TCPWM trigger output reduction mux - tr_group[0].input[23]
    CYHAL_TRIGGER_TR_GROUP0_INPUT24 = 90, //!< TCPWM trigger output reduction mux - tr_group[0].input[24]
    CYHAL_TRIGGER_TR_GROUP0_INPUT25 = 91, //!< HSIOM Pin input reduction mux - tr_group[0].input[25]
    CYHAL_TRIGGER_TR_GROUP0_INPUT26 = 92, //!< HSIOM Pin input reduction mux - tr_group[0].input[26]
    CYHAL_TRIGGER_TR_GROUP0_INPUT27 = 93, //!< DMA request reduction mux - tr_group[0].input[27]
    CYHAL_TRIGGER_TR_GROUP0_INPUT28 = 94, //!< DMA request reduction mux - tr_group[0].input[28]
    CYHAL_TRIGGER_TR_GROUP0_INPUT29 = 95, //!< DMA request reduction mux - tr_group[0].input[29]
    CYHAL_TRIGGER_TR_GROUP0_INPUT30 = 96, //!< DMA request reduction mux - tr_group[0].input[30]
    CYHAL_TRIGGER_TR_GROUP0_INPUT31 = 97, //!< DMA request reduction mux - tr_group[0].input[31]
    CYHAL_TRIGGER_TR_GROUP0_INPUT32 = 98, //!< DMA request reduction mux - tr_group[0].input[32]
    CYHAL_TRIGGER_TR_GROUP0_INPUT33 = 99, //!< DMA request reduction mux - tr_group[0].input[33]
    CYHAL_TRIGGER_TR_GROUP0_INPUT34 = 100, //!< DMA request reduction mux - tr_group[0].input[34]
    CYHAL_TRIGGER_TR_GROUP0_INPUT35 = 101, //!< DMA request reduction mux - tr_group[0].input[35]
    CYHAL_TRIGGER_TR_GROUP0_INPUT36 = 102, //!< DMA request reduction mux - tr_group[0].input[36]
    CYHAL_TRIGGER_TR_GROUP0_INPUT37 = 103, //!< DMA request reduction mux - tr_group[0].input[37]
    CYHAL_TRIGGER_TR_GROUP0_INPUT38 = 104, //!< DMA request reduction mux - tr_group[0].input[38]
    CYHAL_TRIGGER_TR_GROUP0_INPUT39 = 105, //!< DMA request reduction mux - tr_group[0].input[39]
    CYHAL_TRIGGER_TR_GROUP0_INPUT40 = 106, //!< DMA request reduction mux - tr_group[0].input[40]
    CYHAL_TRIGGER_TR_GROUP0_INPUT41 = 107, //!< DMA request reduction mux - tr_group[0].input[41]
    CYHAL_TRIGGER_TR_GROUP0_INPUT42 = 108, //!< DMA request reduction mux - tr_group[0].input[42]
    CYHAL_TRIGGER_TR_GROUP0_INPUT43 = 109, //!< Trigger input reduction mux - tr_group[0].input[43]
    CYHAL_TRIGGER_TR_GROUP0_INPUT44 = 110, //!< Trigger input reduction mux - tr_group[0].input[44]
    CYHAL_TRIGGER_TR_GROUP0_INPUT45 = 111, //!< Trigger input reduction mux - tr_group[0].input[45]
    CYHAL_TRIGGER_TR_GROUP0_INPUT46 = 112, //!< Trigger input reduction mux - tr_group[0].input[46]
    CYHAL_TRIGGER_TR_GROUP0_INPUT47 = 113, //!< Trigger input reduction mux - tr_group[0].input[47]
    CYHAL_TRIGGER_TR_GROUP0_INPUT48 = 114, //!< Trigger input reduction mux - tr_group[0].input[48]
    CYHAL_TRIGGER_TR_GROUP0_INPUT49 = 115, //!< Trigger input reduction mux - tr_group[0].input[49]
    CYHAL_TRIGGER_TR_GROUP0_INPUT50 = 116, //!< Trigger input reduction mux - tr_group[0].input[50]
    CYHAL_TRIGGER_TR_GROUP1_INPUT1 = 117, //!< Datawire output trigger reduction mux - tr_group[1].input[1]
    CYHAL_TRIGGER_TR_GROUP1_INPUT2 = 118, //!< Datawire output trigger reduction mux - tr_group[1].input[2]
    CYHAL_TRIGGER_TR_GROUP1_INPUT3 = 119, //!< Datawire output trigger reduction mux - tr_group[1].input[3]
    CYHAL_TRIGGER_TR_GROUP1_INPUT4 = 120, //!< Datawire output trigger reduction mux - tr_group[1].input[4]
    CYHAL_TRIGGER_TR_GROUP1_INPUT5 = 121, //!< Datawire output trigger reduction mux - tr_group[1].input[5]
    CYHAL_TRIGGER_TR_GROUP1_INPUT6 = 122, //!< Datawire output trigger reduction mux - tr_group[1].input[6]
    CYHAL_TRIGGER_TR_GROUP1_INPUT7 = 123, //!< Datawire output trigger reduction mux - tr_group[1].input[7]
    CYHAL_TRIGGER_TR_GROUP1_INPUT8 = 124, //!< Datawire output trigger reduction mux - tr_group[1].input[8]
    CYHAL_TRIGGER_TR_GROUP1_INPUT9 = 125, //!< TCPWM trigger output reduction mux - tr_group[1].input[9]
    CYHAL_TRIGGER_TR_GROUP1_INPUT10 = 126, //!< TCPWM trigger output reduction mux - tr_group[1].input[10]
    CYHAL_TRIGGER_TR_GROUP1_INPUT11 = 127, //!< TCPWM trigger output reduction mux - tr_group[1].input[11]
    CYHAL_TRIGGER_TR_GROUP1_INPUT12 = 128, //!< TCPWM trigger output reduction mux - tr_group[1].input[12]
    CYHAL_TRIGGER_TR_GROUP1_INPUT13 = 129, //!< TCPWM trigger output reduction mux - tr_group[1].input[13]
    CYHAL_TRIGGER_TR_GROUP1_INPUT14 = 130, //!< TCPWM trigger output reduction mux - tr_group[1].input[14]
    CYHAL_TRIGGER_TR_GROUP1_INPUT15 = 131, //!< TCPWM trigger output reduction mux - tr_group[1].input[15]
    CYHAL_TRIGGER_TR_GROUP1_INPUT16 = 132, //!< TCPWM trigger output reduction mux - tr_group[1].input[16]
    CYHAL_TRIGGER_TR_GROUP1_INPUT17 = 133, //!< TCPWM trigger output reduction mux - tr_group[1].input[17]
    CYHAL_TRIGGER_TR_GROUP1_INPUT18 = 134, //!< TCPWM trigger output reduction mux - tr_group[1].input[18]
    CYHAL_TRIGGER_TR_GROUP1_INPUT19 = 135, //!< TCPWM trigger output reduction mux - tr_group[1].input[19]
    CYHAL_TRIGGER_TR_GROUP1_INPUT20 = 136, //!< TCPWM trigger output reduction mux - tr_group[1].input[20]
    CYHAL_TRIGGER_TR_GROUP1_INPUT21 = 137, //!< TCPWM trigger output reduction mux - tr_group[1].input[21]
    CYHAL_TRIGGER_TR_GROUP1_INPUT22 = 138, //!< TCPWM trigger output reduction mux - tr_group[1].input[22]
    CYHAL_TRIGGER_TR_GROUP1_INPUT23 = 139, //!< TCPWM trigger output reduction mux - tr_group[1].input[23]
    CYHAL_TRIGGER_TR_GROUP1_INPUT24 = 140, //!< TCPWM trigger output reduction mux - tr_group[1].input[24]
    CYHAL_TRIGGER_TR_GROUP1_INPUT25 = 141, //!< HSIOM Pin input reduction mux - tr_group[1].input[25]
    CYHAL_TRIGGER_TR_GROUP1_INPUT26 = 142, //!< HSIOM Pin input reduction mux - tr_group[1].input[26]
    CYHAL_TRIGGER_TR_GROUP1_INPUT27 = 143, //!< DMA request reduction mux - tr_group[1].input[27]
    CYHAL_TRIGGER_TR_GROUP1_INPUT28 = 144, //!< DMA request reduction mux - tr_group[1].input[28]
    CYHAL_TRIGGER_TR_GROUP1_INPUT29 = 145, //!< DMA request reduction mux - tr_group[1].input[29]
    CYHAL_TRIGGER_TR_GROUP1_INPUT30 = 146, //!< DMA request reduction mux - tr_group[1].input[30]
    CYHAL_TRIGGER_TR_GROUP1_INPUT31 = 147, //!< DMA request reduction mux - tr_group[1].input[31]
    CYHAL_TRIGGER_TR_GROUP1_INPUT32 = 148, //!< DMA request reduction mux - tr_group[1].input[32]
    CYHAL_TRIGGER_TR_GROUP1_INPUT33 = 149, //!< DMA request reduction mux - tr_group[1].input[33]
    CYHAL_TRIGGER_TR_GROUP1_INPUT34 = 150, //!< DMA request reduction mux - tr_group[1].input[34]
    CYHAL_TRIGGER_TR_GROUP1_INPUT35 = 151, //!< DMA request reduction mux - tr_group[1].input[35]
    CYHAL_TRIGGER_TR_GROUP1_INPUT36 = 152, //!< DMA request reduction mux - tr_group[1].input[36]
    CYHAL_TRIGGER_TR_GROUP1_INPUT37 = 153, //!< DMA request reduction mux - tr_group[1].input[37]
    CYHAL_TRIGGER_TR_GROUP1_INPUT38 = 154, //!< DMA request reduction mux - tr_group[1].input[38]
    CYHAL_TRIGGER_TR_GROUP1_INPUT39 = 155, //!< DMA request reduction mux - tr_group[1].input[39]
    CYHAL_TRIGGER_TR_GROUP1_INPUT40 = 156, //!< DMA request reduction mux - tr_group[1].input[40]
    CYHAL_TRIGGER_TR_GROUP1_INPUT41 = 157, //!< DMA request reduction mux - tr_group[1].input[41]
    CYHAL_TRIGGER_TR_GROUP1_INPUT42 = 158, //!< DMA request reduction mux - tr_group[1].input[42]
    CYHAL_TRIGGER_TR_GROUP1_INPUT43 = 159, //!< Trigger input reduction mux - tr_group[1].input[43]
    CYHAL_TRIGGER_TR_GROUP1_INPUT44 = 160, //!< Trigger input reduction mux - tr_group[1].input[44]
    CYHAL_TRIGGER_TR_GROUP1_INPUT45 = 161, //!< Trigger input reduction mux - tr_group[1].input[45]
    CYHAL_TRIGGER_TR_GROUP1_INPUT46 = 162, //!< Trigger input reduction mux - tr_group[1].input[46]
    CYHAL_TRIGGER_TR_GROUP1_INPUT47 = 163, //!< Trigger input reduction mux - tr_group[1].input[47]
    CYHAL_TRIGGER_TR_GROUP1_INPUT48 = 164, //!< Trigger input reduction mux - tr_group[1].input[48]
    CYHAL_TRIGGER_TR_GROUP1_INPUT49 = 165, //!< Trigger input reduction mux - tr_group[1].input[49]
    CYHAL_TRIGGER_TR_GROUP1_INPUT50 = 166, //!< Trigger input reduction mux - tr_group[1].input[50]
    CYHAL_TRIGGER_TR_GROUP2_INPUT1 = 167, //!< Datawire output trigger reduction mux - tr_group[2].input[1]
    CYHAL_TRIGGER_TR_GROUP2_INPUT2 = 168, //!< Datawire output trigger reduction mux - tr_group[2].input[2]
    CYHAL_TRIGGER_TR_GROUP2_INPUT3 = 169, //!< Datawire output trigger reduction mux - tr_group[2].input[3]
    CYHAL_TRIGGER_TR_GROUP2_INPUT4 = 170, //!< Datawire output trigger reduction mux - tr_group[2].input[4]
    CYHAL_TRIGGER_TR_GROUP2_INPUT5 = 171, //!< Datawire output trigger reduction mux - tr_group[2].input[5]
    CYHAL_TRIGGER_TR_GROUP2_INPUT6 = 172, //!< Datawire output trigger reduction mux - tr_group[2].input[6]
    CYHAL_TRIGGER_TR_GROUP2_INPUT7 = 173, //!< Datawire output trigger reduction mux - tr_group[2].input[7]
    CYHAL_TRIGGER_TR_GROUP2_INPUT8 = 174, //!< Datawire output trigger reduction mux - tr_group[2].input[8]
    CYHAL_TRIGGER_TR_GROUP2_INPUT9 = 175, //!< TCPWM trigger output reduction mux - tr_group[2].input[9]
    CYHAL_TRIGGER_TR_GROUP2_INPUT10 = 176, //!< TCPWM trigger output reduction mux - tr_group[2].input[10]
    CYHAL_TRIGGER_TR_GROUP2_INPUT11 = 177, //!< TCPWM trigger output reduction mux - tr_group[2].input[11]
    CYHAL_TRIGGER_TR_GROUP2_INPUT12 = 178, //!< TCPWM trigger output reduction mux - tr_group[2].input[12]
    CYHAL_TRIGGER_TR_GROUP2_INPUT13 = 179, //!< TCPWM trigger output reduction mux - tr_group[2].input[13]
    CYHAL_TRIGGER_TR_GROUP2_INPUT14 = 180, //!< TCPWM trigger output reduction mux - tr_group[2].input[14]
    CYHAL_TRIGGER_TR_GROUP2_INPUT15 = 181, //!< TCPWM trigger output reduction mux - tr_group[2].input[15]
    CYHAL_TRIGGER_TR_GROUP2_INPUT16 = 182, //!< TCPWM trigger output reduction mux - tr_group[2].input[16]
    CYHAL_TRIGGER_TR_GROUP2_INPUT17 = 183, //!< TCPWM trigger output reduction mux - tr_group[2].input[17]
    CYHAL_TRIGGER_TR_GROUP2_INPUT18 = 184, //!< TCPWM trigger output reduction mux - tr_group[2].input[18]
    CYHAL_TRIGGER_TR_GROUP2_INPUT19 = 185, //!< TCPWM trigger output reduction mux - tr_group[2].input[19]
    CYHAL_TRIGGER_TR_GROUP2_INPUT20 = 186, //!< TCPWM trigger output reduction mux - tr_group[2].input[20]
    CYHAL_TRIGGER_TR_GROUP2_INPUT21 = 187, //!< TCPWM trigger output reduction mux - tr_group[2].input[21]
    CYHAL_TRIGGER_TR_GROUP2_INPUT22 = 188, //!< TCPWM trigger output reduction mux - tr_group[2].input[22]
    CYHAL_TRIGGER_TR_GROUP2_INPUT23 = 189, //!< TCPWM trigger output reduction mux - tr_group[2].input[23]
    CYHAL_TRIGGER_TR_GROUP2_INPUT24 = 190, //!< TCPWM trigger output reduction mux - tr_group[2].input[24]
    CYHAL_TRIGGER_TR_GROUP2_INPUT25 = 191, //!< HSIOM Pin input reduction mux - tr_group[2].input[25]
    CYHAL_TRIGGER_TR_GROUP2_INPUT26 = 192, //!< HSIOM Pin input reduction mux - tr_group[2].input[26]
    CYHAL_TRIGGER_TR_GROUP2_INPUT27 = 193, //!< HSIOM Pin input reduction mux - tr_group[2].input[27]
    CYHAL_TRIGGER_TR_GROUP2_INPUT28 = 194, //!< HSIOM Pin input reduction mux - tr_group[2].input[28]
    CYHAL_TRIGGER_TR_GROUP2_INPUT29 = 195, //!< HSIOM Pin input reduction mux - tr_group[2].input[29]
    CYHAL_TRIGGER_TR_GROUP2_INPUT30 = 196, //!< HSIOM Pin input reduction mux - tr_group[2].input[30]
    CYHAL_TRIGGER_TR_GROUP2_INPUT31 = 197, //!< HSIOM Pin input reduction mux - tr_group[2].input[31]
    CYHAL_TRIGGER_TR_GROUP2_INPUT32 = 198, //!< HSIOM Pin input reduction mux - tr_group[2].input[32]
    CYHAL_TRIGGER_TR_GROUP2_INPUT33 = 199, //!< DMA request reduction mux - tr_group[2].input[33]
    CYHAL_TRIGGER_TR_GROUP2_INPUT34 = 200, //!< DMA request reduction mux - tr_group[2].input[34]
    CYHAL_TRIGGER_TR_GROUP2_INPUT35 = 201, //!< Trigger input reduction mux - tr_group[2].input[35]
    CYHAL_TRIGGER_TR_GROUP2_INPUT36 = 202, //!< Trigger input reduction mux - tr_group[2].input[36]
    CYHAL_TRIGGER_TR_GROUP2_INPUT37 = 203, //!< Trigger input reduction mux - tr_group[2].input[37]
    CYHAL_TRIGGER_TR_GROUP2_INPUT38 = 204, //!< Trigger input reduction mux - tr_group[2].input[38]
    CYHAL_TRIGGER_TR_GROUP2_INPUT39 = 205, //!< Trigger input reduction mux - tr_group[2].input[39]
    CYHAL_TRIGGER_TR_GROUP2_INPUT40 = 206, //!< Trigger input reduction mux - tr_group[2].input[40]
    CYHAL_TRIGGER_TR_GROUP2_INPUT41 = 207, //!< Trigger input reduction mux - tr_group[2].input[41]
    CYHAL_TRIGGER_TR_GROUP2_INPUT42 = 208, //!< Trigger input reduction mux - tr_group[2].input[42]
    CYHAL_TRIGGER_TR_GROUP3_INPUT1 = 209, //!< Datawire output trigger reduction mux - tr_group[3].input[1]
    CYHAL_TRIGGER_TR_GROUP3_INPUT2 = 210, //!< Datawire output trigger reduction mux - tr_group[3].input[2]
    CYHAL_TRIGGER_TR_GROUP3_INPUT3 = 211, //!< Datawire output trigger reduction mux - tr_group[3].input[3]
    CYHAL_TRIGGER_TR_GROUP3_INPUT4 = 212, //!< Datawire output trigger reduction mux - tr_group[3].input[4]
    CYHAL_TRIGGER_TR_GROUP3_INPUT5 = 213, //!< Datawire output trigger reduction mux - tr_group[3].input[5]
    CYHAL_TRIGGER_TR_GROUP3_INPUT6 = 214, //!< Datawire output trigger reduction mux - tr_group[3].input[6]
    CYHAL_TRIGGER_TR_GROUP3_INPUT7 = 215, //!< Datawire output trigger reduction mux - tr_group[3].input[7]
    CYHAL_TRIGGER_TR_GROUP3_INPUT8 = 216, //!< Datawire output trigger reduction mux - tr_group[3].input[8]
    CYHAL_TRIGGER_TR_GROUP3_INPUT9 = 217, //!< TCPWM trigger output reduction mux - tr_group[3].input[9]
    CYHAL_TRIGGER_TR_GROUP3_INPUT10 = 218, //!< TCPWM trigger output reduction mux - tr_group[3].input[10]
    CYHAL_TRIGGER_TR_GROUP3_INPUT11 = 219, //!< TCPWM trigger output reduction mux - tr_group[3].input[11]
    CYHAL_TRIGGER_TR_GROUP3_INPUT12 = 220, //!< TCPWM trigger output reduction mux - tr_group[3].input[12]
    CYHAL_TRIGGER_TR_GROUP3_INPUT13 = 221, //!< TCPWM trigger output reduction mux - tr_group[3].input[13]
    CYHAL_TRIGGER_TR_GROUP3_INPUT14 = 222, //!< TCPWM trigger output reduction mux - tr_group[3].input[14]
    CYHAL_TRIGGER_TR_GROUP3_INPUT15 = 223, //!< TCPWM trigger output reduction mux - tr_group[3].input[15]
    CYHAL_TRIGGER_TR_GROUP3_INPUT16 = 224, //!< TCPWM trigger output reduction mux - tr_group[3].input[16]
    CYHAL_TRIGGER_TR_GROUP3_INPUT17 = 225, //!< TCPWM trigger output reduction mux - tr_group[3].input[17]
    CYHAL_TRIGGER_TR_GROUP3_INPUT18 = 226, //!< TCPWM trigger output reduction mux - tr_group[3].input[18]
    CYHAL_TRIGGER_TR_GROUP3_INPUT19 = 227, //!< TCPWM trigger output reduction mux - tr_group[3].input[19]
    CYHAL_TRIGGER_TR_GROUP3_INPUT20 = 228, //!< TCPWM trigger output reduction mux - tr_group[3].input[20]
    CYHAL_TRIGGER_TR_GROUP3_INPUT21 = 229, //!< TCPWM trigger output reduction mux - tr_group[3].input[21]
    CYHAL_TRIGGER_TR_GROUP3_INPUT22 = 230, //!< TCPWM trigger output reduction mux - tr_group[3].input[22]
    CYHAL_TRIGGER_TR_GROUP3_INPUT23 = 231, //!< TCPWM trigger output reduction mux - tr_group[3].input[23]
    CYHAL_TRIGGER_TR_GROUP3_INPUT24 = 232, //!< TCPWM trigger output reduction mux - tr_group[3].input[24]
    CYHAL_TRIGGER_TR_GROUP3_INPUT25 = 233, //!< HSIOM Pin input reduction mux - tr_group[3].input[25]
    CYHAL_TRIGGER_TR_GROUP3_INPUT26 = 234, //!< HSIOM Pin input reduction mux - tr_group[3].input[26]
    CYHAL_TRIGGER_TR_GROUP3_INPUT27 = 235, //!< HSIOM Pin input reduction mux - tr_group[3].input[27]
    CYHAL_TRIGGER_TR_GROUP3_INPUT28 = 236, //!< HSIOM Pin input reduction mux - tr_group[3].input[28]
    CYHAL_TRIGGER_TR_GROUP3_INPUT29 = 237, //!< HSIOM Pin input reduction mux - tr_group[3].input[29]
    CYHAL_TRIGGER_TR_GROUP3_INPUT30 = 238, //!< HSIOM Pin input reduction mux - tr_group[3].input[30]
    CYHAL_TRIGGER_TR_GROUP3_INPUT31 = 239, //!< HSIOM Pin input reduction mux - tr_group[3].input[31]
    CYHAL_TRIGGER_TR_GROUP3_INPUT32 = 240, //!< HSIOM Pin input reduction mux - tr_group[3].input[32]
    CYHAL_TRIGGER_TR_GROUP3_INPUT33 = 241, //!< DMA request reduction mux - tr_group[3].input[33]
    CYHAL_TRIGGER_TR_GROUP3_INPUT34 = 242, //!< DMA request reduction mux - tr_group[3].input[34]
    CYHAL_TRIGGER_TR_GROUP3_INPUT35 = 243, //!< Trigger input reduction mux - tr_group[3].input[35]
    CYHAL_TRIGGER_TR_GROUP3_INPUT36 = 244, //!< Trigger input reduction mux - tr_group[3].input[36]
    CYHAL_TRIGGER_TR_GROUP3_INPUT37 = 245, //!< Trigger input reduction mux - tr_group[3].input[37]
    CYHAL_TRIGGER_TR_GROUP3_INPUT38 = 246, //!< Trigger input reduction mux - tr_group[3].input[38]
    CYHAL_TRIGGER_TR_GROUP3_INPUT39 = 247, //!< Trigger input reduction mux - tr_group[3].input[39]
    CYHAL_TRIGGER_TR_GROUP3_INPUT40 = 248, //!< Trigger input reduction mux - tr_group[3].input[40]
    CYHAL_TRIGGER_TR_GROUP3_INPUT41 = 249, //!< Trigger input reduction mux - tr_group[3].input[41]
    CYHAL_TRIGGER_TR_GROUP3_INPUT42 = 250, //!< Trigger input reduction mux - tr_group[3].input[42]
    CYHAL_TRIGGER_TR_GROUP4_INPUT1 = 251, //!< Datawire output trigger reduction mux - tr_group[4].input[1]
    CYHAL_TRIGGER_TR_GROUP4_INPUT2 = 252, //!< Datawire output trigger reduction mux - tr_group[4].input[2]
    CYHAL_TRIGGER_TR_GROUP4_INPUT3 = 253, //!< Datawire output trigger reduction mux - tr_group[4].input[3]
    CYHAL_TRIGGER_TR_GROUP4_INPUT4 = 254, //!< Datawire output trigger reduction mux - tr_group[4].input[4]
    CYHAL_TRIGGER_TR_GROUP4_INPUT5 = 255, //!< Datawire output trigger reduction mux - tr_group[4].input[5]
    CYHAL_TRIGGER_TR_GROUP4_INPUT6 = 256, //!< Datawire output trigger reduction mux - tr_group[4].input[6]
    CYHAL_TRIGGER_TR_GROUP4_INPUT7 = 257, //!< Datawire output trigger reduction mux - tr_group[4].input[7]
    CYHAL_TRIGGER_TR_GROUP4_INPUT8 = 258, //!< Datawire output trigger reduction mux - tr_group[4].input[8]
    CYHAL_TRIGGER_TR_GROUP4_INPUT9 = 259, //!< TCPWM trigger output reduction mux - tr_group[4].input[9]
    CYHAL_TRIGGER_TR_GROUP4_INPUT10 = 260, //!< TCPWM trigger output reduction mux - tr_group[4].input[10]
    CYHAL_TRIGGER_TR_GROUP4_INPUT11 = 261, //!< TCPWM trigger output reduction mux - tr_group[4].input[11]
    CYHAL_TRIGGER_TR_GROUP4_INPUT12 = 262, //!< TCPWM trigger output reduction mux - tr_group[4].input[12]
    CYHAL_TRIGGER_TR_GROUP4_INPUT13 = 263, //!< TCPWM trigger output reduction mux - tr_group[4].input[13]
    CYHAL_TRIGGER_TR_GROUP4_INPUT14 = 264, //!< TCPWM trigger output reduction mux - tr_group[4].input[14]
    CYHAL_TRIGGER_TR_GROUP4_INPUT15 = 265, //!< TCPWM trigger output reduction mux - tr_group[4].input[15]
    CYHAL_TRIGGER_TR_GROUP4_INPUT16 = 266, //!< TCPWM trigger output reduction mux - tr_group[4].input[16]
    CYHAL_TRIGGER_TR_GROUP4_INPUT17 = 267, //!< TCPWM trigger output reduction mux - tr_group[4].input[17]
    CYHAL_TRIGGER_TR_GROUP4_INPUT18 = 268, //!< TCPWM trigger output reduction mux - tr_group[4].input[18]
    CYHAL_TRIGGER_TR_GROUP4_INPUT19 = 269, //!< TCPWM trigger output reduction mux - tr_group[4].input[19]
    CYHAL_TRIGGER_TR_GROUP4_INPUT20 = 270, //!< TCPWM trigger output reduction mux - tr_group[4].input[20]
    CYHAL_TRIGGER_TR_GROUP4_INPUT21 = 271, //!< TCPWM trigger output reduction mux - tr_group[4].input[21]
    CYHAL_TRIGGER_TR_GROUP4_INPUT22 = 272, //!< TCPWM trigger output reduction mux - tr_group[4].input[22]
    CYHAL_TRIGGER_TR_GROUP4_INPUT23 = 273, //!< TCPWM trigger output reduction mux - tr_group[4].input[23]
    CYHAL_TRIGGER_TR_GROUP4_INPUT24 = 274, //!< TCPWM trigger output reduction mux - tr_group[4].input[24]
    CYHAL_TRIGGER_TR_GROUP4_INPUT25 = 275, //!< HSIOM Pin input reduction mux - tr_group[4].input[25]
    CYHAL_TRIGGER_TR_GROUP4_INPUT26 = 276, //!< HSIOM Pin input reduction mux - tr_group[4].input[26]
    CYHAL_TRIGGER_TR_GROUP4_INPUT27 = 277, //!< HSIOM Pin input reduction mux - tr_group[4].input[27]
    CYHAL_TRIGGER_TR_GROUP4_INPUT28 = 278, //!< HSIOM Pin input reduction mux - tr_group[4].input[28]
    CYHAL_TRIGGER_TR_GROUP4_INPUT29 = 279, //!< HSIOM Pin input reduction mux - tr_group[4].input[29]
    CYHAL_TRIGGER_TR_GROUP4_INPUT30 = 280, //!< HSIOM Pin input reduction mux - tr_group[4].input[30]
    CYHAL_TRIGGER_TR_GROUP4_INPUT31 = 281, //!< HSIOM Pin input reduction mux - tr_group[4].input[31]
    CYHAL_TRIGGER_TR_GROUP4_INPUT32 = 282, //!< HSIOM Pin input reduction mux - tr_group[4].input[32]
    CYHAL_TRIGGER_TR_GROUP4_INPUT33 = 283, //!< DMA request reduction mux - tr_group[4].input[33]
    CYHAL_TRIGGER_TR_GROUP4_INPUT34 = 284, //!< DMA request reduction mux - tr_group[4].input[34]
    CYHAL_TRIGGER_TR_GROUP4_INPUT35 = 285, //!< Trigger input reduction mux - tr_group[4].input[35]
    CYHAL_TRIGGER_TR_GROUP4_INPUT36 = 286, //!< Trigger input reduction mux - tr_group[4].input[36]
    CYHAL_TRIGGER_TR_GROUP4_INPUT37 = 287, //!< Trigger input reduction mux - tr_group[4].input[37]
    CYHAL_TRIGGER_TR_GROUP4_INPUT38 = 288, //!< Trigger input reduction mux - tr_group[4].input[38]
    CYHAL_TRIGGER_TR_GROUP4_INPUT39 = 289, //!< Trigger input reduction mux - tr_group[4].input[39]
    CYHAL_TRIGGER_TR_GROUP4_INPUT40 = 290, //!< Trigger input reduction mux - tr_group[4].input[40]
    CYHAL_TRIGGER_TR_GROUP4_INPUT41 = 291, //!< Trigger input reduction mux - tr_group[4].input[41]
    CYHAL_TRIGGER_TR_GROUP4_INPUT42 = 292, //!< Trigger input reduction mux - tr_group[4].input[42]
    CYHAL_TRIGGER_TR_GROUP5_INPUT1 = 293, //!< Datawire output trigger reduction mux - tr_group[5].input[1]
    CYHAL_TRIGGER_TR_GROUP5_INPUT2 = 294, //!< Datawire output trigger reduction mux - tr_group[5].input[2]
    CYHAL_TRIGGER_TR_GROUP5_INPUT3 = 295, //!< Datawire output trigger reduction mux - tr_group[5].input[3]
    CYHAL_TRIGGER_TR_GROUP5_INPUT4 = 296, //!< Datawire output trigger reduction mux - tr_group[5].input[4]
    CYHAL_TRIGGER_TR_GROUP5_INPUT5 = 297, //!< Datawire output trigger reduction mux - tr_group[5].input[5]
    CYHAL_TRIGGER_TR_GROUP5_INPUT6 = 298, //!< Datawire output trigger reduction mux - tr_group[5].input[6]
    CYHAL_TRIGGER_TR_GROUP5_INPUT7 = 299, //!< Datawire output trigger reduction mux - tr_group[5].input[7]
    CYHAL_TRIGGER_TR_GROUP5_INPUT8 = 300, //!< Datawire output trigger reduction mux - tr_group[5].input[8]
    CYHAL_TRIGGER_TR_GROUP5_INPUT9 = 301, //!< TCPWM trigger output reduction mux - tr_group[5].input[9]
    CYHAL_TRIGGER_TR_GROUP5_INPUT10 = 302, //!< TCPWM trigger output reduction mux - tr_group[5].input[10]
    CYHAL_TRIGGER_TR_GROUP5_INPUT11 = 303, //!< TCPWM trigger output reduction mux - tr_group[5].input[11]
    CYHAL_TRIGGER_TR_GROUP5_INPUT12 = 304, //!< TCPWM trigger output reduction mux - tr_group[5].input[12]
    CYHAL_TRIGGER_TR_GROUP5_INPUT13 = 305, //!< TCPWM trigger output reduction mux - tr_group[5].input[13]
    CYHAL_TRIGGER_TR_GROUP5_INPUT14 = 306, //!< TCPWM trigger output reduction mux - tr_group[5].input[14]
    CYHAL_TRIGGER_TR_GROUP5_INPUT15 = 307, //!< TCPWM trigger output reduction mux - tr_group[5].input[15]
    CYHAL_TRIGGER_TR_GROUP5_INPUT16 = 308, //!< TCPWM trigger output reduction mux - tr_group[5].input[16]
    CYHAL_TRIGGER_TR_GROUP5_INPUT17 = 309, //!< TCPWM trigger output reduction mux - tr_group[5].input[17]
    CYHAL_TRIGGER_TR_GROUP5_INPUT18 = 310, //!< TCPWM trigger output reduction mux - tr_group[5].input[18]
    CYHAL_TRIGGER_TR_GROUP5_INPUT19 = 311, //!< TCPWM trigger output reduction mux - tr_group[5].input[19]
    CYHAL_TRIGGER_TR_GROUP5_INPUT20 = 312, //!< TCPWM trigger output reduction mux - tr_group[5].input[20]
    CYHAL_TRIGGER_TR_GROUP5_INPUT21 = 313, //!< TCPWM trigger output reduction mux - tr_group[5].input[21]
    CYHAL_TRIGGER_TR_GROUP5_INPUT22 = 314, //!< TCPWM trigger output reduction mux - tr_group[5].input[22]
    CYHAL_TRIGGER_TR_GROUP5_INPUT23 = 315, //!< TCPWM trigger output reduction mux - tr_group[5].input[23]
    CYHAL_TRIGGER_TR_GROUP5_INPUT24 = 316, //!< TCPWM trigger output reduction mux - tr_group[5].input[24]
    CYHAL_TRIGGER_TR_GROUP5_INPUT25 = 317, //!< HSIOM Pin input reduction mux - tr_group[5].input[25]
    CYHAL_TRIGGER_TR_GROUP5_INPUT26 = 318, //!< HSIOM Pin input reduction mux - tr_group[5].input[26]
    CYHAL_TRIGGER_TR_GROUP5_INPUT27 = 319, //!< HSIOM Pin input reduction mux - tr_group[5].input[27]
    CYHAL_TRIGGER_TR_GROUP5_INPUT28 = 320, //!< HSIOM Pin input reduction mux - tr_group[5].input[28]
    CYHAL_TRIGGER_TR_GROUP5_INPUT29 = 321, //!< HSIOM Pin input reduction mux - tr_group[5].input[29]
    CYHAL_TRIGGER_TR_GROUP5_INPUT30 = 322, //!< HSIOM Pin input reduction mux - tr_group[5].input[30]
    CYHAL_TRIGGER_TR_GROUP5_INPUT31 = 323, //!< HSIOM Pin input reduction mux - tr_group[5].input[31]
    CYHAL_TRIGGER_TR_GROUP5_INPUT32 = 324, //!< HSIOM Pin input reduction mux - tr_group[5].input[32]
    CYHAL_TRIGGER_TR_GROUP5_INPUT33 = 325, //!< DMA request reduction mux - tr_group[5].input[33]
    CYHAL_TRIGGER_TR_GROUP5_INPUT34 = 326, //!< DMA request reduction mux - tr_group[5].input[34]
    CYHAL_TRIGGER_TR_GROUP5_INPUT35 = 327, //!< Trigger input reduction mux - tr_group[5].input[35]
    CYHAL_TRIGGER_TR_GROUP5_INPUT36 = 328, //!< Trigger input reduction mux - tr_group[5].input[36]
    CYHAL_TRIGGER_TR_GROUP5_INPUT37 = 329, //!< Trigger input reduction mux - tr_group[5].input[37]
    CYHAL_TRIGGER_TR_GROUP5_INPUT38 = 330, //!< Trigger input reduction mux - tr_group[5].input[38]
    CYHAL_TRIGGER_TR_GROUP5_INPUT39 = 331, //!< Trigger input reduction mux - tr_group[5].input[39]
    CYHAL_TRIGGER_TR_GROUP5_INPUT40 = 332, //!< Trigger input reduction mux - tr_group[5].input[40]
    CYHAL_TRIGGER_TR_GROUP5_INPUT41 = 333, //!< Trigger input reduction mux - tr_group[5].input[41]
    CYHAL_TRIGGER_TR_GROUP5_INPUT42 = 334, //!< Trigger input reduction mux - tr_group[5].input[42]
    CYHAL_TRIGGER_TR_GROUP6_INPUT1 = 335, //!< Datawire output trigger reduction mux - tr_group[6].input[1]
    CYHAL_TRIGGER_TR_GROUP6_INPUT2 = 336, //!< Datawire output trigger reduction mux - tr_group[6].input[2]
    CYHAL_TRIGGER_TR_GROUP6_INPUT3 = 337, //!< Datawire output trigger reduction mux - tr_group[6].input[3]
    CYHAL_TRIGGER_TR_GROUP6_INPUT4 = 338, //!< Datawire output trigger reduction mux - tr_group[6].input[4]
    CYHAL_TRIGGER_TR_GROUP6_INPUT5 = 339, //!< Datawire output trigger reduction mux - tr_group[6].input[5]
    CYHAL_TRIGGER_TR_GROUP6_INPUT6 = 340, //!< Datawire output trigger reduction mux - tr_group[6].input[6]
    CYHAL_TRIGGER_TR_GROUP6_INPUT7 = 341, //!< Datawire output trigger reduction mux - tr_group[6].input[7]
    CYHAL_TRIGGER_TR_GROUP6_INPUT8 = 342, //!< Datawire output trigger reduction mux - tr_group[6].input[8]
    CYHAL_TRIGGER_TR_GROUP6_INPUT9 = 343, //!< TCPWM trigger output reduction mux - tr_group[6].input[9]
    CYHAL_TRIGGER_TR_GROUP6_INPUT10 = 344, //!< TCPWM trigger output reduction mux - tr_group[6].input[10]
    CYHAL_TRIGGER_TR_GROUP6_INPUT11 = 345, //!< TCPWM trigger output reduction mux - tr_group[6].input[11]
    CYHAL_TRIGGER_TR_GROUP6_INPUT12 = 346, //!< TCPWM trigger output reduction mux - tr_group[6].input[12]
    CYHAL_TRIGGER_TR_GROUP6_INPUT13 = 347, //!< TCPWM trigger output reduction mux - tr_group[6].input[13]
    CYHAL_TRIGGER_TR_GROUP6_INPUT14 = 348, //!< TCPWM trigger output reduction mux - tr_group[6].input[14]
    CYHAL_TRIGGER_TR_GROUP6_INPUT15 = 349, //!< TCPWM trigger output reduction mux - tr_group[6].input[15]
    CYHAL_TRIGGER_TR_GROUP6_INPUT16 = 350, //!< TCPWM trigger output reduction mux - tr_group[6].input[16]
    CYHAL_TRIGGER_TR_GROUP6_INPUT17 = 351, //!< TCPWM trigger output reduction mux - tr_group[6].input[17]
    CYHAL_TRIGGER_TR_GROUP6_INPUT18 = 352, //!< TCPWM trigger output reduction mux - tr_group[6].input[18]
    CYHAL_TRIGGER_TR_GROUP6_INPUT19 = 353, //!< TCPWM trigger output reduction mux - tr_group[6].input[19]
    CYHAL_TRIGGER_TR_GROUP6_INPUT20 = 354, //!< TCPWM trigger output reduction mux - tr_group[6].input[20]
    CYHAL_TRIGGER_TR_GROUP6_INPUT21 = 355, //!< TCPWM trigger output reduction mux - tr_group[6].input[21]
    CYHAL_TRIGGER_TR_GROUP6_INPUT22 = 356, //!< TCPWM trigger output reduction mux - tr_group[6].input[22]
    CYHAL_TRIGGER_TR_GROUP6_INPUT23 = 357, //!< TCPWM trigger output reduction mux - tr_group[6].input[23]
    CYHAL_TRIGGER_TR_GROUP6_INPUT24 = 358, //!< TCPWM trigger output reduction mux - tr_group[6].input[24]
    CYHAL_TRIGGER_TR_GROUP6_INPUT25 = 359, //!< HSIOM Pin input reduction mux - tr_group[6].input[25]
    CYHAL_TRIGGER_TR_GROUP6_INPUT26 = 360, //!< HSIOM Pin input reduction mux - tr_group[6].input[26]
    CYHAL_TRIGGER_TR_GROUP6_INPUT27 = 361, //!< HSIOM Pin input reduction mux - tr_group[6].input[27]
    CYHAL_TRIGGER_TR_GROUP6_INPUT28 = 362, //!< HSIOM Pin input reduction mux - tr_group[6].input[28]
    CYHAL_TRIGGER_TR_GROUP6_INPUT29 = 363, //!< HSIOM Pin input reduction mux - tr_group[6].input[29]
    CYHAL_TRIGGER_TR_GROUP6_INPUT30 = 364, //!< HSIOM Pin input reduction mux - tr_group[6].input[30]
    CYHAL_TRIGGER_TR_GROUP6_INPUT31 = 365, //!< HSIOM Pin input reduction mux - tr_group[6].input[31]
    CYHAL_TRIGGER_TR_GROUP6_INPUT32 = 366, //!< HSIOM Pin input reduction mux - tr_group[6].input[32]
    CYHAL_TRIGGER_TR_GROUP6_INPUT33 = 367, //!< DMA request reduction mux - tr_group[6].input[33]
    CYHAL_TRIGGER_TR_GROUP6_INPUT34 = 368, //!< DMA request reduction mux - tr_group[6].input[34]
    CYHAL_TRIGGER_TR_GROUP6_INPUT35 = 369, //!< Trigger input reduction mux - tr_group[6].input[35]
    CYHAL_TRIGGER_TR_GROUP6_INPUT36 = 370, //!< Trigger input reduction mux - tr_group[6].input[36]
    CYHAL_TRIGGER_TR_GROUP6_INPUT37 = 371, //!< Trigger input reduction mux - tr_group[6].input[37]
    CYHAL_TRIGGER_TR_GROUP6_INPUT38 = 372, //!< Trigger input reduction mux - tr_group[6].input[38]
    CYHAL_TRIGGER_TR_GROUP6_INPUT39 = 373, //!< Trigger input reduction mux - tr_group[6].input[39]
    CYHAL_TRIGGER_TR_GROUP6_INPUT40 = 374, //!< Trigger input reduction mux - tr_group[6].input[40]
    CYHAL_TRIGGER_TR_GROUP6_INPUT41 = 375, //!< Trigger input reduction mux - tr_group[6].input[41]
    CYHAL_TRIGGER_TR_GROUP6_INPUT42 = 376, //!< Trigger input reduction mux - tr_group[6].input[42]
    CYHAL_TRIGGER_TR_GROUP7_INPUT1 = 377, //!< Datawire output trigger reduction mux - tr_group[7].input[1]
    CYHAL_TRIGGER_TR_GROUP7_INPUT2 = 378, //!< Datawire output trigger reduction mux - tr_group[7].input[2]
    CYHAL_TRIGGER_TR_GROUP7_INPUT3 = 379, //!< Datawire output trigger reduction mux - tr_group[7].input[3]
    CYHAL_TRIGGER_TR_GROUP7_INPUT4 = 380, //!< Datawire output trigger reduction mux - tr_group[7].input[4]
    CYHAL_TRIGGER_TR_GROUP7_INPUT5 = 381, //!< Datawire output trigger reduction mux - tr_group[7].input[5]
    CYHAL_TRIGGER_TR_GROUP7_INPUT6 = 382, //!< Datawire output trigger reduction mux - tr_group[7].input[6]
    CYHAL_TRIGGER_TR_GROUP7_INPUT7 = 383, //!< Datawire output trigger reduction mux - tr_group[7].input[7]
    CYHAL_TRIGGER_TR_GROUP7_INPUT8 = 384, //!< Datawire output trigger reduction mux - tr_group[7].input[8]
    CYHAL_TRIGGER_TR_GROUP7_INPUT9 = 385, //!< TCPWM trigger output reduction mux - tr_group[7].input[9]
    CYHAL_TRIGGER_TR_GROUP7_INPUT10 = 386, //!< TCPWM trigger output reduction mux - tr_group[7].input[10]
    CYHAL_TRIGGER_TR_GROUP7_INPUT11 = 387, //!< TCPWM trigger output reduction mux - tr_group[7].input[11]
    CYHAL_TRIGGER_TR_GROUP7_INPUT12 = 388, //!< TCPWM trigger output reduction mux - tr_group[7].input[12]
    CYHAL_TRIGGER_TR_GROUP7_INPUT13 = 389, //!< TCPWM trigger output reduction mux - tr_group[7].input[13]
    CYHAL_TRIGGER_TR_GROUP7_INPUT14 = 390, //!< TCPWM trigger output reduction mux - tr_group[7].input[14]
    CYHAL_TRIGGER_TR_GROUP7_INPUT15 = 391, //!< TCPWM trigger output reduction mux - tr_group[7].input[15]
    CYHAL_TRIGGER_TR_GROUP7_INPUT16 = 392, //!< TCPWM trigger output reduction mux - tr_group[7].input[16]
    CYHAL_TRIGGER_TR_GROUP7_INPUT17 = 393, //!< TCPWM trigger output reduction mux - tr_group[7].input[17]
    CYHAL_TRIGGER_TR_GROUP7_INPUT18 = 394, //!< TCPWM trigger output reduction mux - tr_group[7].input[18]
    CYHAL_TRIGGER_TR_GROUP7_INPUT19 = 395, //!< TCPWM trigger output reduction mux - tr_group[7].input[19]
    CYHAL_TRIGGER_TR_GROUP7_INPUT20 = 396, //!< TCPWM trigger output reduction mux - tr_group[7].input[20]
    CYHAL_TRIGGER_TR_GROUP7_INPUT21 = 397, //!< TCPWM trigger output reduction mux - tr_group[7].input[21]
    CYHAL_TRIGGER_TR_GROUP7_INPUT22 = 398, //!< TCPWM trigger output reduction mux - tr_group[7].input[22]
    CYHAL_TRIGGER_TR_GROUP7_INPUT23 = 399, //!< TCPWM trigger output reduction mux - tr_group[7].input[23]
    CYHAL_TRIGGER_TR_GROUP7_INPUT24 = 400, //!< TCPWM trigger output reduction mux - tr_group[7].input[24]
    CYHAL_TRIGGER_TR_GROUP7_INPUT25 = 401, //!< HSIOM Pin input reduction mux - tr_group[7].input[25]
    CYHAL_TRIGGER_TR_GROUP7_INPUT26 = 402, //!< HSIOM Pin input reduction mux - tr_group[7].input[26]
    CYHAL_TRIGGER_TR_GROUP7_INPUT27 = 403, //!< HSIOM Pin input reduction mux - tr_group[7].input[27]
    CYHAL_TRIGGER_TR_GROUP7_INPUT28 = 404, //!< HSIOM Pin input reduction mux - tr_group[7].input[28]
    CYHAL_TRIGGER_TR_GROUP7_INPUT29 = 405, //!< HSIOM Pin input reduction mux - tr_group[7].input[29]
    CYHAL_TRIGGER_TR_GROUP7_INPUT30 = 406, //!< HSIOM Pin input reduction mux - tr_group[7].input[30]
    CYHAL_TRIGGER_TR_GROUP7_INPUT31 = 407, //!< HSIOM Pin input reduction mux - tr_group[7].input[31]
    CYHAL_TRIGGER_TR_GROUP7_INPUT32 = 408, //!< HSIOM Pin input reduction mux - tr_group[7].input[32]
    CYHAL_TRIGGER_TR_GROUP7_INPUT33 = 409, //!< DMA request reduction mux - tr_group[7].input[33]
    CYHAL_TRIGGER_TR_GROUP7_INPUT34 = 410, //!< DMA request reduction mux - tr_group[7].input[34]
    CYHAL_TRIGGER_TR_GROUP7_INPUT35 = 411, //!< Trigger input reduction mux - tr_group[7].input[35]
    CYHAL_TRIGGER_TR_GROUP7_INPUT36 = 412, //!< Trigger input reduction mux - tr_group[7].input[36]
    CYHAL_TRIGGER_TR_GROUP7_INPUT37 = 413, //!< Trigger input reduction mux - tr_group[7].input[37]
    CYHAL_TRIGGER_TR_GROUP7_INPUT38 = 414, //!< Trigger input reduction mux - tr_group[7].input[38]
    CYHAL_TRIGGER_TR_GROUP7_INPUT39 = 415, //!< Trigger input reduction mux - tr_group[7].input[39]
    CYHAL_TRIGGER_TR_GROUP7_INPUT40 = 416, //!< Trigger input reduction mux - tr_group[7].input[40]
    CYHAL_TRIGGER_TR_GROUP7_INPUT41 = 417, //!< Trigger input reduction mux - tr_group[7].input[41]
    CYHAL_TRIGGER_TR_GROUP7_INPUT42 = 418, //!< Trigger input reduction mux - tr_group[7].input[42]
    CYHAL_TRIGGER_TR_GROUP8_INPUT1 = 419, //!< Datawire output trigger reduction mux - tr_group[8].input[1]
    CYHAL_TRIGGER_TR_GROUP8_INPUT2 = 420, //!< Datawire output trigger reduction mux - tr_group[8].input[2]
    CYHAL_TRIGGER_TR_GROUP8_INPUT3 = 421, //!< Datawire output trigger reduction mux - tr_group[8].input[3]
    CYHAL_TRIGGER_TR_GROUP8_INPUT4 = 422, //!< Datawire output trigger reduction mux - tr_group[8].input[4]
    CYHAL_TRIGGER_TR_GROUP8_INPUT5 = 423, //!< Datawire output trigger reduction mux - tr_group[8].input[5]
    CYHAL_TRIGGER_TR_GROUP8_INPUT6 = 424, //!< Datawire output trigger reduction mux - tr_group[8].input[6]
    CYHAL_TRIGGER_TR_GROUP8_INPUT7 = 425, //!< Datawire output trigger reduction mux - tr_group[8].input[7]
    CYHAL_TRIGGER_TR_GROUP8_INPUT8 = 426, //!< Datawire output trigger reduction mux - tr_group[8].input[8]
    CYHAL_TRIGGER_TR_GROUP8_INPUT9 = 427, //!< TCPWM trigger output reduction mux - tr_group[8].input[9]
    CYHAL_TRIGGER_TR_GROUP8_INPUT10 = 428, //!< TCPWM trigger output reduction mux - tr_group[8].input[10]
    CYHAL_TRIGGER_TR_GROUP8_INPUT11 = 429, //!< TCPWM trigger output reduction mux - tr_group[8].input[11]
    CYHAL_TRIGGER_TR_GROUP8_INPUT12 = 430, //!< TCPWM trigger output reduction mux - tr_group[8].input[12]
    CYHAL_TRIGGER_TR_GROUP8_INPUT13 = 431, //!< TCPWM trigger output reduction mux - tr_group[8].input[13]
    CYHAL_TRIGGER_TR_GROUP8_INPUT14 = 432, //!< TCPWM trigger output reduction mux - tr_group[8].input[14]
    CYHAL_TRIGGER_TR_GROUP8_INPUT15 = 433, //!< TCPWM trigger output reduction mux - tr_group[8].input[15]
    CYHAL_TRIGGER_TR_GROUP8_INPUT16 = 434, //!< TCPWM trigger output reduction mux - tr_group[8].input[16]
    CYHAL_TRIGGER_TR_GROUP8_INPUT17 = 435, //!< TCPWM trigger output reduction mux - tr_group[8].input[17]
    CYHAL_TRIGGER_TR_GROUP8_INPUT18 = 436, //!< TCPWM trigger output reduction mux - tr_group[8].input[18]
    CYHAL_TRIGGER_TR_GROUP8_INPUT19 = 437, //!< TCPWM trigger output reduction mux - tr_group[8].input[19]
    CYHAL_TRIGGER_TR_GROUP8_INPUT20 = 438, //!< TCPWM trigger output reduction mux - tr_group[8].input[20]
    CYHAL_TRIGGER_TR_GROUP8_INPUT21 = 439, //!< TCPWM trigger output reduction mux - tr_group[8].input[21]
    CYHAL_TRIGGER_TR_GROUP8_INPUT22 = 440, //!< TCPWM trigger output reduction mux - tr_group[8].input[22]
    CYHAL_TRIGGER_TR_GROUP8_INPUT23 = 441, //!< TCPWM trigger output reduction mux - tr_group[8].input[23]
    CYHAL_TRIGGER_TR_GROUP8_INPUT24 = 442, //!< TCPWM trigger output reduction mux - tr_group[8].input[24]
    CYHAL_TRIGGER_TR_GROUP8_INPUT25 = 443, //!< HSIOM Pin input reduction mux - tr_group[8].input[25]
    CYHAL_TRIGGER_TR_GROUP8_INPUT26 = 444, //!< HSIOM Pin input reduction mux - tr_group[8].input[26]
    CYHAL_TRIGGER_TR_GROUP8_INPUT27 = 445, //!< HSIOM Pin input reduction mux - tr_group[8].input[27]
    CYHAL_TRIGGER_TR_GROUP8_INPUT28 = 446, //!< HSIOM Pin input reduction mux - tr_group[8].input[28]
    CYHAL_TRIGGER_TR_GROUP8_INPUT29 = 447, //!< HSIOM Pin input reduction mux - tr_group[8].input[29]
    CYHAL_TRIGGER_TR_GROUP8_INPUT30 = 448, //!< HSIOM Pin input reduction mux - tr_group[8].input[30]
    CYHAL_TRIGGER_TR_GROUP8_INPUT31 = 449, //!< HSIOM Pin input reduction mux - tr_group[8].input[31]
    CYHAL_TRIGGER_TR_GROUP8_INPUT32 = 450, //!< HSIOM Pin input reduction mux - tr_group[8].input[32]
    CYHAL_TRIGGER_TR_GROUP8_INPUT33 = 451, //!< DMA request reduction mux - tr_group[8].input[33]
    CYHAL_TRIGGER_TR_GROUP8_INPUT34 = 452, //!< DMA request reduction mux - tr_group[8].input[34]
    CYHAL_TRIGGER_TR_GROUP8_INPUT35 = 453, //!< Trigger input reduction mux - tr_group[8].input[35]
    CYHAL_TRIGGER_TR_GROUP8_INPUT36 = 454, //!< Trigger input reduction mux - tr_group[8].input[36]
    CYHAL_TRIGGER_TR_GROUP8_INPUT37 = 455, //!< Trigger input reduction mux - tr_group[8].input[37]
    CYHAL_TRIGGER_TR_GROUP8_INPUT38 = 456, //!< Trigger input reduction mux - tr_group[8].input[38]
    CYHAL_TRIGGER_TR_GROUP8_INPUT39 = 457, //!< Trigger input reduction mux - tr_group[8].input[39]
    CYHAL_TRIGGER_TR_GROUP8_INPUT40 = 458, //!< Trigger input reduction mux - tr_group[8].input[40]
    CYHAL_TRIGGER_TR_GROUP8_INPUT41 = 459, //!< Trigger input reduction mux - tr_group[8].input[41]
    CYHAL_TRIGGER_TR_GROUP8_INPUT42 = 460, //!< Trigger input reduction mux - tr_group[8].input[42]
    CYHAL_TRIGGER_UDB_TR_DW_ACK0 = 461, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[0]
    CYHAL_TRIGGER_UDB_TR_DW_ACK1 = 462, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[1]
    CYHAL_TRIGGER_UDB_TR_DW_ACK2 = 463, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[2]
    CYHAL_TRIGGER_UDB_TR_DW_ACK3 = 464, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[3]
    CYHAL_TRIGGER_UDB_TR_DW_ACK4 = 465, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[4]
    CYHAL_TRIGGER_UDB_TR_DW_ACK5 = 466, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[5]
    CYHAL_TRIGGER_UDB_TR_DW_ACK6 = 467, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[6]
    CYHAL_TRIGGER_UDB_TR_DW_ACK7 = 468, //!< Datawire output trigger reduction mux - udb.tr_dw_ack[7]
    CYHAL_TRIGGER_UDB_TR_IN0 = 469, //!< UDB trigger multiplexer - udb.tr_in[0]
    CYHAL_TRIGGER_UDB_TR_IN1 = 470, //!< UDB trigger multiplexer - udb.tr_in[1]
    CYHAL_TRIGGER_USB_DMA_BURSTEND0 = 471, //!< USB DMA burstend multiplexer - usb.dma_burstend[0]
    CYHAL_TRIGGER_USB_DMA_BURSTEND1 = 472, //!< USB DMA burstend multiplexer - usb.dma_burstend[1]
    CYHAL_TRIGGER_USB_DMA_BURSTEND2 = 473, //!< USB DMA burstend multiplexer - usb.dma_burstend[2]
    CYHAL_TRIGGER_USB_DMA_BURSTEND3 = 474, //!< USB DMA burstend multiplexer - usb.dma_burstend[3]
    CYHAL_TRIGGER_USB_DMA_BURSTEND4 = 475, //!< USB DMA burstend multiplexer - usb.dma_burstend[4]
    CYHAL_TRIGGER_USB_DMA_BURSTEND5 = 476, //!< USB DMA burstend multiplexer - usb.dma_burstend[5]
    CYHAL_TRIGGER_USB_DMA_BURSTEND6 = 477, //!< USB DMA burstend multiplexer - usb.dma_burstend[6]
    CYHAL_TRIGGER_USB_DMA_BURSTEND7 = 478, //!< USB DMA burstend multiplexer - usb.dma_burstend[7]
} cyhal_trigger_dest_psoc6_01_t;

/** Typedef from device family specific trigger dest to generic trigger dest */
typedef cyhal_trigger_dest_psoc6_01_t cyhal_dest_t;

/** \cond INTERNAL */
/** Table of number of inputs to each mux. */
extern const uint16_t cyhal_sources_per_mux[15];

/** Table indicating whether mux is 1to1. */
extern const bool cyhal_is_mux_1to1[15];

/** Table pointing to each mux source table. The index of each source in the table is its mux input index. */
extern const _cyhal_trigger_source_psoc6_01_t* cyhal_mux_to_sources [15];

/** Maps each cyhal_destination_t to a mux index.
 * If bit 8 of the mux index is set, this denotes that the trigger is a
 * one to one trigger.
 */
extern const uint8_t cyhal_dest_to_mux[479];

/* Maps each cyhal_destination_t to a specific output in its mux */
extern const uint8_t cyhal_mux_dest_index[479];
/** \endcond */

#if defined(__cplusplus)
}
#endif /* __cplusplus */
/** \} group_hal_impl_triggers_psoc6_01 */
#endif /* _CYHAL_TRIGGERS_PSOC6_01_H_ */


/* [] END OF FILE */
