/***************************************************************************//**
* \file cyhal_triggers_psoc6_01.c
*
* \brief
* PSoC6_01 family HAL triggers header
*
********************************************************************************
* \copyright
* (c) (2016-2023), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cy_device_headers.h"
#include "cyhal_hw_types.h"

#ifdef CY_DEVICE_PSOC6ABLE2
#include "triggers/cyhal_triggers_psoc6_01.h"

const uint16_t cyhal_sources_per_mux[15] =
{
    51, 51, 43, 43, 43, 43, 43, 43, 43, 33, 33, 97, 29, 34, 38,
};

const bool cyhal_is_mux_1to1[15] =
{
    false, false, false, false, false, false, false, false, false, false, false, false, false, false, false,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux0_sources[51] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT7,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux1_sources[51] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT7,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux2_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux3_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux4_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux5_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux6_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux7_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux8_sources[43] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT15,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT5,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT6,
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT7,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT16,
    _CYHAL_TRIGGER_TR_GROUP13_OUTPUT17,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT8,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT9,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT10,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT11,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT12,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT13,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT14,
    _CYHAL_TRIGGER_TR_GROUP14_OUTPUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux9_sources[33] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux10_sources[33] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux11_sources[97] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM0_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM0_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_OVERFLOW23,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH0,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH1,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH2,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH3,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH4,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH5,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH6,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH7,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH8,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH9,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH10,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH11,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH12,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH13,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH14,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH15,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH16,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH17,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH18,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH19,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH20,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH21,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH22,
    _CYHAL_TRIGGER_TCPWM1_TR_COMPARE_MATCH23,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW0,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW1,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW2,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW3,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW4,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW5,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW6,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW7,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW8,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW9,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW10,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW11,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW12,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW13,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW14,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW15,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW16,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW17,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW18,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW19,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW20,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW21,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW22,
    _CYHAL_TRIGGER_TCPWM1_TR_UNDERFLOW23,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux12_sources[29] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux13_sources[34] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS_TR_PDM_RX_REQ,
    _CYHAL_TRIGGER_AUDIOSS_TR_I2S_TX_REQ,
    _CYHAL_TRIGGER_AUDIOSS_TR_I2S_RX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
};

const _cyhal_trigger_source_psoc6_01_t cyhal_mux14_sources[38] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_UDB_TR_UDB0,
    _CYHAL_TRIGGER_UDB_TR_UDB1,
    _CYHAL_TRIGGER_UDB_TR_UDB2,
    _CYHAL_TRIGGER_UDB_TR_UDB3,
    _CYHAL_TRIGGER_UDB_TR_UDB4,
    _CYHAL_TRIGGER_UDB_TR_UDB5,
    _CYHAL_TRIGGER_UDB_TR_UDB6,
    _CYHAL_TRIGGER_UDB_TR_UDB7,
    _CYHAL_TRIGGER_UDB_TR_UDB8,
    _CYHAL_TRIGGER_UDB_TR_UDB9,
    _CYHAL_TRIGGER_UDB_TR_UDB10,
    _CYHAL_TRIGGER_UDB_TR_UDB11,
    _CYHAL_TRIGGER_UDB_TR_UDB12,
    _CYHAL_TRIGGER_UDB_TR_UDB13,
    _CYHAL_TRIGGER_UDB_TR_UDB14,
    _CYHAL_TRIGGER_UDB_TR_UDB15,
    _CYHAL_TRIGGER_UDB_DSI_OUT_TR0,
    _CYHAL_TRIGGER_UDB_DSI_OUT_TR1,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT,
    _CYHAL_TRIGGER_PASS_TR_CTDAC_EMPTY,
    _CYHAL_TRIGGER_PASS_DSI_CTB_CMP0,
    _CYHAL_TRIGGER_PASS_DSI_CTB_CMP1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
};

const _cyhal_trigger_source_psoc6_01_t* cyhal_mux_to_sources[15] =
{
    cyhal_mux0_sources,
    cyhal_mux1_sources,
    cyhal_mux2_sources,
    cyhal_mux3_sources,
    cyhal_mux4_sources,
    cyhal_mux5_sources,
    cyhal_mux6_sources,
    cyhal_mux7_sources,
    cyhal_mux8_sources,
    cyhal_mux9_sources,
    cyhal_mux10_sources,
    cyhal_mux11_sources,
    cyhal_mux12_sources,
    cyhal_mux13_sources,
    cyhal_mux14_sources,
};

const uint8_t cyhal_dest_to_mux[479] =
{
    5, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    5, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    6, /* CYHAL_TRIGGER_PASS_TR_SAR_IN */
    8, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    8, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    4, /* CYHAL_TRIGGER_PROFILE_TR_START */
    4, /* CYHAL_TRIGGER_PROFILE_TR_STOP */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN0 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN2 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN3 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN4 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN5 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN6 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN7 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN8 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN9 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN10 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN11 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN12 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN13 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN0 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN1 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN3 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN4 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN5 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN6 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN7 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN8 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN9 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN10 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN11 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN12 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN13 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP0_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP0_INPUT26 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT27 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT28 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT29 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT30 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT31 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT34 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT35 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT36 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT37 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT38 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT40 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT41 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT42 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT43 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT44 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT45 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT46 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT47 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT48 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT49 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT50 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP1_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP1_INPUT26 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT27 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT28 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT29 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT30 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT31 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT34 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT35 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT36 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT37 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT38 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT40 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT41 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT42 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT43 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT44 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT45 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT46 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT47 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT48 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT49 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT50 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP2_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP2_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT42 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP3_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP3_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT42 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP4_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP4_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT42 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP5_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP5_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT42 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP6_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP6_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT42 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP7_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP7_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT42 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT1 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT2 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT3 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT4 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT5 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT6 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT7 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT8 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT9 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT10 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT11 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT12 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT13 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT14 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT15 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT16 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT17 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT18 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT20 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT21 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT22 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT23 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT24 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT25 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT26 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT27 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT28 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT29 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT30 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT31 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT32 */
    13, /* CYHAL_TRIGGER_TR_GROUP8_INPUT33 */
    13, /* CYHAL_TRIGGER_TR_GROUP8_INPUT34 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT35 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT36 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT37 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT38 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT39 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT41 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT42 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK0 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK1 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK2 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK3 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK4 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK5 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK6 */
    10, /* CYHAL_TRIGGER_UDB_TR_DW_ACK7 */
    7, /* CYHAL_TRIGGER_UDB_TR_IN0 */
    7, /* CYHAL_TRIGGER_UDB_TR_IN1 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND0 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND1 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND2 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND3 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND4 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND5 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND6 */
    9, /* CYHAL_TRIGGER_USB_DMA_BURSTEND7 */
};

const uint8_t cyhal_mux_dest_index[479] =
{
    0, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    12, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    13, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    14, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    15, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    8, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    9, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    10, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    11, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    12, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    13, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    14, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    15, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    0, /* CYHAL_TRIGGER_PASS_TR_SAR_IN */
    0, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    1, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    0, /* CYHAL_TRIGGER_PROFILE_TR_START */
    1, /* CYHAL_TRIGGER_PROFILE_TR_STOP */
    0, /* CYHAL_TRIGGER_TCPWM0_TR_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM0_TR_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM0_TR_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM0_TR_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM0_TR_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM0_TR_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM0_TR_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM0_TR_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM0_TR_IN11 */
    12, /* CYHAL_TRIGGER_TCPWM0_TR_IN12 */
    13, /* CYHAL_TRIGGER_TCPWM0_TR_IN13 */
    0, /* CYHAL_TRIGGER_TCPWM1_TR_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM1_TR_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM1_TR_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM1_TR_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM1_TR_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM1_TR_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM1_TR_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM1_TR_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM1_TR_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM1_TR_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM1_TR_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM1_TR_IN11 */
    12, /* CYHAL_TRIGGER_TCPWM1_TR_IN12 */
    13, /* CYHAL_TRIGGER_TCPWM1_TR_IN13 */
    0, /* CYHAL_TRIGGER_TR_GROUP0_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP0_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP0_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP0_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP0_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP0_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP0_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP0_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP0_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP0_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP0_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP0_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP0_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP0_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP0_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP0_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP0_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP0_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP0_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP0_INPUT24 */
    8, /* CYHAL_TRIGGER_TR_GROUP0_INPUT25 */
    9, /* CYHAL_TRIGGER_TR_GROUP0_INPUT26 */
    0, /* CYHAL_TRIGGER_TR_GROUP0_INPUT27 */
    1, /* CYHAL_TRIGGER_TR_GROUP0_INPUT28 */
    2, /* CYHAL_TRIGGER_TR_GROUP0_INPUT29 */
    3, /* CYHAL_TRIGGER_TR_GROUP0_INPUT30 */
    4, /* CYHAL_TRIGGER_TR_GROUP0_INPUT31 */
    5, /* CYHAL_TRIGGER_TR_GROUP0_INPUT32 */
    6, /* CYHAL_TRIGGER_TR_GROUP0_INPUT33 */
    7, /* CYHAL_TRIGGER_TR_GROUP0_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP0_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP0_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP0_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP0_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP0_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP0_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP0_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP0_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP0_INPUT43 */
    1, /* CYHAL_TRIGGER_TR_GROUP0_INPUT44 */
    2, /* CYHAL_TRIGGER_TR_GROUP0_INPUT45 */
    3, /* CYHAL_TRIGGER_TR_GROUP0_INPUT46 */
    4, /* CYHAL_TRIGGER_TR_GROUP0_INPUT47 */
    5, /* CYHAL_TRIGGER_TR_GROUP0_INPUT48 */
    6, /* CYHAL_TRIGGER_TR_GROUP0_INPUT49 */
    7, /* CYHAL_TRIGGER_TR_GROUP0_INPUT50 */
    0, /* CYHAL_TRIGGER_TR_GROUP1_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP1_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP1_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP1_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP1_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP1_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP1_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP1_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP1_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP1_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP1_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP1_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP1_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP1_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP1_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP1_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP1_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP1_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP1_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP1_INPUT24 */
    8, /* CYHAL_TRIGGER_TR_GROUP1_INPUT25 */
    9, /* CYHAL_TRIGGER_TR_GROUP1_INPUT26 */
    0, /* CYHAL_TRIGGER_TR_GROUP1_INPUT27 */
    1, /* CYHAL_TRIGGER_TR_GROUP1_INPUT28 */
    2, /* CYHAL_TRIGGER_TR_GROUP1_INPUT29 */
    3, /* CYHAL_TRIGGER_TR_GROUP1_INPUT30 */
    4, /* CYHAL_TRIGGER_TR_GROUP1_INPUT31 */
    5, /* CYHAL_TRIGGER_TR_GROUP1_INPUT32 */
    6, /* CYHAL_TRIGGER_TR_GROUP1_INPUT33 */
    7, /* CYHAL_TRIGGER_TR_GROUP1_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP1_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP1_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP1_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP1_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP1_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP1_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP1_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP1_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP1_INPUT43 */
    1, /* CYHAL_TRIGGER_TR_GROUP1_INPUT44 */
    2, /* CYHAL_TRIGGER_TR_GROUP1_INPUT45 */
    3, /* CYHAL_TRIGGER_TR_GROUP1_INPUT46 */
    4, /* CYHAL_TRIGGER_TR_GROUP1_INPUT47 */
    5, /* CYHAL_TRIGGER_TR_GROUP1_INPUT48 */
    6, /* CYHAL_TRIGGER_TR_GROUP1_INPUT49 */
    7, /* CYHAL_TRIGGER_TR_GROUP1_INPUT50 */
    0, /* CYHAL_TRIGGER_TR_GROUP2_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP2_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP2_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP2_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP2_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP2_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP2_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP2_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP2_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP2_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP2_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP2_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP2_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP2_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP2_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP2_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP2_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP2_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP2_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP2_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP2_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP2_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP2_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP2_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP2_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP2_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP2_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP2_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP2_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP2_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP2_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP2_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP2_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP2_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP2_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP2_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP2_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP2_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP3_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP3_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP3_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP3_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP3_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP3_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP3_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP3_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP3_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP3_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP3_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP3_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP3_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP3_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP3_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP3_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP3_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP3_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP3_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP3_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP3_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP3_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP3_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP3_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP3_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP3_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP3_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP3_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP3_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP3_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP3_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP3_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP3_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP3_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP3_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP3_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP3_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP3_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP4_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP4_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP4_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP4_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP4_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP4_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP4_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP4_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP4_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP4_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP4_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP4_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP4_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP4_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP4_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP4_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP4_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP4_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP4_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP4_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP4_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP4_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP4_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP4_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP4_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP4_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP4_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP4_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP4_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP4_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP4_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP4_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP4_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP4_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP4_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP4_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP4_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP4_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP5_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP5_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP5_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP5_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP5_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP5_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP5_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP5_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP5_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP5_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP5_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP5_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP5_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP5_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP5_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP5_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP5_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP5_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP5_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP5_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP5_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP5_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP5_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP5_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP5_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP5_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP5_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP5_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP5_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP5_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP5_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP5_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP5_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP5_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP5_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP5_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP5_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP5_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP6_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP6_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP6_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP6_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP6_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP6_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP6_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP6_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP6_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP6_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP6_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP6_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP6_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP6_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP6_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP6_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP6_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP6_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP6_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP6_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP6_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP6_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP6_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP6_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP6_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP6_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP6_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP6_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP6_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP6_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP6_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP6_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP6_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP6_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP6_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP6_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP6_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP6_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP7_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP7_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP7_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP7_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP7_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP7_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP7_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP7_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP7_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP7_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP7_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP7_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP7_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP7_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP7_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP7_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP7_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP7_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP7_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP7_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP7_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP7_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP7_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP7_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP7_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP7_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP7_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP7_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP7_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP7_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP7_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP7_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP7_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP7_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP7_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP7_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP7_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP7_INPUT42 */
    0, /* CYHAL_TRIGGER_TR_GROUP8_INPUT1 */
    1, /* CYHAL_TRIGGER_TR_GROUP8_INPUT2 */
    2, /* CYHAL_TRIGGER_TR_GROUP8_INPUT3 */
    3, /* CYHAL_TRIGGER_TR_GROUP8_INPUT4 */
    4, /* CYHAL_TRIGGER_TR_GROUP8_INPUT5 */
    5, /* CYHAL_TRIGGER_TR_GROUP8_INPUT6 */
    6, /* CYHAL_TRIGGER_TR_GROUP8_INPUT7 */
    7, /* CYHAL_TRIGGER_TR_GROUP8_INPUT8 */
    0, /* CYHAL_TRIGGER_TR_GROUP8_INPUT9 */
    1, /* CYHAL_TRIGGER_TR_GROUP8_INPUT10 */
    2, /* CYHAL_TRIGGER_TR_GROUP8_INPUT11 */
    3, /* CYHAL_TRIGGER_TR_GROUP8_INPUT12 */
    4, /* CYHAL_TRIGGER_TR_GROUP8_INPUT13 */
    5, /* CYHAL_TRIGGER_TR_GROUP8_INPUT14 */
    6, /* CYHAL_TRIGGER_TR_GROUP8_INPUT15 */
    7, /* CYHAL_TRIGGER_TR_GROUP8_INPUT16 */
    8, /* CYHAL_TRIGGER_TR_GROUP8_INPUT17 */
    9, /* CYHAL_TRIGGER_TR_GROUP8_INPUT18 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT19 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT20 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT21 */
    13, /* CYHAL_TRIGGER_TR_GROUP8_INPUT22 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT23 */
    15, /* CYHAL_TRIGGER_TR_GROUP8_INPUT24 */
    0, /* CYHAL_TRIGGER_TR_GROUP8_INPUT25 */
    1, /* CYHAL_TRIGGER_TR_GROUP8_INPUT26 */
    2, /* CYHAL_TRIGGER_TR_GROUP8_INPUT27 */
    3, /* CYHAL_TRIGGER_TR_GROUP8_INPUT28 */
    4, /* CYHAL_TRIGGER_TR_GROUP8_INPUT29 */
    5, /* CYHAL_TRIGGER_TR_GROUP8_INPUT30 */
    6, /* CYHAL_TRIGGER_TR_GROUP8_INPUT31 */
    7, /* CYHAL_TRIGGER_TR_GROUP8_INPUT32 */
    16, /* CYHAL_TRIGGER_TR_GROUP8_INPUT33 */
    17, /* CYHAL_TRIGGER_TR_GROUP8_INPUT34 */
    8, /* CYHAL_TRIGGER_TR_GROUP8_INPUT35 */
    9, /* CYHAL_TRIGGER_TR_GROUP8_INPUT36 */
    10, /* CYHAL_TRIGGER_TR_GROUP8_INPUT37 */
    11, /* CYHAL_TRIGGER_TR_GROUP8_INPUT38 */
    12, /* CYHAL_TRIGGER_TR_GROUP8_INPUT39 */
    13, /* CYHAL_TRIGGER_TR_GROUP8_INPUT40 */
    14, /* CYHAL_TRIGGER_TR_GROUP8_INPUT41 */
    15, /* CYHAL_TRIGGER_TR_GROUP8_INPUT42 */
    0, /* CYHAL_TRIGGER_UDB_TR_DW_ACK0 */
    1, /* CYHAL_TRIGGER_UDB_TR_DW_ACK1 */
    2, /* CYHAL_TRIGGER_UDB_TR_DW_ACK2 */
    3, /* CYHAL_TRIGGER_UDB_TR_DW_ACK3 */
    4, /* CYHAL_TRIGGER_UDB_TR_DW_ACK4 */
    5, /* CYHAL_TRIGGER_UDB_TR_DW_ACK5 */
    6, /* CYHAL_TRIGGER_UDB_TR_DW_ACK6 */
    7, /* CYHAL_TRIGGER_UDB_TR_DW_ACK7 */
    0, /* CYHAL_TRIGGER_UDB_TR_IN0 */
    1, /* CYHAL_TRIGGER_UDB_TR_IN1 */
    0, /* CYHAL_TRIGGER_USB_DMA_BURSTEND0 */
    1, /* CYHAL_TRIGGER_USB_DMA_BURSTEND1 */
    2, /* CYHAL_TRIGGER_USB_DMA_BURSTEND2 */
    3, /* CYHAL_TRIGGER_USB_DMA_BURSTEND3 */
    4, /* CYHAL_TRIGGER_USB_DMA_BURSTEND4 */
    5, /* CYHAL_TRIGGER_USB_DMA_BURSTEND5 */
    6, /* CYHAL_TRIGGER_USB_DMA_BURSTEND6 */
    7, /* CYHAL_TRIGGER_USB_DMA_BURSTEND7 */
};

#endif /* CY_DEVICE_PSOC6ABLE2 */
