/***************************************************************************//**
* \file cyhal_triggers_psoc6_04.c
*
* \brief
* PSoC6_04 family HAL triggers header
*
********************************************************************************
* \copyright
* (c) (2016-2023), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cy_device_headers.h"
#include "cyhal_hw_types.h"

#ifdef CY_DEVICE_PSOC6A256K
#include "triggers/cyhal_triggers_psoc6_04.h"

const uint16_t cyhal_sources_per_mux[21] =
{
    87, 87, 139, 139, 229, 256, 27, 3, 139, 127, 2, 51, 12, 14, 1, 7, 3, 8, 8, 1, 1,
};

const bool cyhal_is_mux_1to1[21] =
{
    false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux0_sources[87] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux1_sources[87] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux2_sources[139] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT0,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_PASS_TR_CTDAC_EMPTY,
    _CYHAL_TRIGGER_PASS_DSI_CTB_CMP0,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux3_sources[139] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT0,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_PASS_TR_CTDAC_EMPTY,
    _CYHAL_TRIGGER_PASS_DSI_CTB_CMP1,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux4_sources[229] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_CSD_DSI_SAMPLE_OUT,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT31,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux5_sources[256] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED,
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CSD_DSI_SENSE_OUT,
    _CYHAL_TRIGGER_CSD_DSI_SAMPLE_OUT,
    _CYHAL_TRIGGER_CSD_TR_ADC_DONE,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0,
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT30,
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT31,
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux6_sources[27] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux7_sources[3] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0,
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux8_sources[139] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux9_sources[127] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux10_sources[2] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux11_sources[51] =
{
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT03,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT13,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1259,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1260,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1261,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1262,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0263,
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1263,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22,
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP0,
    _CYHAL_TRIGGER_LPCOMP_DSI_COMP1,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux12_sources[12] =
{
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux13_sources[14] =
{
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ,
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux14_sources[1] =
{
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT0,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux15_sources[7] =
{
    _CYHAL_TRIGGER_SMIF_TR_TX_REQ,
    _CYHAL_TRIGGER_SMIF_TR_RX_REQ,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
    _CYHAL_TRIGGER_CPUSS_ZERO,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux16_sources[3] =
{
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO00,
    _CYHAL_TRIGGER_CANFD0_TR_FIFO10,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux17_sources[8] =
{
    _CYHAL_TRIGGER_USB_DMA_REQ0,
    _CYHAL_TRIGGER_USB_DMA_REQ1,
    _CYHAL_TRIGGER_USB_DMA_REQ2,
    _CYHAL_TRIGGER_USB_DMA_REQ3,
    _CYHAL_TRIGGER_USB_DMA_REQ4,
    _CYHAL_TRIGGER_USB_DMA_REQ5,
    _CYHAL_TRIGGER_USB_DMA_REQ6,
    _CYHAL_TRIGGER_USB_DMA_REQ7,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux18_sources[8] =
{
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14,
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux19_sources[1] =
{
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29,
};

const _cyhal_trigger_source_psoc6_04_t cyhal_mux20_sources[1] =
{
    _CYHAL_TRIGGER_PASS_TR_SAR_OUT1,
};

const _cyhal_trigger_source_psoc6_04_t* cyhal_mux_to_sources[21] =
{
    cyhal_mux0_sources,
    cyhal_mux1_sources,
    cyhal_mux2_sources,
    cyhal_mux3_sources,
    cyhal_mux4_sources,
    cyhal_mux5_sources,
    cyhal_mux6_sources,
    cyhal_mux7_sources,
    cyhal_mux8_sources,
    cyhal_mux9_sources,
    cyhal_mux10_sources,
    cyhal_mux11_sources,
    cyhal_mux12_sources,
    cyhal_mux13_sources,
    cyhal_mux14_sources,
    cyhal_mux15_sources,
    cyhal_mux16_sources,
    cyhal_mux17_sources,
    cyhal_mux18_sources,
    cyhal_mux19_sources,
    cyhal_mux20_sources,
};

const uint8_t cyhal_dest_to_mux[112] =
{
    135, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK0 */
    10, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN0 */
    5, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    5, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 */
    6, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    133, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 */
    128, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 */
    130, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 */
    136, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN29 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 */
    129, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 */
    131, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN29 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN30 */
    132, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN31 */
    8, /* CYHAL_TRIGGER_CSD_DSI_START */
    11, /* CYHAL_TRIGGER_PASS_DSI_CTDAC_STROBE */
    9, /* CYHAL_TRIGGER_PASS_TR_SAR_IN0 */
    9, /* CYHAL_TRIGGER_PASS_TR_SAR_IN1 */
    7, /* CYHAL_TRIGGER_PERI_TR_DBG_FREEZE */
    4, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    4, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN0 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN2 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN3 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN4 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN5 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN6 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN7 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN8 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN9 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN10 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN11 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN12 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN13 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN14 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN15 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN16 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN17 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN18 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN19 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN20 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN21 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN22 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN23 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN24 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN25 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN26 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN27 */
    7, /* CYHAL_TRIGGER_TCPWM0_TR_DEBUG_FREEZE */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND0 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND1 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND2 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND3 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND4 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND5 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND6 */
    134, /* CYHAL_TRIGGER_USB_DMA_BURSTEND7 */
};

const uint8_t cyhal_mux_dest_index[112] =
{
    0, /* CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK0 */
    0, /* CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN0 */
    0, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 */
    1, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 */
    2, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 */
    3, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 */
    4, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 */
    5, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 */
    6, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 */
    7, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 */
    8, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 */
    9, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 */
    10, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 */
    11, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 */
    0, /* CYHAL_TRIGGER_CPUSS_DW0_TR_IN29 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 */
    7, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 */
    8, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 */
    9, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 */
    10, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 */
    11, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 */
    12, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 */
    13, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 */
    3, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 */
    4, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 */
    5, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 */
    6, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 */
    0, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN29 */
    1, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN30 */
    2, /* CYHAL_TRIGGER_CPUSS_DW1_TR_IN31 */
    0, /* CYHAL_TRIGGER_CSD_DSI_START */
    0, /* CYHAL_TRIGGER_PASS_DSI_CTDAC_STROBE */
    0, /* CYHAL_TRIGGER_PASS_TR_SAR_IN0 */
    1, /* CYHAL_TRIGGER_PASS_TR_SAR_IN1 */
    0, /* CYHAL_TRIGGER_PERI_TR_DBG_FREEZE */
    0, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 */
    1, /* CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 */
    0, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN0 */
    1, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN1 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN2 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN3 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN4 */
    5, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN5 */
    6, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN6 */
    7, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN7 */
    8, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN8 */
    9, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN9 */
    10, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN10 */
    11, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN11 */
    12, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN12 */
    13, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN13 */
    0, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN14 */
    1, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN15 */
    2, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN16 */
    3, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN17 */
    4, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN18 */
    5, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN19 */
    6, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN20 */
    7, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN21 */
    8, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN22 */
    9, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN23 */
    10, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN24 */
    11, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN25 */
    12, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN26 */
    13, /* CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN27 */
    1, /* CYHAL_TRIGGER_TCPWM0_TR_DEBUG_FREEZE */
    0, /* CYHAL_TRIGGER_USB_DMA_BURSTEND0 */
    1, /* CYHAL_TRIGGER_USB_DMA_BURSTEND1 */
    2, /* CYHAL_TRIGGER_USB_DMA_BURSTEND2 */
    3, /* CYHAL_TRIGGER_USB_DMA_BURSTEND3 */
    4, /* CYHAL_TRIGGER_USB_DMA_BURSTEND4 */
    5, /* CYHAL_TRIGGER_USB_DMA_BURSTEND5 */
    6, /* CYHAL_TRIGGER_USB_DMA_BURSTEND6 */
    7, /* CYHAL_TRIGGER_USB_DMA_BURSTEND7 */
};

#endif /* CY_DEVICE_PSOC6A256K */
