/***************************************************************************//**
* \file cyhal_triggers_xmc7200.h
*
* \brief
* XMC7200 family HAL triggers header
*
********************************************************************************
* \copyright
* (c) (2016-2023), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYHAL_TRIGGERS_XMC7200_H_
#define _CYHAL_TRIGGERS_XMC7200_H_

/**
 * \addtogroup group_hal_impl_triggers_xmc7200 XMC7200
 * \ingroup group_hal_impl_triggers
 * \{
 * Trigger connections for xmc7200
 */

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/** \cond INTERNAL */
/** @brief Name of each input trigger. */
typedef enum
{
    _CYHAL_TRIGGER_CPUSS_ZERO = 0, //!< cpuss.zero
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ = 1, //!< audioss[0].tr_i2s_rx_req
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ = 2, //!< audioss[1].tr_i2s_rx_req
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_RX_REQ = 3, //!< audioss[2].tr_i2s_rx_req
    _CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ = 4, //!< audioss[0].tr_i2s_tx_req
    _CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ = 5, //!< audioss[1].tr_i2s_tx_req
    _CYHAL_TRIGGER_AUDIOSS2_TR_I2S_TX_REQ = 6, //!< audioss[2].tr_i2s_tx_req
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0 = 7, //!< canfd[0].tr_dbg_dma_req[0]
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ1 = 8, //!< canfd[0].tr_dbg_dma_req[1]
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ2 = 9, //!< canfd[0].tr_dbg_dma_req[2]
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ3 = 10, //!< canfd[0].tr_dbg_dma_req[3]
    _CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ4 = 11, //!< canfd[0].tr_dbg_dma_req[4]
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ0 = 12, //!< canfd[1].tr_dbg_dma_req[0]
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ1 = 13, //!< canfd[1].tr_dbg_dma_req[1]
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ2 = 14, //!< canfd[1].tr_dbg_dma_req[2]
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ3 = 15, //!< canfd[1].tr_dbg_dma_req[3]
    _CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ4 = 16, //!< canfd[1].tr_dbg_dma_req[4]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO00 = 17, //!< canfd[0].tr_fifo0[0]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO01 = 18, //!< canfd[0].tr_fifo0[1]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO02 = 19, //!< canfd[0].tr_fifo0[2]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO03 = 20, //!< canfd[0].tr_fifo0[3]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO04 = 21, //!< canfd[0].tr_fifo0[4]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO00 = 22, //!< canfd[1].tr_fifo0[0]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO01 = 23, //!< canfd[1].tr_fifo0[1]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO02 = 24, //!< canfd[1].tr_fifo0[2]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO03 = 25, //!< canfd[1].tr_fifo0[3]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO04 = 26, //!< canfd[1].tr_fifo0[4]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO10 = 27, //!< canfd[0].tr_fifo1[0]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO11 = 28, //!< canfd[0].tr_fifo1[1]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO12 = 29, //!< canfd[0].tr_fifo1[2]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO13 = 30, //!< canfd[0].tr_fifo1[3]
    _CYHAL_TRIGGER_CANFD0_TR_FIFO14 = 31, //!< canfd[0].tr_fifo1[4]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO10 = 32, //!< canfd[1].tr_fifo1[0]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO11 = 33, //!< canfd[1].tr_fifo1[1]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO12 = 34, //!< canfd[1].tr_fifo1[2]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO13 = 35, //!< canfd[1].tr_fifo1[3]
    _CYHAL_TRIGGER_CANFD1_TR_FIFO14 = 36, //!< canfd[1].tr_fifo1[4]
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0 = 37, //!< canfd[0].tr_tmp_rtp_out[0]
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1 = 38, //!< canfd[0].tr_tmp_rtp_out[1]
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2 = 39, //!< canfd[0].tr_tmp_rtp_out[2]
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3 = 40, //!< canfd[0].tr_tmp_rtp_out[3]
    _CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4 = 41, //!< canfd[0].tr_tmp_rtp_out[4]
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0 = 42, //!< canfd[1].tr_tmp_rtp_out[0]
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1 = 43, //!< canfd[1].tr_tmp_rtp_out[1]
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2 = 44, //!< canfd[1].tr_tmp_rtp_out[2]
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3 = 45, //!< canfd[1].tr_tmp_rtp_out[3]
    _CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4 = 46, //!< canfd[1].tr_tmp_rtp_out[4]
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0 = 47, //!< cpuss.cti_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1 = 48, //!< cpuss.cti_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0 = 49, //!< cpuss.dmac_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1 = 50, //!< cpuss.dmac_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2 = 51, //!< cpuss.dmac_tr_out[2]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3 = 52, //!< cpuss.dmac_tr_out[3]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT4 = 53, //!< cpuss.dmac_tr_out[4]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT5 = 54, //!< cpuss.dmac_tr_out[5]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT6 = 55, //!< cpuss.dmac_tr_out[6]
    _CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT7 = 56, //!< cpuss.dmac_tr_out[7]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0 = 57, //!< cpuss.dw0_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1 = 58, //!< cpuss.dw0_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2 = 59, //!< cpuss.dw0_tr_out[2]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3 = 60, //!< cpuss.dw0_tr_out[3]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4 = 61, //!< cpuss.dw0_tr_out[4]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5 = 62, //!< cpuss.dw0_tr_out[5]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6 = 63, //!< cpuss.dw0_tr_out[6]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7 = 64, //!< cpuss.dw0_tr_out[7]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8 = 65, //!< cpuss.dw0_tr_out[8]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9 = 66, //!< cpuss.dw0_tr_out[9]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10 = 67, //!< cpuss.dw0_tr_out[10]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11 = 68, //!< cpuss.dw0_tr_out[11]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12 = 69, //!< cpuss.dw0_tr_out[12]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13 = 70, //!< cpuss.dw0_tr_out[13]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14 = 71, //!< cpuss.dw0_tr_out[14]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15 = 72, //!< cpuss.dw0_tr_out[15]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16 = 73, //!< cpuss.dw0_tr_out[16]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17 = 74, //!< cpuss.dw0_tr_out[17]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18 = 75, //!< cpuss.dw0_tr_out[18]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19 = 76, //!< cpuss.dw0_tr_out[19]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20 = 77, //!< cpuss.dw0_tr_out[20]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21 = 78, //!< cpuss.dw0_tr_out[21]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22 = 79, //!< cpuss.dw0_tr_out[22]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23 = 80, //!< cpuss.dw0_tr_out[23]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24 = 81, //!< cpuss.dw0_tr_out[24]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25 = 82, //!< cpuss.dw0_tr_out[25]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26 = 83, //!< cpuss.dw0_tr_out[26]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27 = 84, //!< cpuss.dw0_tr_out[27]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28 = 85, //!< cpuss.dw0_tr_out[28]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29 = 86, //!< cpuss.dw0_tr_out[29]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30 = 87, //!< cpuss.dw0_tr_out[30]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31 = 88, //!< cpuss.dw0_tr_out[31]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT32 = 89, //!< cpuss.dw0_tr_out[32]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT33 = 90, //!< cpuss.dw0_tr_out[33]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT34 = 91, //!< cpuss.dw0_tr_out[34]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT35 = 92, //!< cpuss.dw0_tr_out[35]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT36 = 93, //!< cpuss.dw0_tr_out[36]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT37 = 94, //!< cpuss.dw0_tr_out[37]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT38 = 95, //!< cpuss.dw0_tr_out[38]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT39 = 96, //!< cpuss.dw0_tr_out[39]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT40 = 97, //!< cpuss.dw0_tr_out[40]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT41 = 98, //!< cpuss.dw0_tr_out[41]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT42 = 99, //!< cpuss.dw0_tr_out[42]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT43 = 100, //!< cpuss.dw0_tr_out[43]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT44 = 101, //!< cpuss.dw0_tr_out[44]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT45 = 102, //!< cpuss.dw0_tr_out[45]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT46 = 103, //!< cpuss.dw0_tr_out[46]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT47 = 104, //!< cpuss.dw0_tr_out[47]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT48 = 105, //!< cpuss.dw0_tr_out[48]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT49 = 106, //!< cpuss.dw0_tr_out[49]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT50 = 107, //!< cpuss.dw0_tr_out[50]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT51 = 108, //!< cpuss.dw0_tr_out[51]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT52 = 109, //!< cpuss.dw0_tr_out[52]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT53 = 110, //!< cpuss.dw0_tr_out[53]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT54 = 111, //!< cpuss.dw0_tr_out[54]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT55 = 112, //!< cpuss.dw0_tr_out[55]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT56 = 113, //!< cpuss.dw0_tr_out[56]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT57 = 114, //!< cpuss.dw0_tr_out[57]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT58 = 115, //!< cpuss.dw0_tr_out[58]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT59 = 116, //!< cpuss.dw0_tr_out[59]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT60 = 117, //!< cpuss.dw0_tr_out[60]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT61 = 118, //!< cpuss.dw0_tr_out[61]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT62 = 119, //!< cpuss.dw0_tr_out[62]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT63 = 120, //!< cpuss.dw0_tr_out[63]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT64 = 121, //!< cpuss.dw0_tr_out[64]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT65 = 122, //!< cpuss.dw0_tr_out[65]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT66 = 123, //!< cpuss.dw0_tr_out[66]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT67 = 124, //!< cpuss.dw0_tr_out[67]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT68 = 125, //!< cpuss.dw0_tr_out[68]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT69 = 126, //!< cpuss.dw0_tr_out[69]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT70 = 127, //!< cpuss.dw0_tr_out[70]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT71 = 128, //!< cpuss.dw0_tr_out[71]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT72 = 129, //!< cpuss.dw0_tr_out[72]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT73 = 130, //!< cpuss.dw0_tr_out[73]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT74 = 131, //!< cpuss.dw0_tr_out[74]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT75 = 132, //!< cpuss.dw0_tr_out[75]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT76 = 133, //!< cpuss.dw0_tr_out[76]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT77 = 134, //!< cpuss.dw0_tr_out[77]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT78 = 135, //!< cpuss.dw0_tr_out[78]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT79 = 136, //!< cpuss.dw0_tr_out[79]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT80 = 137, //!< cpuss.dw0_tr_out[80]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT81 = 138, //!< cpuss.dw0_tr_out[81]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT82 = 139, //!< cpuss.dw0_tr_out[82]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT83 = 140, //!< cpuss.dw0_tr_out[83]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT84 = 141, //!< cpuss.dw0_tr_out[84]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT85 = 142, //!< cpuss.dw0_tr_out[85]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT86 = 143, //!< cpuss.dw0_tr_out[86]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT87 = 144, //!< cpuss.dw0_tr_out[87]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT88 = 145, //!< cpuss.dw0_tr_out[88]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT89 = 146, //!< cpuss.dw0_tr_out[89]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT90 = 147, //!< cpuss.dw0_tr_out[90]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT91 = 148, //!< cpuss.dw0_tr_out[91]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT92 = 149, //!< cpuss.dw0_tr_out[92]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT93 = 150, //!< cpuss.dw0_tr_out[93]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT94 = 151, //!< cpuss.dw0_tr_out[94]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT95 = 152, //!< cpuss.dw0_tr_out[95]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT96 = 153, //!< cpuss.dw0_tr_out[96]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT97 = 154, //!< cpuss.dw0_tr_out[97]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT98 = 155, //!< cpuss.dw0_tr_out[98]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT99 = 156, //!< cpuss.dw0_tr_out[99]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT100 = 157, //!< cpuss.dw0_tr_out[100]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT101 = 158, //!< cpuss.dw0_tr_out[101]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT102 = 159, //!< cpuss.dw0_tr_out[102]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT103 = 160, //!< cpuss.dw0_tr_out[103]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT104 = 161, //!< cpuss.dw0_tr_out[104]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT105 = 162, //!< cpuss.dw0_tr_out[105]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT106 = 163, //!< cpuss.dw0_tr_out[106]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT107 = 164, //!< cpuss.dw0_tr_out[107]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT108 = 165, //!< cpuss.dw0_tr_out[108]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT109 = 166, //!< cpuss.dw0_tr_out[109]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT110 = 167, //!< cpuss.dw0_tr_out[110]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT111 = 168, //!< cpuss.dw0_tr_out[111]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT112 = 169, //!< cpuss.dw0_tr_out[112]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT113 = 170, //!< cpuss.dw0_tr_out[113]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT114 = 171, //!< cpuss.dw0_tr_out[114]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT115 = 172, //!< cpuss.dw0_tr_out[115]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT116 = 173, //!< cpuss.dw0_tr_out[116]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT117 = 174, //!< cpuss.dw0_tr_out[117]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT118 = 175, //!< cpuss.dw0_tr_out[118]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT119 = 176, //!< cpuss.dw0_tr_out[119]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT120 = 177, //!< cpuss.dw0_tr_out[120]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT121 = 178, //!< cpuss.dw0_tr_out[121]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT122 = 179, //!< cpuss.dw0_tr_out[122]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT123 = 180, //!< cpuss.dw0_tr_out[123]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT124 = 181, //!< cpuss.dw0_tr_out[124]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT125 = 182, //!< cpuss.dw0_tr_out[125]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT126 = 183, //!< cpuss.dw0_tr_out[126]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT127 = 184, //!< cpuss.dw0_tr_out[127]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT128 = 185, //!< cpuss.dw0_tr_out[128]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT129 = 186, //!< cpuss.dw0_tr_out[129]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT130 = 187, //!< cpuss.dw0_tr_out[130]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT131 = 188, //!< cpuss.dw0_tr_out[131]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT132 = 189, //!< cpuss.dw0_tr_out[132]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT133 = 190, //!< cpuss.dw0_tr_out[133]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT134 = 191, //!< cpuss.dw0_tr_out[134]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT135 = 192, //!< cpuss.dw0_tr_out[135]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT136 = 193, //!< cpuss.dw0_tr_out[136]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT137 = 194, //!< cpuss.dw0_tr_out[137]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT138 = 195, //!< cpuss.dw0_tr_out[138]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT139 = 196, //!< cpuss.dw0_tr_out[139]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT140 = 197, //!< cpuss.dw0_tr_out[140]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT141 = 198, //!< cpuss.dw0_tr_out[141]
    _CYHAL_TRIGGER_CPUSS_DW0_TR_OUT142 = 199, //!< cpuss.dw0_tr_out[142]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0 = 200, //!< cpuss.dw1_tr_out[0]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1 = 201, //!< cpuss.dw1_tr_out[1]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2 = 202, //!< cpuss.dw1_tr_out[2]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3 = 203, //!< cpuss.dw1_tr_out[3]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4 = 204, //!< cpuss.dw1_tr_out[4]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5 = 205, //!< cpuss.dw1_tr_out[5]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6 = 206, //!< cpuss.dw1_tr_out[6]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7 = 207, //!< cpuss.dw1_tr_out[7]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8 = 208, //!< cpuss.dw1_tr_out[8]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9 = 209, //!< cpuss.dw1_tr_out[9]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10 = 210, //!< cpuss.dw1_tr_out[10]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11 = 211, //!< cpuss.dw1_tr_out[11]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12 = 212, //!< cpuss.dw1_tr_out[12]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13 = 213, //!< cpuss.dw1_tr_out[13]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14 = 214, //!< cpuss.dw1_tr_out[14]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15 = 215, //!< cpuss.dw1_tr_out[15]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16 = 216, //!< cpuss.dw1_tr_out[16]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17 = 217, //!< cpuss.dw1_tr_out[17]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18 = 218, //!< cpuss.dw1_tr_out[18]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19 = 219, //!< cpuss.dw1_tr_out[19]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20 = 220, //!< cpuss.dw1_tr_out[20]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21 = 221, //!< cpuss.dw1_tr_out[21]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22 = 222, //!< cpuss.dw1_tr_out[22]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23 = 223, //!< cpuss.dw1_tr_out[23]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24 = 224, //!< cpuss.dw1_tr_out[24]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25 = 225, //!< cpuss.dw1_tr_out[25]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26 = 226, //!< cpuss.dw1_tr_out[26]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27 = 227, //!< cpuss.dw1_tr_out[27]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28 = 228, //!< cpuss.dw1_tr_out[28]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29 = 229, //!< cpuss.dw1_tr_out[29]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT30 = 230, //!< cpuss.dw1_tr_out[30]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT31 = 231, //!< cpuss.dw1_tr_out[31]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT32 = 232, //!< cpuss.dw1_tr_out[32]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT33 = 233, //!< cpuss.dw1_tr_out[33]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT34 = 234, //!< cpuss.dw1_tr_out[34]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT35 = 235, //!< cpuss.dw1_tr_out[35]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT36 = 236, //!< cpuss.dw1_tr_out[36]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT37 = 237, //!< cpuss.dw1_tr_out[37]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT38 = 238, //!< cpuss.dw1_tr_out[38]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT39 = 239, //!< cpuss.dw1_tr_out[39]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT40 = 240, //!< cpuss.dw1_tr_out[40]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT41 = 241, //!< cpuss.dw1_tr_out[41]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT42 = 242, //!< cpuss.dw1_tr_out[42]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT43 = 243, //!< cpuss.dw1_tr_out[43]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT44 = 244, //!< cpuss.dw1_tr_out[44]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT45 = 245, //!< cpuss.dw1_tr_out[45]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT46 = 246, //!< cpuss.dw1_tr_out[46]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT47 = 247, //!< cpuss.dw1_tr_out[47]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT48 = 248, //!< cpuss.dw1_tr_out[48]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT49 = 249, //!< cpuss.dw1_tr_out[49]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT50 = 250, //!< cpuss.dw1_tr_out[50]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT51 = 251, //!< cpuss.dw1_tr_out[51]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT52 = 252, //!< cpuss.dw1_tr_out[52]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT53 = 253, //!< cpuss.dw1_tr_out[53]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT54 = 254, //!< cpuss.dw1_tr_out[54]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT55 = 255, //!< cpuss.dw1_tr_out[55]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT56 = 256, //!< cpuss.dw1_tr_out[56]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT57 = 257, //!< cpuss.dw1_tr_out[57]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT58 = 258, //!< cpuss.dw1_tr_out[58]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT59 = 259, //!< cpuss.dw1_tr_out[59]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT60 = 260, //!< cpuss.dw1_tr_out[60]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT61 = 261, //!< cpuss.dw1_tr_out[61]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT62 = 262, //!< cpuss.dw1_tr_out[62]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT63 = 263, //!< cpuss.dw1_tr_out[63]
    _CYHAL_TRIGGER_CPUSS_DW1_TR_OUT64 = 264, //!< cpuss.dw1_tr_out[64]
    _CYHAL_TRIGGER_CPUSS_TR_FAULT0 = 265, //!< cpuss.tr_fault[0]
    _CYHAL_TRIGGER_CPUSS_TR_FAULT1 = 266, //!< cpuss.tr_fault[1]
    _CYHAL_TRIGGER_CPUSS_TR_FAULT2 = 267, //!< cpuss.tr_fault[2]
    _CYHAL_TRIGGER_CPUSS_TR_FAULT3 = 268, //!< cpuss.tr_fault[3]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT0 = 269, //!< evtgen[0].tr_out[0]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT1 = 270, //!< evtgen[0].tr_out[1]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT2 = 271, //!< evtgen[0].tr_out[2]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT3 = 272, //!< evtgen[0].tr_out[3]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT4 = 273, //!< evtgen[0].tr_out[4]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT5 = 274, //!< evtgen[0].tr_out[5]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT6 = 275, //!< evtgen[0].tr_out[6]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT7 = 276, //!< evtgen[0].tr_out[7]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT8 = 277, //!< evtgen[0].tr_out[8]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT9 = 278, //!< evtgen[0].tr_out[9]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT10 = 279, //!< evtgen[0].tr_out[10]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT11 = 280, //!< evtgen[0].tr_out[11]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT12 = 281, //!< evtgen[0].tr_out[12]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT13 = 282, //!< evtgen[0].tr_out[13]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT14 = 283, //!< evtgen[0].tr_out[14]
    _CYHAL_TRIGGER_EVTGEN0_TR_OUT15 = 284, //!< evtgen[0].tr_out[15]
    _CYHAL_TRIGGER_FLEXRAY0_TR_IBF_OUT = 285, //!< flexray[0].tr_ibf_out
    _CYHAL_TRIGGER_FLEXRAY0_TR_OBF_OUT = 286, //!< flexray[0].tr_obf_out
    _CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT = 287, //!< flexray[0].tr_tint0_out
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0 = 288, //!< pass[0].tr_sar_ch_done[0]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1 = 289, //!< pass[0].tr_sar_ch_done[1]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2 = 290, //!< pass[0].tr_sar_ch_done[2]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3 = 291, //!< pass[0].tr_sar_ch_done[3]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4 = 292, //!< pass[0].tr_sar_ch_done[4]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5 = 293, //!< pass[0].tr_sar_ch_done[5]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6 = 294, //!< pass[0].tr_sar_ch_done[6]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7 = 295, //!< pass[0].tr_sar_ch_done[7]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8 = 296, //!< pass[0].tr_sar_ch_done[8]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9 = 297, //!< pass[0].tr_sar_ch_done[9]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10 = 298, //!< pass[0].tr_sar_ch_done[10]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11 = 299, //!< pass[0].tr_sar_ch_done[11]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12 = 300, //!< pass[0].tr_sar_ch_done[12]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13 = 301, //!< pass[0].tr_sar_ch_done[13]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14 = 302, //!< pass[0].tr_sar_ch_done[14]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15 = 303, //!< pass[0].tr_sar_ch_done[15]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16 = 304, //!< pass[0].tr_sar_ch_done[16]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17 = 305, //!< pass[0].tr_sar_ch_done[17]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18 = 306, //!< pass[0].tr_sar_ch_done[18]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19 = 307, //!< pass[0].tr_sar_ch_done[19]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20 = 308, //!< pass[0].tr_sar_ch_done[20]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21 = 309, //!< pass[0].tr_sar_ch_done[21]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22 = 310, //!< pass[0].tr_sar_ch_done[22]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23 = 311, //!< pass[0].tr_sar_ch_done[23]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24 = 312, //!< pass[0].tr_sar_ch_done[24]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25 = 313, //!< pass[0].tr_sar_ch_done[25]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26 = 314, //!< pass[0].tr_sar_ch_done[26]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27 = 315, //!< pass[0].tr_sar_ch_done[27]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28 = 316, //!< pass[0].tr_sar_ch_done[28]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29 = 317, //!< pass[0].tr_sar_ch_done[29]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30 = 318, //!< pass[0].tr_sar_ch_done[30]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31 = 319, //!< pass[0].tr_sar_ch_done[31]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32 = 320, //!< pass[0].tr_sar_ch_done[32]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33 = 321, //!< pass[0].tr_sar_ch_done[33]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34 = 322, //!< pass[0].tr_sar_ch_done[34]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35 = 323, //!< pass[0].tr_sar_ch_done[35]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36 = 324, //!< pass[0].tr_sar_ch_done[36]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37 = 325, //!< pass[0].tr_sar_ch_done[37]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38 = 326, //!< pass[0].tr_sar_ch_done[38]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39 = 327, //!< pass[0].tr_sar_ch_done[39]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40 = 328, //!< pass[0].tr_sar_ch_done[40]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41 = 329, //!< pass[0].tr_sar_ch_done[41]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42 = 330, //!< pass[0].tr_sar_ch_done[42]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43 = 331, //!< pass[0].tr_sar_ch_done[43]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44 = 332, //!< pass[0].tr_sar_ch_done[44]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45 = 333, //!< pass[0].tr_sar_ch_done[45]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46 = 334, //!< pass[0].tr_sar_ch_done[46]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47 = 335, //!< pass[0].tr_sar_ch_done[47]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48 = 336, //!< pass[0].tr_sar_ch_done[48]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49 = 337, //!< pass[0].tr_sar_ch_done[49]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50 = 338, //!< pass[0].tr_sar_ch_done[50]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51 = 339, //!< pass[0].tr_sar_ch_done[51]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52 = 340, //!< pass[0].tr_sar_ch_done[52]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53 = 341, //!< pass[0].tr_sar_ch_done[53]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54 = 342, //!< pass[0].tr_sar_ch_done[54]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55 = 343, //!< pass[0].tr_sar_ch_done[55]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56 = 344, //!< pass[0].tr_sar_ch_done[56]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57 = 345, //!< pass[0].tr_sar_ch_done[57]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58 = 346, //!< pass[0].tr_sar_ch_done[58]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59 = 347, //!< pass[0].tr_sar_ch_done[59]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60 = 348, //!< pass[0].tr_sar_ch_done[60]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61 = 349, //!< pass[0].tr_sar_ch_done[61]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62 = 350, //!< pass[0].tr_sar_ch_done[62]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63 = 351, //!< pass[0].tr_sar_ch_done[63]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64 = 352, //!< pass[0].tr_sar_ch_done[64]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65 = 353, //!< pass[0].tr_sar_ch_done[65]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66 = 354, //!< pass[0].tr_sar_ch_done[66]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67 = 355, //!< pass[0].tr_sar_ch_done[67]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68 = 356, //!< pass[0].tr_sar_ch_done[68]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69 = 357, //!< pass[0].tr_sar_ch_done[69]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70 = 358, //!< pass[0].tr_sar_ch_done[70]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71 = 359, //!< pass[0].tr_sar_ch_done[71]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72 = 360, //!< pass[0].tr_sar_ch_done[72]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73 = 361, //!< pass[0].tr_sar_ch_done[73]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74 = 362, //!< pass[0].tr_sar_ch_done[74]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75 = 363, //!< pass[0].tr_sar_ch_done[75]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76 = 364, //!< pass[0].tr_sar_ch_done[76]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77 = 365, //!< pass[0].tr_sar_ch_done[77]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78 = 366, //!< pass[0].tr_sar_ch_done[78]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79 = 367, //!< pass[0].tr_sar_ch_done[79]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80 = 368, //!< pass[0].tr_sar_ch_done[80]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81 = 369, //!< pass[0].tr_sar_ch_done[81]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82 = 370, //!< pass[0].tr_sar_ch_done[82]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83 = 371, //!< pass[0].tr_sar_ch_done[83]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84 = 372, //!< pass[0].tr_sar_ch_done[84]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85 = 373, //!< pass[0].tr_sar_ch_done[85]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86 = 374, //!< pass[0].tr_sar_ch_done[86]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87 = 375, //!< pass[0].tr_sar_ch_done[87]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88 = 376, //!< pass[0].tr_sar_ch_done[88]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89 = 377, //!< pass[0].tr_sar_ch_done[89]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90 = 378, //!< pass[0].tr_sar_ch_done[90]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91 = 379, //!< pass[0].tr_sar_ch_done[91]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92 = 380, //!< pass[0].tr_sar_ch_done[92]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93 = 381, //!< pass[0].tr_sar_ch_done[93]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94 = 382, //!< pass[0].tr_sar_ch_done[94]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95 = 383, //!< pass[0].tr_sar_ch_done[95]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO0 = 384, //!< pass[0].tr_sar_ch_rangevio[0]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO1 = 385, //!< pass[0].tr_sar_ch_rangevio[1]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO2 = 386, //!< pass[0].tr_sar_ch_rangevio[2]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO3 = 387, //!< pass[0].tr_sar_ch_rangevio[3]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO4 = 388, //!< pass[0].tr_sar_ch_rangevio[4]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO5 = 389, //!< pass[0].tr_sar_ch_rangevio[5]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO6 = 390, //!< pass[0].tr_sar_ch_rangevio[6]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO7 = 391, //!< pass[0].tr_sar_ch_rangevio[7]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO8 = 392, //!< pass[0].tr_sar_ch_rangevio[8]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO9 = 393, //!< pass[0].tr_sar_ch_rangevio[9]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO10 = 394, //!< pass[0].tr_sar_ch_rangevio[10]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO11 = 395, //!< pass[0].tr_sar_ch_rangevio[11]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO12 = 396, //!< pass[0].tr_sar_ch_rangevio[12]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO13 = 397, //!< pass[0].tr_sar_ch_rangevio[13]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO14 = 398, //!< pass[0].tr_sar_ch_rangevio[14]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO15 = 399, //!< pass[0].tr_sar_ch_rangevio[15]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO16 = 400, //!< pass[0].tr_sar_ch_rangevio[16]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO17 = 401, //!< pass[0].tr_sar_ch_rangevio[17]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO18 = 402, //!< pass[0].tr_sar_ch_rangevio[18]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO19 = 403, //!< pass[0].tr_sar_ch_rangevio[19]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO20 = 404, //!< pass[0].tr_sar_ch_rangevio[20]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO21 = 405, //!< pass[0].tr_sar_ch_rangevio[21]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO22 = 406, //!< pass[0].tr_sar_ch_rangevio[22]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO23 = 407, //!< pass[0].tr_sar_ch_rangevio[23]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO24 = 408, //!< pass[0].tr_sar_ch_rangevio[24]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO25 = 409, //!< pass[0].tr_sar_ch_rangevio[25]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO26 = 410, //!< pass[0].tr_sar_ch_rangevio[26]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO27 = 411, //!< pass[0].tr_sar_ch_rangevio[27]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO28 = 412, //!< pass[0].tr_sar_ch_rangevio[28]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO29 = 413, //!< pass[0].tr_sar_ch_rangevio[29]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO30 = 414, //!< pass[0].tr_sar_ch_rangevio[30]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO31 = 415, //!< pass[0].tr_sar_ch_rangevio[31]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO32 = 416, //!< pass[0].tr_sar_ch_rangevio[32]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO33 = 417, //!< pass[0].tr_sar_ch_rangevio[33]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO34 = 418, //!< pass[0].tr_sar_ch_rangevio[34]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO35 = 419, //!< pass[0].tr_sar_ch_rangevio[35]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO36 = 420, //!< pass[0].tr_sar_ch_rangevio[36]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO37 = 421, //!< pass[0].tr_sar_ch_rangevio[37]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO38 = 422, //!< pass[0].tr_sar_ch_rangevio[38]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO39 = 423, //!< pass[0].tr_sar_ch_rangevio[39]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO40 = 424, //!< pass[0].tr_sar_ch_rangevio[40]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO41 = 425, //!< pass[0].tr_sar_ch_rangevio[41]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO42 = 426, //!< pass[0].tr_sar_ch_rangevio[42]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO43 = 427, //!< pass[0].tr_sar_ch_rangevio[43]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO44 = 428, //!< pass[0].tr_sar_ch_rangevio[44]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO45 = 429, //!< pass[0].tr_sar_ch_rangevio[45]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO46 = 430, //!< pass[0].tr_sar_ch_rangevio[46]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO47 = 431, //!< pass[0].tr_sar_ch_rangevio[47]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO48 = 432, //!< pass[0].tr_sar_ch_rangevio[48]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO49 = 433, //!< pass[0].tr_sar_ch_rangevio[49]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO50 = 434, //!< pass[0].tr_sar_ch_rangevio[50]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO51 = 435, //!< pass[0].tr_sar_ch_rangevio[51]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO52 = 436, //!< pass[0].tr_sar_ch_rangevio[52]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO53 = 437, //!< pass[0].tr_sar_ch_rangevio[53]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO54 = 438, //!< pass[0].tr_sar_ch_rangevio[54]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO55 = 439, //!< pass[0].tr_sar_ch_rangevio[55]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO56 = 440, //!< pass[0].tr_sar_ch_rangevio[56]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO57 = 441, //!< pass[0].tr_sar_ch_rangevio[57]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO58 = 442, //!< pass[0].tr_sar_ch_rangevio[58]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO59 = 443, //!< pass[0].tr_sar_ch_rangevio[59]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO60 = 444, //!< pass[0].tr_sar_ch_rangevio[60]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO61 = 445, //!< pass[0].tr_sar_ch_rangevio[61]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO62 = 446, //!< pass[0].tr_sar_ch_rangevio[62]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO63 = 447, //!< pass[0].tr_sar_ch_rangevio[63]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO64 = 448, //!< pass[0].tr_sar_ch_rangevio[64]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO65 = 449, //!< pass[0].tr_sar_ch_rangevio[65]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO66 = 450, //!< pass[0].tr_sar_ch_rangevio[66]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO67 = 451, //!< pass[0].tr_sar_ch_rangevio[67]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO68 = 452, //!< pass[0].tr_sar_ch_rangevio[68]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO69 = 453, //!< pass[0].tr_sar_ch_rangevio[69]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO70 = 454, //!< pass[0].tr_sar_ch_rangevio[70]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO71 = 455, //!< pass[0].tr_sar_ch_rangevio[71]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO72 = 456, //!< pass[0].tr_sar_ch_rangevio[72]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO73 = 457, //!< pass[0].tr_sar_ch_rangevio[73]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO74 = 458, //!< pass[0].tr_sar_ch_rangevio[74]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO75 = 459, //!< pass[0].tr_sar_ch_rangevio[75]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO76 = 460, //!< pass[0].tr_sar_ch_rangevio[76]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO77 = 461, //!< pass[0].tr_sar_ch_rangevio[77]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO78 = 462, //!< pass[0].tr_sar_ch_rangevio[78]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO79 = 463, //!< pass[0].tr_sar_ch_rangevio[79]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO80 = 464, //!< pass[0].tr_sar_ch_rangevio[80]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO81 = 465, //!< pass[0].tr_sar_ch_rangevio[81]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO82 = 466, //!< pass[0].tr_sar_ch_rangevio[82]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO83 = 467, //!< pass[0].tr_sar_ch_rangevio[83]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO84 = 468, //!< pass[0].tr_sar_ch_rangevio[84]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO85 = 469, //!< pass[0].tr_sar_ch_rangevio[85]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO86 = 470, //!< pass[0].tr_sar_ch_rangevio[86]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO87 = 471, //!< pass[0].tr_sar_ch_rangevio[87]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO88 = 472, //!< pass[0].tr_sar_ch_rangevio[88]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO89 = 473, //!< pass[0].tr_sar_ch_rangevio[89]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO90 = 474, //!< pass[0].tr_sar_ch_rangevio[90]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO91 = 475, //!< pass[0].tr_sar_ch_rangevio[91]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO92 = 476, //!< pass[0].tr_sar_ch_rangevio[92]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO93 = 477, //!< pass[0].tr_sar_ch_rangevio[93]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO94 = 478, //!< pass[0].tr_sar_ch_rangevio[94]
    _CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO95 = 479, //!< pass[0].tr_sar_ch_rangevio[95]
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0 = 480, //!< pass[0].tr_sar_gen_out[0]
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1 = 481, //!< pass[0].tr_sar_gen_out[1]
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2 = 482, //!< pass[0].tr_sar_gen_out[2]
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3 = 483, //!< pass[0].tr_sar_gen_out[3]
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4 = 484, //!< pass[0].tr_sar_gen_out[4]
    _CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5 = 485, //!< pass[0].tr_sar_gen_out[5]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT0 = 486, //!< peri.tr_io_input[0]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT1 = 487, //!< peri.tr_io_input[1]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT2 = 488, //!< peri.tr_io_input[2]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT3 = 489, //!< peri.tr_io_input[3]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT4 = 490, //!< peri.tr_io_input[4]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT5 = 491, //!< peri.tr_io_input[5]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT6 = 492, //!< peri.tr_io_input[6]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT7 = 493, //!< peri.tr_io_input[7]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT8 = 494, //!< peri.tr_io_input[8]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT9 = 495, //!< peri.tr_io_input[9]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT10 = 496, //!< peri.tr_io_input[10]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT11 = 497, //!< peri.tr_io_input[11]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT12 = 498, //!< peri.tr_io_input[12]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT13 = 499, //!< peri.tr_io_input[13]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT14 = 500, //!< peri.tr_io_input[14]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT15 = 501, //!< peri.tr_io_input[15]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT16 = 502, //!< peri.tr_io_input[16]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT17 = 503, //!< peri.tr_io_input[17]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT18 = 504, //!< peri.tr_io_input[18]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT19 = 505, //!< peri.tr_io_input[19]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT20 = 506, //!< peri.tr_io_input[20]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT21 = 507, //!< peri.tr_io_input[21]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT22 = 508, //!< peri.tr_io_input[22]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT23 = 509, //!< peri.tr_io_input[23]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT24 = 510, //!< peri.tr_io_input[24]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT25 = 511, //!< peri.tr_io_input[25]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT26 = 512, //!< peri.tr_io_input[26]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT27 = 513, //!< peri.tr_io_input[27]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT28 = 514, //!< peri.tr_io_input[28]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT29 = 515, //!< peri.tr_io_input[29]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT30 = 516, //!< peri.tr_io_input[30]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT31 = 517, //!< peri.tr_io_input[31]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT32 = 518, //!< peri.tr_io_input[32]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT33 = 519, //!< peri.tr_io_input[33]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT34 = 520, //!< peri.tr_io_input[34]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT35 = 521, //!< peri.tr_io_input[35]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT36 = 522, //!< peri.tr_io_input[36]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT37 = 523, //!< peri.tr_io_input[37]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT38 = 524, //!< peri.tr_io_input[38]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT39 = 525, //!< peri.tr_io_input[39]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT40 = 526, //!< peri.tr_io_input[40]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT41 = 527, //!< peri.tr_io_input[41]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT42 = 528, //!< peri.tr_io_input[42]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT43 = 529, //!< peri.tr_io_input[43]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT44 = 530, //!< peri.tr_io_input[44]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT45 = 531, //!< peri.tr_io_input[45]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT46 = 532, //!< peri.tr_io_input[46]
    _CYHAL_TRIGGER_PERI_TR_IO_INPUT47 = 533, //!< peri.tr_io_input[47]
    _CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED = 534, //!< scb[0].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED = 535, //!< scb[1].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED = 536, //!< scb[2].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED = 537, //!< scb[3].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED = 538, //!< scb[4].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED = 539, //!< scb[5].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED = 540, //!< scb[6].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED = 541, //!< scb[7].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED = 542, //!< scb[8].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED = 543, //!< scb[9].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED = 544, //!< scb[10].tr_i2c_scl_filtered
    _CYHAL_TRIGGER_SCB0_TR_RX_REQ = 545, //!< scb[0].tr_rx_req
    _CYHAL_TRIGGER_SCB1_TR_RX_REQ = 546, //!< scb[1].tr_rx_req
    _CYHAL_TRIGGER_SCB2_TR_RX_REQ = 547, //!< scb[2].tr_rx_req
    _CYHAL_TRIGGER_SCB3_TR_RX_REQ = 548, //!< scb[3].tr_rx_req
    _CYHAL_TRIGGER_SCB4_TR_RX_REQ = 549, //!< scb[4].tr_rx_req
    _CYHAL_TRIGGER_SCB5_TR_RX_REQ = 550, //!< scb[5].tr_rx_req
    _CYHAL_TRIGGER_SCB6_TR_RX_REQ = 551, //!< scb[6].tr_rx_req
    _CYHAL_TRIGGER_SCB7_TR_RX_REQ = 552, //!< scb[7].tr_rx_req
    _CYHAL_TRIGGER_SCB8_TR_RX_REQ = 553, //!< scb[8].tr_rx_req
    _CYHAL_TRIGGER_SCB9_TR_RX_REQ = 554, //!< scb[9].tr_rx_req
    _CYHAL_TRIGGER_SCB10_TR_RX_REQ = 555, //!< scb[10].tr_rx_req
    _CYHAL_TRIGGER_SCB0_TR_TX_REQ = 556, //!< scb[0].tr_tx_req
    _CYHAL_TRIGGER_SCB1_TR_TX_REQ = 557, //!< scb[1].tr_tx_req
    _CYHAL_TRIGGER_SCB2_TR_TX_REQ = 558, //!< scb[2].tr_tx_req
    _CYHAL_TRIGGER_SCB3_TR_TX_REQ = 559, //!< scb[3].tr_tx_req
    _CYHAL_TRIGGER_SCB4_TR_TX_REQ = 560, //!< scb[4].tr_tx_req
    _CYHAL_TRIGGER_SCB5_TR_TX_REQ = 561, //!< scb[5].tr_tx_req
    _CYHAL_TRIGGER_SCB6_TR_TX_REQ = 562, //!< scb[6].tr_tx_req
    _CYHAL_TRIGGER_SCB7_TR_TX_REQ = 563, //!< scb[7].tr_tx_req
    _CYHAL_TRIGGER_SCB8_TR_TX_REQ = 564, //!< scb[8].tr_tx_req
    _CYHAL_TRIGGER_SCB9_TR_TX_REQ = 565, //!< scb[9].tr_tx_req
    _CYHAL_TRIGGER_SCB10_TR_TX_REQ = 566, //!< scb[10].tr_tx_req
    _CYHAL_TRIGGER_SMIF0_TR_RX_REQ = 567, //!< smif[0].tr_rx_req
    _CYHAL_TRIGGER_SMIF0_TR_TX_REQ = 568, //!< smif[0].tr_tx_req
    _CYHAL_TRIGGER_TCPWM0_TR_OUT00 = 569, //!< tcpwm[0].tr_out0[0]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT01 = 570, //!< tcpwm[0].tr_out0[1]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT02 = 571, //!< tcpwm[0].tr_out0[2]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0256 = 572, //!< tcpwm[0].tr_out0[256]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0257 = 573, //!< tcpwm[0].tr_out0[257]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0258 = 574, //!< tcpwm[0].tr_out0[258]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0512 = 575, //!< tcpwm[0].tr_out0[512]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0513 = 576, //!< tcpwm[0].tr_out0[513]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT0514 = 577, //!< tcpwm[0].tr_out0[514]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT00 = 578, //!< tcpwm[1].tr_out0[0]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT01 = 579, //!< tcpwm[1].tr_out0[1]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT02 = 580, //!< tcpwm[1].tr_out0[2]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT03 = 581, //!< tcpwm[1].tr_out0[3]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT04 = 582, //!< tcpwm[1].tr_out0[4]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT05 = 583, //!< tcpwm[1].tr_out0[5]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT06 = 584, //!< tcpwm[1].tr_out0[6]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT07 = 585, //!< tcpwm[1].tr_out0[7]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT08 = 586, //!< tcpwm[1].tr_out0[8]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT09 = 587, //!< tcpwm[1].tr_out0[9]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT010 = 588, //!< tcpwm[1].tr_out0[10]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT011 = 589, //!< tcpwm[1].tr_out0[11]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT012 = 590, //!< tcpwm[1].tr_out0[12]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT013 = 591, //!< tcpwm[1].tr_out0[13]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT014 = 592, //!< tcpwm[1].tr_out0[14]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT015 = 593, //!< tcpwm[1].tr_out0[15]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT016 = 594, //!< tcpwm[1].tr_out0[16]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT017 = 595, //!< tcpwm[1].tr_out0[17]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT018 = 596, //!< tcpwm[1].tr_out0[18]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT019 = 597, //!< tcpwm[1].tr_out0[19]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT020 = 598, //!< tcpwm[1].tr_out0[20]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT021 = 599, //!< tcpwm[1].tr_out0[21]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT022 = 600, //!< tcpwm[1].tr_out0[22]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT023 = 601, //!< tcpwm[1].tr_out0[23]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT024 = 602, //!< tcpwm[1].tr_out0[24]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT025 = 603, //!< tcpwm[1].tr_out0[25]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT026 = 604, //!< tcpwm[1].tr_out0[26]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT027 = 605, //!< tcpwm[1].tr_out0[27]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT028 = 606, //!< tcpwm[1].tr_out0[28]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT029 = 607, //!< tcpwm[1].tr_out0[29]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT030 = 608, //!< tcpwm[1].tr_out0[30]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT031 = 609, //!< tcpwm[1].tr_out0[31]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT032 = 610, //!< tcpwm[1].tr_out0[32]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT033 = 611, //!< tcpwm[1].tr_out0[33]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT034 = 612, //!< tcpwm[1].tr_out0[34]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT035 = 613, //!< tcpwm[1].tr_out0[35]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT036 = 614, //!< tcpwm[1].tr_out0[36]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT037 = 615, //!< tcpwm[1].tr_out0[37]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT038 = 616, //!< tcpwm[1].tr_out0[38]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT039 = 617, //!< tcpwm[1].tr_out0[39]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT040 = 618, //!< tcpwm[1].tr_out0[40]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT041 = 619, //!< tcpwm[1].tr_out0[41]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT042 = 620, //!< tcpwm[1].tr_out0[42]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT043 = 621, //!< tcpwm[1].tr_out0[43]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT044 = 622, //!< tcpwm[1].tr_out0[44]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT045 = 623, //!< tcpwm[1].tr_out0[45]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT046 = 624, //!< tcpwm[1].tr_out0[46]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT047 = 625, //!< tcpwm[1].tr_out0[47]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT048 = 626, //!< tcpwm[1].tr_out0[48]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT049 = 627, //!< tcpwm[1].tr_out0[49]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT050 = 628, //!< tcpwm[1].tr_out0[50]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT051 = 629, //!< tcpwm[1].tr_out0[51]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT052 = 630, //!< tcpwm[1].tr_out0[52]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT053 = 631, //!< tcpwm[1].tr_out0[53]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT054 = 632, //!< tcpwm[1].tr_out0[54]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT055 = 633, //!< tcpwm[1].tr_out0[55]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT056 = 634, //!< tcpwm[1].tr_out0[56]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT057 = 635, //!< tcpwm[1].tr_out0[57]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT058 = 636, //!< tcpwm[1].tr_out0[58]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT059 = 637, //!< tcpwm[1].tr_out0[59]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT060 = 638, //!< tcpwm[1].tr_out0[60]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT061 = 639, //!< tcpwm[1].tr_out0[61]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT062 = 640, //!< tcpwm[1].tr_out0[62]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT063 = 641, //!< tcpwm[1].tr_out0[63]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT064 = 642, //!< tcpwm[1].tr_out0[64]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT065 = 643, //!< tcpwm[1].tr_out0[65]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT066 = 644, //!< tcpwm[1].tr_out0[66]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT067 = 645, //!< tcpwm[1].tr_out0[67]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT068 = 646, //!< tcpwm[1].tr_out0[68]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT069 = 647, //!< tcpwm[1].tr_out0[69]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT070 = 648, //!< tcpwm[1].tr_out0[70]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT071 = 649, //!< tcpwm[1].tr_out0[71]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT072 = 650, //!< tcpwm[1].tr_out0[72]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT073 = 651, //!< tcpwm[1].tr_out0[73]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT074 = 652, //!< tcpwm[1].tr_out0[74]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT075 = 653, //!< tcpwm[1].tr_out0[75]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT076 = 654, //!< tcpwm[1].tr_out0[76]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT077 = 655, //!< tcpwm[1].tr_out0[77]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT078 = 656, //!< tcpwm[1].tr_out0[78]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT079 = 657, //!< tcpwm[1].tr_out0[79]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT080 = 658, //!< tcpwm[1].tr_out0[80]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT081 = 659, //!< tcpwm[1].tr_out0[81]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT082 = 660, //!< tcpwm[1].tr_out0[82]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT083 = 661, //!< tcpwm[1].tr_out0[83]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0256 = 662, //!< tcpwm[1].tr_out0[256]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0257 = 663, //!< tcpwm[1].tr_out0[257]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0258 = 664, //!< tcpwm[1].tr_out0[258]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0259 = 665, //!< tcpwm[1].tr_out0[259]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0260 = 666, //!< tcpwm[1].tr_out0[260]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0261 = 667, //!< tcpwm[1].tr_out0[261]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0262 = 668, //!< tcpwm[1].tr_out0[262]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0263 = 669, //!< tcpwm[1].tr_out0[263]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0264 = 670, //!< tcpwm[1].tr_out0[264]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0265 = 671, //!< tcpwm[1].tr_out0[265]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0266 = 672, //!< tcpwm[1].tr_out0[266]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0267 = 673, //!< tcpwm[1].tr_out0[267]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0512 = 674, //!< tcpwm[1].tr_out0[512]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0513 = 675, //!< tcpwm[1].tr_out0[513]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0514 = 676, //!< tcpwm[1].tr_out0[514]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0515 = 677, //!< tcpwm[1].tr_out0[515]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0516 = 678, //!< tcpwm[1].tr_out0[516]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0517 = 679, //!< tcpwm[1].tr_out0[517]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0518 = 680, //!< tcpwm[1].tr_out0[518]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0519 = 681, //!< tcpwm[1].tr_out0[519]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0520 = 682, //!< tcpwm[1].tr_out0[520]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0521 = 683, //!< tcpwm[1].tr_out0[521]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0522 = 684, //!< tcpwm[1].tr_out0[522]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0523 = 685, //!< tcpwm[1].tr_out0[523]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT0524 = 686, //!< tcpwm[1].tr_out0[524]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT10 = 687, //!< tcpwm[0].tr_out1[0]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT11 = 688, //!< tcpwm[0].tr_out1[1]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT12 = 689, //!< tcpwm[0].tr_out1[2]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1256 = 690, //!< tcpwm[0].tr_out1[256]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1257 = 691, //!< tcpwm[0].tr_out1[257]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1258 = 692, //!< tcpwm[0].tr_out1[258]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1512 = 693, //!< tcpwm[0].tr_out1[512]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1513 = 694, //!< tcpwm[0].tr_out1[513]
    _CYHAL_TRIGGER_TCPWM0_TR_OUT1514 = 695, //!< tcpwm[0].tr_out1[514]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT10 = 696, //!< tcpwm[1].tr_out1[0]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT11 = 697, //!< tcpwm[1].tr_out1[1]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT12 = 698, //!< tcpwm[1].tr_out1[2]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT13 = 699, //!< tcpwm[1].tr_out1[3]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT14 = 700, //!< tcpwm[1].tr_out1[4]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT15 = 701, //!< tcpwm[1].tr_out1[5]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT16 = 702, //!< tcpwm[1].tr_out1[6]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT17 = 703, //!< tcpwm[1].tr_out1[7]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT18 = 704, //!< tcpwm[1].tr_out1[8]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT19 = 705, //!< tcpwm[1].tr_out1[9]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT110 = 706, //!< tcpwm[1].tr_out1[10]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT111 = 707, //!< tcpwm[1].tr_out1[11]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT112 = 708, //!< tcpwm[1].tr_out1[12]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT113 = 709, //!< tcpwm[1].tr_out1[13]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT114 = 710, //!< tcpwm[1].tr_out1[14]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT115 = 711, //!< tcpwm[1].tr_out1[15]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT116 = 712, //!< tcpwm[1].tr_out1[16]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT117 = 713, //!< tcpwm[1].tr_out1[17]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT118 = 714, //!< tcpwm[1].tr_out1[18]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT119 = 715, //!< tcpwm[1].tr_out1[19]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT120 = 716, //!< tcpwm[1].tr_out1[20]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT121 = 717, //!< tcpwm[1].tr_out1[21]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT122 = 718, //!< tcpwm[1].tr_out1[22]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT123 = 719, //!< tcpwm[1].tr_out1[23]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT124 = 720, //!< tcpwm[1].tr_out1[24]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT125 = 721, //!< tcpwm[1].tr_out1[25]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT126 = 722, //!< tcpwm[1].tr_out1[26]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT127 = 723, //!< tcpwm[1].tr_out1[27]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT128 = 724, //!< tcpwm[1].tr_out1[28]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT129 = 725, //!< tcpwm[1].tr_out1[29]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT130 = 726, //!< tcpwm[1].tr_out1[30]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT131 = 727, //!< tcpwm[1].tr_out1[31]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT132 = 728, //!< tcpwm[1].tr_out1[32]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT133 = 729, //!< tcpwm[1].tr_out1[33]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT134 = 730, //!< tcpwm[1].tr_out1[34]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT135 = 731, //!< tcpwm[1].tr_out1[35]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT136 = 732, //!< tcpwm[1].tr_out1[36]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT137 = 733, //!< tcpwm[1].tr_out1[37]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT138 = 734, //!< tcpwm[1].tr_out1[38]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT139 = 735, //!< tcpwm[1].tr_out1[39]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT140 = 736, //!< tcpwm[1].tr_out1[40]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT141 = 737, //!< tcpwm[1].tr_out1[41]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT142 = 738, //!< tcpwm[1].tr_out1[42]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT143 = 739, //!< tcpwm[1].tr_out1[43]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT144 = 740, //!< tcpwm[1].tr_out1[44]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT145 = 741, //!< tcpwm[1].tr_out1[45]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT146 = 742, //!< tcpwm[1].tr_out1[46]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT147 = 743, //!< tcpwm[1].tr_out1[47]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT148 = 744, //!< tcpwm[1].tr_out1[48]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT149 = 745, //!< tcpwm[1].tr_out1[49]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT150 = 746, //!< tcpwm[1].tr_out1[50]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT151 = 747, //!< tcpwm[1].tr_out1[51]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT152 = 748, //!< tcpwm[1].tr_out1[52]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT153 = 749, //!< tcpwm[1].tr_out1[53]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT154 = 750, //!< tcpwm[1].tr_out1[54]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT155 = 751, //!< tcpwm[1].tr_out1[55]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT156 = 752, //!< tcpwm[1].tr_out1[56]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT157 = 753, //!< tcpwm[1].tr_out1[57]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT158 = 754, //!< tcpwm[1].tr_out1[58]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT159 = 755, //!< tcpwm[1].tr_out1[59]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT160 = 756, //!< tcpwm[1].tr_out1[60]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT161 = 757, //!< tcpwm[1].tr_out1[61]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT162 = 758, //!< tcpwm[1].tr_out1[62]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT163 = 759, //!< tcpwm[1].tr_out1[63]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT164 = 760, //!< tcpwm[1].tr_out1[64]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT165 = 761, //!< tcpwm[1].tr_out1[65]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT166 = 762, //!< tcpwm[1].tr_out1[66]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT167 = 763, //!< tcpwm[1].tr_out1[67]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT168 = 764, //!< tcpwm[1].tr_out1[68]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT169 = 765, //!< tcpwm[1].tr_out1[69]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT170 = 766, //!< tcpwm[1].tr_out1[70]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT171 = 767, //!< tcpwm[1].tr_out1[71]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT172 = 768, //!< tcpwm[1].tr_out1[72]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT173 = 769, //!< tcpwm[1].tr_out1[73]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT174 = 770, //!< tcpwm[1].tr_out1[74]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT175 = 771, //!< tcpwm[1].tr_out1[75]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT176 = 772, //!< tcpwm[1].tr_out1[76]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT177 = 773, //!< tcpwm[1].tr_out1[77]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT178 = 774, //!< tcpwm[1].tr_out1[78]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT179 = 775, //!< tcpwm[1].tr_out1[79]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT180 = 776, //!< tcpwm[1].tr_out1[80]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT181 = 777, //!< tcpwm[1].tr_out1[81]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT182 = 778, //!< tcpwm[1].tr_out1[82]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT183 = 779, //!< tcpwm[1].tr_out1[83]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1256 = 780, //!< tcpwm[1].tr_out1[256]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1257 = 781, //!< tcpwm[1].tr_out1[257]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1258 = 782, //!< tcpwm[1].tr_out1[258]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1259 = 783, //!< tcpwm[1].tr_out1[259]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1260 = 784, //!< tcpwm[1].tr_out1[260]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1261 = 785, //!< tcpwm[1].tr_out1[261]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1262 = 786, //!< tcpwm[1].tr_out1[262]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1263 = 787, //!< tcpwm[1].tr_out1[263]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1264 = 788, //!< tcpwm[1].tr_out1[264]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1265 = 789, //!< tcpwm[1].tr_out1[265]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1266 = 790, //!< tcpwm[1].tr_out1[266]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1267 = 791, //!< tcpwm[1].tr_out1[267]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1512 = 792, //!< tcpwm[1].tr_out1[512]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1513 = 793, //!< tcpwm[1].tr_out1[513]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1514 = 794, //!< tcpwm[1].tr_out1[514]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1515 = 795, //!< tcpwm[1].tr_out1[515]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1516 = 796, //!< tcpwm[1].tr_out1[516]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1517 = 797, //!< tcpwm[1].tr_out1[517]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1518 = 798, //!< tcpwm[1].tr_out1[518]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1519 = 799, //!< tcpwm[1].tr_out1[519]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1520 = 800, //!< tcpwm[1].tr_out1[520]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1521 = 801, //!< tcpwm[1].tr_out1[521]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1522 = 802, //!< tcpwm[1].tr_out1[522]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1523 = 803, //!< tcpwm[1].tr_out1[523]
    _CYHAL_TRIGGER_TCPWM1_TR_OUT1524 = 804, //!< tcpwm[1].tr_out1[524]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT0 = 805, //!< tr_group[10].output[0]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT1 = 806, //!< tr_group[10].output[1]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT2 = 807, //!< tr_group[10].output[2]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT3 = 808, //!< tr_group[10].output[3]
    _CYHAL_TRIGGER_TR_GROUP10_OUTPUT4 = 809, //!< tr_group[10].output[4]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT0 = 810, //!< tr_group[11].output[0]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT1 = 811, //!< tr_group[11].output[1]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT2 = 812, //!< tr_group[11].output[2]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT3 = 813, //!< tr_group[11].output[3]
    _CYHAL_TRIGGER_TR_GROUP11_OUTPUT4 = 814, //!< tr_group[11].output[4]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT0 = 815, //!< tr_group[12].output[0]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT1 = 816, //!< tr_group[12].output[1]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT2 = 817, //!< tr_group[12].output[2]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT3 = 818, //!< tr_group[12].output[3]
    _CYHAL_TRIGGER_TR_GROUP12_OUTPUT4 = 819, //!< tr_group[12].output[4]
} _cyhal_trigger_source_xmc7200_t;

/** Typedef for internal device family specific trigger source to generic trigger source */
typedef _cyhal_trigger_source_xmc7200_t cyhal_internal_source_t;

/** @brief Get a public source signal type (cyhal_trigger_source_xmc7200_t) given an internal source signal and signal type */
#define _CYHAL_TRIGGER_CREATE_SOURCE(src, type)    ((src) << 1 | (type))
/** @brief Get an internal source signal (_cyhal_trigger_source_xmc7200_t) given a public source signal. */
#define _CYHAL_TRIGGER_GET_SOURCE_SIGNAL(src)      ((cyhal_internal_source_t)((src) >> 1))
/** @brief Get the signal type (cyhal_signal_type_t) given a public source signal. */
#define _CYHAL_TRIGGER_GET_SOURCE_TYPE(src)        ((cyhal_signal_type_t)((src) & 1))
/** \endcond */

/** @brief Name of each input trigger. */
typedef enum
{
    CYHAL_TRIGGER_CPUSS_ZERO_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_ZERO, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.zero
    CYHAL_TRIGGER_CPUSS_ZERO_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_ZERO, CYHAL_SIGNAL_TYPE_LEVEL), //!< cpuss.zero
    CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS0_TR_I2S_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss[0].tr_i2s_rx_req
    CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS1_TR_I2S_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss[1].tr_i2s_rx_req
    CYHAL_TRIGGER_AUDIOSS2_TR_I2S_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS2_TR_I2S_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss[2].tr_i2s_rx_req
    CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS0_TR_I2S_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss[0].tr_i2s_tx_req
    CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS1_TR_I2S_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss[1].tr_i2s_tx_req
    CYHAL_TRIGGER_AUDIOSS2_TR_I2S_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_AUDIOSS2_TR_I2S_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< audioss[2].tr_i2s_tx_req
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ0, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_dbg_dma_req[0]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ1, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_dbg_dma_req[1]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ2, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_dbg_dma_req[2]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ3, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_dbg_dma_req[3]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_REQ4, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_dbg_dma_req[4]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ0, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_dbg_dma_req[0]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ1, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_dbg_dma_req[1]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ2, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_dbg_dma_req[2]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ3, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_dbg_dma_req[3]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_REQ4, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_dbg_dma_req[4]
    CYHAL_TRIGGER_CANFD0_TR_FIFO00 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO00, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo0[0]
    CYHAL_TRIGGER_CANFD0_TR_FIFO01 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO01, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo0[1]
    CYHAL_TRIGGER_CANFD0_TR_FIFO02 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO02, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo0[2]
    CYHAL_TRIGGER_CANFD0_TR_FIFO03 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO03, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo0[3]
    CYHAL_TRIGGER_CANFD0_TR_FIFO04 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO04, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo0[4]
    CYHAL_TRIGGER_CANFD1_TR_FIFO00 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO00, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo0[0]
    CYHAL_TRIGGER_CANFD1_TR_FIFO01 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO01, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo0[1]
    CYHAL_TRIGGER_CANFD1_TR_FIFO02 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO02, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo0[2]
    CYHAL_TRIGGER_CANFD1_TR_FIFO03 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO03, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo0[3]
    CYHAL_TRIGGER_CANFD1_TR_FIFO04 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO04, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo0[4]
    CYHAL_TRIGGER_CANFD0_TR_FIFO10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO10, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo1[0]
    CYHAL_TRIGGER_CANFD0_TR_FIFO11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO11, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo1[1]
    CYHAL_TRIGGER_CANFD0_TR_FIFO12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO12, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo1[2]
    CYHAL_TRIGGER_CANFD0_TR_FIFO13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO13, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo1[3]
    CYHAL_TRIGGER_CANFD0_TR_FIFO14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_FIFO14, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[0].tr_fifo1[4]
    CYHAL_TRIGGER_CANFD1_TR_FIFO10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO10, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo1[0]
    CYHAL_TRIGGER_CANFD1_TR_FIFO11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO11, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo1[1]
    CYHAL_TRIGGER_CANFD1_TR_FIFO12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO12, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo1[2]
    CYHAL_TRIGGER_CANFD1_TR_FIFO13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO13, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo1[3]
    CYHAL_TRIGGER_CANFD1_TR_FIFO14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_FIFO14, CYHAL_SIGNAL_TYPE_LEVEL), //!< canfd[1].tr_fifo1[4]
    CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[0].tr_tmp_rtp_out[0]
    CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[0].tr_tmp_rtp_out[1]
    CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[0].tr_tmp_rtp_out[2]
    CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[0].tr_tmp_rtp_out[3]
    CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD0_TR_TMP_RTP_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[0].tr_tmp_rtp_out[4]
    CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[1].tr_tmp_rtp_out[0]
    CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[1].tr_tmp_rtp_out[1]
    CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[1].tr_tmp_rtp_out[2]
    CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[1].tr_tmp_rtp_out[3]
    CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CANFD1_TR_TMP_RTP_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< canfd[1].tr_tmp_rtp_out[4]
    CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_CTI_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.cti_tr_out[0]
    CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_CTI_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.cti_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[0]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[2]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[3]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[4]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[5]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[6]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DMAC_TR_OUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dmac_tr_out[7]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[0]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[2]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[3]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[4]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[5]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[6]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[7]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[8]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[9]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[10]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[11]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[12]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[13]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[14]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[15]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT16, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[16]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT17, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[17]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT18, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[18]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT19, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[19]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT20, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[20]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT21, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[21]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT22, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[22]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT23, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[23]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT24, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[24]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT25, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[25]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT26, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[26]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT27, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[27]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT28, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[28]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT29, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[29]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT30, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[30]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT31, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[31]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT32 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT32, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[32]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT33 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT33, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[33]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT34 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT34, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[34]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT35 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT35, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[35]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT36 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT36, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[36]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT37 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT37, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[37]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT38 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT38, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[38]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT39 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT39, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[39]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT40 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT40, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[40]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT41 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT41, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[41]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT42 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT42, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[42]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT43 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT43, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[43]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT44 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT44, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[44]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT45 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT45, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[45]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT46 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT46, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[46]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT47 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT47, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[47]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT48 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT48, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[48]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT49 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT49, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[49]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT50 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT50, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[50]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT51 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT51, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[51]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT52 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT52, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[52]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT53 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT53, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[53]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT54 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT54, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[54]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT55 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT55, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[55]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT56 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT56, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[56]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT57 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT57, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[57]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT58 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT58, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[58]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT59 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT59, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[59]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT60 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT60, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[60]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT61 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT61, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[61]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT62 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT62, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[62]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT63 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT63, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[63]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT64 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT64, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[64]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT65 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT65, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[65]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT66 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT66, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[66]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT67 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT67, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[67]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT68 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT68, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[68]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT69 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT69, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[69]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT70 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT70, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[70]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT71 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT71, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[71]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT72 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT72, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[72]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT73 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT73, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[73]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT74 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT74, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[74]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT75 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT75, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[75]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT76 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT76, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[76]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT77 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT77, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[77]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT78 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT78, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[78]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT79 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT79, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[79]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT80 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT80, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[80]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT81 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT81, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[81]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT82 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT82, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[82]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT83 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT83, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[83]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT84 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT84, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[84]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT85 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT85, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[85]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT86 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT86, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[86]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT87 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT87, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[87]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT88 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT88, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[88]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT89 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT89, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[89]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT90 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT90, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[90]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT91 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT91, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[91]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT92 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT92, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[92]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT93 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT93, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[93]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT94 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT94, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[94]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT95 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT95, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[95]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT96 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT96, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[96]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT97 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT97, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[97]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT98 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT98, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[98]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT99 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT99, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[99]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT100 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT100, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[100]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT101 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT101, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[101]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT102 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT102, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[102]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT103 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT103, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[103]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT104 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT104, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[104]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT105 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT105, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[105]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT106 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT106, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[106]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT107 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT107, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[107]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT108 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT108, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[108]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT109 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT109, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[109]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT110 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT110, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[110]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT111 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT111, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[111]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT112 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT112, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[112]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT113 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT113, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[113]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT114 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT114, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[114]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT115 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT115, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[115]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT116 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT116, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[116]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT117 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT117, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[117]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT118 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT118, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[118]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT119 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT119, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[119]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT120 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT120, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[120]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT121 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT121, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[121]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT122 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT122, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[122]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT123 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT123, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[123]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT124 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT124, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[124]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT125 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT125, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[125]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT126 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT126, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[126]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT127 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT127, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[127]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT128 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT128, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[128]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT129 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT129, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[129]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT130 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT130, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[130]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT131 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT131, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[131]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT132 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT132, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[132]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT133 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT133, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[133]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT134 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT134, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[134]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT135 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT135, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[135]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT136 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT136, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[136]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT137 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT137, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[137]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT138 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT138, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[138]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT139 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT139, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[139]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT140 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT140, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[140]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT141 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT141, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[141]
    CYHAL_TRIGGER_CPUSS_DW0_TR_OUT142 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW0_TR_OUT142, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw0_tr_out[142]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[0]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[1]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[2]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[3]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[4]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[5]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[6]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[7]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[8]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[9]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[10]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[11]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[12]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[13]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[14]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[15]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT16, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[16]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT17, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[17]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT18, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[18]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT19, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[19]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT20, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[20]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT21, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[21]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT22, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[22]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT23, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[23]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT24, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[24]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT25, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[25]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT26, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[26]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT27, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[27]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT28, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[28]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT29, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[29]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT30 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT30, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[30]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT31 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT31, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[31]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT32 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT32, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[32]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT33 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT33, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[33]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT34 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT34, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[34]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT35 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT35, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[35]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT36 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT36, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[36]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT37 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT37, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[37]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT38 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT38, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[38]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT39 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT39, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[39]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT40 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT40, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[40]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT41 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT41, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[41]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT42 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT42, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[42]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT43 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT43, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[43]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT44 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT44, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[44]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT45 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT45, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[45]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT46 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT46, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[46]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT47 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT47, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[47]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT48 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT48, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[48]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT49 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT49, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[49]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT50 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT50, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[50]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT51 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT51, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[51]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT52 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT52, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[52]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT53 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT53, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[53]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT54 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT54, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[54]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT55 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT55, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[55]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT56 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT56, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[56]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT57 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT57, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[57]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT58 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT58, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[58]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT59 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT59, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[59]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT60 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT60, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[60]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT61 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT61, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[61]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT62 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT62, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[62]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT63 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT63, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[63]
    CYHAL_TRIGGER_CPUSS_DW1_TR_OUT64 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_DW1_TR_OUT64, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.dw1_tr_out[64]
    CYHAL_TRIGGER_CPUSS_TR_FAULT0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_TR_FAULT0, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.tr_fault[0]
    CYHAL_TRIGGER_CPUSS_TR_FAULT1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_TR_FAULT1, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.tr_fault[1]
    CYHAL_TRIGGER_CPUSS_TR_FAULT2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_TR_FAULT2, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.tr_fault[2]
    CYHAL_TRIGGER_CPUSS_TR_FAULT3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_CPUSS_TR_FAULT3, CYHAL_SIGNAL_TYPE_EDGE), //!< cpuss.tr_fault[3]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[0]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[0]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[1]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[1]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[2]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[2]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[3]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[3]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[4]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[4]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[5]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[5]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[6]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[6]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[7]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[7]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[8]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[8]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[9]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[9]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[10]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[10]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[11]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[11]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[12]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[12]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[13]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[13]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[14]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[14]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< evtgen[0].tr_out[15]
    CYHAL_TRIGGER_EVTGEN0_TR_OUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_EVTGEN0_TR_OUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< evtgen[0].tr_out[15]
    CYHAL_TRIGGER_FLEXRAY0_TR_IBF_OUT = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_FLEXRAY0_TR_IBF_OUT, CYHAL_SIGNAL_TYPE_EDGE), //!< flexray[0].tr_ibf_out
    CYHAL_TRIGGER_FLEXRAY0_TR_OBF_OUT = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_FLEXRAY0_TR_OBF_OUT, CYHAL_SIGNAL_TYPE_EDGE), //!< flexray[0].tr_obf_out
    CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_FLEXRAY0_TR_TINT0_OUT, CYHAL_SIGNAL_TYPE_EDGE), //!< flexray[0].tr_tint0_out
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[5]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[5]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[6]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[6]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[7]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[7]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[8]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[8]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[9]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[9]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[10]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[10]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[11]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[11]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[12]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[12]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[13]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[13]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[14]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[14]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[15]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[15]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[16]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[16]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[17]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[17]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[18]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[18]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[19]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[19]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[20]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[20]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[21]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[21]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[22]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[22]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[23]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[23]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[24]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[24]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[25]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[25]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[26]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[26]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[27]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[27]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[28]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[28]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[29]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[29]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[30]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[30]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[31]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[31]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[32]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[32]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[33]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[33]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[34]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[34]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[35]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[35]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[36]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[36]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[37]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[37]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[38]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[38]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[39]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[39]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[40]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[40]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[41]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[41]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[42]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[42]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[43]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[43]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[44]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[44]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[45]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[45]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[46]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[46]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[47]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[47]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[48]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[48]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[49]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[49]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[50]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[50]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[51]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[51]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[52]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[52]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[53]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[53]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[54]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[54]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[55]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[55]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[56]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[56]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[57]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[57]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[58]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[58]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[59]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[59]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[60]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[60]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[61]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[61]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[62]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[62]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[63]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[63]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[64]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[64]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[65]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[65]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[66]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[66]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[67]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[67]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[68]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[68]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[69]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[69]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[70]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[70]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[71]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[71]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[72]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[72]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[73]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[73]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[74]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[74]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[75]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[75]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[76]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[76]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[77]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[77]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[78]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[78]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[79]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[79]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[80]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[80]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[81]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[81]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[82]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[82]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[83]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[83]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[84]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[84]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[85]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[85]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[86]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[86]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[87]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[87]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[88]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[88]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[89]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[89]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[90]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[90]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[91]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[91]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[92]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[92]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[93]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[93]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[94]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[94]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_done[95]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_ch_done[95]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO0 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO0, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO1 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO1, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO2 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO2, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO3 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO3, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO4 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO4, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO5 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO5, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[5]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO6 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO6, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[6]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO7 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO7, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[7]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO8 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO8, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[8]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO9 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO9, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[9]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO10 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO10, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[10]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO11 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO11, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[11]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO12 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO12, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[12]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO13 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO13, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[13]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO14 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO14, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[14]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO15 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO15, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[15]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO16 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO16, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[16]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO17 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO17, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[17]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO18 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO18, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[18]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO19 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO19, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[19]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO20 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO20, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[20]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO21 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO21, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[21]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO22 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO22, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[22]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO23 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO23, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[23]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO24 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO24, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[24]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO25 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO25, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[25]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO26 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO26, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[26]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO27 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO27, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[27]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO28 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO28, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[28]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO29 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO29, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[29]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO30 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO30, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[30]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO31 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO31, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[31]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO32 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO32, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[32]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO33 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO33, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[33]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO34 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO34, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[34]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO35 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO35, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[35]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO36 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO36, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[36]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO37 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO37, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[37]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO38 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO38, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[38]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO39 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO39, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[39]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO40 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO40, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[40]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO41 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO41, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[41]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO42 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO42, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[42]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO43 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO43, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[43]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO44 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO44, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[44]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO45 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO45, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[45]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO46 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO46, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[46]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO47 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO47, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[47]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO48 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO48, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[48]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO49 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO49, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[49]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO50 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO50, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[50]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO51 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO51, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[51]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO52 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO52, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[52]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO53 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO53, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[53]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO54 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO54, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[54]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO55 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO55, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[55]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO56 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO56, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[56]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO57 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO57, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[57]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO58 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO58, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[58]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO59 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO59, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[59]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO60 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO60, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[60]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO61 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO61, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[61]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO62 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO62, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[62]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO63 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO63, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[63]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO64 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO64, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[64]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO65 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO65, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[65]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO66 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO66, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[66]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO67 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO67, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[67]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO68 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO68, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[68]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO69 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO69, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[69]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO70 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO70, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[70]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO71 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO71, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[71]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO72 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO72, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[72]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO73 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO73, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[73]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO74 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO74, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[74]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO75 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO75, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[75]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO76 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO76, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[76]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO77 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO77, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[77]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO78 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO78, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[78]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO79 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO79, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[79]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO80 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO80, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[80]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO81 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO81, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[81]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO82 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO82, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[82]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO83 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO83, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[83]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO84 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO84, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[84]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO85 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO85, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[85]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO86 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO86, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[86]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO87 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO87, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[87]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO88 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO88, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[88]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO89 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO89, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[89]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO90 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO90, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[90]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO91 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO91, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[91]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO92 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO92, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[92]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO93 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO93, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[93]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO94 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO94, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[94]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO95 = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_CH_RANGEVIO95, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_ch_rangevio[95]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_gen_out[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_gen_out[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_gen_out[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_gen_out[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_gen_out[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_gen_out[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_gen_out[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_gen_out[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_gen_out[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_gen_out[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< pass[0].tr_sar_gen_out[5]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< pass[0].tr_sar_gen_out[5]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[0]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[0]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[1]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[1]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[2]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[2]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[3]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[3]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[4]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[4]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT5_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT5, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[5]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT5_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT5, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[5]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT6_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT6, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[6]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT6_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT6, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[6]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT7_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT7, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[7]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT7_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT7, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[7]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT8_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT8, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[8]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT8_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT8, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[8]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT9_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT9, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[9]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT9_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT9, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[9]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[10]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[10]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[11]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[11]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[12]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[12]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[13]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[13]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[14]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[14]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[15]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[15]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT16_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT16, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[16]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT16_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT16, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[16]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT17_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT17, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[17]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT17_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT17, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[17]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT18_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT18, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[18]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT18_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT18, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[18]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT19_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT19, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[19]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT19_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT19, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[19]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT20_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT20, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[20]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT20_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT20, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[20]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT21_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT21, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[21]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT21_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT21, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[21]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT22_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT22, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[22]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT22_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT22, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[22]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT23_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT23, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[23]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT23_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT23, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[23]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT24_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT24, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[24]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT24_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT24, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[24]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT25_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT25, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[25]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT25_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT25, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[25]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT26_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT26, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[26]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT26_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT26, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[26]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT27_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT27, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[27]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT27_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT27, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[27]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT28_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT28, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[28]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT28_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT28, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[28]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT29_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT29, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[29]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT29_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT29, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[29]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT30_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT30, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[30]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT30_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT30, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[30]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT31_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT31, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[31]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT31_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT31, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[31]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT32_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT32, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[32]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT32_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT32, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[32]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT33_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT33, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[33]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT33_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT33, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[33]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT34_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT34, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[34]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT34_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT34, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[34]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT35_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT35, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[35]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT35_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT35, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[35]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT36_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT36, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[36]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT36_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT36, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[36]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT37_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT37, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[37]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT37_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT37, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[37]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT38_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT38, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[38]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT38_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT38, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[38]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT39_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT39, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[39]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT39_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT39, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[39]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT40_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT40, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[40]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT40_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT40, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[40]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT41_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT41, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[41]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT41_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT41, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[41]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT42_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT42, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[42]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT42_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT42, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[42]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT43_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT43, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[43]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT43_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT43, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[43]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT44_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT44, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[44]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT44_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT44, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[44]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT45_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT45, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[45]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT45_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT45, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[45]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT46_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT46, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[46]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT46_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT46, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[46]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT47_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT47, CYHAL_SIGNAL_TYPE_EDGE), //!< peri.tr_io_input[47]
    CYHAL_TRIGGER_PERI_TR_IO_INPUT47_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_PERI_TR_IO_INPUT47, CYHAL_SIGNAL_TYPE_LEVEL), //!< peri.tr_io_input[47]
    CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB0_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[0].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB1_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[1].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB2_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[2].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB3_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[3].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB4_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[4].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB5_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[5].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB6_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[6].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB7_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[7].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB8_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[8].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB9_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[9].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB10_TR_I2C_SCL_FILTERED, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[10].tr_i2c_scl_filtered
    CYHAL_TRIGGER_SCB0_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB0_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[0].tr_rx_req
    CYHAL_TRIGGER_SCB1_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB1_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[1].tr_rx_req
    CYHAL_TRIGGER_SCB2_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB2_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[2].tr_rx_req
    CYHAL_TRIGGER_SCB3_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB3_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[3].tr_rx_req
    CYHAL_TRIGGER_SCB4_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB4_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[4].tr_rx_req
    CYHAL_TRIGGER_SCB5_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB5_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[5].tr_rx_req
    CYHAL_TRIGGER_SCB6_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB6_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[6].tr_rx_req
    CYHAL_TRIGGER_SCB7_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB7_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[7].tr_rx_req
    CYHAL_TRIGGER_SCB8_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB8_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[8].tr_rx_req
    CYHAL_TRIGGER_SCB9_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB9_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[9].tr_rx_req
    CYHAL_TRIGGER_SCB10_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB10_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[10].tr_rx_req
    CYHAL_TRIGGER_SCB0_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB0_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[0].tr_tx_req
    CYHAL_TRIGGER_SCB1_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB1_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[1].tr_tx_req
    CYHAL_TRIGGER_SCB2_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB2_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[2].tr_tx_req
    CYHAL_TRIGGER_SCB3_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB3_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[3].tr_tx_req
    CYHAL_TRIGGER_SCB4_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB4_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[4].tr_tx_req
    CYHAL_TRIGGER_SCB5_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB5_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[5].tr_tx_req
    CYHAL_TRIGGER_SCB6_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB6_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[6].tr_tx_req
    CYHAL_TRIGGER_SCB7_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB7_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[7].tr_tx_req
    CYHAL_TRIGGER_SCB8_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB8_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[8].tr_tx_req
    CYHAL_TRIGGER_SCB9_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB9_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[9].tr_tx_req
    CYHAL_TRIGGER_SCB10_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SCB10_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< scb[10].tr_tx_req
    CYHAL_TRIGGER_SMIF0_TR_RX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SMIF0_TR_RX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< smif[0].tr_rx_req
    CYHAL_TRIGGER_SMIF0_TR_TX_REQ = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_SMIF0_TR_TX_REQ, CYHAL_SIGNAL_TYPE_LEVEL), //!< smif[0].tr_tx_req
    CYHAL_TRIGGER_TCPWM0_TR_OUT00_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT00, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[0]
    CYHAL_TRIGGER_TCPWM0_TR_OUT00_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT00, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[0]
    CYHAL_TRIGGER_TCPWM0_TR_OUT01_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT01, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[1]
    CYHAL_TRIGGER_TCPWM0_TR_OUT01_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT01, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[1]
    CYHAL_TRIGGER_TCPWM0_TR_OUT02_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT02, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[2]
    CYHAL_TRIGGER_TCPWM0_TR_OUT02_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT02, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[2]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0256_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0256, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[256]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0256_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0256, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[256]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0257_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0257, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[257]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0257_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0257, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[257]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0258_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0258, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[258]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0258_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0258, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[258]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0512_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0512, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[512]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0512_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0512, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[512]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0513_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0513, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[513]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0513_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0513, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[513]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0514_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0514, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out0[514]
    CYHAL_TRIGGER_TCPWM0_TR_OUT0514_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT0514, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out0[514]
    CYHAL_TRIGGER_TCPWM1_TR_OUT00_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT00, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[0]
    CYHAL_TRIGGER_TCPWM1_TR_OUT00_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT00, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[0]
    CYHAL_TRIGGER_TCPWM1_TR_OUT01_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT01, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[1]
    CYHAL_TRIGGER_TCPWM1_TR_OUT01_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT01, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[1]
    CYHAL_TRIGGER_TCPWM1_TR_OUT02_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT02, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[2]
    CYHAL_TRIGGER_TCPWM1_TR_OUT02_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT02, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[2]
    CYHAL_TRIGGER_TCPWM1_TR_OUT03_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT03, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[3]
    CYHAL_TRIGGER_TCPWM1_TR_OUT03_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT03, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[3]
    CYHAL_TRIGGER_TCPWM1_TR_OUT04_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT04, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[4]
    CYHAL_TRIGGER_TCPWM1_TR_OUT04_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT04, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[4]
    CYHAL_TRIGGER_TCPWM1_TR_OUT05_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT05, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[5]
    CYHAL_TRIGGER_TCPWM1_TR_OUT05_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT05, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[5]
    CYHAL_TRIGGER_TCPWM1_TR_OUT06_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT06, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[6]
    CYHAL_TRIGGER_TCPWM1_TR_OUT06_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT06, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[6]
    CYHAL_TRIGGER_TCPWM1_TR_OUT07_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT07, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[7]
    CYHAL_TRIGGER_TCPWM1_TR_OUT07_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT07, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[7]
    CYHAL_TRIGGER_TCPWM1_TR_OUT08_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT08, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[8]
    CYHAL_TRIGGER_TCPWM1_TR_OUT08_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT08, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[8]
    CYHAL_TRIGGER_TCPWM1_TR_OUT09_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT09, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[9]
    CYHAL_TRIGGER_TCPWM1_TR_OUT09_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT09, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[9]
    CYHAL_TRIGGER_TCPWM1_TR_OUT010_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT010, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[10]
    CYHAL_TRIGGER_TCPWM1_TR_OUT010_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT010, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[10]
    CYHAL_TRIGGER_TCPWM1_TR_OUT011_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT011, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[11]
    CYHAL_TRIGGER_TCPWM1_TR_OUT011_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT011, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[11]
    CYHAL_TRIGGER_TCPWM1_TR_OUT012_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT012, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[12]
    CYHAL_TRIGGER_TCPWM1_TR_OUT012_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT012, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[12]
    CYHAL_TRIGGER_TCPWM1_TR_OUT013_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT013, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[13]
    CYHAL_TRIGGER_TCPWM1_TR_OUT013_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT013, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[13]
    CYHAL_TRIGGER_TCPWM1_TR_OUT014_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT014, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[14]
    CYHAL_TRIGGER_TCPWM1_TR_OUT014_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT014, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[14]
    CYHAL_TRIGGER_TCPWM1_TR_OUT015_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT015, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[15]
    CYHAL_TRIGGER_TCPWM1_TR_OUT015_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT015, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[15]
    CYHAL_TRIGGER_TCPWM1_TR_OUT016_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT016, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[16]
    CYHAL_TRIGGER_TCPWM1_TR_OUT016_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT016, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[16]
    CYHAL_TRIGGER_TCPWM1_TR_OUT017_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT017, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[17]
    CYHAL_TRIGGER_TCPWM1_TR_OUT017_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT017, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[17]
    CYHAL_TRIGGER_TCPWM1_TR_OUT018_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT018, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[18]
    CYHAL_TRIGGER_TCPWM1_TR_OUT018_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT018, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[18]
    CYHAL_TRIGGER_TCPWM1_TR_OUT019_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT019, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[19]
    CYHAL_TRIGGER_TCPWM1_TR_OUT019_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT019, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[19]
    CYHAL_TRIGGER_TCPWM1_TR_OUT020_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT020, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[20]
    CYHAL_TRIGGER_TCPWM1_TR_OUT020_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT020, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[20]
    CYHAL_TRIGGER_TCPWM1_TR_OUT021_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT021, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[21]
    CYHAL_TRIGGER_TCPWM1_TR_OUT021_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT021, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[21]
    CYHAL_TRIGGER_TCPWM1_TR_OUT022_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT022, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[22]
    CYHAL_TRIGGER_TCPWM1_TR_OUT022_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT022, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[22]
    CYHAL_TRIGGER_TCPWM1_TR_OUT023_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT023, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[23]
    CYHAL_TRIGGER_TCPWM1_TR_OUT023_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT023, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[23]
    CYHAL_TRIGGER_TCPWM1_TR_OUT024_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT024, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[24]
    CYHAL_TRIGGER_TCPWM1_TR_OUT024_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT024, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[24]
    CYHAL_TRIGGER_TCPWM1_TR_OUT025_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT025, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[25]
    CYHAL_TRIGGER_TCPWM1_TR_OUT025_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT025, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[25]
    CYHAL_TRIGGER_TCPWM1_TR_OUT026_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT026, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[26]
    CYHAL_TRIGGER_TCPWM1_TR_OUT026_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT026, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[26]
    CYHAL_TRIGGER_TCPWM1_TR_OUT027_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT027, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[27]
    CYHAL_TRIGGER_TCPWM1_TR_OUT027_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT027, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[27]
    CYHAL_TRIGGER_TCPWM1_TR_OUT028_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT028, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[28]
    CYHAL_TRIGGER_TCPWM1_TR_OUT028_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT028, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[28]
    CYHAL_TRIGGER_TCPWM1_TR_OUT029_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT029, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[29]
    CYHAL_TRIGGER_TCPWM1_TR_OUT029_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT029, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[29]
    CYHAL_TRIGGER_TCPWM1_TR_OUT030_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT030, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[30]
    CYHAL_TRIGGER_TCPWM1_TR_OUT030_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT030, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[30]
    CYHAL_TRIGGER_TCPWM1_TR_OUT031_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT031, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[31]
    CYHAL_TRIGGER_TCPWM1_TR_OUT031_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT031, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[31]
    CYHAL_TRIGGER_TCPWM1_TR_OUT032_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT032, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[32]
    CYHAL_TRIGGER_TCPWM1_TR_OUT032_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT032, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[32]
    CYHAL_TRIGGER_TCPWM1_TR_OUT033_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT033, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[33]
    CYHAL_TRIGGER_TCPWM1_TR_OUT033_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT033, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[33]
    CYHAL_TRIGGER_TCPWM1_TR_OUT034_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT034, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[34]
    CYHAL_TRIGGER_TCPWM1_TR_OUT034_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT034, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[34]
    CYHAL_TRIGGER_TCPWM1_TR_OUT035_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT035, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[35]
    CYHAL_TRIGGER_TCPWM1_TR_OUT035_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT035, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[35]
    CYHAL_TRIGGER_TCPWM1_TR_OUT036_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT036, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[36]
    CYHAL_TRIGGER_TCPWM1_TR_OUT036_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT036, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[36]
    CYHAL_TRIGGER_TCPWM1_TR_OUT037_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT037, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[37]
    CYHAL_TRIGGER_TCPWM1_TR_OUT037_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT037, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[37]
    CYHAL_TRIGGER_TCPWM1_TR_OUT038_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT038, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[38]
    CYHAL_TRIGGER_TCPWM1_TR_OUT038_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT038, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[38]
    CYHAL_TRIGGER_TCPWM1_TR_OUT039_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT039, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[39]
    CYHAL_TRIGGER_TCPWM1_TR_OUT039_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT039, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[39]
    CYHAL_TRIGGER_TCPWM1_TR_OUT040_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT040, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[40]
    CYHAL_TRIGGER_TCPWM1_TR_OUT040_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT040, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[40]
    CYHAL_TRIGGER_TCPWM1_TR_OUT041_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT041, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[41]
    CYHAL_TRIGGER_TCPWM1_TR_OUT041_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT041, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[41]
    CYHAL_TRIGGER_TCPWM1_TR_OUT042_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT042, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[42]
    CYHAL_TRIGGER_TCPWM1_TR_OUT042_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT042, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[42]
    CYHAL_TRIGGER_TCPWM1_TR_OUT043_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT043, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[43]
    CYHAL_TRIGGER_TCPWM1_TR_OUT043_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT043, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[43]
    CYHAL_TRIGGER_TCPWM1_TR_OUT044_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT044, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[44]
    CYHAL_TRIGGER_TCPWM1_TR_OUT044_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT044, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[44]
    CYHAL_TRIGGER_TCPWM1_TR_OUT045_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT045, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[45]
    CYHAL_TRIGGER_TCPWM1_TR_OUT045_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT045, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[45]
    CYHAL_TRIGGER_TCPWM1_TR_OUT046_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT046, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[46]
    CYHAL_TRIGGER_TCPWM1_TR_OUT046_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT046, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[46]
    CYHAL_TRIGGER_TCPWM1_TR_OUT047_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT047, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[47]
    CYHAL_TRIGGER_TCPWM1_TR_OUT047_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT047, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[47]
    CYHAL_TRIGGER_TCPWM1_TR_OUT048_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT048, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[48]
    CYHAL_TRIGGER_TCPWM1_TR_OUT048_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT048, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[48]
    CYHAL_TRIGGER_TCPWM1_TR_OUT049_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT049, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[49]
    CYHAL_TRIGGER_TCPWM1_TR_OUT049_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT049, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[49]
    CYHAL_TRIGGER_TCPWM1_TR_OUT050_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT050, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[50]
    CYHAL_TRIGGER_TCPWM1_TR_OUT050_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT050, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[50]
    CYHAL_TRIGGER_TCPWM1_TR_OUT051_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT051, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[51]
    CYHAL_TRIGGER_TCPWM1_TR_OUT051_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT051, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[51]
    CYHAL_TRIGGER_TCPWM1_TR_OUT052_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT052, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[52]
    CYHAL_TRIGGER_TCPWM1_TR_OUT052_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT052, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[52]
    CYHAL_TRIGGER_TCPWM1_TR_OUT053_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT053, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[53]
    CYHAL_TRIGGER_TCPWM1_TR_OUT053_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT053, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[53]
    CYHAL_TRIGGER_TCPWM1_TR_OUT054_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT054, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[54]
    CYHAL_TRIGGER_TCPWM1_TR_OUT054_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT054, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[54]
    CYHAL_TRIGGER_TCPWM1_TR_OUT055_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT055, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[55]
    CYHAL_TRIGGER_TCPWM1_TR_OUT055_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT055, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[55]
    CYHAL_TRIGGER_TCPWM1_TR_OUT056_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT056, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[56]
    CYHAL_TRIGGER_TCPWM1_TR_OUT056_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT056, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[56]
    CYHAL_TRIGGER_TCPWM1_TR_OUT057_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT057, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[57]
    CYHAL_TRIGGER_TCPWM1_TR_OUT057_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT057, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[57]
    CYHAL_TRIGGER_TCPWM1_TR_OUT058_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT058, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[58]
    CYHAL_TRIGGER_TCPWM1_TR_OUT058_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT058, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[58]
    CYHAL_TRIGGER_TCPWM1_TR_OUT059_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT059, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[59]
    CYHAL_TRIGGER_TCPWM1_TR_OUT059_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT059, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[59]
    CYHAL_TRIGGER_TCPWM1_TR_OUT060_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT060, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[60]
    CYHAL_TRIGGER_TCPWM1_TR_OUT060_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT060, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[60]
    CYHAL_TRIGGER_TCPWM1_TR_OUT061_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT061, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[61]
    CYHAL_TRIGGER_TCPWM1_TR_OUT061_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT061, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[61]
    CYHAL_TRIGGER_TCPWM1_TR_OUT062_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT062, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[62]
    CYHAL_TRIGGER_TCPWM1_TR_OUT062_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT062, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[62]
    CYHAL_TRIGGER_TCPWM1_TR_OUT063_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT063, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[63]
    CYHAL_TRIGGER_TCPWM1_TR_OUT063_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT063, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[63]
    CYHAL_TRIGGER_TCPWM1_TR_OUT064_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT064, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[64]
    CYHAL_TRIGGER_TCPWM1_TR_OUT064_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT064, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[64]
    CYHAL_TRIGGER_TCPWM1_TR_OUT065_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT065, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[65]
    CYHAL_TRIGGER_TCPWM1_TR_OUT065_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT065, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[65]
    CYHAL_TRIGGER_TCPWM1_TR_OUT066_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT066, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[66]
    CYHAL_TRIGGER_TCPWM1_TR_OUT066_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT066, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[66]
    CYHAL_TRIGGER_TCPWM1_TR_OUT067_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT067, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[67]
    CYHAL_TRIGGER_TCPWM1_TR_OUT067_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT067, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[67]
    CYHAL_TRIGGER_TCPWM1_TR_OUT068_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT068, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[68]
    CYHAL_TRIGGER_TCPWM1_TR_OUT068_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT068, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[68]
    CYHAL_TRIGGER_TCPWM1_TR_OUT069_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT069, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[69]
    CYHAL_TRIGGER_TCPWM1_TR_OUT069_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT069, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[69]
    CYHAL_TRIGGER_TCPWM1_TR_OUT070_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT070, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[70]
    CYHAL_TRIGGER_TCPWM1_TR_OUT070_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT070, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[70]
    CYHAL_TRIGGER_TCPWM1_TR_OUT071_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT071, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[71]
    CYHAL_TRIGGER_TCPWM1_TR_OUT071_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT071, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[71]
    CYHAL_TRIGGER_TCPWM1_TR_OUT072_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT072, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[72]
    CYHAL_TRIGGER_TCPWM1_TR_OUT072_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT072, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[72]
    CYHAL_TRIGGER_TCPWM1_TR_OUT073_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT073, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[73]
    CYHAL_TRIGGER_TCPWM1_TR_OUT073_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT073, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[73]
    CYHAL_TRIGGER_TCPWM1_TR_OUT074_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT074, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[74]
    CYHAL_TRIGGER_TCPWM1_TR_OUT074_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT074, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[74]
    CYHAL_TRIGGER_TCPWM1_TR_OUT075_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT075, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[75]
    CYHAL_TRIGGER_TCPWM1_TR_OUT075_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT075, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[75]
    CYHAL_TRIGGER_TCPWM1_TR_OUT076_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT076, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[76]
    CYHAL_TRIGGER_TCPWM1_TR_OUT076_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT076, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[76]
    CYHAL_TRIGGER_TCPWM1_TR_OUT077_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT077, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[77]
    CYHAL_TRIGGER_TCPWM1_TR_OUT077_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT077, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[77]
    CYHAL_TRIGGER_TCPWM1_TR_OUT078_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT078, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[78]
    CYHAL_TRIGGER_TCPWM1_TR_OUT078_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT078, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[78]
    CYHAL_TRIGGER_TCPWM1_TR_OUT079_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT079, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[79]
    CYHAL_TRIGGER_TCPWM1_TR_OUT079_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT079, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[79]
    CYHAL_TRIGGER_TCPWM1_TR_OUT080_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT080, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[80]
    CYHAL_TRIGGER_TCPWM1_TR_OUT080_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT080, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[80]
    CYHAL_TRIGGER_TCPWM1_TR_OUT081_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT081, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[81]
    CYHAL_TRIGGER_TCPWM1_TR_OUT081_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT081, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[81]
    CYHAL_TRIGGER_TCPWM1_TR_OUT082_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT082, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[82]
    CYHAL_TRIGGER_TCPWM1_TR_OUT082_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT082, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[82]
    CYHAL_TRIGGER_TCPWM1_TR_OUT083_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT083, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[83]
    CYHAL_TRIGGER_TCPWM1_TR_OUT083_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT083, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[83]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0256_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0256, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[256]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0256_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0256, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[256]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0257_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0257, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[257]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0257_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0257, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[257]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0258_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0258, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[258]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0258_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0258, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[258]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0259_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0259, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[259]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0259_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0259, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[259]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0260_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0260, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[260]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0260_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0260, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[260]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0261_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0261, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[261]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0261_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0261, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[261]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0262_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0262, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[262]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0262_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0262, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[262]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0263_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0263, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[263]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0263_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0263, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[263]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0264_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0264, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[264]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0264_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0264, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[264]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0265_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0265, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[265]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0265_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0265, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[265]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0266_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0266, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[266]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0266_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0266, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[266]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0267_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0267, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[267]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0267_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0267, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[267]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0512_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0512, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[512]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0512_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0512, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[512]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0513_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0513, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[513]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0513_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0513, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[513]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0514_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0514, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[514]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0514_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0514, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[514]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0515_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0515, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[515]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0515_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0515, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[515]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0516_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0516, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[516]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0516_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0516, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[516]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0517_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0517, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[517]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0517_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0517, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[517]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0518_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0518, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[518]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0518_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0518, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[518]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0519_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0519, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[519]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0519_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0519, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[519]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0520_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0520, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[520]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0520_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0520, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[520]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0521_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0521, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[521]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0521_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0521, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[521]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0522_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0522, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[522]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0522_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0522, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[522]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0523_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0523, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[523]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0523_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0523, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[523]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0524_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0524, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out0[524]
    CYHAL_TRIGGER_TCPWM1_TR_OUT0524_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT0524, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out0[524]
    CYHAL_TRIGGER_TCPWM0_TR_OUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[0]
    CYHAL_TRIGGER_TCPWM0_TR_OUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[0]
    CYHAL_TRIGGER_TCPWM0_TR_OUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[1]
    CYHAL_TRIGGER_TCPWM0_TR_OUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[1]
    CYHAL_TRIGGER_TCPWM0_TR_OUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[2]
    CYHAL_TRIGGER_TCPWM0_TR_OUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[2]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1256_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1256, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[256]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1256_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1256, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[256]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1257_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1257, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[257]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1257_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1257, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[257]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1258_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1258, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[258]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1258_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1258, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[258]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1512_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1512, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[512]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1512_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1512, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[512]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1513_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1513, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[513]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1513_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1513, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[513]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1514_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1514, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[0].tr_out1[514]
    CYHAL_TRIGGER_TCPWM0_TR_OUT1514_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM0_TR_OUT1514, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[0].tr_out1[514]
    CYHAL_TRIGGER_TCPWM1_TR_OUT10_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT10, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[0]
    CYHAL_TRIGGER_TCPWM1_TR_OUT10_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT10, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[0]
    CYHAL_TRIGGER_TCPWM1_TR_OUT11_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT11, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[1]
    CYHAL_TRIGGER_TCPWM1_TR_OUT11_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT11, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[1]
    CYHAL_TRIGGER_TCPWM1_TR_OUT12_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT12, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[2]
    CYHAL_TRIGGER_TCPWM1_TR_OUT12_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT12, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[2]
    CYHAL_TRIGGER_TCPWM1_TR_OUT13_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT13, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[3]
    CYHAL_TRIGGER_TCPWM1_TR_OUT13_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT13, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[3]
    CYHAL_TRIGGER_TCPWM1_TR_OUT14_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT14, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[4]
    CYHAL_TRIGGER_TCPWM1_TR_OUT14_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT14, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[4]
    CYHAL_TRIGGER_TCPWM1_TR_OUT15_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT15, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[5]
    CYHAL_TRIGGER_TCPWM1_TR_OUT15_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT15, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[5]
    CYHAL_TRIGGER_TCPWM1_TR_OUT16_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT16, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[6]
    CYHAL_TRIGGER_TCPWM1_TR_OUT16_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT16, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[6]
    CYHAL_TRIGGER_TCPWM1_TR_OUT17_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT17, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[7]
    CYHAL_TRIGGER_TCPWM1_TR_OUT17_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT17, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[7]
    CYHAL_TRIGGER_TCPWM1_TR_OUT18_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT18, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[8]
    CYHAL_TRIGGER_TCPWM1_TR_OUT18_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT18, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[8]
    CYHAL_TRIGGER_TCPWM1_TR_OUT19_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT19, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[9]
    CYHAL_TRIGGER_TCPWM1_TR_OUT19_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT19, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[9]
    CYHAL_TRIGGER_TCPWM1_TR_OUT110_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT110, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[10]
    CYHAL_TRIGGER_TCPWM1_TR_OUT110_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT110, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[10]
    CYHAL_TRIGGER_TCPWM1_TR_OUT111_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT111, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[11]
    CYHAL_TRIGGER_TCPWM1_TR_OUT111_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT111, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[11]
    CYHAL_TRIGGER_TCPWM1_TR_OUT112_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT112, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[12]
    CYHAL_TRIGGER_TCPWM1_TR_OUT112_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT112, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[12]
    CYHAL_TRIGGER_TCPWM1_TR_OUT113_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT113, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[13]
    CYHAL_TRIGGER_TCPWM1_TR_OUT113_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT113, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[13]
    CYHAL_TRIGGER_TCPWM1_TR_OUT114_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT114, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[14]
    CYHAL_TRIGGER_TCPWM1_TR_OUT114_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT114, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[14]
    CYHAL_TRIGGER_TCPWM1_TR_OUT115_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT115, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[15]
    CYHAL_TRIGGER_TCPWM1_TR_OUT115_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT115, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[15]
    CYHAL_TRIGGER_TCPWM1_TR_OUT116_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT116, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[16]
    CYHAL_TRIGGER_TCPWM1_TR_OUT116_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT116, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[16]
    CYHAL_TRIGGER_TCPWM1_TR_OUT117_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT117, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[17]
    CYHAL_TRIGGER_TCPWM1_TR_OUT117_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT117, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[17]
    CYHAL_TRIGGER_TCPWM1_TR_OUT118_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT118, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[18]
    CYHAL_TRIGGER_TCPWM1_TR_OUT118_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT118, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[18]
    CYHAL_TRIGGER_TCPWM1_TR_OUT119_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT119, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[19]
    CYHAL_TRIGGER_TCPWM1_TR_OUT119_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT119, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[19]
    CYHAL_TRIGGER_TCPWM1_TR_OUT120_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT120, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[20]
    CYHAL_TRIGGER_TCPWM1_TR_OUT120_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT120, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[20]
    CYHAL_TRIGGER_TCPWM1_TR_OUT121_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT121, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[21]
    CYHAL_TRIGGER_TCPWM1_TR_OUT121_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT121, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[21]
    CYHAL_TRIGGER_TCPWM1_TR_OUT122_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT122, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[22]
    CYHAL_TRIGGER_TCPWM1_TR_OUT122_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT122, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[22]
    CYHAL_TRIGGER_TCPWM1_TR_OUT123_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT123, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[23]
    CYHAL_TRIGGER_TCPWM1_TR_OUT123_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT123, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[23]
    CYHAL_TRIGGER_TCPWM1_TR_OUT124_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT124, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[24]
    CYHAL_TRIGGER_TCPWM1_TR_OUT124_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT124, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[24]
    CYHAL_TRIGGER_TCPWM1_TR_OUT125_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT125, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[25]
    CYHAL_TRIGGER_TCPWM1_TR_OUT125_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT125, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[25]
    CYHAL_TRIGGER_TCPWM1_TR_OUT126_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT126, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[26]
    CYHAL_TRIGGER_TCPWM1_TR_OUT126_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT126, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[26]
    CYHAL_TRIGGER_TCPWM1_TR_OUT127_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT127, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[27]
    CYHAL_TRIGGER_TCPWM1_TR_OUT127_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT127, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[27]
    CYHAL_TRIGGER_TCPWM1_TR_OUT128_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT128, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[28]
    CYHAL_TRIGGER_TCPWM1_TR_OUT128_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT128, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[28]
    CYHAL_TRIGGER_TCPWM1_TR_OUT129_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT129, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[29]
    CYHAL_TRIGGER_TCPWM1_TR_OUT129_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT129, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[29]
    CYHAL_TRIGGER_TCPWM1_TR_OUT130_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT130, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[30]
    CYHAL_TRIGGER_TCPWM1_TR_OUT130_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT130, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[30]
    CYHAL_TRIGGER_TCPWM1_TR_OUT131_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT131, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[31]
    CYHAL_TRIGGER_TCPWM1_TR_OUT131_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT131, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[31]
    CYHAL_TRIGGER_TCPWM1_TR_OUT132_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT132, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[32]
    CYHAL_TRIGGER_TCPWM1_TR_OUT132_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT132, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[32]
    CYHAL_TRIGGER_TCPWM1_TR_OUT133_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT133, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[33]
    CYHAL_TRIGGER_TCPWM1_TR_OUT133_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT133, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[33]
    CYHAL_TRIGGER_TCPWM1_TR_OUT134_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT134, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[34]
    CYHAL_TRIGGER_TCPWM1_TR_OUT134_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT134, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[34]
    CYHAL_TRIGGER_TCPWM1_TR_OUT135_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT135, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[35]
    CYHAL_TRIGGER_TCPWM1_TR_OUT135_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT135, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[35]
    CYHAL_TRIGGER_TCPWM1_TR_OUT136_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT136, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[36]
    CYHAL_TRIGGER_TCPWM1_TR_OUT136_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT136, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[36]
    CYHAL_TRIGGER_TCPWM1_TR_OUT137_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT137, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[37]
    CYHAL_TRIGGER_TCPWM1_TR_OUT137_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT137, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[37]
    CYHAL_TRIGGER_TCPWM1_TR_OUT138_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT138, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[38]
    CYHAL_TRIGGER_TCPWM1_TR_OUT138_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT138, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[38]
    CYHAL_TRIGGER_TCPWM1_TR_OUT139_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT139, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[39]
    CYHAL_TRIGGER_TCPWM1_TR_OUT139_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT139, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[39]
    CYHAL_TRIGGER_TCPWM1_TR_OUT140_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT140, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[40]
    CYHAL_TRIGGER_TCPWM1_TR_OUT140_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT140, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[40]
    CYHAL_TRIGGER_TCPWM1_TR_OUT141_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT141, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[41]
    CYHAL_TRIGGER_TCPWM1_TR_OUT141_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT141, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[41]
    CYHAL_TRIGGER_TCPWM1_TR_OUT142_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT142, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[42]
    CYHAL_TRIGGER_TCPWM1_TR_OUT142_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT142, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[42]
    CYHAL_TRIGGER_TCPWM1_TR_OUT143_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT143, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[43]
    CYHAL_TRIGGER_TCPWM1_TR_OUT143_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT143, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[43]
    CYHAL_TRIGGER_TCPWM1_TR_OUT144_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT144, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[44]
    CYHAL_TRIGGER_TCPWM1_TR_OUT144_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT144, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[44]
    CYHAL_TRIGGER_TCPWM1_TR_OUT145_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT145, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[45]
    CYHAL_TRIGGER_TCPWM1_TR_OUT145_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT145, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[45]
    CYHAL_TRIGGER_TCPWM1_TR_OUT146_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT146, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[46]
    CYHAL_TRIGGER_TCPWM1_TR_OUT146_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT146, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[46]
    CYHAL_TRIGGER_TCPWM1_TR_OUT147_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT147, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[47]
    CYHAL_TRIGGER_TCPWM1_TR_OUT147_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT147, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[47]
    CYHAL_TRIGGER_TCPWM1_TR_OUT148_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT148, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[48]
    CYHAL_TRIGGER_TCPWM1_TR_OUT148_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT148, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[48]
    CYHAL_TRIGGER_TCPWM1_TR_OUT149_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT149, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[49]
    CYHAL_TRIGGER_TCPWM1_TR_OUT149_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT149, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[49]
    CYHAL_TRIGGER_TCPWM1_TR_OUT150_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT150, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[50]
    CYHAL_TRIGGER_TCPWM1_TR_OUT150_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT150, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[50]
    CYHAL_TRIGGER_TCPWM1_TR_OUT151_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT151, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[51]
    CYHAL_TRIGGER_TCPWM1_TR_OUT151_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT151, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[51]
    CYHAL_TRIGGER_TCPWM1_TR_OUT152_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT152, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[52]
    CYHAL_TRIGGER_TCPWM1_TR_OUT152_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT152, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[52]
    CYHAL_TRIGGER_TCPWM1_TR_OUT153_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT153, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[53]
    CYHAL_TRIGGER_TCPWM1_TR_OUT153_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT153, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[53]
    CYHAL_TRIGGER_TCPWM1_TR_OUT154_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT154, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[54]
    CYHAL_TRIGGER_TCPWM1_TR_OUT154_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT154, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[54]
    CYHAL_TRIGGER_TCPWM1_TR_OUT155_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT155, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[55]
    CYHAL_TRIGGER_TCPWM1_TR_OUT155_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT155, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[55]
    CYHAL_TRIGGER_TCPWM1_TR_OUT156_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT156, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[56]
    CYHAL_TRIGGER_TCPWM1_TR_OUT156_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT156, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[56]
    CYHAL_TRIGGER_TCPWM1_TR_OUT157_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT157, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[57]
    CYHAL_TRIGGER_TCPWM1_TR_OUT157_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT157, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[57]
    CYHAL_TRIGGER_TCPWM1_TR_OUT158_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT158, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[58]
    CYHAL_TRIGGER_TCPWM1_TR_OUT158_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT158, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[58]
    CYHAL_TRIGGER_TCPWM1_TR_OUT159_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT159, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[59]
    CYHAL_TRIGGER_TCPWM1_TR_OUT159_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT159, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[59]
    CYHAL_TRIGGER_TCPWM1_TR_OUT160_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT160, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[60]
    CYHAL_TRIGGER_TCPWM1_TR_OUT160_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT160, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[60]
    CYHAL_TRIGGER_TCPWM1_TR_OUT161_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT161, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[61]
    CYHAL_TRIGGER_TCPWM1_TR_OUT161_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT161, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[61]
    CYHAL_TRIGGER_TCPWM1_TR_OUT162_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT162, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[62]
    CYHAL_TRIGGER_TCPWM1_TR_OUT162_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT162, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[62]
    CYHAL_TRIGGER_TCPWM1_TR_OUT163_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT163, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[63]
    CYHAL_TRIGGER_TCPWM1_TR_OUT163_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT163, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[63]
    CYHAL_TRIGGER_TCPWM1_TR_OUT164_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT164, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[64]
    CYHAL_TRIGGER_TCPWM1_TR_OUT164_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT164, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[64]
    CYHAL_TRIGGER_TCPWM1_TR_OUT165_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT165, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[65]
    CYHAL_TRIGGER_TCPWM1_TR_OUT165_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT165, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[65]
    CYHAL_TRIGGER_TCPWM1_TR_OUT166_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT166, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[66]
    CYHAL_TRIGGER_TCPWM1_TR_OUT166_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT166, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[66]
    CYHAL_TRIGGER_TCPWM1_TR_OUT167_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT167, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[67]
    CYHAL_TRIGGER_TCPWM1_TR_OUT167_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT167, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[67]
    CYHAL_TRIGGER_TCPWM1_TR_OUT168_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT168, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[68]
    CYHAL_TRIGGER_TCPWM1_TR_OUT168_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT168, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[68]
    CYHAL_TRIGGER_TCPWM1_TR_OUT169_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT169, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[69]
    CYHAL_TRIGGER_TCPWM1_TR_OUT169_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT169, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[69]
    CYHAL_TRIGGER_TCPWM1_TR_OUT170_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT170, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[70]
    CYHAL_TRIGGER_TCPWM1_TR_OUT170_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT170, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[70]
    CYHAL_TRIGGER_TCPWM1_TR_OUT171_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT171, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[71]
    CYHAL_TRIGGER_TCPWM1_TR_OUT171_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT171, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[71]
    CYHAL_TRIGGER_TCPWM1_TR_OUT172_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT172, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[72]
    CYHAL_TRIGGER_TCPWM1_TR_OUT172_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT172, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[72]
    CYHAL_TRIGGER_TCPWM1_TR_OUT173_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT173, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[73]
    CYHAL_TRIGGER_TCPWM1_TR_OUT173_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT173, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[73]
    CYHAL_TRIGGER_TCPWM1_TR_OUT174_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT174, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[74]
    CYHAL_TRIGGER_TCPWM1_TR_OUT174_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT174, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[74]
    CYHAL_TRIGGER_TCPWM1_TR_OUT175_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT175, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[75]
    CYHAL_TRIGGER_TCPWM1_TR_OUT175_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT175, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[75]
    CYHAL_TRIGGER_TCPWM1_TR_OUT176_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT176, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[76]
    CYHAL_TRIGGER_TCPWM1_TR_OUT176_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT176, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[76]
    CYHAL_TRIGGER_TCPWM1_TR_OUT177_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT177, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[77]
    CYHAL_TRIGGER_TCPWM1_TR_OUT177_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT177, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[77]
    CYHAL_TRIGGER_TCPWM1_TR_OUT178_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT178, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[78]
    CYHAL_TRIGGER_TCPWM1_TR_OUT178_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT178, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[78]
    CYHAL_TRIGGER_TCPWM1_TR_OUT179_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT179, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[79]
    CYHAL_TRIGGER_TCPWM1_TR_OUT179_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT179, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[79]
    CYHAL_TRIGGER_TCPWM1_TR_OUT180_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT180, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[80]
    CYHAL_TRIGGER_TCPWM1_TR_OUT180_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT180, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[80]
    CYHAL_TRIGGER_TCPWM1_TR_OUT181_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT181, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[81]
    CYHAL_TRIGGER_TCPWM1_TR_OUT181_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT181, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[81]
    CYHAL_TRIGGER_TCPWM1_TR_OUT182_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT182, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[82]
    CYHAL_TRIGGER_TCPWM1_TR_OUT182_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT182, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[82]
    CYHAL_TRIGGER_TCPWM1_TR_OUT183_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT183, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[83]
    CYHAL_TRIGGER_TCPWM1_TR_OUT183_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT183, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[83]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1256_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1256, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[256]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1256_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1256, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[256]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1257_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1257, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[257]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1257_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1257, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[257]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1258_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1258, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[258]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1258_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1258, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[258]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1259_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1259, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[259]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1259_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1259, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[259]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1260_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1260, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[260]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1260_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1260, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[260]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1261_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1261, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[261]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1261_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1261, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[261]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1262_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1262, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[262]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1262_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1262, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[262]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1263_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1263, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[263]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1263_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1263, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[263]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1264_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1264, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[264]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1264_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1264, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[264]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1265_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1265, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[265]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1265_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1265, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[265]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1266_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1266, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[266]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1266_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1266, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[266]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1267_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1267, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[267]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1267_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1267, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[267]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1512_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1512, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[512]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1512_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1512, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[512]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1513_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1513, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[513]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1513_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1513, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[513]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1514_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1514, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[514]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1514_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1514, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[514]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1515_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1515, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[515]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1515_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1515, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[515]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1516_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1516, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[516]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1516_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1516, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[516]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1517_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1517, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[517]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1517_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1517, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[517]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1518_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1518, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[518]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1518_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1518, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[518]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1519_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1519, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[519]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1519_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1519, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[519]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1520_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1520, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[520]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1520_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1520, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[520]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1521_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1521, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[521]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1521_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1521, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[521]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1522_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1522, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[522]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1522_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1522, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[522]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1523_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1523, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[523]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1523_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1523, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[523]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1524_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1524, CYHAL_SIGNAL_TYPE_EDGE), //!< tcpwm[1].tr_out1[524]
    CYHAL_TRIGGER_TCPWM1_TR_OUT1524_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TCPWM1_TR_OUT1524, CYHAL_SIGNAL_TYPE_LEVEL), //!< tcpwm[1].tr_out1[524]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[0]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[0]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[1]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[1]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[2]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[2]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[3]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[3]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[10].output[4]
    CYHAL_TRIGGER_TR_GROUP10_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP10_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[10].output[4]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[0]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[0]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[1]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[1]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[2]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[2]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[3]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[3]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[11].output[4]
    CYHAL_TRIGGER_TR_GROUP11_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP11_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[11].output[4]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT0_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT0, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[0]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT0_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT0, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[0]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT1_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT1, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[1]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT1_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT1, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[1]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT2_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT2, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[2]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT2_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT2, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[2]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT3_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT3, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[3]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT3_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT3, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[3]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT4_EDGE = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT4, CYHAL_SIGNAL_TYPE_EDGE), //!< tr_group[12].output[4]
    CYHAL_TRIGGER_TR_GROUP12_OUTPUT4_LEVEL = _CYHAL_TRIGGER_CREATE_SOURCE(_CYHAL_TRIGGER_TR_GROUP12_OUTPUT4, CYHAL_SIGNAL_TYPE_LEVEL), //!< tr_group[12].output[4]
} cyhal_trigger_source_xmc7200_t;

/** Typedef from device family specific trigger source to generic trigger source */
typedef cyhal_trigger_source_xmc7200_t cyhal_source_t;

/** Deprecated defines for signals that can be either level or edge. */
#define CYHAL_TRIGGER_CPUSS_ZERO (CYHAL_TRIGGER_CPUSS_ZERO_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT0 (CYHAL_TRIGGER_EVTGEN0_TR_OUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT1 (CYHAL_TRIGGER_EVTGEN0_TR_OUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT2 (CYHAL_TRIGGER_EVTGEN0_TR_OUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT3 (CYHAL_TRIGGER_EVTGEN0_TR_OUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT4 (CYHAL_TRIGGER_EVTGEN0_TR_OUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT5 (CYHAL_TRIGGER_EVTGEN0_TR_OUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT6 (CYHAL_TRIGGER_EVTGEN0_TR_OUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT7 (CYHAL_TRIGGER_EVTGEN0_TR_OUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT8 (CYHAL_TRIGGER_EVTGEN0_TR_OUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT9 (CYHAL_TRIGGER_EVTGEN0_TR_OUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT10 (CYHAL_TRIGGER_EVTGEN0_TR_OUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT11 (CYHAL_TRIGGER_EVTGEN0_TR_OUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT12 (CYHAL_TRIGGER_EVTGEN0_TR_OUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT13 (CYHAL_TRIGGER_EVTGEN0_TR_OUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT14 (CYHAL_TRIGGER_EVTGEN0_TR_OUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_EVTGEN0_TR_OUT15 (CYHAL_TRIGGER_EVTGEN0_TR_OUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE16_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE17_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE18_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE19_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE20_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE21_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE22_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE23_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE24_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE25_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE26_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE27_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE28_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE29_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE30_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE31_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE32_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE33_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE34_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE35_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE36_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE37_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE38_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE39_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE40_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE41_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE42_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE43_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE44_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE45_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE46_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE47_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE48_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE49_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE50_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE51_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE52_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE53_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE54_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE55_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE56_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE57_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE58_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE59_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE60_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE61_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE62_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE63_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE64_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE65_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE66_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE67_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE68_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE69_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE70_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE71_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE72_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE73_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE74_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE75_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE76_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE77_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE78_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE79_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE80_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE81_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE82_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE83_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE84_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE85_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE86_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE87_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE88_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE89_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE90_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE91_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE92_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE93_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE94_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95 (CYHAL_TRIGGER_PASS0_TR_SAR_CH_DONE95_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0 (CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1 (CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2 (CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3 (CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4 (CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5 (CYHAL_TRIGGER_PASS0_TR_SAR_GEN_OUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT0 (CYHAL_TRIGGER_PERI_TR_IO_INPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT1 (CYHAL_TRIGGER_PERI_TR_IO_INPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT2 (CYHAL_TRIGGER_PERI_TR_IO_INPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT3 (CYHAL_TRIGGER_PERI_TR_IO_INPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT4 (CYHAL_TRIGGER_PERI_TR_IO_INPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT5 (CYHAL_TRIGGER_PERI_TR_IO_INPUT5_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT6 (CYHAL_TRIGGER_PERI_TR_IO_INPUT6_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT7 (CYHAL_TRIGGER_PERI_TR_IO_INPUT7_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT8 (CYHAL_TRIGGER_PERI_TR_IO_INPUT8_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT9 (CYHAL_TRIGGER_PERI_TR_IO_INPUT9_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT10 (CYHAL_TRIGGER_PERI_TR_IO_INPUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT11 (CYHAL_TRIGGER_PERI_TR_IO_INPUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT12 (CYHAL_TRIGGER_PERI_TR_IO_INPUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT13 (CYHAL_TRIGGER_PERI_TR_IO_INPUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT14 (CYHAL_TRIGGER_PERI_TR_IO_INPUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT15 (CYHAL_TRIGGER_PERI_TR_IO_INPUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT16 (CYHAL_TRIGGER_PERI_TR_IO_INPUT16_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT17 (CYHAL_TRIGGER_PERI_TR_IO_INPUT17_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT18 (CYHAL_TRIGGER_PERI_TR_IO_INPUT18_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT19 (CYHAL_TRIGGER_PERI_TR_IO_INPUT19_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT20 (CYHAL_TRIGGER_PERI_TR_IO_INPUT20_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT21 (CYHAL_TRIGGER_PERI_TR_IO_INPUT21_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT22 (CYHAL_TRIGGER_PERI_TR_IO_INPUT22_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT23 (CYHAL_TRIGGER_PERI_TR_IO_INPUT23_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT24 (CYHAL_TRIGGER_PERI_TR_IO_INPUT24_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT25 (CYHAL_TRIGGER_PERI_TR_IO_INPUT25_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT26 (CYHAL_TRIGGER_PERI_TR_IO_INPUT26_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT27 (CYHAL_TRIGGER_PERI_TR_IO_INPUT27_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT28 (CYHAL_TRIGGER_PERI_TR_IO_INPUT28_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT29 (CYHAL_TRIGGER_PERI_TR_IO_INPUT29_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT30 (CYHAL_TRIGGER_PERI_TR_IO_INPUT30_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT31 (CYHAL_TRIGGER_PERI_TR_IO_INPUT31_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT32 (CYHAL_TRIGGER_PERI_TR_IO_INPUT32_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT33 (CYHAL_TRIGGER_PERI_TR_IO_INPUT33_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT34 (CYHAL_TRIGGER_PERI_TR_IO_INPUT34_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT35 (CYHAL_TRIGGER_PERI_TR_IO_INPUT35_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT36 (CYHAL_TRIGGER_PERI_TR_IO_INPUT36_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT37 (CYHAL_TRIGGER_PERI_TR_IO_INPUT37_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT38 (CYHAL_TRIGGER_PERI_TR_IO_INPUT38_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT39 (CYHAL_TRIGGER_PERI_TR_IO_INPUT39_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT40 (CYHAL_TRIGGER_PERI_TR_IO_INPUT40_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT41 (CYHAL_TRIGGER_PERI_TR_IO_INPUT41_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT42 (CYHAL_TRIGGER_PERI_TR_IO_INPUT42_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT43 (CYHAL_TRIGGER_PERI_TR_IO_INPUT43_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT44 (CYHAL_TRIGGER_PERI_TR_IO_INPUT44_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT45 (CYHAL_TRIGGER_PERI_TR_IO_INPUT45_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT46 (CYHAL_TRIGGER_PERI_TR_IO_INPUT46_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_PERI_TR_IO_INPUT47 (CYHAL_TRIGGER_PERI_TR_IO_INPUT47_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT00 (CYHAL_TRIGGER_TCPWM0_TR_OUT00_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT01 (CYHAL_TRIGGER_TCPWM0_TR_OUT01_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT02 (CYHAL_TRIGGER_TCPWM0_TR_OUT02_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT0256 (CYHAL_TRIGGER_TCPWM0_TR_OUT0256_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT0257 (CYHAL_TRIGGER_TCPWM0_TR_OUT0257_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT0258 (CYHAL_TRIGGER_TCPWM0_TR_OUT0258_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT0512 (CYHAL_TRIGGER_TCPWM0_TR_OUT0512_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT0513 (CYHAL_TRIGGER_TCPWM0_TR_OUT0513_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT0514 (CYHAL_TRIGGER_TCPWM0_TR_OUT0514_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT00 (CYHAL_TRIGGER_TCPWM1_TR_OUT00_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT01 (CYHAL_TRIGGER_TCPWM1_TR_OUT01_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT02 (CYHAL_TRIGGER_TCPWM1_TR_OUT02_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT03 (CYHAL_TRIGGER_TCPWM1_TR_OUT03_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT04 (CYHAL_TRIGGER_TCPWM1_TR_OUT04_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT05 (CYHAL_TRIGGER_TCPWM1_TR_OUT05_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT06 (CYHAL_TRIGGER_TCPWM1_TR_OUT06_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT07 (CYHAL_TRIGGER_TCPWM1_TR_OUT07_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT08 (CYHAL_TRIGGER_TCPWM1_TR_OUT08_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT09 (CYHAL_TRIGGER_TCPWM1_TR_OUT09_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT010 (CYHAL_TRIGGER_TCPWM1_TR_OUT010_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT011 (CYHAL_TRIGGER_TCPWM1_TR_OUT011_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT012 (CYHAL_TRIGGER_TCPWM1_TR_OUT012_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT013 (CYHAL_TRIGGER_TCPWM1_TR_OUT013_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT014 (CYHAL_TRIGGER_TCPWM1_TR_OUT014_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT015 (CYHAL_TRIGGER_TCPWM1_TR_OUT015_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT016 (CYHAL_TRIGGER_TCPWM1_TR_OUT016_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT017 (CYHAL_TRIGGER_TCPWM1_TR_OUT017_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT018 (CYHAL_TRIGGER_TCPWM1_TR_OUT018_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT019 (CYHAL_TRIGGER_TCPWM1_TR_OUT019_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT020 (CYHAL_TRIGGER_TCPWM1_TR_OUT020_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT021 (CYHAL_TRIGGER_TCPWM1_TR_OUT021_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT022 (CYHAL_TRIGGER_TCPWM1_TR_OUT022_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT023 (CYHAL_TRIGGER_TCPWM1_TR_OUT023_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT024 (CYHAL_TRIGGER_TCPWM1_TR_OUT024_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT025 (CYHAL_TRIGGER_TCPWM1_TR_OUT025_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT026 (CYHAL_TRIGGER_TCPWM1_TR_OUT026_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT027 (CYHAL_TRIGGER_TCPWM1_TR_OUT027_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT028 (CYHAL_TRIGGER_TCPWM1_TR_OUT028_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT029 (CYHAL_TRIGGER_TCPWM1_TR_OUT029_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT030 (CYHAL_TRIGGER_TCPWM1_TR_OUT030_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT031 (CYHAL_TRIGGER_TCPWM1_TR_OUT031_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT032 (CYHAL_TRIGGER_TCPWM1_TR_OUT032_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT033 (CYHAL_TRIGGER_TCPWM1_TR_OUT033_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT034 (CYHAL_TRIGGER_TCPWM1_TR_OUT034_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT035 (CYHAL_TRIGGER_TCPWM1_TR_OUT035_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT036 (CYHAL_TRIGGER_TCPWM1_TR_OUT036_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT037 (CYHAL_TRIGGER_TCPWM1_TR_OUT037_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT038 (CYHAL_TRIGGER_TCPWM1_TR_OUT038_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT039 (CYHAL_TRIGGER_TCPWM1_TR_OUT039_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT040 (CYHAL_TRIGGER_TCPWM1_TR_OUT040_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT041 (CYHAL_TRIGGER_TCPWM1_TR_OUT041_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT042 (CYHAL_TRIGGER_TCPWM1_TR_OUT042_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT043 (CYHAL_TRIGGER_TCPWM1_TR_OUT043_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT044 (CYHAL_TRIGGER_TCPWM1_TR_OUT044_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT045 (CYHAL_TRIGGER_TCPWM1_TR_OUT045_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT046 (CYHAL_TRIGGER_TCPWM1_TR_OUT046_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT047 (CYHAL_TRIGGER_TCPWM1_TR_OUT047_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT048 (CYHAL_TRIGGER_TCPWM1_TR_OUT048_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT049 (CYHAL_TRIGGER_TCPWM1_TR_OUT049_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT050 (CYHAL_TRIGGER_TCPWM1_TR_OUT050_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT051 (CYHAL_TRIGGER_TCPWM1_TR_OUT051_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT052 (CYHAL_TRIGGER_TCPWM1_TR_OUT052_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT053 (CYHAL_TRIGGER_TCPWM1_TR_OUT053_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT054 (CYHAL_TRIGGER_TCPWM1_TR_OUT054_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT055 (CYHAL_TRIGGER_TCPWM1_TR_OUT055_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT056 (CYHAL_TRIGGER_TCPWM1_TR_OUT056_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT057 (CYHAL_TRIGGER_TCPWM1_TR_OUT057_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT058 (CYHAL_TRIGGER_TCPWM1_TR_OUT058_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT059 (CYHAL_TRIGGER_TCPWM1_TR_OUT059_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT060 (CYHAL_TRIGGER_TCPWM1_TR_OUT060_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT061 (CYHAL_TRIGGER_TCPWM1_TR_OUT061_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT062 (CYHAL_TRIGGER_TCPWM1_TR_OUT062_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT063 (CYHAL_TRIGGER_TCPWM1_TR_OUT063_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT064 (CYHAL_TRIGGER_TCPWM1_TR_OUT064_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT065 (CYHAL_TRIGGER_TCPWM1_TR_OUT065_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT066 (CYHAL_TRIGGER_TCPWM1_TR_OUT066_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT067 (CYHAL_TRIGGER_TCPWM1_TR_OUT067_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT068 (CYHAL_TRIGGER_TCPWM1_TR_OUT068_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT069 (CYHAL_TRIGGER_TCPWM1_TR_OUT069_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT070 (CYHAL_TRIGGER_TCPWM1_TR_OUT070_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT071 (CYHAL_TRIGGER_TCPWM1_TR_OUT071_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT072 (CYHAL_TRIGGER_TCPWM1_TR_OUT072_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT073 (CYHAL_TRIGGER_TCPWM1_TR_OUT073_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT074 (CYHAL_TRIGGER_TCPWM1_TR_OUT074_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT075 (CYHAL_TRIGGER_TCPWM1_TR_OUT075_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT076 (CYHAL_TRIGGER_TCPWM1_TR_OUT076_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT077 (CYHAL_TRIGGER_TCPWM1_TR_OUT077_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT078 (CYHAL_TRIGGER_TCPWM1_TR_OUT078_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT079 (CYHAL_TRIGGER_TCPWM1_TR_OUT079_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT080 (CYHAL_TRIGGER_TCPWM1_TR_OUT080_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT081 (CYHAL_TRIGGER_TCPWM1_TR_OUT081_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT082 (CYHAL_TRIGGER_TCPWM1_TR_OUT082_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT083 (CYHAL_TRIGGER_TCPWM1_TR_OUT083_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0256 (CYHAL_TRIGGER_TCPWM1_TR_OUT0256_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0257 (CYHAL_TRIGGER_TCPWM1_TR_OUT0257_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0258 (CYHAL_TRIGGER_TCPWM1_TR_OUT0258_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0259 (CYHAL_TRIGGER_TCPWM1_TR_OUT0259_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0260 (CYHAL_TRIGGER_TCPWM1_TR_OUT0260_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0261 (CYHAL_TRIGGER_TCPWM1_TR_OUT0261_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0262 (CYHAL_TRIGGER_TCPWM1_TR_OUT0262_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0263 (CYHAL_TRIGGER_TCPWM1_TR_OUT0263_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0264 (CYHAL_TRIGGER_TCPWM1_TR_OUT0264_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0265 (CYHAL_TRIGGER_TCPWM1_TR_OUT0265_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0266 (CYHAL_TRIGGER_TCPWM1_TR_OUT0266_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0267 (CYHAL_TRIGGER_TCPWM1_TR_OUT0267_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0512 (CYHAL_TRIGGER_TCPWM1_TR_OUT0512_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0513 (CYHAL_TRIGGER_TCPWM1_TR_OUT0513_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0514 (CYHAL_TRIGGER_TCPWM1_TR_OUT0514_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0515 (CYHAL_TRIGGER_TCPWM1_TR_OUT0515_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0516 (CYHAL_TRIGGER_TCPWM1_TR_OUT0516_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0517 (CYHAL_TRIGGER_TCPWM1_TR_OUT0517_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0518 (CYHAL_TRIGGER_TCPWM1_TR_OUT0518_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0519 (CYHAL_TRIGGER_TCPWM1_TR_OUT0519_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0520 (CYHAL_TRIGGER_TCPWM1_TR_OUT0520_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0521 (CYHAL_TRIGGER_TCPWM1_TR_OUT0521_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0522 (CYHAL_TRIGGER_TCPWM1_TR_OUT0522_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0523 (CYHAL_TRIGGER_TCPWM1_TR_OUT0523_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT0524 (CYHAL_TRIGGER_TCPWM1_TR_OUT0524_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT10 (CYHAL_TRIGGER_TCPWM0_TR_OUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT11 (CYHAL_TRIGGER_TCPWM0_TR_OUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT12 (CYHAL_TRIGGER_TCPWM0_TR_OUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT1256 (CYHAL_TRIGGER_TCPWM0_TR_OUT1256_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT1257 (CYHAL_TRIGGER_TCPWM0_TR_OUT1257_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT1258 (CYHAL_TRIGGER_TCPWM0_TR_OUT1258_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT1512 (CYHAL_TRIGGER_TCPWM0_TR_OUT1512_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT1513 (CYHAL_TRIGGER_TCPWM0_TR_OUT1513_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM0_TR_OUT1514 (CYHAL_TRIGGER_TCPWM0_TR_OUT1514_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT10 (CYHAL_TRIGGER_TCPWM1_TR_OUT10_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT11 (CYHAL_TRIGGER_TCPWM1_TR_OUT11_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT12 (CYHAL_TRIGGER_TCPWM1_TR_OUT12_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT13 (CYHAL_TRIGGER_TCPWM1_TR_OUT13_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT14 (CYHAL_TRIGGER_TCPWM1_TR_OUT14_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT15 (CYHAL_TRIGGER_TCPWM1_TR_OUT15_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT16 (CYHAL_TRIGGER_TCPWM1_TR_OUT16_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT17 (CYHAL_TRIGGER_TCPWM1_TR_OUT17_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT18 (CYHAL_TRIGGER_TCPWM1_TR_OUT18_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT19 (CYHAL_TRIGGER_TCPWM1_TR_OUT19_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT110 (CYHAL_TRIGGER_TCPWM1_TR_OUT110_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT111 (CYHAL_TRIGGER_TCPWM1_TR_OUT111_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT112 (CYHAL_TRIGGER_TCPWM1_TR_OUT112_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT113 (CYHAL_TRIGGER_TCPWM1_TR_OUT113_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT114 (CYHAL_TRIGGER_TCPWM1_TR_OUT114_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT115 (CYHAL_TRIGGER_TCPWM1_TR_OUT115_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT116 (CYHAL_TRIGGER_TCPWM1_TR_OUT116_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT117 (CYHAL_TRIGGER_TCPWM1_TR_OUT117_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT118 (CYHAL_TRIGGER_TCPWM1_TR_OUT118_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT119 (CYHAL_TRIGGER_TCPWM1_TR_OUT119_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT120 (CYHAL_TRIGGER_TCPWM1_TR_OUT120_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT121 (CYHAL_TRIGGER_TCPWM1_TR_OUT121_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT122 (CYHAL_TRIGGER_TCPWM1_TR_OUT122_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT123 (CYHAL_TRIGGER_TCPWM1_TR_OUT123_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT124 (CYHAL_TRIGGER_TCPWM1_TR_OUT124_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT125 (CYHAL_TRIGGER_TCPWM1_TR_OUT125_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT126 (CYHAL_TRIGGER_TCPWM1_TR_OUT126_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT127 (CYHAL_TRIGGER_TCPWM1_TR_OUT127_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT128 (CYHAL_TRIGGER_TCPWM1_TR_OUT128_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT129 (CYHAL_TRIGGER_TCPWM1_TR_OUT129_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT130 (CYHAL_TRIGGER_TCPWM1_TR_OUT130_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT131 (CYHAL_TRIGGER_TCPWM1_TR_OUT131_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT132 (CYHAL_TRIGGER_TCPWM1_TR_OUT132_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT133 (CYHAL_TRIGGER_TCPWM1_TR_OUT133_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT134 (CYHAL_TRIGGER_TCPWM1_TR_OUT134_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT135 (CYHAL_TRIGGER_TCPWM1_TR_OUT135_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT136 (CYHAL_TRIGGER_TCPWM1_TR_OUT136_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT137 (CYHAL_TRIGGER_TCPWM1_TR_OUT137_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT138 (CYHAL_TRIGGER_TCPWM1_TR_OUT138_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT139 (CYHAL_TRIGGER_TCPWM1_TR_OUT139_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT140 (CYHAL_TRIGGER_TCPWM1_TR_OUT140_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT141 (CYHAL_TRIGGER_TCPWM1_TR_OUT141_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT142 (CYHAL_TRIGGER_TCPWM1_TR_OUT142_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT143 (CYHAL_TRIGGER_TCPWM1_TR_OUT143_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT144 (CYHAL_TRIGGER_TCPWM1_TR_OUT144_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT145 (CYHAL_TRIGGER_TCPWM1_TR_OUT145_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT146 (CYHAL_TRIGGER_TCPWM1_TR_OUT146_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT147 (CYHAL_TRIGGER_TCPWM1_TR_OUT147_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT148 (CYHAL_TRIGGER_TCPWM1_TR_OUT148_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT149 (CYHAL_TRIGGER_TCPWM1_TR_OUT149_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT150 (CYHAL_TRIGGER_TCPWM1_TR_OUT150_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT151 (CYHAL_TRIGGER_TCPWM1_TR_OUT151_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT152 (CYHAL_TRIGGER_TCPWM1_TR_OUT152_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT153 (CYHAL_TRIGGER_TCPWM1_TR_OUT153_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT154 (CYHAL_TRIGGER_TCPWM1_TR_OUT154_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT155 (CYHAL_TRIGGER_TCPWM1_TR_OUT155_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT156 (CYHAL_TRIGGER_TCPWM1_TR_OUT156_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT157 (CYHAL_TRIGGER_TCPWM1_TR_OUT157_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT158 (CYHAL_TRIGGER_TCPWM1_TR_OUT158_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT159 (CYHAL_TRIGGER_TCPWM1_TR_OUT159_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT160 (CYHAL_TRIGGER_TCPWM1_TR_OUT160_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT161 (CYHAL_TRIGGER_TCPWM1_TR_OUT161_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT162 (CYHAL_TRIGGER_TCPWM1_TR_OUT162_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT163 (CYHAL_TRIGGER_TCPWM1_TR_OUT163_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT164 (CYHAL_TRIGGER_TCPWM1_TR_OUT164_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT165 (CYHAL_TRIGGER_TCPWM1_TR_OUT165_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT166 (CYHAL_TRIGGER_TCPWM1_TR_OUT166_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT167 (CYHAL_TRIGGER_TCPWM1_TR_OUT167_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT168 (CYHAL_TRIGGER_TCPWM1_TR_OUT168_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT169 (CYHAL_TRIGGER_TCPWM1_TR_OUT169_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT170 (CYHAL_TRIGGER_TCPWM1_TR_OUT170_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT171 (CYHAL_TRIGGER_TCPWM1_TR_OUT171_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT172 (CYHAL_TRIGGER_TCPWM1_TR_OUT172_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT173 (CYHAL_TRIGGER_TCPWM1_TR_OUT173_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT174 (CYHAL_TRIGGER_TCPWM1_TR_OUT174_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT175 (CYHAL_TRIGGER_TCPWM1_TR_OUT175_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT176 (CYHAL_TRIGGER_TCPWM1_TR_OUT176_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT177 (CYHAL_TRIGGER_TCPWM1_TR_OUT177_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT178 (CYHAL_TRIGGER_TCPWM1_TR_OUT178_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT179 (CYHAL_TRIGGER_TCPWM1_TR_OUT179_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT180 (CYHAL_TRIGGER_TCPWM1_TR_OUT180_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT181 (CYHAL_TRIGGER_TCPWM1_TR_OUT181_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT182 (CYHAL_TRIGGER_TCPWM1_TR_OUT182_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT183 (CYHAL_TRIGGER_TCPWM1_TR_OUT183_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1256 (CYHAL_TRIGGER_TCPWM1_TR_OUT1256_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1257 (CYHAL_TRIGGER_TCPWM1_TR_OUT1257_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1258 (CYHAL_TRIGGER_TCPWM1_TR_OUT1258_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1259 (CYHAL_TRIGGER_TCPWM1_TR_OUT1259_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1260 (CYHAL_TRIGGER_TCPWM1_TR_OUT1260_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1261 (CYHAL_TRIGGER_TCPWM1_TR_OUT1261_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1262 (CYHAL_TRIGGER_TCPWM1_TR_OUT1262_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1263 (CYHAL_TRIGGER_TCPWM1_TR_OUT1263_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1264 (CYHAL_TRIGGER_TCPWM1_TR_OUT1264_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1265 (CYHAL_TRIGGER_TCPWM1_TR_OUT1265_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1266 (CYHAL_TRIGGER_TCPWM1_TR_OUT1266_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1267 (CYHAL_TRIGGER_TCPWM1_TR_OUT1267_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1512 (CYHAL_TRIGGER_TCPWM1_TR_OUT1512_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1513 (CYHAL_TRIGGER_TCPWM1_TR_OUT1513_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1514 (CYHAL_TRIGGER_TCPWM1_TR_OUT1514_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1515 (CYHAL_TRIGGER_TCPWM1_TR_OUT1515_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1516 (CYHAL_TRIGGER_TCPWM1_TR_OUT1516_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1517 (CYHAL_TRIGGER_TCPWM1_TR_OUT1517_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1518 (CYHAL_TRIGGER_TCPWM1_TR_OUT1518_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1519 (CYHAL_TRIGGER_TCPWM1_TR_OUT1519_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1520 (CYHAL_TRIGGER_TCPWM1_TR_OUT1520_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1521 (CYHAL_TRIGGER_TCPWM1_TR_OUT1521_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1522 (CYHAL_TRIGGER_TCPWM1_TR_OUT1522_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1523 (CYHAL_TRIGGER_TCPWM1_TR_OUT1523_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TCPWM1_TR_OUT1524 (CYHAL_TRIGGER_TCPWM1_TR_OUT1524_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP10_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP10_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP11_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP11_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT0 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT0_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT1 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT1_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT2 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT2_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT3 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT3_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.
#define CYHAL_TRIGGER_TR_GROUP12_OUTPUT4 (CYHAL_TRIGGER_TR_GROUP12_OUTPUT4_LEVEL) //!< Legacy define. Instead, use the explicit _LEVEL or _EDGE version.

/** @brief Name of each output trigger. */
typedef enum
{
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK0 = 0, //!< CAN0 DW0 triggers (from DW0 back to CAN0) - canfd[0].tr_dbg_dma_ack[0]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK1 = 1, //!< CAN0 DW0 triggers (from DW0 back to CAN0) - canfd[0].tr_dbg_dma_ack[1]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK2 = 2, //!< CAN0 DW0 triggers (from DW0 back to CAN0) - canfd[0].tr_dbg_dma_ack[2]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK3 = 3, //!< CAN0 DW0 triggers (from DW0 back to CAN0) - canfd[0].tr_dbg_dma_ack[3]
    CYHAL_TRIGGER_CANFD0_TR_DBG_DMA_ACK4 = 4, //!< CAN0 DW0 triggers (from DW0 back to CAN0) - canfd[0].tr_dbg_dma_ack[4]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK0 = 5, //!< CAN1 DW1 triggers (from DW1 back to CAN1) - canfd[1].tr_dbg_dma_ack[0]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK1 = 6, //!< CAN1 DW1 triggers (from DW1 back to CAN1) - canfd[1].tr_dbg_dma_ack[1]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK2 = 7, //!< CAN1 DW1 triggers (from DW1 back to CAN1) - canfd[1].tr_dbg_dma_ack[2]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK3 = 8, //!< CAN1 DW1 triggers (from DW1 back to CAN1) - canfd[1].tr_dbg_dma_ack[3]
    CYHAL_TRIGGER_CANFD1_TR_DBG_DMA_ACK4 = 9, //!< CAN1 DW1 triggers (from DW1 back to CAN1) - canfd[1].tr_dbg_dma_ack[4]
    CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN0 = 10, //!< CAN TT Sync - canfd[0].tr_evt_swt_in[0]
    CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN1 = 11, //!< CAN TT Sync - canfd[0].tr_evt_swt_in[1]
    CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN2 = 12, //!< CAN TT Sync - canfd[0].tr_evt_swt_in[2]
    CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN3 = 13, //!< CAN TT Sync - canfd[0].tr_evt_swt_in[3]
    CYHAL_TRIGGER_CANFD0_TR_EVT_SWT_IN4 = 14, //!< CAN TT Sync - canfd[0].tr_evt_swt_in[4]
    CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN0 = 15, //!< CAN TT Sync - canfd[1].tr_evt_swt_in[0]
    CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN1 = 16, //!< CAN TT Sync - canfd[1].tr_evt_swt_in[1]
    CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN2 = 17, //!< CAN TT Sync - canfd[1].tr_evt_swt_in[2]
    CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN3 = 18, //!< CAN TT Sync - canfd[1].tr_evt_swt_in[3]
    CYHAL_TRIGGER_CANFD1_TR_EVT_SWT_IN4 = 19, //!< CAN TT Sync - canfd[1].tr_evt_swt_in[4]
    CYHAL_TRIGGER_CPUSS_CTI_TR_IN0 = 20, //!< Debug Multiplexer - cpuss.cti_tr_in[0]
    CYHAL_TRIGGER_CPUSS_CTI_TR_IN1 = 21, //!< Debug Multiplexer - cpuss.cti_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN0 = 22, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[0]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN1 = 23, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN2 = 24, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[2]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN3 = 25, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[3]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN4 = 26, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[4]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN5 = 27, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[5]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN6 = 28, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[6]
    CYHAL_TRIGGER_CPUSS_DMAC_TR_IN7 = 29, //!< M-DMA trigger multiplexer - cpuss.dmac_tr_in[7]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN0 = 30, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[0]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN1 = 31, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN2 = 32, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[2]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN3 = 33, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[3]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN4 = 34, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[4]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN5 = 35, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[5]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN6 = 36, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[6]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN7 = 37, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[7]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN8 = 38, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[8]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN9 = 39, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[9]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN10 = 40, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[10]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN11 = 41, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[11]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN12 = 42, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[12]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN13 = 43, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[13]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN14 = 44, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[14]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN15 = 45, //!< P-DMA0 trigger multiplexer - cpuss.dw0_tr_in[15]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN16 = 46, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[16]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN17 = 47, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[17]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN18 = 48, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[18]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN19 = 49, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[19]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN20 = 50, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[20]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN21 = 51, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[21]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN22 = 52, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[22]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN23 = 53, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[23]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN24 = 54, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[24]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN25 = 55, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[25]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN26 = 56, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[26]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN27 = 57, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[27]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN28 = 58, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[28]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN29 = 59, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[29]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN30 = 60, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[30]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN31 = 61, //!< TCPWM to P-DMA0 trigger mux - cpuss.dw0_tr_in[31]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN32 = 62, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[32]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN33 = 63, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[33]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN34 = 64, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[34]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN35 = 65, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[35]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN36 = 66, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[36]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN37 = 67, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[37]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN38 = 68, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[38]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN39 = 69, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[39]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN40 = 70, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[40]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN41 = 71, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[41]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN42 = 72, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[42]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN43 = 73, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[43]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN44 = 74, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[44]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN45 = 75, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[45]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN46 = 76, //!< CAN0 DW0 Triggers - cpuss.dw0_tr_in[46]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN47 = 77, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[47]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN48 = 78, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[48]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN49 = 79, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[49]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN50 = 80, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[50]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN51 = 81, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[51]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN52 = 82, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[52]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN53 = 83, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[53]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN54 = 84, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[54]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN55 = 85, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[55]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN56 = 86, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[56]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN57 = 87, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[57]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN58 = 88, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[58]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN59 = 89, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[59]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN60 = 90, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[60]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN61 = 91, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[61]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN62 = 92, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[62]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN63 = 93, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[63]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN64 = 94, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[64]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN65 = 95, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[65]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN66 = 96, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[66]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN67 = 97, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[67]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN68 = 98, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[68]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN69 = 99, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[69]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN70 = 100, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[70]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN71 = 101, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[71]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN72 = 102, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[72]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN73 = 103, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[73]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN74 = 104, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[74]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN75 = 105, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[75]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN76 = 106, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[76]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN77 = 107, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[77]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN78 = 108, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[78]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN79 = 109, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[79]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN80 = 110, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[80]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN81 = 111, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[81]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN82 = 112, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[82]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN83 = 113, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[83]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN84 = 114, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[84]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN85 = 115, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[85]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN86 = 116, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[86]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN87 = 117, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[87]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN88 = 118, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[88]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN89 = 119, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[89]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN90 = 120, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[90]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN91 = 121, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[91]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN92 = 122, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[92]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN93 = 123, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[93]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN94 = 124, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[94]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN95 = 125, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[95]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN96 = 126, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[96]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN97 = 127, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[97]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN98 = 128, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[98]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN99 = 129, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[99]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN100 = 130, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[100]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN101 = 131, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[101]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN102 = 132, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[102]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN103 = 133, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[103]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN104 = 134, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[104]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN105 = 135, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[105]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN106 = 136, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[106]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN107 = 137, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[107]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN108 = 138, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[108]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN109 = 139, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[109]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN110 = 140, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[110]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN111 = 141, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[111]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN112 = 142, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[112]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN113 = 143, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[113]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN114 = 144, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[114]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN115 = 145, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[115]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN116 = 146, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[116]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN117 = 147, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[117]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN118 = 148, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[118]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN119 = 149, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[119]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN120 = 150, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[120]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN121 = 151, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[121]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN122 = 152, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[122]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN123 = 153, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[123]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN124 = 154, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[124]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN125 = 155, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[125]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN126 = 156, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[126]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN127 = 157, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[127]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN128 = 158, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[128]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN129 = 159, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[129]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN130 = 160, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[130]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN131 = 161, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[131]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN132 = 162, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[132]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN133 = 163, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[133]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN134 = 164, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[134]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN135 = 165, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[135]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN136 = 166, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[136]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN137 = 167, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[137]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN138 = 168, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[138]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN139 = 169, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[139]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN140 = 170, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[140]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN141 = 171, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[141]
    CYHAL_TRIGGER_CPUSS_DW0_TR_IN142 = 172, //!< PASS to DW0 direct connect - cpuss.dw0_tr_in[142]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN0 = 173, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[0]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN1 = 174, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[1]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN2 = 175, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[2]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN3 = 176, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[3]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN4 = 177, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[4]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN5 = 178, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[5]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN6 = 179, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[6]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN7 = 180, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[7]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN8 = 181, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[8]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN9 = 182, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[9]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN10 = 183, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[10]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN11 = 184, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[11]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN12 = 185, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[12]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN13 = 186, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[13]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN14 = 187, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[14]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN15 = 188, //!< P-DMA1 trigger multiplexer - cpuss.dw1_tr_in[15]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN16 = 189, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[16]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN17 = 190, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[17]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN18 = 191, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[18]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN19 = 192, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[19]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN20 = 193, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[20]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN21 = 194, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[21]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN22 = 195, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[22]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN23 = 196, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[23]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN24 = 197, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[24]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN25 = 198, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[25]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN26 = 199, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[26]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN27 = 200, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[27]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN28 = 201, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[28]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN29 = 202, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[29]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN30 = 203, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[30]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN31 = 204, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[31]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN32 = 205, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[32]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN33 = 206, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[33]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN34 = 207, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[34]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN35 = 208, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[35]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN36 = 209, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[36]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN37 = 210, //!< SCB DW1 Triggers - cpuss.dw1_tr_in[37]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN38 = 211, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[38]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN39 = 212, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[39]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN40 = 213, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[40]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN41 = 214, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[41]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN42 = 215, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[42]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN43 = 216, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[43]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN44 = 217, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[44]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN45 = 218, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[45]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN46 = 219, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[46]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN47 = 220, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[47]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN48 = 221, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[48]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN49 = 222, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[49]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN50 = 223, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[50]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN51 = 224, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[51]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN52 = 225, //!< CAN1 DW1 Triggers - cpuss.dw1_tr_in[52]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN53 = 226, //!< SMIF DW1 Triggers - cpuss.dw1_tr_in[53]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN54 = 227, //!< SMIF DW1 Triggers - cpuss.dw1_tr_in[54]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN55 = 228, //!< I2S DW1 Triggers - cpuss.dw1_tr_in[55]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN56 = 229, //!< I2S DW1 Triggers - cpuss.dw1_tr_in[56]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN57 = 230, //!< I2S DW1 Triggers - cpuss.dw1_tr_in[57]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN58 = 231, //!< I2S DW1 Triggers - cpuss.dw1_tr_in[58]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN59 = 232, //!< I2S DW1 Triggers - cpuss.dw1_tr_in[59]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN60 = 233, //!< I2S DW1 Triggers - cpuss.dw1_tr_in[60]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN61 = 234, //!< FLEXRAY DW1 Triggers - cpuss.dw1_tr_in[61]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN62 = 235, //!< FLEXRAY DW1 Triggers - cpuss.dw1_tr_in[62]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN63 = 236, //!< DW1 DW1 Triggers - cpuss.dw1_tr_in[63]
    CYHAL_TRIGGER_CPUSS_DW1_TR_IN64 = 237, //!< DW1 DW1 Triggers - cpuss.dw1_tr_in[64]
    CYHAL_TRIGGER_FLEXRAY0_TR_IBF_IN = 238, //!< DW1 FLEXRAY Triggers - flexray[0].tr_ibf_in
    CYHAL_TRIGGER_FLEXRAY0_TR_OBF_IN = 239, //!< DW1 FLEXRAY Triggers - flexray[0].tr_obf_in
    CYHAL_TRIGGER_FLEXRAY0_TR_STPWT_IN = 240, //!< CAN TT Sync - flexray[0].tr_stpwt_in
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER0 = 241, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[0]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER1 = 242, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[1]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER2 = 243, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[2]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER3 = 244, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[3]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER4 = 245, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[4]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER5 = 246, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[5]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER6 = 247, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[6]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER7 = 248, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[7]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER8 = 249, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[8]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER9 = 250, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[9]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER10 = 251, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[10]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER11 = 252, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[11]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER12 = 253, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[12]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER13 = 254, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[13]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER14 = 255, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[14]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER15 = 256, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[15]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER16 = 257, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[16]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER17 = 258, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[17]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER18 = 259, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[18]
    CYHAL_TRIGGER_LIN0_TR_CMD_TX_HEADER19 = 260, //!< TCPWM to LIN - lin[0].tr_cmd_tx_header[19]
    CYHAL_TRIGGER_PASS0_TR_DEBUG_FREEZE = 261, //!< Debug Multiplexer - pass[0].tr_debug_freeze
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN0 = 262, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN1 = 263, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN2 = 264, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN3 = 265, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN4 = 266, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN5 = 267, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[5]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN6 = 268, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[6]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN7 = 269, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[7]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN8 = 270, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[8]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN9 = 271, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[9]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN10 = 272, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[10]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN11 = 273, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[11]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN12 = 274, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[12]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN13 = 275, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[13]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN14 = 276, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[14]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN15 = 277, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[15]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN16 = 278, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[16]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN17 = 279, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[17]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN18 = 280, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[18]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN19 = 281, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[19]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN20 = 282, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[20]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN21 = 283, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[21]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN22 = 284, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[22]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN23 = 285, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[23]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN24 = 286, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[24]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN25 = 287, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[25]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN26 = 288, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[26]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN27 = 289, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[27]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN28 = 290, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[28]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN29 = 291, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[29]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN30 = 292, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[30]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN31 = 293, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[31]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN32 = 294, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[32]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN33 = 295, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[33]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN34 = 296, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[34]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN35 = 297, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[35]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN36 = 298, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[36]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN37 = 299, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[37]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN38 = 300, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[38]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN39 = 301, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[39]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN40 = 302, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[40]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN41 = 303, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[41]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN42 = 304, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[42]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN43 = 305, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[43]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN44 = 306, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[44]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN45 = 307, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[45]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN46 = 308, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[46]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN47 = 309, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[47]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN48 = 310, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[48]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN49 = 311, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[49]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN50 = 312, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[50]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN51 = 313, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[51]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN52 = 314, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[52]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN53 = 315, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[53]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN54 = 316, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[54]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN55 = 317, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[55]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN56 = 318, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[56]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN57 = 319, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[57]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN58 = 320, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[58]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN59 = 321, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[59]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN60 = 322, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[60]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN61 = 323, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[61]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN62 = 324, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[62]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN63 = 325, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[63]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN64 = 326, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[64]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN65 = 327, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[65]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN66 = 328, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[66]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN67 = 329, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[67]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN68 = 330, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[68]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN69 = 331, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[69]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN70 = 332, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[70]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN71 = 333, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[71]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN72 = 334, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[72]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN73 = 335, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[73]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN74 = 336, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[74]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN75 = 337, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[75]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN76 = 338, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[76]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN77 = 339, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[77]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN78 = 340, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[78]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN79 = 341, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[79]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN80 = 342, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[80]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN81 = 343, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[81]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN82 = 344, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[82]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN83 = 345, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[83]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN84 = 346, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[84]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN85 = 347, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[85]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN86 = 348, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[86]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN87 = 349, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[87]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN88 = 350, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[88]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN89 = 351, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[89]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN90 = 352, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[90]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN91 = 353, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[91]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN92 = 354, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[92]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN93 = 355, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[93]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN94 = 356, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[94]
    CYHAL_TRIGGER_PASS0_TR_SAR_CH_IN95 = 357, //!< PWM to PASS direct connect - pass[0].tr_sar_ch_in[95]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN0 = 358, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[0]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN1 = 359, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[1]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN2 = 360, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[2]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN3 = 361, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[3]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN4 = 362, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[4]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN5 = 363, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[5]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN6 = 364, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[6]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN7 = 365, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[7]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN8 = 366, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[8]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN9 = 367, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[9]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN10 = 368, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[10]
    CYHAL_TRIGGER_PASS0_TR_SAR_GEN_IN11 = 369, //!< PASS trigger multiplexer - pass[0].tr_sar_gen_in[11]
    CYHAL_TRIGGER_PERI_TR_DBG_FREEZE = 370, //!< Debug Multiplexer - peri.tr_dbg_freeze
    CYHAL_TRIGGER_PERI_TR_IO_OUTPUT0 = 371, //!< Debug Multiplexer - peri.tr_io_output[0]
    CYHAL_TRIGGER_PERI_TR_IO_OUTPUT1 = 372, //!< Debug Multiplexer - peri.tr_io_output[1]
    CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT0 = 373, //!< Debug Multiplexer - srss.tr_debug_freeze_mcwdt[0]
    CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT1 = 374, //!< Debug Multiplexer - srss.tr_debug_freeze_mcwdt[1]
    CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_MCWDT2 = 375, //!< Debug Multiplexer - srss.tr_debug_freeze_mcwdt[2]
    CYHAL_TRIGGER_SRSS_TR_DEBUG_FREEZE_WDT = 376, //!< Debug Multiplexer - srss.tr_debug_freeze_wdt
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN0 = 377, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[0]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN1 = 378, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[1]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN2 = 379, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[2]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN3 = 380, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[3]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN4 = 381, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[4]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN5 = 382, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[5]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN6 = 383, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[6]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN7 = 384, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[7]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN8 = 385, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[8]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN9 = 386, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[9]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN10 = 387, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[10]
    CYHAL_TRIGGER_TCPWM0_TR_ALL_CNT_IN11 = 388, //!< TCPWM0 loopback mux - tcpwm[0].tr_all_cnt_in[11]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN0 = 389, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[0]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN1 = 390, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[1]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN2 = 391, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[2]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN3 = 392, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[3]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN4 = 393, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[4]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN5 = 394, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[5]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN6 = 395, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[6]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN7 = 396, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[7]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN8 = 397, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[8]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN9 = 398, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[9]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN10 = 399, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[10]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN11 = 400, //!< TCPWM1 loopback mux - tcpwm[1].tr_all_cnt_in[11]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN12 = 401, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[12]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN13 = 402, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[13]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN14 = 403, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[14]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN15 = 404, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[15]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN16 = 405, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[16]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN17 = 406, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[17]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN18 = 407, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[18]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN19 = 408, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[19]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN20 = 409, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[20]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN21 = 410, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[21]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN22 = 411, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[22]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN23 = 412, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[23]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN24 = 413, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[24]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN25 = 414, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[25]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN26 = 415, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[26]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN27 = 416, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[27]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN28 = 417, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[28]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN29 = 418, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[29]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN30 = 419, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[30]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN31 = 420, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[31]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN32 = 421, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[32]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN33 = 422, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[33]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN34 = 423, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[34]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN35 = 424, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[35]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN36 = 425, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[36]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN37 = 426, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[37]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN38 = 427, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[38]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN39 = 428, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[39]
    CYHAL_TRIGGER_TCPWM1_TR_ALL_CNT_IN40 = 429, //!< TCPWM1 Trigger Multiplexer - tcpwm[1].tr_all_cnt_in[40]
    CYHAL_TRIGGER_TCPWM0_TR_DEBUG_FREEZE = 430, //!< Debug Multiplexer - tcpwm[0].tr_debug_freeze
    CYHAL_TRIGGER_TCPWM1_TR_DEBUG_FREEZE = 431, //!< Debug Multiplexer - tcpwm[1].tr_debug_freeze
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN2 = 432, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[2]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN5 = 433, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[5]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN8 = 434, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[8]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN11 = 435, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[11]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN14 = 436, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[14]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN17 = 437, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[17]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN20 = 438, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[20]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN23 = 439, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[23]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN26 = 440, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[26]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN29 = 441, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[29]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN32 = 442, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[32]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN35 = 443, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[35]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN38 = 444, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[38]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN41 = 445, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[41]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN44 = 446, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[44]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN47 = 447, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[47]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN50 = 448, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[50]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN53 = 449, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[53]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN56 = 450, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[56]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN59 = 451, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[59]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN62 = 452, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[62]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN65 = 453, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[65]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN68 = 454, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[68]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN71 = 455, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[71]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN74 = 456, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[74]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN77 = 457, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[77]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN80 = 458, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[80]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN83 = 459, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[83]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN86 = 460, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[86]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN89 = 461, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[89]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN92 = 462, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[92]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN95 = 463, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[95]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN98 = 464, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[98]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN101 = 465, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[101]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN104 = 466, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[104]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN107 = 467, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[107]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN110 = 468, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[110]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN113 = 469, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[113]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN116 = 470, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[116]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN119 = 471, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[119]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN122 = 472, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[122]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN125 = 473, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[125]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN128 = 474, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[128]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN131 = 475, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[131]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN134 = 476, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[134]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN137 = 477, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[137]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN140 = 478, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[140]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN143 = 479, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[143]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN146 = 480, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[146]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN149 = 481, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[149]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN152 = 482, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[152]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN155 = 483, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[155]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN158 = 484, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[158]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN161 = 485, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[161]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN164 = 486, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[164]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN167 = 487, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[167]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN170 = 488, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[170]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN173 = 489, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[173]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN176 = 490, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[176]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN179 = 491, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[179]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN182 = 492, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[182]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN185 = 493, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[185]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN188 = 494, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[188]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN191 = 495, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[191]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN194 = 496, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[194]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN197 = 497, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[197]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN200 = 498, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[200]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN203 = 499, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[203]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN206 = 500, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[206]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN209 = 501, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[209]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN212 = 502, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[212]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN215 = 503, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[215]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN218 = 504, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[218]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN221 = 505, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[221]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN224 = 506, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[224]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN227 = 507, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[227]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN230 = 508, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[230]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN233 = 509, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[233]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN236 = 510, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[236]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN239 = 511, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[239]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN242 = 512, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[242]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN245 = 513, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[245]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN248 = 514, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[248]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN251 = 515, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[251]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN770 = 516, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[770]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN773 = 517, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[773]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN776 = 518, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[776]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN779 = 519, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[779]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN782 = 520, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[782]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN785 = 521, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[785]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN788 = 522, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[788]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN791 = 523, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[791]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN794 = 524, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[794]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN797 = 525, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[797]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN800 = 526, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[800]
    CYHAL_TRIGGER_TCPWM1_TR_ONE_CNT_IN803 = 527, //!< PASS to PWM direct connect - tcpwm[1].tr_one_cnt_in[803]
    CYHAL_TRIGGER_TR_GROUP9_INPUT1 = 528, //!< Debug Reduction #1 - tr_group[9].input[1]
    CYHAL_TRIGGER_TR_GROUP9_INPUT2 = 529, //!< Debug Reduction #1 - tr_group[9].input[2]
    CYHAL_TRIGGER_TR_GROUP9_INPUT3 = 530, //!< Debug Reduction #1 - tr_group[9].input[3]
    CYHAL_TRIGGER_TR_GROUP9_INPUT4 = 531, //!< Debug Reduction #1 - tr_group[9].input[4]
    CYHAL_TRIGGER_TR_GROUP9_INPUT5 = 532, //!< Debug Reduction #1 - tr_group[9].input[5]
    CYHAL_TRIGGER_TR_GROUP9_INPUT6 = 533, //!< Debug Reduction #2 - tr_group[9].input[6]
    CYHAL_TRIGGER_TR_GROUP9_INPUT7 = 534, //!< Debug Reduction #2 - tr_group[9].input[7]
    CYHAL_TRIGGER_TR_GROUP9_INPUT8 = 535, //!< Debug Reduction #2 - tr_group[9].input[8]
    CYHAL_TRIGGER_TR_GROUP9_INPUT9 = 536, //!< Debug Reduction #2 - tr_group[9].input[9]
    CYHAL_TRIGGER_TR_GROUP9_INPUT10 = 537, //!< Debug Reduction #2 - tr_group[9].input[10]
    CYHAL_TRIGGER_TR_GROUP9_INPUT11 = 538, //!< Debug Reduction #3 - tr_group[9].input[11]
    CYHAL_TRIGGER_TR_GROUP9_INPUT12 = 539, //!< Debug Reduction #3 - tr_group[9].input[12]
    CYHAL_TRIGGER_TR_GROUP9_INPUT13 = 540, //!< Debug Reduction #3 - tr_group[9].input[13]
    CYHAL_TRIGGER_TR_GROUP9_INPUT14 = 541, //!< Debug Reduction #3 - tr_group[9].input[14]
    CYHAL_TRIGGER_TR_GROUP9_INPUT15 = 542, //!< Debug Reduction #3 - tr_group[9].input[15]
} cyhal_trigger_dest_xmc7200_t;

/** Typedef from device family specific trigger dest to generic trigger dest */
typedef cyhal_trigger_dest_xmc7200_t cyhal_dest_t;

/** \cond INTERNAL */
/** Table of number of inputs to each mux. */
extern const uint16_t cyhal_sources_per_mux[27];

/** Table indicating whether mux is 1to1. */
extern const bool cyhal_is_mux_1to1[27];

/** Table pointing to each mux source table. The index of each source in the table is its mux input index. */
extern const _cyhal_trigger_source_xmc7200_t* cyhal_mux_to_sources [27];

/** Maps each cyhal_destination_t to a mux index.
 * If bit 8 of the mux index is set, this denotes that the trigger is a
 * one to one trigger.
 */
extern const uint8_t cyhal_dest_to_mux[543];

/* Maps each cyhal_destination_t to a specific output in its mux */
extern const uint8_t cyhal_mux_dest_index[543];
/** \endcond */

#if defined(__cplusplus)
}
#endif /* __cplusplus */
/** \} group_hal_impl_triggers_xmc7200 */
#endif /* _CYHAL_TRIGGERS_XMC7200_H_ */


/* [] END OF FILE */
