# MTB CAT1 Peripheral Driver Library

### Overview
The Cypress PDL simplifies software development for CAT1 family of devices.
The PDL integrates device header files, startup code, and 
peripheral drivers into a single package. The drivers abstract the hardware functions into a set of 
easy-to-use APIs. These are fully documented in the [PDL API Reference Manual](https://infineon.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/index.html). 

This version of the PDL is compatible with ModusToolbox. It is not compatible 
with PSoC Creator. The most recent PSoC Creator-compatible version of the PDL 
is [available here](https://www.infineon.com/cms/en/design-support/software/device-driver-libraries/psoc-6-peripheral-driver-library-pdl-for-psoc-creator).

### Features
* Includes all the updates made to the peripheral drivers for ModusToolbox™ software
* Contains standard set of CAT1 digital and analog peripheral drivers that enable rapid peripheral software development in third-party IDEs
* The ARM Cortex® Microcontroller Software Interface Standard (CMSIS) core access header files
* CMSIS compliant device header files, startup code (platform initialization) and device configuration header files

The PDL reduces the need to understand register usage and bit structures, 
thus easing software development for the extensive set of peripherals in the 
CAT1 series. 
See the [PDL API Reference Manual](https://infineon.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/index.html) for more detailed information.
See the [PDL Release Notes](./RELEASE.md) for release-specific information.

### Peripheral Drivers
The PDL provides a high-level API to configure, initialize, and use a peripheral driver. 
The drivers are designed for peripheral IP blocks. 
See [PDL API Reference](https://infineon.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/modules.html) for the list of drivers.

### Quick Start
See the [PDL API Reference Manual Getting Started section](https://infineon.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/page_getting_started.html) for quick start instructions.

### More information
* [Peripheral Driver Library Release Notes](./RELEASE.md)
* [Peripheral Driver Library API Reference Manual](https://infineon.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/index.html)
* [ModusToolbox Software Environment, Quick Start Guide, Documentation, and Videos](https://www.infineon.com/cms/en/design-support/tools/sdk/modustoolbox-software/)
* [ModusToolbox Device Configurator Tool Guide](https://www.infineon.com/dgdl/Infineon-ModusToolbox_Device_Configurator_Guide_4-UserManual-v01_00-EN.pdf?fileId=8ac78c8c7d718a49017d99ab297631cb)
* [AN210781 Getting Started with PSoC 6 MCU with Bluetooth Low Energy (BLE) Connectivity](https://www.infineon.com/dgdl/Infineon-AN210781_Getting_Started_with_PSoC_6_MCU_with_Bluetooth_Low_Energy_(BLE)_Connectivity_on_PSoC_Creator-ApplicationNotes-v05_00-EN.pdf?fileId=8ac78c8c7cdc391c017d0d311f536528)
* [PSoC 6](https://www.infineon.com/cms/en/product/microcontroller/32-bit-psoc-arm-cortex-microcontroller/psoc-6-32-bit-arm-cortex-m4-mcu/)
* [CYW20829](https://www.infineon.com/cms/en/product/promopages/airoc20829)
* [TV-II-BH8/BH4](https://www.infineon.com/cms/en/product/microcontroller/32-bit-traveo-t2g-arm-cortex-microcontroller/)
* [XMC7000](https://www.infineon.com/cms/en/product/microcontroller/32-bit-industrial-microcontroller-based-on-arm-cortex-m/)
* [Infineon](http://www.infineon.com)


### Note
New versions of PDL from 2.0 onwards are now be available in [mtb-pdl-cat1](https://infineon.github.io/mtb-pdl-cat1/pdl_api_reference_manual/html/index.html) repo and [psoc6pdl](https://infineon.github.io/psoc6pdl/pdl_api_reference_manual/html/index.html) repo will no longer be updated in future.

---
© Cypress Semiconductor Corporation (an Infineon company), 2022.
