/***************************************************************************//**
* \file cyip_tdm.h
*
* \brief
* TDM IP definitions
*
********************************************************************************
* \copyright
* (c) (2016-2022), Cypress Semiconductor Corporation (an Infineon company) or
* an affiliate of Cypress Semiconductor Corporation.
*
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYIP_TDM_H_
#define _CYIP_TDM_H_

#include "cyip_headers.h"

/*******************************************************************************
*                                     TDM
*******************************************************************************/

#define TDM_TDM_STRUCT_TDM_TX_STRUCT_SECTION_SIZE 0x00000100UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_SECTION_SIZE 0x00000100UL
#define TDM_TDM_STRUCT_SECTION_SIZE             0x00000200UL
#define TDM_SECTION_SIZE                        0x00010000UL

/**
  * \brief TDM TX structure (TDM_TDM_STRUCT_TDM_TX_STRUCT)
  */
typedef struct {
  __IOM uint32_t TX_CTL;                        /*!< 0x00000000 TX control */
   __IM uint32_t RESERVED[3];
  __IOM uint32_t TX_IF_CTL;                     /*!< 0x00000010 TX interface control */
  __IOM uint32_t TX_CH_CTL;                     /*!< 0x00000014 TX channel control */
   __IM uint32_t RESERVED1[2];
  __IOM uint32_t TX_TEST_CTL;                   /*!< 0x00000020 TX test control */
  __IOM uint32_t TX_ROUTE_CTL;                  /*!< 0x00000024 TX route control */
   __IM uint32_t RESERVED2[22];
  __IOM uint32_t TX_FIFO_CTL;                   /*!< 0x00000080 TX FIFO control */
   __IM uint32_t TX_FIFO_STATUS;                /*!< 0x00000084 TX FIFO status */
   __OM uint32_t TX_FIFO_WR;                    /*!< 0x00000088 TX FIFO write */
   __IM uint32_t RESERVED3[13];
  __IOM uint32_t INTR_TX;                       /*!< 0x000000C0 Interrupt */
  __IOM uint32_t INTR_TX_SET;                   /*!< 0x000000C4 Interrupt set */
  __IOM uint32_t INTR_TX_MASK;                  /*!< 0x000000C8 Interrupt mask */
   __IM uint32_t INTR_TX_MASKED;                /*!< 0x000000CC Interrupt masked */
   __IM uint32_t RESERVED4[12];
} TDM_TDM_STRUCT_TDM_TX_STRUCT_Type;            /*!< Size = 256 (0x100) */

/**
  * \brief TDM RX structure (TDM_TDM_STRUCT_TDM_RX_STRUCT)
  */
typedef struct {
  __IOM uint32_t RX_CTL;                        /*!< 0x00000000 RX control */
   __IM uint32_t RESERVED[3];
  __IOM uint32_t RX_IF_CTL;                     /*!< 0x00000010 RX interface control */
  __IOM uint32_t RX_CH_CTL;                     /*!< 0x00000014 RX channel control */
   __IM uint32_t RESERVED1[2];
  __IOM uint32_t RX_TEST_CTL;                   /*!< 0x00000020 RX test control */
  __IOM uint32_t RX_ROUTE_CTL;                  /*!< 0x00000024 RX route control */
   __IM uint32_t RESERVED2[22];
  __IOM uint32_t RX_FIFO_CTL;                   /*!< 0x00000080 RX FIFO control */
   __IM uint32_t RX_FIFO_STATUS;                /*!< 0x00000084 RX FIFO status */
   __IM uint32_t RX_FIFO_RD;                    /*!< 0x00000088 RX FIFO read */
   __IM uint32_t RX_FIFO_RD_SILENT;             /*!< 0x0000008C RX FIFO silent read */
   __IM uint32_t RESERVED3[12];
  __IOM uint32_t INTR_RX;                       /*!< 0x000000C0 Interrupt */
  __IOM uint32_t INTR_RX_SET;                   /*!< 0x000000C4 Interrupt set */
  __IOM uint32_t INTR_RX_MASK;                  /*!< 0x000000C8 Interrupt mask */
   __IM uint32_t INTR_RX_MASKED;                /*!< 0x000000CC Interrupt masked */
   __IM uint32_t RESERVED4[12];
} TDM_TDM_STRUCT_TDM_RX_STRUCT_Type;            /*!< Size = 256 (0x100) */

/**
  * \brief TDM structure (TDM_TDM_STRUCT)
  */
typedef struct {
        TDM_TDM_STRUCT_TDM_TX_STRUCT_Type TDM_TX_STRUCT; /*!< 0x00000000 TDM TX structure */
        TDM_TDM_STRUCT_TDM_RX_STRUCT_Type TDM_RX_STRUCT; /*!< 0x00000100 TDM RX structure */
} TDM_TDM_STRUCT_Type;                          /*!< Size = 512 (0x200) */

/**
  * \brief TDM (TDM)
  */
typedef struct {
   __IM uint32_t RESERVED[8192];
        TDM_TDM_STRUCT_Type TDM_STRUCT[4];      /*!< 0x00008000 TDM structure */
} TDM_Type;                                     /*!< Size = 34816 (0x8800) */


/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_CTL */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_WORD_SIZE_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_WORD_SIZE_Msk 0xFUL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_FORMAT_Pos 12UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_FORMAT_Msk 0x3000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_MS_Pos 16UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_MS_Msk 0x10000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_ENABLED_Pos 31UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CTL_ENABLED_Msk 0x80000000UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_IF_CTL */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CLOCK_DIV_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CLOCK_DIV_Msk 0xFFUL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CLOCK_SEL_Pos 8UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CLOCK_SEL_Msk 0x700UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_SCK_POLARITY_Pos 12UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_SCK_POLARITY_Msk 0x1000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_FSYNC_POLARITY_Pos 13UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_FSYNC_POLARITY_Msk 0x2000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_FSYNC_FORMAT_Pos 15UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_FSYNC_FORMAT_Msk 0x8000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CH_NR_Pos 16UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CH_NR_Msk 0x1F0000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CH_SIZE_Pos 24UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_CH_SIZE_Msk 0x1F000000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_I2S_MODE_Pos 31UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_IF_CTL_I2S_MODE_Msk 0x80000000UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_CH_CTL */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CH_CTL_CH_EN_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_CH_CTL_CH_EN_Msk 0xFFFFFFFFUL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_TEST_CTL */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_TEST_CTL_ENABLED_Pos 31UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_TEST_CTL_ENABLED_Msk 0x80000000UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_ROUTE_CTL */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_ROUTE_CTL_MODE_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_ROUTE_CTL_MODE_Msk 0x3UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_FIFO_CTL */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_TRIGGER_LEVEL_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_TRIGGER_LEVEL_Msk 0x7FUL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_MUTE_Pos 16UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_MUTE_Msk 0x10000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_FREEZE_Pos 17UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_FREEZE_Msk 0x20000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_ACTIVE_Pos 18UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_ACTIVE_Msk 0x40000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_REPLAY_Pos 19UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_CTL_REPLAY_Msk 0x80000UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_FIFO_STATUS */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_STATUS_USED_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_STATUS_USED_Msk 0xFFUL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_STATUS_RD_PTR_Pos 16UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_STATUS_RD_PTR_Msk 0x7F0000UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_STATUS_WR_PTR_Pos 24UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_STATUS_WR_PTR_Msk 0x7F000000UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.TX_FIFO_WR */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_WR_DATA_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_TX_FIFO_WR_DATA_Msk 0xFFFFFFFFUL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.INTR_TX */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_IF_UNDERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_IF_UNDERFLOW_Msk 0x100UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.INTR_TX_SET */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_IF_UNDERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_SET_IF_UNDERFLOW_Msk 0x100UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.INTR_TX_MASK */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_IF_UNDERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASK_IF_UNDERFLOW_Msk 0x100UL
/* TDM_TDM_STRUCT_TDM_TX_STRUCT.INTR_TX_MASKED */
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_IF_UNDERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_TX_STRUCT_INTR_TX_MASKED_IF_UNDERFLOW_Msk 0x100UL


/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_CTL */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_WORD_SIZE_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_WORD_SIZE_Msk 0xFUL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_WORD_SIGN_EXTEND_Pos 8UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_WORD_SIGN_EXTEND_Msk 0x100UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_FORMAT_Pos 12UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_FORMAT_Msk 0x3000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_MS_Pos 16UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_MS_Msk 0x10000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_ENABLED_Pos 31UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CTL_ENABLED_Msk 0x80000000UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_IF_CTL */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CLOCK_DIV_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CLOCK_DIV_Msk 0xFFUL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CLOCK_SEL_Pos 8UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CLOCK_SEL_Msk 0x700UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_SCK_POLARITY_Pos 12UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_SCK_POLARITY_Msk 0x1000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_FSYNC_POLARITY_Pos 13UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_FSYNC_POLARITY_Msk 0x2000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_LATE_SAMPLE_Pos 14UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_LATE_SAMPLE_Msk 0x4000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_FSYNC_FORMAT_Pos 15UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_FSYNC_FORMAT_Msk 0x8000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CH_NR_Pos 16UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CH_NR_Msk 0x1F0000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CH_SIZE_Pos 24UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_CH_SIZE_Msk 0x1F000000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_LATE_CAPTURE_Pos 29UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_LATE_CAPTURE_Msk 0x60000000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_I2S_MODE_Pos 31UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_IF_CTL_I2S_MODE_Msk 0x80000000UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_CH_CTL */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CH_CTL_CH_EN_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_CH_CTL_CH_EN_Msk 0xFFFFFFFFUL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_TEST_CTL */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_TEST_CTL_ENABLED_Pos 31UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_TEST_CTL_ENABLED_Msk 0x80000000UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_ROUTE_CTL */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_ROUTE_CTL_MODE_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_ROUTE_CTL_MODE_Msk 0x3UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_FIFO_CTL */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_CTL_TRIGGER_LEVEL_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_CTL_TRIGGER_LEVEL_Msk 0x7FUL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_CTL_FREEZE_Pos 17UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_CTL_FREEZE_Msk 0x20000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_CTL_ACTIVE_Pos 18UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_CTL_ACTIVE_Msk 0x40000UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_FIFO_STATUS */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_STATUS_USED_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_STATUS_USED_Msk 0xFFUL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_STATUS_RD_PTR_Pos 16UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_STATUS_RD_PTR_Msk 0x7F0000UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_STATUS_WR_PTR_Pos 24UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_STATUS_WR_PTR_Msk 0x7F000000UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_FIFO_RD */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_RD_DATA_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_RD_DATA_Msk 0xFFFFFFFFUL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.RX_FIFO_RD_SILENT */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_RD_SILENT_DATA_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_RX_FIFO_RD_SILENT_DATA_Msk 0xFFFFFFFFUL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.INTR_RX */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_IF_OVERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_IF_OVERFLOW_Msk 0x100UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.INTR_RX_SET */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_IF_OVERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_SET_IF_OVERFLOW_Msk 0x100UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.INTR_RX_MASK */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_IF_OVERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASK_IF_OVERFLOW_Msk 0x100UL
/* TDM_TDM_STRUCT_TDM_RX_STRUCT.INTR_RX_MASKED */
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_FIFO_TRIGGER_Pos 0UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_FIFO_TRIGGER_Msk 0x1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_FIFO_OVERFLOW_Pos 1UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_FIFO_OVERFLOW_Msk 0x2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_FIFO_UNDERFLOW_Pos 2UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_FIFO_UNDERFLOW_Msk 0x4UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_IF_OVERFLOW_Pos 8UL
#define TDM_TDM_STRUCT_TDM_RX_STRUCT_INTR_RX_MASKED_IF_OVERFLOW_Msk 0x100UL


#endif /* _CYIP_TDM_H_ */


/* [] END OF FILE */
