/*******************************************************************************
* File Name: cycfg_capsense.h
*
* Description:
* CAPSENSE Middleware configuration
* This file should not be modified. It was automatically generated by
* CAPSENSE Configurator 5.0.0.2684
*
********************************************************************************
* Copyright 2023, Cypress Semiconductor Corporation (an Infineon company)
* or an affiliate of Cypress Semiconductor Corporation.
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#if !defined(CYCFG_CAPSENSE_H)
#define CYCFG_CAPSENSE_H

/* This enables code only when the CAPSENSE(TM) Middleware is present in the project
 * or the information about the Middleware presence cannot be obtained.
 */
#if (defined(COMPONENT_MW_CAPSENSE) || !defined(COMPONENT_MW_CORE_MAKE))

#include <stddef.h>
#include "cy_device_headers.h"
#include "cycfg_peripherals.h"
#include "cycfg_capsense_defines.h"

#define CY_CAPSENSE_CFG_TOOL_VERSION              (500)

#if !defined(CY_DISABLE_CAPSENSE)

#if (CY_CAPSENSE_CORE == __CORTEX_M)


#if !defined(Cmod_PORT) || !defined(Cmod_PIN) || !defined(Cmod_PORT_NUM)
#error Cmod Capacitor is not assigned: missing #define Cmod_PORT, #define Cmod_PIN, #define Cmod_PORT_NUM
#endif

#if !defined(LinearSlider0_Sns0_PORT) || !defined(LinearSlider0_Sns0_PIN)
#error LinearSlider0_Sns0 Sensor is not assigned: missing #define LinearSlider0_Sns0_PORT, #define LinearSlider0_Sns0_PIN
#endif

#if !defined(LinearSlider0_Sns1_PORT) || !defined(LinearSlider0_Sns1_PIN)
#error LinearSlider0_Sns1 Sensor is not assigned: missing #define LinearSlider0_Sns1_PORT, #define LinearSlider0_Sns1_PIN
#endif

#if !defined(LinearSlider0_Sns2_PORT) || !defined(LinearSlider0_Sns2_PIN)
#error LinearSlider0_Sns2 Sensor is not assigned: missing #define LinearSlider0_Sns2_PORT, #define LinearSlider0_Sns2_PIN
#endif

#if !defined(LinearSlider0_Sns3_PORT) || !defined(LinearSlider0_Sns3_PIN)
#error LinearSlider0_Sns3 Sensor is not assigned: missing #define LinearSlider0_Sns3_PORT, #define LinearSlider0_Sns3_PIN
#endif

#if !defined(LinearSlider0_Sns4_PORT) || !defined(LinearSlider0_Sns4_PIN)
#error LinearSlider0_Sns4 Sensor is not assigned: missing #define LinearSlider0_Sns4_PORT, #define LinearSlider0_Sns4_PIN
#endif

#if !defined(CY_CAPSENSE_CPU_CLK)
#error CPU clock frequency is not set: missing #define CY_CAPSENSE_CPU_CLK
#endif

#if !defined(CY_CAPSENSE_PERI_CLK)
#error Peripheral clock core is not set: missing #define CY_CAPSENSE_PERI_CLK
#endif

#if !defined(CY_CAPSENSE_VDDA_MV)
#error VDDA voltage is not set: missing #define CY_CAPSENSE_VDDA_MV
#endif

#if !defined(CY_CAPSENSE_PERI_DIV_TYPE)
#error Peripheral clock divider type is not set: missing #define CY_CAPSENSE_PERI_DIV_TYPE
#endif

#if !defined(CY_CAPSENSE_PERI_DIV_INDEX)
#error Peripheral clock divider index is not set: missing #define CY_CAPSENSE_PERI_DIV_INDEX
#endif



#include "cy_capsense.h"

/* Supported CapSense Middleware version */
#define CY_CAPSENSE_MW_VERSION_REQUIRED           (200)

#if !defined (CY_CAPSENSE_MW_VERSION)
    #if (CY_CAPSENSE_MW_VERSION_MAJOR == 2)
        #define CY_CAPSENSE_MW_VERSION            (200)
    #elif (CY_CAPSENSE_MW_VERSION_MAJOR == 1)
        #define CY_CAPSENSE_MW_VERSION            (100)
    #else
        #define CY_CAPSENSE_MW_VERSION            (100)
    #endif
#endif

/* Check the used Middleware version */
#if (CY_CAPSENSE_MW_VERSION_REQUIRED > CY_CAPSENSE_MW_VERSION)
    #error The CapSense Configurator requires a newer version of the CapSense Middleware. Update the CapSense Middleware in your project.
#endif

#define CY_CAPSENSE_BIST_SUPPORTED                (CY_CAPSENSE_MW_VERSION >= 210)

#if defined(__cplusplus)
extern "C" {
#endif

/* Widget names */
#define CY_CAPSENSE_LINEARSLIDER0_WDGT_ID                                        (0u)

/* LinearSlider0 sensor names */
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ID                                        (0u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ID                                        (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ID                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ID                                        (3u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ID                                        (4u)


typedef struct {
    cy_stc_capsense_common_context_t commonContext;
    cy_stc_capsense_widget_context_t widgetContext[1];
    cy_stc_capsense_sensor_context_t sensorContext[5];
    cy_stc_capsense_position_t position[1];
} cy_stc_capsense_tuner_t;

extern cy_stc_capsense_tuner_t cy_capsense_tuner;

extern cy_stc_capsense_context_t cy_capsense_context;

/* RAM Data structure register definitions */
#if (CY_CAPSENSE_MW_VERSION < 300)
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000004u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000006u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000007u)

#define CY_CAPSENSE_PTRSSCALLBACK_VALUE                                          (cy_capsense_tuner.commonContext.ptrSSCallback)
#define CY_CAPSENSE_PTRSSCALLBACK_OFFSET                                         (8u)
#define CY_CAPSENSE_PTRSSCALLBACK_SIZE                                           (4u)
#define CY_CAPSENSE_PTRSSCALLBACK_PARAM_ID                                       (0x03000008u)

#define CY_CAPSENSE_PTREOSCALLBACK_VALUE                                         (cy_capsense_tuner.commonContext.ptrEOSCallback)
#define CY_CAPSENSE_PTREOSCALLBACK_OFFSET                                        (12u)
#define CY_CAPSENSE_PTREOSCALLBACK_SIZE                                          (4u)
#define CY_CAPSENSE_PTREOSCALLBACK_PARAM_ID                                      (0x0300000cu)

#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_VALUE                                   (cy_capsense_tuner.commonContext.ptrTunerSendCallback)
#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_OFFSET                                  (16u)
#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_SIZE                                    (4u)
#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_PARAM_ID                                (0x03000010u)

#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_VALUE                                (cy_capsense_tuner.commonContext.ptrTunerReceiveCallback)
#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_OFFSET                               (20u)
#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_SIZE                                 (4u)
#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_PARAM_ID                             (0x03000014u)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (24u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x03000018u)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (28u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x0300001cu)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (32u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000020u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (36u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000024u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (37u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000025u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (38u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x01000026u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (40u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x06000028u)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (42u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0600002au)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (44u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x0600002cu)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (46u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x0200002eu)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (48u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02000030u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (50u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02000032u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (52u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x06000034u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (54u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x06000036u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (56u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x06000038u)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (58u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x0200003au)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (60u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x0200003cu)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (62u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x0200003eu)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (64u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x02000040u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (66u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x01000042u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (67u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x01000043u)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (68u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x01000044u)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (69u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x05000045u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (70u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x05000046u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (71u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x05000047u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (72u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x05000048u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (73u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x05000049u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (74u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x0500004au)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (75u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x0500004bu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (76u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x0500004cu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (77u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x0500004du)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (78u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x0100004eu)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (79u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x0100004fu)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (80u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x03000050u)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (84u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x01000054u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (88u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x02000058u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (90u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x0200005au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (92u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x0200005cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (94u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x0100005eu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (95u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x0100005fu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (96u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x01000060u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (97u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x01000061u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (98u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x02000062u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (100u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x02000064u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (102u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x02000066u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (104u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x01000068u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (105u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01000069u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (106u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x0100006au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (107u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x0100006bu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (108u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x0200006cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (110u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x0200006eu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (112u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x02000070u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (114u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x01000072u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (115u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01000073u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (116u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x01000074u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (117u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x01000075u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (118u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x02000076u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (120u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x02000078u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (122u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x0200007au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (124u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x0100007cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (125u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x0100007du)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (126u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x0100007eu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (127u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x0100007fu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (128u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x02000080u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (130u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x02000082u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (132u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x02000084u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (134u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x01000086u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (135u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01000087u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (136u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x01000088u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (137u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x01000089u)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (138u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x0200008au)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (140u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x0200008cu)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (142u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x0200008eu)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (144u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x02000090u)

#else /* CY_CAPSENSE_MW_VERSION >= 300 */
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000004u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000006u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000007u)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x03000008u)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x0300000cu)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000010u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000014u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000015u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x01000016u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (24u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x06000018u)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (26u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0600001au)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (28u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x0600001cu)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (30u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x0200001eu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_VALUE                        (cy_capsense_tuner.widgetContext[0].maxRawCountRow)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (32u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_PARAM_ID                     (0x02000020u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (34u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02000022u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (36u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02000024u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (38u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x06000026u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (40u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x06000028u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (42u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x0600002au)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (44u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x0200002cu)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (46u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x0200002eu)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (48u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x02000030u)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (50u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x02000032u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (52u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x02000034u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (54u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x02000036u)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (56u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x02000038u)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (58u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x0500003au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (59u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x0500003bu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (60u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x0500003cu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (61u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x0500003du)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (62u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x0500003eu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (63u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x0500003fu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (64u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x05000040u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (65u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x05000041u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (66u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x05000042u)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (67u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x01000043u)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (68u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x01000044u)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (72u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x03000048u)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (76u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x0100004cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (80u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x02000050u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (82u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x02000052u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (84u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x02000054u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (86u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x01000056u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (87u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01000057u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (88u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x01000058u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (89u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x01000059u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (90u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x0200005au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (92u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x0200005cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (94u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x0200005eu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (96u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x01000060u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (97u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01000061u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (98u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x01000062u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (99u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x01000063u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (100u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x02000064u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (102u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x02000066u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (104u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x02000068u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (106u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x0100006au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (107u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x0100006bu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (108u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x0100006cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (109u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x0100006du)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (110u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x0200006eu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (112u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x02000070u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (114u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x02000072u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (116u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x01000074u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (117u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01000075u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (118u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x01000076u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (119u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x01000077u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (120u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x02000078u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (122u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x0200007au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (124u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x0200007cu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (126u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x0100007eu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (127u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x0100007fu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (128u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x01000080u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (129u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x01000081u)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (130u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x02000082u)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (132u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x02000084u)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (134u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x02000086u)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (136u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x02000088u)

#endif
/* cy_capsense_context */
#define CY_CAPSENSE_COMMON_CONFIG_PTR_VALUE                                      (cy_capsense_context.ptrCommonConfig)
#define CY_CAPSENSE_COMMON_CONFIG_PTR_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig))

#define CY_CAPSENSE_COMMON_CONTEXT_PTR_VALUE                                     (cy_capsense_context.ptrCommonContext)
#define CY_CAPSENSE_COMMON_CONTEXT_PTR_SIZE                                      (sizeof(cy_capsense_context.ptrCommonContext))

#define CY_CAPSENSE_INTERNAL_CONTEXT_PTR_VALUE                                   (cy_capsense_context.ptrInternalContext)
#define CY_CAPSENSE_INTERNAL_CONTEXT_PTR_SIZE                                    (sizeof(cy_capsense_context.ptrInternalContext))

#define CY_CAPSENSE_WD_CONFIG_PTR_VALUE                                          (cy_capsense_context.ptrWdConfig)
#define CY_CAPSENSE_WD_CONFIG_PTR_SIZE                                           (sizeof(cy_capsense_context.ptrWdConfig))

#define CY_CAPSENSE_WD_CONTEXT_PTR_VALUE                                         (cy_capsense_context.ptrWdContext)
#define CY_CAPSENSE_WD_CONTEXT_PTR_SIZE                                          (sizeof(cy_capsense_context.ptrWdContext))

#define CY_CAPSENSE_PIN_CONFIG_PTR_VALUE                                         (cy_capsense_context.ptrPinConfig)
#define CY_CAPSENSE_PIN_CONFIG_PTR_SIZE                                          (sizeof(cy_capsense_context.ptrPinConfig))

#define CY_CAPSENSE_SHIELD_PIN_CONFIG_PTR_VALUE                                  (cy_capsense_context.ptrShieldPinConfig)
#define CY_CAPSENSE_SHIELD_PIN_CONFIG_PTR_SIZE                                   (sizeof(cy_capsense_context.ptrShieldPinConfig))

#define CY_CAPSENSE_ACTIVE_SCAN_SNS_PTR_VALUE                                    (cy_capsense_context.ptrActiveScanSns)
#define CY_CAPSENSE_ACTIVE_SCAN_SNS_PTR_SIZE                                     (sizeof(cy_capsense_context.ptrActiveScanSns))

#if (CY_CAPSENSE_MW_VERSION < 300)
#define CY_CAPSENSE_FPTR_CONFIG_PTR_VALUE                                        (cy_capsense_context.ptrFptrConfig)
#define CY_CAPSENSE_FPTR_CONFIG_PTR_SIZE                                         (sizeof(cy_capsense_context.ptrFptrConfig))
#endif

#define CY_CAPSENSE_BIST_CONTEXT_PTR_VALUE                                       (cy_capsense_context.ptrBistContext)
#define CY_CAPSENSE_BIST_CONTEXT_PTR_SIZE                                        (sizeof(cy_capsense_context.ptrBistContext))

/* cy_capsense_commonConfig */
#define CY_CAPSENSE_CPU_CLK_HZ_VALUE                                             (cy_capsense_context.ptrCommonConfig->cpuClkHz)
#define CY_CAPSENSE_CPU_CLK_HZ_SIZE                                              (sizeof(cy_capsense_context.ptrCommonConfig->cpuClkHz))

#define CY_CAPSENSE_PERI_CLK_HZ_VALUE                                            (cy_capsense_context.ptrCommonConfig->periClkHz)
#define CY_CAPSENSE_PERI_CLK_HZ_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->periClkHz))

#define CY_CAPSENSE_VDDA_VALUE                                                   (cy_capsense_context.ptrCommonConfig->vdda)
#define CY_CAPSENSE_VDDA_SIZE                                                    (sizeof(cy_capsense_context.ptrCommonConfig->vdda))

#define CY_CAPSENSE_NUM_PIN_VALUE                                                (cy_capsense_context.ptrCommonConfig->numPin)
#define CY_CAPSENSE_NUM_PIN_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->numPin))

#define CY_CAPSENSE_NUM_SNS_VALUE                                                (cy_capsense_context.ptrCommonConfig->numSns)
#define CY_CAPSENSE_NUM_SNS_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->numSns))

#define CY_CAPSENSE_NUM_WD_VALUE                                                 (cy_capsense_context.ptrCommonConfig->numWd)
#define CY_CAPSENSE_NUM_WD_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->numWd))

#define CY_CAPSENSE_CSD_EN_VALUE                                                 (cy_capsense_context.ptrCommonConfig->csdEn)
#define CY_CAPSENSE_CSD_EN_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->csdEn))

#define CY_CAPSENSE_CSX_EN_VALUE                                                 (cy_capsense_context.ptrCommonConfig->csxEn)
#define CY_CAPSENSE_CSX_EN_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->csxEn))

#if (CY_CAPSENSE_MW_VERSION < 300)
#define CY_CAPSENSE_MFS_EN_VALUE                                                 (cy_capsense_context.ptrCommonConfig->mfsEn)
#define CY_CAPSENSE_MFS_EN_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->mfsEn))
#endif

#define CY_CAPSENSE_BIST_EN_VALUE                                                (cy_capsense_context.ptrCommonConfig->bistEn)
#define CY_CAPSENSE_BIST_EN_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->bistEn))

#define CY_CAPSENSE_POSITION_FILTER_EN_VALUE                                     (cy_capsense_context.ptrCommonConfig->positionFilterEn)
#define CY_CAPSENSE_POSITION_FILTER_EN_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->positionFilterEn))

#define CY_CAPSENSE_PERI_DIVIDER_TYPE_VALUE                                      (cy_capsense_context.ptrCommonConfig->periDividerType)
#define CY_CAPSENSE_PERI_DIVIDER_TYPE_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig->periDividerType))

#define CY_CAPSENSE_PERI_DIVIDER_INDEX_VALUE                                     (cy_capsense_context.ptrCommonConfig->periDividerIndex)
#define CY_CAPSENSE_PERI_DIVIDER_INDEX_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->periDividerIndex))

#define CY_CAPSENSE_ANALOG_WAKEUP_DELAY_VALUE                                    (cy_capsense_context.ptrCommonConfig->analogWakeupDelay)
#define CY_CAPSENSE_ANALOG_WAKEUP_DELAY_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->analogWakeupDelay))

#define CY_CAPSENSE_SS_IREF_SOURCE_VALUE                                         (cy_capsense_context.ptrCommonConfig->ssIrefSource)
#define CY_CAPSENSE_SS_IREF_SOURCE_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->ssIrefSource))

#define CY_CAPSENSE_SS_VREF_SOURCE_VALUE                                         (cy_capsense_context.ptrCommonConfig->ssVrefSource)
#define CY_CAPSENSE_SS_VREF_SOURCE_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->ssVrefSource))

#define CY_CAPSENSE_PROX_TOUCH_COEFF_VALUE                                       (cy_capsense_context.ptrCommonConfig->proxTouchCoeff)
#define CY_CAPSENSE_PROX_TOUCH_COEFF_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->proxTouchCoeff))

#define CY_CAPSENSE_SW_SENSOR_AUTO_RESET_EN_VALUE                                (cy_capsense_context.ptrCommonConfig->swSensorAutoResetEn)
#define CY_CAPSENSE_SW_SENSOR_AUTO_RESET_EN_SIZE                                 (sizeof(cy_capsense_context.ptrCommonConfig->swSensorAutoResetEn))

#define CY_CAPSENSE_PORT_CMOD_PAD_NUM_VALUE                                      (cy_capsense_context.ptrCommonConfig->portCmodPadNum)
#define CY_CAPSENSE_PORT_CMOD_PAD_NUM_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig->portCmodPadNum))

#define CY_CAPSENSE_PIN_CMOD_PAD_VALUE                                           (cy_capsense_context.ptrCommonConfig->pinCmodPad)
#define CY_CAPSENSE_PIN_CMOD_PAD_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->pinCmodPad))

#define CY_CAPSENSE_PORT_CSH_PAD_NUM_VALUE                                       (cy_capsense_context.ptrCommonConfig->portCshPadNum)
#define CY_CAPSENSE_PORT_CSH_PAD_NUM_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->portCshPadNum))

#define CY_CAPSENSE_PIN_CSH_PAD_VALUE                                            (cy_capsense_context.ptrCommonConfig->pinCshPad)
#define CY_CAPSENSE_PIN_CSH_PAD_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->pinCshPad))

#define CY_CAPSENSE_PORT_SHIELD_PAD_NUM_VALUE                                    (cy_capsense_context.ptrCommonConfig->portShieldPadNum)
#define CY_CAPSENSE_PORT_SHIELD_PAD_NUM_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->portShieldPadNum))

#define CY_CAPSENSE_PIN_SHIELD_PAD_VALUE                                         (cy_capsense_context.ptrCommonConfig->pinShieldPad)
#define CY_CAPSENSE_PIN_SHIELD_PAD_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->pinShieldPad))

#define CY_CAPSENSE_PORT_VREF_EXT_PAD_NUM_VALUE                                  (cy_capsense_context.ptrCommonConfig->portVrefExtPadNum)
#define CY_CAPSENSE_PORT_VREF_EXT_PAD_NUM_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->portVrefExtPadNum))

#define CY_CAPSENSE_PIN_VREF_EXT_PAD_VALUE                                       (cy_capsense_context.ptrCommonConfig->pinVrefExtPad)
#define CY_CAPSENSE_PIN_VREF_EXT_PAD_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->pinVrefExtPad))

#define CY_CAPSENSE_PORT_CMOD_NUM_VALUE                                          (cy_capsense_context.ptrCommonConfig->portCmodNum)
#define CY_CAPSENSE_PORT_CMOD_NUM_SIZE                                           (sizeof(cy_capsense_context.ptrCommonConfig->portCmodNum))

#define CY_CAPSENSE_IDAC_GAIN_TABLE_PTR_VALUE                                    (&cy_capsense_context.ptrCommonConfig->idacGainTable[0u])
#define CY_CAPSENSE_IDAC_GAIN_TABLE_PTR_SIZE                                     (sizeof(&cy_capsense_context.ptrCommonConfig->idacGainTable[0u]))

#define CY_CAPSENSE_PTR_CSD_BASE_VALUE                                           (cy_capsense_context.ptrCommonConfig->ptrCsdBase)
#define CY_CAPSENSE_PTR_CSD_BASE_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->ptrCsdBase))

#define CY_CAPSENSE_PTR_CSD_CONTEXT_VALUE                                        (cy_capsense_context.ptrCommonConfig->ptrCsdContext)
#define CY_CAPSENSE_PTR_CSD_CONTEXT_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->ptrCsdContext))

#define CY_CAPSENSE_PORT_CMOD_VALUE                                              (cy_capsense_context.ptrCommonConfig->portCmod)
#define CY_CAPSENSE_PORT_CMOD_SIZE                                               (sizeof(cy_capsense_context.ptrCommonConfig->portCmod))

#define CY_CAPSENSE_PORT_CSH_VALUE                                               (cy_capsense_context.ptrCommonConfig->portCsh)
#define CY_CAPSENSE_PORT_CSH_SIZE                                                (sizeof(cy_capsense_context.ptrCommonConfig->portCsh))

#define CY_CAPSENSE_PORT_CINT_A_VALUE                                            (cy_capsense_context.ptrCommonConfig->portCintA)
#define CY_CAPSENSE_PORT_CINT_A_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->portCintA))

#define CY_CAPSENSE_PORT_CINT_B_VALUE                                            (cy_capsense_context.ptrCommonConfig->portCintB)
#define CY_CAPSENSE_PORT_CINT_B_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->portCintB))

#define CY_CAPSENSE_PIN_CMOD_VALUE                                               (cy_capsense_context.ptrCommonConfig->pinCmod)
#define CY_CAPSENSE_PIN_CMOD_SIZE                                                (sizeof(cy_capsense_context.ptrCommonConfig->pinCmod))

#define CY_CAPSENSE_PORT_CSH_NUM_VALUE                                           (cy_capsense_context.ptrCommonConfig->portCshNum)
#define CY_CAPSENSE_PORT_CSH_NUM_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->portCshNum))

#define CY_CAPSENSE_PIN_CSH_VALUE                                                (cy_capsense_context.ptrCommonConfig->pinCsh)
#define CY_CAPSENSE_PIN_CSH_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->pinCsh))

#define CY_CAPSENSE_PIN_CINT_A_VALUE                                             (cy_capsense_context.ptrCommonConfig->pinCintA)
#define CY_CAPSENSE_PIN_CINT_A_SIZE                                              (sizeof(cy_capsense_context.ptrCommonConfig->pinCintA))

#define CY_CAPSENSE_PIN_CINT_B_VALUE                                             (cy_capsense_context.ptrCommonConfig->pinCintB)
#define CY_CAPSENSE_PIN_CINT_B_SIZE                                              (sizeof(cy_capsense_context.ptrCommonConfig->pinCintB))

#define CY_CAPSENSE_CSD_SHIELD_EN_VALUE                                          (cy_capsense_context.ptrCommonConfig->csdShieldEn)
#define CY_CAPSENSE_CSD_SHIELD_EN_SIZE                                           (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldEn))

#define CY_CAPSENSE_CSD_INACTIVE_SNS_CONNECTION_VALUE                            (cy_capsense_context.ptrCommonConfig->csdInactiveSnsConnection)
#define CY_CAPSENSE_CSD_INACTIVE_SNS_CONNECTION_SIZE                             (sizeof(cy_capsense_context.ptrCommonConfig->csdInactiveSnsConnection))

#if (CY_CAPSENSE_MW_VERSION >= 300)
#define CY_CAPSENSE_CSX_INACTIVE_SNS_CONNECTION_VALUE                            (cy_capsense_context.ptrCommonConfig->csxInactiveSnsConnection)
#define CY_CAPSENSE_CSX_INACTIVE_SNS_CONNECTION_SIZE                             (sizeof(cy_capsense_context.ptrCommonConfig->csxInactiveSnsConnection))
#endif

#define CY_CAPSENSE_CSD_SHIELD_DELAY_VALUE                                       (cy_capsense_context.ptrCommonConfig->csdShieldDelay)
#define CY_CAPSENSE_CSD_SHIELD_DELAY_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldDelay))

#define CY_CAPSENSE_CSD_VREF_VALUE                                               (cy_capsense_context.ptrCommonConfig->csdVref)
#define CY_CAPSENSE_CSD_VREF_SIZE                                                (sizeof(cy_capsense_context.ptrCommonConfig->csdVref))

#define CY_CAPSENSE_CSD_R_CONST_VALUE                                            (cy_capsense_context.ptrCommonConfig->csdRConst)
#define CY_CAPSENSE_CSD_R_CONST_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->csdRConst))

#define CY_CAPSENSE_CSD_C_TANK_SHIELD_EN_VALUE                                   (cy_capsense_context.ptrCommonConfig->csdCTankShieldEn)
#define CY_CAPSENSE_CSD_C_TANK_SHIELD_EN_SIZE                                    (sizeof(cy_capsense_context.ptrCommonConfig->csdCTankShieldEn))

#define CY_CAPSENSE_CSD_SHIELD_NUM_PIN_VALUE                                     (cy_capsense_context.ptrCommonConfig->csdShieldNumPin)
#define CY_CAPSENSE_CSD_SHIELD_NUM_PIN_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldNumPin))

#define CY_CAPSENSE_CSD_SHIELD_SW_RES_VALUE                                      (cy_capsense_context.ptrCommonConfig->csdShieldSwRes)
#define CY_CAPSENSE_CSD_SHIELD_SW_RES_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldSwRes))

#define CY_CAPSENSE_CSD_INIT_SW_RES_VALUE                                        (cy_capsense_context.ptrCommonConfig->csdInitSwRes)
#define CY_CAPSENSE_CSD_INIT_SW_RES_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csdInitSwRes))

#define CY_CAPSENSE_CSD_CHARGE_TRANSFER_VALUE                                    (cy_capsense_context.ptrCommonConfig->csdChargeTransfer)
#define CY_CAPSENSE_CSD_CHARGE_TRANSFER_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->csdChargeTransfer))

#define CY_CAPSENSE_CSD_RAW_TARGET_VALUE                                         (cy_capsense_context.ptrCommonConfig->csdRawTarget)
#define CY_CAPSENSE_CSD_RAW_TARGET_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->csdRawTarget))

#define CY_CAPSENSE_CSD_AUTOTUNE_EN_VALUE                                        (cy_capsense_context.ptrCommonConfig->csdAutotuneEn)
#define CY_CAPSENSE_CSD_AUTOTUNE_EN_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csdAutotuneEn))

#define CY_CAPSENSE_CSD_IDAC_AUTOCAL_EN_VALUE                                    (cy_capsense_context.ptrCommonConfig->csdIdacAutocalEn)
#define CY_CAPSENSE_CSD_IDAC_AUTOCAL_EN_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacAutocalEn))

#define CY_CAPSENSE_CSD_IDAC_AUTO_GAIN_EN_VALUE                                  (cy_capsense_context.ptrCommonConfig->csdIdacAutoGainEn)
#define CY_CAPSENSE_CSD_IDAC_AUTO_GAIN_EN_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacAutoGainEn))

#define CY_CAPSENSE_CSD_CALIBRATION_ERROR_VALUE                                  (cy_capsense_context.ptrCommonConfig->csdCalibrationError)
#define CY_CAPSENSE_CSD_CALIBRATION_ERROR_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->csdCalibrationError))

#define CY_CAPSENSE_CSD_IDAC_GAIN_INIT_INDEX_VALUE                               (cy_capsense_context.ptrCommonConfig->csdIdacGainInitIndex)
#define CY_CAPSENSE_CSD_IDAC_GAIN_INIT_INDEX_SIZE                                (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacGainInitIndex))

#define CY_CAPSENSE_CSD_IDAC_MIN_VALUE                                           (cy_capsense_context.ptrCommonConfig->csdIdacMin)
#define CY_CAPSENSE_CSD_IDAC_MIN_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacMin))

#define CY_CAPSENSE_CSD_IDAC_COMP_EN_VALUE                                       (cy_capsense_context.ptrCommonConfig->csdIdacCompEn)
#define CY_CAPSENSE_CSD_IDAC_COMP_EN_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacCompEn))

#define CY_CAPSENSE_CSD_FINE_INIT_TIME_VALUE                                     (cy_capsense_context.ptrCommonConfig->csdFineInitTime)
#define CY_CAPSENSE_CSD_FINE_INIT_TIME_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->csdFineInitTime))

#define CY_CAPSENSE_CSD_IDAC_ROW_COL_ALIGN_EN_VALUE                              (cy_capsense_context.ptrCommonConfig->csdIdacRowColAlignEn)
#define CY_CAPSENSE_CSD_IDAC_ROW_COL_ALIGN_EN_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacRowColAlignEn))

#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F1_VALUE                              (cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF1)
#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F1_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF1))

#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F2_VALUE                              (cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF2)
#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F2_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF2))

#define CY_CAPSENSE_CSX_RAW_TARGET_VALUE                                         (cy_capsense_context.ptrCommonConfig->csxRawTarget)
#define CY_CAPSENSE_CSX_RAW_TARGET_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->csxRawTarget))

#define CY_CAPSENSE_CSX_IDAC_GAIN_INIT_INDEX_VALUE                               (cy_capsense_context.ptrCommonConfig->csxIdacGainInitIndex)
#define CY_CAPSENSE_CSX_IDAC_GAIN_INIT_INDEX_SIZE                                (sizeof(cy_capsense_context.ptrCommonConfig->csxIdacGainInitIndex))

#define CY_CAPSENSE_CSX_REF_GAIN_VALUE                                           (cy_capsense_context.ptrCommonConfig->csxRefGain)
#define CY_CAPSENSE_CSX_REF_GAIN_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->csxRefGain))

#define CY_CAPSENSE_CSX_IDAC_AUTOCAL_EN_VALUE                                    (cy_capsense_context.ptrCommonConfig->csxIdacAutocalEn)
#define CY_CAPSENSE_CSX_IDAC_AUTOCAL_EN_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->csxIdacAutocalEn))

#define CY_CAPSENSE_CSX_CALIBRATION_ERROR_VALUE                                  (cy_capsense_context.ptrCommonConfig->csxCalibrationError)
#define CY_CAPSENSE_CSX_CALIBRATION_ERROR_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->csxCalibrationError))

#define CY_CAPSENSE_CSX_FINE_INIT_TIME_VALUE                                     (cy_capsense_context.ptrCommonConfig->csxFineInitTime)
#define CY_CAPSENSE_CSX_FINE_INIT_TIME_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->csxFineInitTime))

#define CY_CAPSENSE_CSX_INIT_SW_RES_VALUE                                        (cy_capsense_context.ptrCommonConfig->csxInitSwRes)
#define CY_CAPSENSE_CSX_INIT_SW_RES_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csxInitSwRes))

#define CY_CAPSENSE_CSX_SCAN_SW_RES_VALUE                                        (cy_capsense_context.ptrCommonConfig->csxScanSwRes)
#define CY_CAPSENSE_CSX_SCAN_SW_RES_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csxScanSwRes))

#define CY_CAPSENSE_CSX_INIT_SHIELD_SW_RES_VALUE                                 (cy_capsense_context.ptrCommonConfig->csxInitShieldSwRes)
#define CY_CAPSENSE_CSX_INIT_SHIELD_SW_RES_SIZE                                  (sizeof(cy_capsense_context.ptrCommonConfig->csxInitShieldSwRes))

#define CY_CAPSENSE_CSX_SCAN_SHIELD_SW_RES_VALUE                                 (cy_capsense_context.ptrCommonConfig->csxScanShieldSwRes)
#define CY_CAPSENSE_CSX_SCAN_SHIELD_SW_RES_SIZE                                  (sizeof(cy_capsense_context.ptrCommonConfig->csxScanShieldSwRes))

#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F1_VALUE                              (cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF1)
#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F1_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF1))

#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F2_VALUE                              (cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF2)
#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F2_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF2))

/* cy_capsense_widgetConfig */
#define CY_CAPSENSE_LINEARSLIDER0_PTR_WD_CONTEXT_VALUE                           (cy_capsense_context.ptrWdConfig[0u].ptrWdContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_WD_CONTEXT_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrWdContext))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_SNS_CONTEXT_VALUE                          (cy_capsense_context.ptrWdConfig[0u].ptrSnsContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_SNS_CONTEXT_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrSnsContext))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CONTEXT_VALUE                         (cy_capsense_context.ptrWdConfig[0u].ptrEltdConfig)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CONTEXT_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrEltdConfig))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CAPACITANCE_VALUE                     (cy_capsense_context.ptrWdConfig[0u].ptrEltdCapacitance)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CAPACITANCE_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrEltdCapacitance))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BSLN_INV_VALUE                             (cy_capsense_context.ptrWdConfig[0u].ptrBslnInv)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BSLN_INV_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrBslnInv))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_NOISE_ENVELOPE_VALUE                       (cy_capsense_context.ptrWdConfig[0u].ptrNoiseEnvelope)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_NOISE_ENVELOPE_SIZE                        (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrNoiseEnvelope))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_VALUE                   (cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistory)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_SIZE                    (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistory))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_LOW_VALUE               (cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistoryLow)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_LOW_SIZE                (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistoryLow))
#define CY_CAPSENSE_LINEARSLIDER0_IIR_COEFF_VALUE                                (cy_capsense_context.ptrWdConfig[0u].iirCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_IIR_COEFF_SIZE                                 (sizeof(cy_capsense_context.ptrWdConfig[0u].iirCoeff))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DEBOUNCE_ARR_VALUE                         (cy_capsense_context.ptrWdConfig[0u].ptrDebounceArr)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DEBOUNCE_ARR_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrDebounceArr))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DIPLEX_TABLE_VALUE                         (cy_capsense_context.ptrWdConfig[0u].ptrDiplexTable)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DIPLEX_TABLE_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrDiplexTable))
#define CY_CAPSENSE_LINEARSLIDER0_CENTROID_CONFIG_VALUE                          (cy_capsense_context.ptrWdConfig[0u].centroidConfig)
#define CY_CAPSENSE_LINEARSLIDER0_CENTROID_CONFIG_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[0u].centroidConfig))
#define CY_CAPSENSE_LINEARSLIDER0_X_RESOLUTION_VALUE                             (cy_capsense_context.ptrWdConfig[0u].xResolution)
#define CY_CAPSENSE_LINEARSLIDER0_X_RESOLUTION_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0u].xResolution))
#define CY_CAPSENSE_LINEARSLIDER0_Y_RESOLUTION_VALUE                             (cy_capsense_context.ptrWdConfig[0u].yResolution)
#define CY_CAPSENSE_LINEARSLIDER0_Y_RESOLUTION_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0u].yResolution))
#define CY_CAPSENSE_LINEARSLIDER0_NUM_SNS_VALUE                                  (cy_capsense_context.ptrWdConfig[0u].numSns)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_SNS_SIZE                                   (sizeof(cy_capsense_context.ptrWdConfig[0u].numSns))
#define CY_CAPSENSE_LINEARSLIDER0_NUM_COLS_VALUE                                 (cy_capsense_context.ptrWdConfig[0u].numCols)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_COLS_SIZE                                  (sizeof(cy_capsense_context.ptrWdConfig[0u].numCols))
#define CY_CAPSENSE_LINEARSLIDER0_NUM_ROWS_VALUE                                 (cy_capsense_context.ptrWdConfig[0u].numRows)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_ROWS_SIZE                                  (sizeof(cy_capsense_context.ptrWdConfig[0u].numRows))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_POS_FILTER_HISTORY_VALUE                   (cy_capsense_context.ptrWdConfig[0u].ptrPosFilterHistory)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_POS_FILTER_HISTORY_SIZE                    (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrPosFilterHistory))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_HISTORY_VALUE                    (cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchHistory)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_HISTORY_SIZE                     (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchHistory))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_BUFFER_VALUE                     (cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchBuffer)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_BUFFER_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchBuffer))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSD_TOUCH_BUFFER_VALUE                     (cy_capsense_context.ptrWdConfig[0u].ptrCsdTouchBuffer)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSD_TOUCH_BUFFER_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrCsdTouchBuffer))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONFIG_VALUE                       (cy_capsense_context.ptrWdConfig[0u].ptrGestureConfig)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONFIG_SIZE                        (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrGestureConfig))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONTEXT_VALUE                      (cy_capsense_context.ptrWdConfig[0u].ptrGestureContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONTEXT_SIZE                       (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrGestureContext))
#define CY_CAPSENSE_LINEARSLIDER0_BALLISTIC_CONFIG_VALUE                         (cy_capsense_context.ptrWdConfig[0u].ballisticConfig)
#define CY_CAPSENSE_LINEARSLIDER0_BALLISTIC_CONFIG_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[0u].ballisticConfig))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BALLISTIC_CONTEXT_VALUE                    (cy_capsense_context.ptrWdConfig[0u].ptrBallisticContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BALLISTIC_CONTEXT_SIZE                     (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrBallisticContext))
#define CY_CAPSENSE_LINEARSLIDER0_AIIR_CONFIG_VALUE                              (cy_capsense_context.ptrWdConfig[0u].aiirConfig)
#define CY_CAPSENSE_LINEARSLIDER0_AIIR_CONFIG_SIZE                               (sizeof(cy_capsense_context.ptrWdConfig[0u].aiirConfig))
#define CY_CAPSENSE_LINEARSLIDER0_ADV_CONFIG_VALUE                               (cy_capsense_context.ptrWdConfig[0u].advConfig)
#define CY_CAPSENSE_LINEARSLIDER0_ADV_CONFIG_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[0u].advConfig))
#define CY_CAPSENSE_LINEARSLIDER0_POS_FILTER_CONFIG_VALUE                        (cy_capsense_context.ptrWdConfig[0u].posFilterConfig)
#define CY_CAPSENSE_LINEARSLIDER0_POS_FILTER_CONFIG_SIZE                         (sizeof(cy_capsense_context.ptrWdConfig[0u].posFilterConfig))
#define CY_CAPSENSE_LINEARSLIDER0_RAW_FILTER_CONFIG_VALUE                        (cy_capsense_context.ptrWdConfig[0u].rawFilterConfig)
#define CY_CAPSENSE_LINEARSLIDER0_RAW_FILTER_CONFIG_SIZE                         (sizeof(cy_capsense_context.ptrWdConfig[0u].rawFilterConfig))
#define CY_CAPSENSE_LINEARSLIDER0_SENSE_METHOD_VALUE                             (cy_capsense_context.ptrWdConfig[0u].senseMethod)
#define CY_CAPSENSE_LINEARSLIDER0_SENSE_METHOD_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0u].senseMethod))
#define CY_CAPSENSE_LINEARSLIDER0_WD_TYPE_VALUE                                  (cy_capsense_context.ptrWdConfig[0u].wdType)
#define CY_CAPSENSE_LINEARSLIDER0_WD_TYPE_SIZE                                   (sizeof(cy_capsense_context.ptrWdConfig[0u].wdType))

/* cy_capsense_pinConfig */
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[0].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[0].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[0].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[0].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[1].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[1].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[1].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[1].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[2].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[2].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[2].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[2].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[3].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[3].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[3].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[3].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[4].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[4].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[4].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[4].pinNumber))

/* cy_capsense_electrodeConfig */
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[2].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[2].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[2].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[2].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[2].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[2].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[3].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[3].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[3].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[3].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[3].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[3].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[4].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[4].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[4].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[4].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[4].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[4].numPins))


#if ((CY_CAPSENSE_PERI_CLK / 2) > 50000000)
    #warning The maximum CSD modulator clock frequency is 50 MHz: increase CSD modulator clock divider to meet the valid operation conditions
#endif



#if defined(__cplusplus)
}
#endif

#endif /* CY_CAPSENSE_CORE == __CORTEX_M */

#endif /* !defined(CY_DISABLE_CAPSENSE) */

#endif /* (defined(COMPONENT_MW_CAPSENSE) || !defined(COMPONENT_MW_CORE_MAKE)) */

#endif /* CYCFG_CAPSENSE_H */

/* [] END OF FILE */
