// #include <cstddef>
#include <stdio.h>
#include <stdlib.h>

int extract(int *arr, int length) {
  int read;
  int write;
  for (read = length - 1, write = length - 1; read >= 0; read--) {
    if (arr[read] == 0)
      continue;
    arr[write--] = arr[read];
  }
  for (write = write; write >= 0; write--) {
    arr[write] = 0;
  }
  return 0;
}

int main(int argc, char *argv[]) {
  char buf[0x100];
  int i, *arr = (int *)malloc(sizeof(int) * (argc - 1));
  if (arr == NULL) {
    fprintf(stderr, "malloc failed\n");
    return EXIT_FAILURE;
  }
  if (argc == 1) {
    fprintf(stderr, "%s <number1 number2 ...>\n", *argv);
    return EXIT_FAILURE;
  }

  for (i = 1; i < argc; i++) {
    // scanf("%s", buf);
    if (sscanf(argv[i], "%i", arr + i - 1) != 1) {
      fprintf(stderr, "unknown number: %s", buf);
      return EXIT_FAILURE;
    }
  }
  extract(arr, argc - 1);
  for (i = 0; i < argc - 1; i++) {
    printf("%d ", arr[i]);
  }
  return EXIT_SUCCESS;
}
