# coding=utf-8
import json
import traceback

import base64
from io import BytesIO
from sys import version_info
import random
import os
from PIL import Image

import requests

from conf import setting

'''
author :owen
createtime:2019_09_18
'''

current_dir = setting.logpath + "/python_data/"
if os.path.exists(current_dir) == False:
    os.mkdir(current_dir)


# 下面的conn是requests.session()对象
# 验证码提取

class Verification_Code(object):
    def __init__(self, uname=setting.Verification_code_uname, pwd=setting.Verification_code_pwd,
                 softid=setting.Verification_code_softid):
        self.random_num = str(random.random())
        self.uname = uname
        self.pwd = pwd
        self.softid = softid
        self.headers = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36"
        }

    # 得到验证码（jpg,png）:
    def get_jpg_png(self, conn, url, headers=None):
        try:
            if headers:
                r = conn.get(url, headers=headers, verify=False)
            else:
                r = conn.get(url, headers=self.headers, verify=False)
            with open(current_dir + self.random_num + 'test.png', 'wb') as f:
                f.write(r.content)
                f.close()
            return current_dir + self.random_num + 'test.png'
        except:
            print("error:please check url")

    # 得到验证码图片（gif）
    def get_gif(self, conn, url, headers=None):
        try:
            # 获取验证码
            if headers:
                img = conn.get(url, headers=headers, verify=False)
            else:
                img = conn.get(url, headers=headers, verify=False)
            with open(current_dir + self.random_num + ".gif", "wb") as f:
                f.write(img.content)
                f.close()
            return current_dir + self.random_num + ".gif"
        except:
            print("error:please check url")

    # 将图片放大
    def change_size(self, path):
        directory = path
        if not (directory.endswith('.jpg') or directory.endswith('.png') or directory.endswith('.bmp')):
            return "not jpg or png or bmp"
        else:
            img = Image.open(directory)
            s = "/"
            # 获取文件名（含后缀）
            oimage_name = directory[directory.rfind(s) + 1:]
            (oimage_width, oimage_height) = img.size
            new_width = oimage_width * 3
            new_height = oimage_height * 3
            out = img.resize((new_width, new_height), Image.ANTIALIAS)
            out.save(current_dir + "%s" % oimage_name)  # 直接替换
            return current_dir + "%s" % oimage_name

    # 将图片背景变成白色
    def Remove_the_background(self, path):
        empire = Image.open(path)
        empire_1 = empire.convert('1')
        empire_1.save(path)

    # 得到验证码
    def get_code(self, path, typeid=None, remark=None):
        try:
            img_url = "http://api.ttshitu.com/base64"
            img = Image.open(path)
            img = img.convert('RGB')
            buffered = BytesIO()
            img.save(buffered, format="JPEG")
            if version_info.major >= 3:
                b64 = str(base64.b64encode(buffered.getvalue()), encoding='utf-8')
            else:
                b64 = str(base64.b64encode(buffered.getvalue()))
            data = {"username": self.uname, "password": self.pwd, "softid": self.softid, "image": b64}
            if typeid:
                data['typeid'] = typeid
            if remark:
                data['remark'] = remark
            result = json.loads(requests.post(img_url, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")

    def get_code_new(self, path, typeid=None):
        try:
            img_url = "http://api.ttshitu.com/base64"
            with open(path, 'rb') as f:
                base64_data = base64.b64encode(f.read())
                b64 = base64_data.decode()
            data = {"username": self.uname, "password": self.pwd, "softid": self.softid, "image": b64}
            if typeid:
                data['typeid'] = typeid

            result = json.loads(requests.post(img_url, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
        except:
            traceback.print_exc()
            print("error:please check path or imgurl")
            return ""

    # 验证码计算typeid=11
    def get_code_count(self, path):
        try:
            img_url = "http://api.ttshitu.com/base64"
            img = Image.open(path)
            img = img.convert('RGB')
            buffered = BytesIO()
            img.save(buffered, format="JPEG")
            if version_info.major >= 3:
                b64 = str(base64.b64encode(buffered.getvalue()), encoding='utf-8')
            else:
                b64 = str(base64.b64encode(buffered.getvalue()))
            data = {"username": self.uname, "password": self.pwd, "softid": self.softid, "image": b64, 'typeid': 11}
            result = json.loads(requests.post(img_url, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")

    def get_code_sliding_validation(self, path: object) -> object:
        try:
            img_url = "http://api.ttshitu.com/base64"
            img = Image.open(path)
            img = img.convert('RGB')
            buffered = BytesIO()
            img.save(buffered, format="JPEG")
            if version_info.major >= 3:
                b64 = str(base64.b64encode(buffered.getvalue()), encoding='utf-8')
            else:
                b64 = str(base64.b64encode(buffered.getvalue()))
            data = {"username": self.uname, "password": self.pwd,
                    "softid": self.softid, "image": b64,
                    'typeid': 19}
            result = json.loads(requests.post(img_url, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")


if __name__ == "__main__":
    conn = requests.session()
    Verification_Code = Verification_Code()
    # path = Verification_Code.get_jpg_png(conn, "http://www.sykgnt.com/hsjyweb/index.php/drugsflow/public/verify")
    # code = Verification_Code.get_code(path)
    # print(code)
