# -*- coding: utf-8 -*-
"""
====================================
@File Name ：utils.py
@Time ： 2023/9/19 11:52
@Program IDE ：PyCharm
@Create by Author ： jamesenh
====================================
"""
import random
import time
import traceback
import requests
import warnings
import json
from conf import setting
from arrow import now
import config
from spider_template.exception import *
from loguru import logger
from Reuse_code import Reuse_Code
from module.mongo_client import MC
from module.redis_client import CjRedis_Client
from paho.mqtt import client as mqtt_client

warnings.filterwarnings('ignore')

"""request_type"""
DEFAULT_REQUEST = 0  # 默认的请求类型
LOGIN_REQUEST = 101  # 登录请求
PURCHASE_SEARCH_REQUEST = 201  # 采购的搜索
PURCHASE_EXPORT_REQUEST = 202  # 采购的导出
SALES_SEARCH_REQUEST = 301  # 销售搜索
SALES_EXPORT_REQUEST = 302  # 销售导出
STOCK_SEARCH_REQUEST = 401  # 库存搜索
STOCK_EXPORT_REQUEST = 402  # 库存导出
LOGIN_OUT_REQUEST = 191  # 账号的登出

# 熊猫代理
PROXY_EXTRACT_PATH = "http://route.xiongmaodaili.com/xiongmao-web/api/glip?secret=bb86ed0902ffd4d0d7d8c980ab832dce&orderNo=GL20220927165455dNvhO4kz&count=1&isTxt=0&proxyType=1"


class BNSession(requests.Session):
    """采集代码的请求封装"""
    proxy = None

    def __init__(self, unique_id, need_proxy=False):
        self.request_times = 0
        self.unique_id = unique_id
        super().__init__()
        if need_proxy:
            self.proxy = get_proxy()

    def get(self, url, request_type=DEFAULT_REQUEST, **kwargs) -> requests.Response:
        time.sleep(0.1)
        self.request_times += 1
        if "proxies" in kwargs:
            kwargs.pop("proxies")
        if "verify" in kwargs:
            kwargs.pop("verify")
        response = super().get(url, proxies=self.proxy, verify=False, **kwargs)
        request_log_resport(request_type, response)
        return response

    def post(self, url, request_type=DEFAULT_REQUEST, **kwargs) -> requests.Response:
        time.sleep(0.1)
        self.request_times += 1
        if "proxies" in kwargs:
            kwargs.pop("proxies")
        if "verify" in kwargs:
            kwargs.pop("verify")
        response = super().post(url, proxies=self.proxy, verify=False, **kwargs)
        request_log_resport(request_type, response)
        return response


def request_log_resport(request_type, response: requests.Response) -> bool:
    """关键请求记录、上报"""
    logger.info("[%s] url=>%s\nmethod=>%s\nstatus_code=>%s\nspend=>%sus" % (
        request_type, response.url, response.request.method, response.status_code, response.elapsed.microseconds
    ))
    return True


def get_proxy() -> dict:
    """获取代理"""
    for _i in range(10):
        try:
            res = requests.get(PROXY_EXTRACT_PATH, timeout=10).json()
            if res.get("code") == '0':
                obj = res.get("obj")[0]
                ip_port = obj['ip'] + ":" + obj['port']
                return {"http": "http://" + ip_port, "https": "http://" + ip_port}
        except:
            continue
        time.sleep(1)
    raise ProxyHandle_Error("代理获取失败->%s" % PROXY_EXTRACT_PATH)


class DataStore:
    """数据储存"""
    sale_collection = "Sales"
    pur_collection = "Purchase"
    stock_collection = "Stock"
    deletion_collections = ("Sales", "Purchase")

    def __init__(self, db_name, cls):
        """
        :param db_name: 存入数据的mongoDB名
        :param cls: 运行BN代码的方法对象
        """
        self.cls = cls
        self.db_name = db_name
        self.rc = Reuse_Code(self.db_name)
        self.which_day = now().format('DD') if self.cls.data_type == "month" else "00"

    def data_deletion(self, collection):
        """删除集合中将要被覆盖的数据"""
        if collection in self.deletion_collections:
            """"""
            if not self.cls.is_monitor:
                self.rc.Romove(self.which_day, collection, self.cls.data_type, self.cls.query_start_date)

    def data_insert(self, dic, collection, which_day=None):
        if which_day is not None:
            self.cls.data_type = which_day
        """键值对类型数据存入mongo"""
        if collection == self.sale_collection:
            """销售存储"""
            if not self.cls.is_monitor:
                self.rc.Save_mongo(dic, self.which_day, self.cls._company, self.cls._comm_name,
                                   self.cls.data_type, collection, self.cls.query_start_date)
            self.cls.collect_nums_sales += 1

        elif collection == self.pur_collection:
            """采购存储"""
            if not self.cls.is_monitor:
                self.rc.Save_mongo(dic, self.which_day, self.cls._company, self.cls._comm_name,
                                   self.cls.data_type, collection, self.cls.query_start_date)
            self.cls.collect_nums_purchase += 1

        elif collection == self.stock_collection:
            """库存存储"""
            if not self.cls.is_monitor:
                self.rc.Save_mongo(dic, self.which_day, self.cls._company, self.cls._comm_name,
                                   self.cls.data_type, collection, self.cls.query_start_date)
            self.cls.collect_nums_stock += 1
        self.cls.result[1] = self.cls.collect_nums_purchase
        self.cls.result[2] = self.cls.collect_nums_sales
        self.cls.result[3] = self.cls.collect_nums_stock

    def Account_validity_period(self, date_time):
        """
        保存账号有效期 根据 DB进行区分
        {'截至日期':'YYYY-MM-DD'}
        """
        dic = {
            'DB': self.cls.db_name,
            'user_name': self.cls.user_name,
            'company_name': self.cls.company_name,
            'commercial_company': self.cls.commercial_company,
            'validity_period': date_time
        }
        self.rc.update_mongo('account_validity_period', dic=dic)


class RuntimeLogRecord(MC):
    """采集脚本日志记录-mongo"""
    db_name = "cj_runtime_log"  # 默认日志存储DB
    runtime_log_collection = "runtime_log"  # 默认日志存储集合
    error_log_collection = "error_log"  # 错误日志集合
    request_log_collection = "request_log"  # 请求日志记录集合

    def log_record(self, log_info: dict):
        """正常日志记录
        日志字段示例：
        create_time         日志创建时间              2023-01-01 00:10:00
        unique_id           执行的商业唯一ID           xea-51702-10848
        query_period        任务搜索区间（开始，结束）      ["2023-01-01", "2023-01-31"]
        data_type           执行任务的类型                 day
        collect_nums        采集数据记录（采购，销售，库存）  [0,99,10]
        result              执行任务结果（流连宝收到的）      网无法访问
        running_step_record 任务执行方法调用记录         [(1697081152.26016,login), (1697081152.3658803,collect_sales_purchase_data), (1697081153.1338246,end)]
        """
        return self.conn[self.db_name][self.runtime_log_collection].insert_one(log_info).inserted_id

    def error_log_record(self, error_info: dict):
        """错误日志记录
        create_time         日志创建时间              2023-01-01 00:10:00
        unique_id           执行的商业唯一ID           xea-51702-10848
        data_type           执行任务的类型                 day
        error_class         捕获到的异常类             ProxyHandle_Error
        error_content       错误异常内容（堆栈信息）
        """
        return self.conn[self.db_name][self.error_log_collection].insert_one(error_info).inserted_id


class RedisStore:
    """Redis存储"""

    def __init__(self):
        self.redis_cli = CjRedis_Client()
        self.rds = self.redis_cli.redis

    def run(self, *args):
        try:
            self.set_list(args[0]['db_name'])
            self.set_hash(args[0]['db_name'], args[0]['json_data'])
            del self.redis_cli
        except:
            logger.error("[网抓数据异步对比]上传redis失败\n%s" % traceback.format_exc())

    def set_list(self, db_name):
        """设置列表值(例: db_list[固定] db_name)"""
        self.rds.lpush('db_list', db_name)

    def set_hash(self, db_name, json_data):
        """设置hash键值
        例: db_hash[固定] db_name {"collect_nums_purchase":5,"collect_nums_sales":122,"collect_data_type":"daily","db_name":"007"}
        """
        json_str = json.dumps(json_data)
        self.rds.hset('db_hash', db_name, json_str)


class MqttConnect:
    client = False

    def __init__(self, topic):
        self.client_id = f'python-mqtt-{random.randint(0, 100)}'
        self.port, self.broker, self.topic = None, None, topic
        # self.port = setting.mqtt_port
        # self.broker = setting.mqtt_broker
        self.mqtt_state = False
        # self.client = False

    def __del__(self):
        if isinstance(self.client, bool):
            return
        else:
            self.client.disconnect()

    # 连接mqtt
    def connect_mqtt(self):
        """
        连接函数
        :return:
        """

        def on_connect(_client, _userdata, _flags, rc):
            if rc == 0:
                print("Connected to MQTT Broker!")
            else:
                print("Failed to connect, return code %d\n", rc)

        self.client = mqtt_client.Client(self.client_id)
        # 密码连接
        # client.username_pw_set(username,password)
        self.client.on_connect = on_connect
        self.client.connect(self.broker, self.port)
        self.mqtt_state = True

    # 发送信息
    def publish(self, msg):
        """
        发送消息
        :param msg:
        :return:
        """
        if not self.mqtt_state:
            self.connect_mqtt()
        result = self.client.publish(self.topic, msg, qos=0)
        status = result[0]
        if status == 0:
            # "发送完成"
            print(f"Send `{msg}` to topic `{self.topic}`")
        else:
            # 发送失败
            print(f"Failed to send message to topic {self.topic}")


if __name__ == '__main__':
    conn = BNSession('1', need_proxy=False)
    resp = conn.get("https://www.baidu.com", verify=False, params={"search": "123"})
    print(conn.cookies.get_dict())
