import os
from datetime import datetime, timedelta

from conf import setting
import pandas as pd
from arrow import now
from module.mongo_client import Mongo


class Reuse_Code:
    def __init__(self, name, **kwargs):
        self.db_name = name
        self.client = Mongo()
        self.db = self.client[name]
        self.config_date = setting.config_data()
        self.diff_directory = setting.diff_data_comparison_directory
        # 初始化的时候删除库存数据
        self.remove_stock()
        
        
    def remove_stock(self):
        """
        2024-11-21 新增 删除库存数据    
        """
        self.db["Stock"].delete_many({"获取数据时间": {"$gte": self.config_date["now_month_day"],
                                                         "$lte": self.config_date["now_month_day"]}, "Type": "day"})

    def Romove(self, which_day, set_name, task_date_type=None, start_time='',):
        """
        :param which_day: 该抓月报的日期  日报为  00
        :param set_name: db名
        :param start_time: 抓取数据的结束时间
        :param task_date_type: 任务的报告类型 -> [day or month]
        """
        if set_name in ["Sales", "Purchase"]:
            """如果目录不存在，则创建目录"""
            # folder_path = f'{self.diff_directory}/{self.db_name}/old_data'
            # if not os.path.exists(folder_path):
            #     os.makedirs(folder_path)
            posts = self.db[set_name]
            if task_date_type == "month" or (self.config_date["The_current_day"] == which_day and not task_date_type):
                # """存储上个月月报"""
                # query = {"数据创建时间": {"$gte": self.config_date["last_month_start"],
                #                           "$lte": self.config_date["last_month_stop"]}, "Type": "month"}
                # counts = posts.count_documents(query)
                # if counts:
                #     last_month_data = posts.find(query)
                #     df = pd.DataFrame(last_month_data)
                #     file_path = f'{folder_path}/{set_name}_monthly.xlsx'
                #     # 存入文件
                #     if os.path.exists(file_path):
                #         os.remove(file_path)
                #         df.to_excel(file_path, index=False)
                #     else:
                #         df.to_excel(file_path, index=False)
                """删除月报"""
                if '-LS-' in self.db_name:
                    # 历史月任务
                    posts.delete_many(
                        {"_perform_period": start_time.rsplit('-', 1)[0], "Type": "month"})
                    posts.delete_many(
                        {"_perform_period": None, "Type": "month"})
                else:
                    posts.delete_many(
                        {"数据创建时间": {"$gte": self.config_date["last_month_start"],
                                          "$lte": self.config_date["last_month_stop"]}, "Type": "month"})
            else:
                # """存储昨天日报"""
                # query = {"获取数据时间": self.config_date["now_month_stop"], "Type": 'day'}
                # # query = {"数据创建时间": {"$gte": self.config_date["now_month_start"], "$lte": self.config_date["now_month_stop"]}}
                # counts = posts.count_documents(query)
                # if counts:
                #     now_month_data = posts.find(query)
                #     df = pd.DataFrame(now_month_data)
                #     folder = [folder_path]
                #     if now().format('DD') == '02':
                #         folder_path2 = f'{self.diff_directory}/{self.db_name}/first_day'
                #         if not os.path.exists(folder_path2):
                #             os.makedirs(folder_path2)
                #         folder.append(folder_path2)
                #     for i in folder:
                #         file_path = f'{i}/{set_name}_daily.xlsx'
                #         # 存入文件
                #         if os.path.exists(file_path):
                #             os.remove(file_path)
                #             df.to_excel(file_path, index=False)
                #         else:
                #             df.to_excel(file_path, index=False)
                """删除日报"""
                posts.delete_many(
                    {"数据创建时间": {"$gte": self.config_date["now_month_start"],
                                      "$lte": self.config_date["now_month_stop"]}, "Type": "day"})
        else:
            return "error set_name"

    def __del__(self):
        try:
            self.db.cloes()
            self.client.close()
        except:
            pass

    def Save_mongo(self, a_dict: dict, which_day,  Company_name, commercial_company, data_type, set_name,query_start_date='', **kwargs):
        """
        :param which_day: 当前是否抓月报
        :param a_dict: 存mongodb的数据
        :param query_start_date: 抓取的开始时间
        :param Company_name: 企业公司名称
        :param commercial_company: 商业公司名称
        :param set_name: 存放的数据库名称
        :param data_type: 任务类型（day/month）
        """
        if set_name in ["Sales", "Purchase", "Stock"]:
            posts = self.db[set_name]
            a_dict["获取数据时间"] = self.config_date["now_month_day"]
            if '-LS-' in self.db_name:
                query_start_date = query_start_date.split(' ')[0]
                date11 = datetime.strptime(query_start_date, "%Y-%m-%d")
                first_day_of_next_month = datetime(date11.year if int(date11.month) < 12 else date11.year + 1, (date11.month % 12) + 1,
                                                   1)
                a_dict["数据创建时间"] = (first_day_of_next_month+timedelta(days=-1)).strftime('%Y-%m-%d')
                a_dict['_perform_period'] = query_start_date.rsplit('-', 1)[0]
            elif self.config_date["The_current_day"] == which_day:
                a_dict["数据创建时间"] = self.config_date["last_month_stop"]
            else:
                a_dict["数据创建时间"] = self.config_date["now_month_stop"]
            a_dict["Company_name"] = Company_name
            a_dict["commercial_company"] = commercial_company
            # 这个是判断是否是天或者月爬取
            a_dict["Type"] = data_type
            posts.insert_one(a_dict)
        else:
            return "error set_name"

    def update_mongo(self, set_name, **kwargs):
        db = self.client['account_validity_period']
        posts = db[set_name]
        query = {'DB': kwargs['dic'].get('DB')}
        posts.update_one(query, {'$set': kwargs['dic']}, upsert=True)


class Parameters_of_the_head():  # line:34
    def __init__(O0OO00OOOOOO0O0OO, *O0OOOO0000OOO00OO):  # line:35
        O0OO00OOOOOO0O0OO.config_date = setting.config_data()  # line:36
        O0OO00OOOOOO0O0OO.start_time = O0OOOO0000OOO00OO[0]["start_time"]  # line:37
        O0OO00OOOOOO0O0OO.stop_time = O0OOOO0000OOO00OO[0]["end_time"]  # line:38
        O0OO00OOOOOO0O0OO.user_name = O0OOOO0000OOO00OO[0]["user_name"]  # line:39
        O0OO00OOOOOO0O0OO.user_password = O0OOOO0000OOO00OO[0]["user_password"]  # line:40
        O0OO00OOOOOO0O0OO.set_name = O0OOOO0000OOO00OO[0]["set_name"]  # line:41
        O0OO00OOOOOO0O0OO.Company_name = O0OOOO0000OOO00OO[0]["Company_name"]  # line:42
        O0OO00OOOOOO0O0OO.commercial_company = O0OOOO0000OOO00OO[0]["commercial_company"]  # line:43
        O0OO00OOOOOO0O0OO.which_day = O0OOOO0000OOO00OO[0]["which_day"]  # line:44
        O0OO00OOOOOO0O0OO.name = O0OO00OOOOOO0O0OO.set_name  # line:46

    def Parameters(O0OO0O000OOOO0OO0):  # line:47
        return O0OO0O000OOOO0OO0.config_date, O0OO0O000OOOO0OO0.start_time, O0OO0O000OOOO0OO0.stop_time, O0OO0O000OOOO0OO0.user_name, O0OO0O000OOOO0OO0.user_password, O0OO0O000OOOO0OO0.Company_name, O0OO0O000OOOO0OO0.commercial_company, O0OO0O000OOOO0OO0.which_day, O0OO0O000OOOO0OO0.name
