# -*- coding: utf-8 -*-
# @File     : mongo_client.py
# @Date     : 2022-06-22
# @LoginUser: jamesenh
# @Author   : jamesenh


from pymongo import MongoClient
from conf.setting import mongo_conf


class MC:
    def __init__(self):
        self.is_closed = False
        self.conn = MongoClient(
            mongo_conf.get('connection_addr'),
            mongo_conf.get('port'),
            replicaSet=mongo_conf.get('replicaSet')
        )
        if mongo_conf.get('username') and mongo_conf.get('password'):
            self.conn.admin.authenticate(mongo_conf.get('username'), mongo_conf.get('password'))

    def __del__(self):
        if self.is_closed:
            return
        try:
            self.conn.close()
            self.is_closed = True
        except:
            pass

    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.is_closed:
            return
        try:
            self.conn.close()
            self.is_closed = True
        except:
            pass

    def get_connection_module(self):
        return self.conn


def Mongo(*args):
    create_connection = MC()
    conn = create_connection.get_connection_module()
    return conn
