# -*- encoding: utf-8 -*-
"""
====================================
@FileName: BN2829.py
@Author: Ariza
@Last Modified by: Ariza
@Last Modified time: 2023/12/11 15:54:13
====================================
"""

import re
import pandas as pd
from io import BytesIO
from spider_template import utils
from spider_template import exception
from spider_template.base import DataCollector
from Verification_code_new import VerificationCode


class BN_Scrapy(DataCollector):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.headers = {"User-Agent":"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36"}

    def run(self):
        """启动"""
        try:
            self.conn = utils.BNSession(self.db_name)   # 示例化请求类
            self.conn.headers = self.headers  # 更新 headers
            self.login()    # 登录
            self.db.data_deletion(self.db.sale_collection)  # 删除销售
            self.collect_sales_data()   # 抓销售路径
            self.db.data_deletion(self.db.pur_collection)   # 删除采购
            self.collect_purchase_data()    # 抓采购
            if self.data_type == "day":
                self.collect_stock_data()   # 抓库存
            return self.result
        except BaseException as error:
            """异常处理"""
            self.exception_handle(error)
            return self.result
        finally:
            """账号登出"""
            try:
                self.conn.get(self.extra["url"] + "/Login/Logout",request_type=utils.LOGIN_OUT_REQUEST)
            except:
                pass
            self.end()

    def login(self):
        """登录"""
        self.step_record()
        for i in range(3):
            # 获取验证码
            path = VerificationCode().get_jpg_png(self.conn, self.extra["url"] + '/Login/GetValidateCode')
            code = VerificationCode().get_code(path)
            # 登录请求
            login_url = self.extra["url"] + '/login/index'
            data_login = {
                'Login': self.user_name,
                'PasswordHash': self.user_password,
                'CheckCode': code,
            }
            resp = self.conn.post(url=login_url, json=data_login, request_type=utils.LOGIN_REQUEST).json()  # 登录
            # 登录请求判断
            if not resp['Success']:
                if resp['Msg'] == '验证码错误':
                    continue
                elif '用户不存在' in resp['Msg']:
                    raise exception.AccountError('账号不存在')
                elif '密码错误' in resp['Msg']:
                    raise exception.AccountPwd_Error('账号或密码不正确')
                else:
                    raise exception.NetWorkError(resp['Msg'])
            return True
        raise exception.VerifyTimesExpire_Error('验证码获取失败')
        
    def collect_sales_data(self):
        """销售数据采集"""
        self.step_record()
        # 查询数据
        sale_url = self.extra["url"] + '/Product/Index'
        res = self.conn.get(sale_url)
        data_query = {
            '__RequestVerificationToken': re.findall(r'name="__RequestVerificationToken" type="hidden" value="(.*?)"', res.text)[0],
            'startDate': self.query_start_date,
            'endDate': self.query_end_date,
            'zjm': '',
            'pizhwh': '',
            'lx': 'sales',
        }
        resp = self.conn.post(url=sale_url, data=data_query, request_type=utils.SALES_SEARCH_REQUEST)
        if resp.status_code >= 400:
             raise exception.WebChanged_Error("销售处改版")
        # 数据处理
        res = self.conn.get('http://sxycyyjt.msns.cn:8998/Product/ExportDirectionExcel', request_type=utils.SALES_EXPORT_REQUEST)
        df = pd.read_excel(BytesIO(res.content))
        data = df.to_dict('records')
        # 入库
        [self.db.data_insert(dic, self.db.sale_collection) for dic in data]

    def collect_purchase_data(self):
        """采购数据采集"""
        self.step_record()
        # 查询数据
        sale_url = self.extra["url"] + '/Product/Index'
        res = self.conn.get(sale_url)
        data_query = {
            '__RequestVerificationToken': re.findall(r'name="__RequestVerificationToken" type="hidden" value="(.*?)"', res.text)[0],
            'startDate': self.query_start_date,
            'endDate': self.query_end_date,
            'zjm': '',
            'pizhwh': '',
            'lx': 'procure',
        }
        resp = self.conn.post(url=sale_url, data=data_query, request_type=utils.PURCHASE_SEARCH_REQUEST)
        if resp.status_code >= 400:
             raise exception.WebChanged_Error("采购处改版")
        # 数据处理
        res = self.conn.get('http://sxycyyjt.msns.cn:8998/Product/ExportDirectionExcel', request_type=utils.PURCHASE_EXPORT_REQUEST)
        df = pd.read_excel(BytesIO(res.content))
        data = df.to_dict('records')
        # 入库
        [self.db.data_insert(dic, self.db.pur_collection) for dic in data]

    def collect_stock_data(self):
        """库存数据采集"""
        self.step_record()
        stock_url = self.extra["url"] + '/Product/Goods'
        res = self.conn.get(stock_url)
        # 查询数据
        data_query = {
                '__RequestVerificationToken':re.findall(r'name="__RequestVerificationToken" type="hidden" value="(.*?)"', res.text)[0],
                'zjm': '',
                'pihao': '',
                'pizhwh': '',
                'page':1
            }
        resp = self.conn.post(url=stock_url, data=data_query, request_type=utils.STOCK_SEARCH_REQUEST)
        if resp.status_code >= 400:
             raise exception.WebChanged_Error("库存处改版")
        # 数据处理
        res = self.conn.get('http://sxycyyjt.msns.cn:8998/Product/ExportGoodExcel', request_type=utils.STOCK_EXPORT_REQUEST)
        df = pd.read_excel(BytesIO(res.content))
        data = df.to_dict('records')
        # 入库
        [self.db.data_insert(dic, self.db.stock_collection) for dic in data]
     


def BN2829(*args, **kwargs):
    url='http://sxycyyjt.msns.cn:8998'
    func = BN_Scrapy(*args, extra={"url": url}, **kwargs)
    return func.run()


if __name__ == '__main__':
    _dic = {
        "start_time": '2022-01-01', "end_time": '2022-11-30',
        "user_name": 'tjzxyyjt', "user_password": 'tjzxyyjt',
        "Company_name": '希尔安', "commercial_company": '希尔安',
        "which_day": '00', "set_name": 'BN_test'
    }
    print(BN2829(_dic, 'day'))
