# -*- coding: utf-8 -*-
"""
====================================
@FileName BN3009.py
@Author Ariza
@UpdateTime 2023/11/03
====================================
"""
import hashlib
import pandas as pd
from io import BytesIO
from spider_template import utils
from spider_template import exception
from spider_template.base import DataCollector

class BN_Scrapy(DataCollector):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.headers = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36"}

    def run(self):
        """启动"""
        try:
            self.conn = utils.BNSession(self.db_name)   # 示例化请求类
            self.conn.headers = self.headers  # 更新 headers
            self.login()    # 登录
            self.db.data_deletion(self.db.sale_collection)  # 删除销售
            self.collect_sales_data()   # 抓销售路径
            self.db.data_deletion(self.db.pur_collection)   # 删除采购
            self.collect_purchase_data()    # 抓采购
            return self.result
        except BaseException as error:
            """异常处理"""
            self.exception_handle(error)
            return self.result
        finally:
            """登出"""
            self.conn.get('http://42.180.2.152:7006/hreport-manager/j_spring_security_logout', request_type=utils.LOGIN_OUT_REQUEST)
            self.end()

    def login(self):
        """登录"""
        self.step_record()
        # 登录请求
        login_url = 'http://42.180.2.152:7006/hreport-manager/j_spring_security_check'
        md5 = hashlib.md5()
        md5.update(self.user_password.encode())
        data_form = {
            'j_username': self.user_name,
            'j_password': md5.hexdigest(),
        }
        res = self.conn.post(url=login_url, data=data_form,
                              request_type=utils.LOGIN_REQUEST)  # 登录
        # 登录请求判断
        if 'http://42.180.2.152:7006/hreport-manager/login/loginCheck' in res.url:
            return True
        elif '登录失败，请检查用户名和密码是否正确' in res.text:
            raise exception.AccountPwd_Error('账号或密码不正确')
        else:
            raise exception.NetWorkError("无法爬取：登陆失败")

    def collect_sales_data(self):
        """销售数据采集"""
        self.step_record()
        # 查询数据
        sale_url = 'http://42.180.2.152:7006/hreport-manager/vendorReportMgr/exportReportExcel?funcId=10003'
        data_query = {
            'endDate': self.query_end_date,
            'beginDate': self.query_start_date,
        }
        resp = self.conn.post(url=sale_url, data=data_query,
                              request_type=utils.SALES_SEARCH_REQUEST)
        if resp.status_code >= 400:
            raise exception.WebChanged_Error("销售处改版")
        # 导出数据
        io = BytesIO()
        io.write(resp.content)
        io.seek(0)
        datas = pd.read_excel(io, dtype=str)
        if not datas.empty:
            datas = datas.fillna('').to_dict('records')
            # 入库
            [self.db.data_insert(dic, self.db.sale_collection) for dic in datas]

    def collect_purchase_data(self):
        """采购数据采集"""
        self.step_record()
        # 查询数据
        pur_url = 'http://42.180.2.152:7006/hreport-manager/vendorReportMgr/exportReportExcel?funcId=37'
        data_query = {
            'endDate': self.query_end_date,
            'beginDate': self.query_start_date,
        }
        resp = self.conn.post(url=pur_url, data=data_query,
                              request_type=utils.PURCHASE_SEARCH_REQUEST)
        if resp.status_code >= 400:
            raise exception.WebChanged_Error("采购处改版")
        # 导出数据
        io = BytesIO()
        io.write(resp.content)
        io.seek(0)
        datas = pd.read_excel(io, dtype=str)
        if not datas.empty:
            datas = datas.fillna('').to_dict('records')
            # 入库
            [self.db.data_insert(dic, self.db.pur_collection) for dic in datas]


def BN3009(*args, **kwargs):
    func = BN_Scrapy(*args, extra={}, **kwargs)
    return func.run()


if __name__ == '__main__':
    _dic = {
        "start_time": '2023-10-01', "end_time": '2023-10-31',
        "user_name": '20230302', "user_password": 'LNjl@123',
        "Company_name": '希尔安', "commercial_company": '希尔安',
        "which_day": '00', "set_name": 'BN_test'
    }
    print(BN3009(_dic, 'day'))
