"""
作者： 宁佳富
日期： 2023/9/27
"""
import base64
import json
import random
from io import BytesIO
from sys import version_info

import requests
from PIL import Image

from conf import setting
from PIL import ImageFile

# import setting

ImageFile.LOAD_TRUNCATED_IMAGES = True

class VerificationCode(object):
    def __init__(self, uname=setting.Verification_code_uname, pwd=setting.Verification_code_pwd,
                 softid=setting.Verification_code_softid):
        self.random_num = str(random.random())
        self.uname = uname
        self.pwd = pwd
        self.softid = softid
        self.api_path = "http://api.ttshitu.com/predict"
        self.headers = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36"
        }

    # 得到验证码（jpg,png）:
    def get_jpg_png(self, conn, url, headers=None):
        try:
            if headers:
                r = conn.get(url, headers=headers, verify=False)
            else:
                r = conn.get(url, headers=self.headers, verify=False)
            return r.content

        except:
            print("error:please check url")

    # 得到验证码
    def get_code(self, path, typeid='3', remark=None):
        """

        :param path:  res.content (bytes) / base64
        :param typeid:
        :param remark:   备注字段 如：填写计算结果 (兼容unicode) 遇到中文乱码情况 请unicode编码以免造成错误。
        :return:
        """
        try:
            if type(path) == bytes:
                img = Image.open(BytesIO(path))
                img = img.convert('RGB')
                buffered = BytesIO()
                img.save(buffered, format="JPEG")
                if version_info.major >= 3:
                    b64 = str(base64.b64encode(buffered.getvalue()), encoding='utf-8')
                else:
                    b64 = str(base64.b64encode(buffered.getvalue()))
            else:
                b64 = path

            data = {"username": self.uname, "password": self.pwd, "softid": self.softid, "image": b64}
            if typeid:
                data['typeid'] = typeid
            if remark:
                data['remark'] = remark
            result = json.loads(requests.post(self.api_path, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")

    # 验证码计算typeid=11  1005  5
    def get_code_count(self, path: object):
        """

        :param path:  res.content (bytes) / base64
        :return:
        """
        try:
            if type(path) == bytes:
                img = Image.open(BytesIO(path))
                img = img.convert('RGB')
                buffered = BytesIO()
                img.save(buffered, format="JPEG")
                if version_info.major >= 3:
                    b64 = str(base64.b64encode(buffered.getvalue()), encoding='utf-8')
                else:
                    b64 = str(base64.b64encode(buffered.getvalue()))
            else:
                b64 = path
            data = {"username": self.uname, "password": self.pwd,
                    "softid": self.softid, "image": b64, 'typeid': 11}
            result = json.loads(requests.post(self.api_path, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")

    # 滑动验证码  typeid=33  返回x坐标
    def get_code_sliding_validation(self, path: object) -> object:
        """
        :param path: res.content (bytes)/ base64
        :return:
        """
        try:
            if type(path) == bytes:
                img = Image.open(BytesIO(path))
                img = img.convert('RGB')
                buffered = BytesIO()
                img.save(buffered, format="JPEG")
                if version_info.major >= 3:
                    b64 = str(base64.b64encode(buffered.getvalue()), encoding='utf-8')
                else:
                    b64 = str(base64.b64encode(buffered.getvalue()))
            else:
                b64 = path

            data = {"username": self.uname, "password": self.pwd,
                    "softid": self.softid, "image": b64,
                    'typeid': '33'}
            result = json.loads(requests.post(self.api_path, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")

    # 多缺口识别 需要两张图片 error
    def get_code_multiple_notches(self, imageback, image):
        """
        :param imageback: 缺口图
        :param image:   目标图
        :return:
        """
        try:
            data = {"username": self.uname, "password": self.pwd,
                    "softid": self.softid, "image": image,
                    'imageback': imageback,
                    'typeid': '18'}
            result = json.loads(requests.post(self.api_path, json=data).text)
            if result['success']:
                return result["data"]["result"]
            else:
                return result["message"]
            return ""
        except:
            print("error:please check path or imgurl")


if __name__ == '__main__':
    conn = requests.session()
    verification_Code = VerificationCode()
    # data = {
    #     "captchaType": "blockPuzzle",
    #     "clientUid": "slider-311c1c92-919f-4151-a827-cb2160d686cc",
    #     "ts": int(time.time()) * 1000
    # }
    # resp = conn.post(
    #     'http://flow.jztit.com/captcha/get', json=data).json()
    #
    # # path = verification_Code.get_jpg_png(conn=conn, url='http://113.214.10.197:82/Confirmation.aspx')
    # jigs = resp['repData']['jigsawImageBase64']
    # origin = resp['repData']['originalImageBase64']

    # notches = verification_Code.get_code_multiple_notches(setting.origin, setting.jigs)
    # notches1 = verification_Code.get_code_multiple_notches(setting.jigs,setting.origin )
    # validation = verification_Code.get_code_sliding_validation(setting.origin)
    # validation1 = verification_Code.get_code_sliding_validation(setting.jigs)
    # captcha_img = Image.open(BytesIO(path))
    # code = verification_Code.get_code(b64_2)
    # code = verification_Code.get_code(path)
    # print(notches)
