# -*- coding: utf-8 -*-
"""
====================================
@File Name ：base.py
@Time ： 2023/9/20 17:53
@Program IDE ：PyCharm
@Create by Author ： jamesenh
====================================
"""
import json
import re
import time
from arrow import now
import inspect
import traceback
from spider_template import utils
from spider_template.exception import *


def error_msg_push(error_msg: dict):
    """特殊的消息推送，
    2023-11-24  用于重构后部分使用错误的企业名称的代码告警"""
    webhook = "https://open.feishu.cn/open-apis/bot/v2/hook/abd77824-b76e-4320-aa01-534dde7cf071"
    try:
        utils.requests.post(webhook, json={
            "msg_type": "post",
            "content": {
                "post": {
                    "zh_cn": {
                        "title": "网抓异常通知",
                        "content": [
                            [{
                                "tag": "text",
                                "text": "网抓代码使用到未定义的属性【%s】" % error_msg['attribute']
                            },
                                {
                                    "tag": "text",
                                    "text": "代码【%s】，企业【%s】，商业【%s】" % (
                                        error_msg['module_code'], error_msg['company'], error_msg['commercial_company'])
                                },
                                {
                                    "tag": "at",
                                    "user_id": "all"
                                }
                            ]
                        ]
                    }
                }
            }
        })
    except:
        pass


class DataCollector:

    def __init__(self, standard_args: dict, data_type: str, **extra):

        """
        :param standard_args: 标准传入参数
        :param data_type: 报告类型
        :param extra: 其他必要参数，传入键值对形式
        """
        self.conn = None
        self.collect_nums_purchase = 0  # 采购采集数量
        self.collect_nums_sales = 0  # 销售采集数量
        self.collect_nums_stock = 0  # 库存采集数量
        self.result = ["正常", 0, 0, 0]  # [运行结果，采购数据，销售数据，库存数据]
        self.running_step_record = []  # 运行步骤记录
        self.done = False  # 运行是否结束
        self.runtime_log_id = None  # 运行日志id
        self.error_log_id = None  # 异常日志id

        self.user_name = standard_args['user_name']
        self.user_password = standard_args['user_password']
        self.query_start_date = standard_args['start_time']
        self.query_end_date = standard_args['end_time']
        self.db_name = standard_args['set_name']
        self._company = standard_args['Company_name']
        self._comm_name = standard_args['commercial_company']
        self.company_name = standard_args['Company_name']
        self.commercial_company = standard_args['commercial_company']
        self.is_monitor = standard_args.get('is_monitor')
        self.data_type = data_type
        self.db = utils.DataStore(self.db_name, self)
        self.record_db = utils.RuntimeLogRecord()
        self.to_redis = utils.RedisStore()
        self.extra = extra.get("extra", {})
        # self.mqttconnect = utils.MqttConnect(topic=standard_args['set_name'])
        self.step_record()

    def __del__(self):
        """结束"""
        if self.done:
            return
        self.end()

    def identify(self):
        frame = inspect.currentframe().f_back
        calling_class = frame.f_locals.get('self', None)
        if calling_class:
            return inspect.getfile(calling_class.__class__)
        else:
            return "Unknown"

    def end(self):
        """结束"""
        self.step_record()
        # 采集结束记录
        print("extra=>%s\npur=>%d\tsale=>%d\tstock=>%d\n%s" % (
            self.extra,
            self.collect_nums_purchase,
            self.collect_nums_sales,
            self.collect_nums_stock,
            ' -> '.join(["%s: %s\n" % (i[0], i[1]) for i in self.running_step_record])
        ))

        self.done = True

        # # 运行正常 关键信息存入redis
        # if self.result == '正常':
        #     data_type = 'monthly' if self.data_type == 'month' else 'daily'
        #     module_code = self.identify()
        #     self.to_redis.run({
        #         'db_name': f'{self.db_name}_{self.data_type}',
        #         'json_data': {'collect_nums_purchase': self.collect_nums_purchase,
        #                       'collect_nums_sales': self.collect_nums_sales,
        #                       'db_name': self.db_name,
        #                       'collect_data_type': data_type,
        #                       'module_code': module_code}
        #     })

        # 运行日志记录
        t = "-monitor" if self.is_monitor else ''
        self.runtime_log_id = self.record_db.log_record({
            "error_log_id": self.error_log_id,
            "create_time": now().format("YYYY-MM-DD HH:mm:ss"),
            "unique_id": self.db_name,
            "query_period": "%s,%s" % (self.query_start_date, self.query_end_date),
            "data_type": self.data_type + str(t),
            "collect_nums": "%d,%d,%d" % (self.collect_nums_purchase, self.collect_nums_sales, self.collect_nums_stock),
            "result": self.result,
            "running_step_record": json.dumps(self.running_step_record)
        })
        del self.db.rc
        del self.record_db
        # del self.mqttconnect

    def step_record(self):
        """记录每个任务的调用次序，记录代码的停止位置"""
        caller_frame = inspect.currentframe().f_back  # 获取调用者的代码帧
        caller_method_name = caller_frame.f_code.co_name  # 获取调用者的方法名称
        self.running_step_record.append((time.time(), caller_method_name))  # 记录调用者的方法名称

    def exception_handle(self, error_obj: BaseException, **kwargs):
        """异常处理模块"""
        self.result = ["无法爬取", 0, 0, 0]
        if issubclass(error_obj.__class__, utils.CjBaseError):  # 判断异常类型是否为采集自定义的异常类型
            """采集的自定义异常类型"""
            print("处理自定义异常->\t", repr(error_obj), traceback.format_tb(error_obj.__traceback__))
            traceback.print_tb(error_obj.__traceback__)
            if isinstance(error_obj, AccountError):
                if isinstance(error_obj, AccountPermission_Error):
                    self.result[0] = '账号权限过期'
                else:
                    self.result[0] = "账号密码错误"
            elif isinstance(error_obj, VerifyCode_Error):
                self.result[0] = "爬取程序出错"
            elif isinstance(error_obj, NetWorkError):
                if isinstance(error_obj, ProxyHandle_Error):
                    self.result[0] = "网站代理处理失败"
                elif isinstance(error_obj, HostUnReachable_Error):
                    self.result[0] = "网站无法访问"
                else:
                    self.result[0] = "网站网络不稳定"
            elif isinstance(error_obj, WebChanged_Error):
                self.result[0] = "爬取程序出错(响应状态码>=400)"
            elif isinstance(error_obj, DataError):
                self.result[0] = "爬取程序出错"
            else:
                self.result[0] = "爬取程序出错"
        else:
            """其他异常类型"""
            try:
                if isinstance(error_obj, AttributeError) and ('comm_name' in error_obj.args[0] or 'company' in error_obj.args[0]):
                    attribute = re.findall("has no attribute '(.*?)'", error_obj.args[0])
                    if attribute:
                        attribute = attribute[0]
                    else:
                        attribute = error_obj.args[0]
                    error_msg_push({
                        "attribute": attribute,
                        "module_code": self.identify(),
                        "company": self._company,
                        "commercial_company": self._comm_name
                    })
            except:
                pass
            # print("处理未定义异常->\t", repr(error_obj), traceback.format_tb(error_obj.__traceback__))
            # traceback.print_tb(error_obj.__traceback__)
            self.result[0] = "爬取程序出错"

        self.result[1] = self.collect_nums_purchase
        self.result[2] = self.collect_nums_sales
        self.result[3] = self.collect_nums_stock

        # 异常记录
        self.error_log_id = self.record_db.error_log_record({
            "create_time": now().format("YYYY-MM-DD HH:mm:ss"),
            "unique_id": self.db_name,
            "data_type": self.data_type,
            "error_class": repr(error_obj),
            "error_content": traceback.format_tb(error_obj.__traceback__)
        })
