# -*- coding: utf-8 -*-
"""
====================================
@File Name ：exception.py
@Time ： 2023/3/13 11:02
@Program IDE ：PyCharm
@Create by Author ： jamesenh
====================================
"""


class CjBaseError(Exception):
    def __init__(self, *args, **kwargs):
        self.message = args[0]
        for key in kwargs:
            self.__dict__[key] = kwargs[key]
        

class AccountError(CjBaseError):
    """网站账密异常"""

class AccountPermission_Error(AccountError):
    """账号权限异常"""

class AccountNotExist_Error(AccountError):
    """账号不存在"""

class AccountPwd_Error(AccountError):
    """密码错误"""

class VerifyCode_Error(CjBaseError):
    """验证码错误"""

class VerifyTimesExpire_Error(VerifyCode_Error):
    """验证码超过次数错误"""

class NetWorkError(CjBaseError):
    """网络异常类"""

class ProxyHandle_Error(NetWorkError):
    """代理处理异常"""

class HostUnReachable_Error(NetWorkError):
    """网站无法访问异常"""

class HostResponseExpire_Error(NetWorkError):
    """网站路径响应超时异常"""

class WebChanged_Error(CjBaseError):
    """网站改版"""

class DataError(CjBaseError):
    """采集数据异常类"""

class SalesDataCollect_Error(DataError):
    """销售采集异常"""

class PurchaseDataCollect_Error(DataError):
    """采购采集异常"""

class StockDataCollect_Error(DataError):
    """库存采集异常"""
